/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.swt.BasicRenderer;

public class LinkListener
implements MouseListener {
    private final BasicRenderer _parent;

    public LinkListener(BasicRenderer parent) {
        this._parent = parent;
        parent.addMouseListener(this);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        String uri = this.findLink(e.x, e.y);
        if (uri != null) {
            this.linkClicked(uri);
        }
    }

    protected void linkClicked(String uri) {
        this._parent.setDocumentRelative(uri);
    }

    protected String findLink(int x, int y) {
        Box box = this._parent.find(x, y);
        if (box == null) {
            return null;
        }
        Element elem = box.getElement();
        if (elem == null) {
            return null;
        }
        return this.findLink(elem);
    }

    protected String findLink(Element e) {
        String uri = null;
        Node node = e;
        while (node.getNodeType() == 1 && (uri = this._parent.getSharedContext().getNamespaceHandler().getLinkUri((Element)node)) == null) {
            node = node.getParentNode();
        }
        return uri;
    }
}

