/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.widgets.generic;

import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.ui.resulttable.EtatResultTableModel;
import fr.gouv.finances.cp.xemelios.widgets.AbstractWidget;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.WidgetModel;
import fr.gouv.finances.dgfip.xemelios.data.DataHandler;
import fr.gouv.finances.dgfip.xemelios.utils.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ViewCode
extends AbstractWidget {
    private static final Logger logger = Logger.getLogger(ViewCode.class);

    public ViewCode(WidgetModel wm, ElementModel em) {
        super(wm, em);
    }

    public void run(EtatResultTableModel etrm, int row) {
        try {
            DataHandler dh = etrm.getRowAt(row, 0);
            Document doc = dh.getDocument();
            String encoding = dh.getDocumentEncoding();
            TransformerFactory tf = TransformerFactoryImpl.newInstance();
            Transformer t = tf.newTransformer(new StreamSource(new File(new File(MainWindow.instance.getEnvProperties().replace("${xemelios.resources.location}")), "XMLPrettyPrint.xsl")));
            File tmp = File.createTempFile("xemelios-data-", ".xml", FileUtils.getTempDir());
            FileOutputStream fos = new FileOutputStream(tmp, false);
            StreamResult sr = new StreamResult(fos);
            t.setParameter("title", this.getElementModel().getParent().getParent().getTitre());
            t.transform(new DOMSource(doc), sr);
            fos.flush();
            fos.close();
            MainWindow.instance.displayHtmlStream(tmp, this.getElementModel().getParent());
            Transformer t2 = tf.newTransformer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t2.transform(new DOMSource(doc), new StreamResult(baos));
            baos.flush();
            baos.close();
            logger.debug((Object)baos.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

