/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.resulttable;

import fr.gouv.finances.dgfip.utils.Amount;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.common.config.ChampModel;
import fr.gouv.finances.dgfip.xemelios.common.config.HiddenModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PjRefHandler;
import fr.gouv.finances.dgfip.xemelios.data.DataHandler;
import fr.gouv.finances.dgfip.xemelios.data.DataResultSet;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EtatResultTableModel
extends AbstractTableModel {
    private static Logger logger = Logger.getLogger(EtatResultTableModel.class);
    private static final long serialVersionUID = 3546078073121223990L;
    private ListeResultatModel lrm;
    private ArrayList<DataHandler> data;
    private DataResultSet rs;
    private int orderByCol;
    private int sortOrder;
    private Class[] datatypes = null;

    public EtatResultTableModel(ListeResultatModel lrm, TreeSet<DataHandler> input, DataResultSet rs) {
        this.lrm = lrm;
        this.data = new ArrayList();
        this.rs = rs;
        for (DataHandler dh : input) {
            for (int i = 0; i < lrm.getListeChamps().size(); ++i) {
                try {
                    dh.getValueAtColumn(i);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.data.add(dh);
        }
        if (this.data.size() > 0) {
            DataHandler dh = this.data.get(0);
            this.orderByCol = dh.getOrderByColumn();
            this.sortOrder = dh.getSortOrder();
        } else {
            this.orderByCol = 0;
            this.sortOrder = -1;
        }
    }

    public EtatResultTableModel(ListeResultatModel lrm, Vector<DataHandler> input) {
        this.lrm = lrm;
        this.data = new ArrayList();
        for (DataHandler dh : input) {
            for (int i = 0; i < lrm.getListeChamps().size(); ++i) {
                try {
                    dh.getValueAtColumn(i);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.data.add(dh);
        }
        if (this.data.size() > 0) {
            DataHandler dh = this.data.get(0);
            this.orderByCol = dh.getOrderByColumn();
            this.sortOrder = dh.getSortOrder();
        } else {
            this.orderByCol = 0;
            this.sortOrder = -1;
        }
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        int ret = this.data.size();
        return ret;
    }

    @Override
    public int getColumnCount() {
        return this.lrm.getListeChamps().size();
    }

    @Override
    public String getColumnName(int col) {
        ChampModel cm = (ChampModel)this.lrm.getListeChamps().elementAt(col);
        return cm.getLibelle();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (this.datatypes == null) {
            this.datatypes = new Class[this.getColumnCount()];
        }
        if (this.datatypes[col] == null) {
            ChampModel cm = (ChampModel)this.lrm.getListeChamps().elementAt(col);
            this.datatypes[col] = cm.getDataClass();
        }
        return this.datatypes[col];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.getColumnClass(column).equals(PjRefHandler.class);
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object o = this.getRowAt(row, col).getValueAtColumn(col);
        return o;
    }

    public Object getInnerValueAt(int row, int col) {
        Object ret = this.getRowAt(row, col).getInnerDataAt(col);
        return ret == null ? "" : ret;
    }

    public DataHandler getRowAt(int row, int col) {
        DataHandler dh = this.data.get(row);
        return dh;
    }

    @Override
    public void setValueAt(Object arg0, int arg1, int arg2) {
    }

    public void setData(TreeSet<DataHandler> input) {
        this.data = new ArrayList();
        for (DataHandler dh : input) {
            for (int i = 0; i < this.lrm.getListeChamps().size(); ++i) {
                try {
                    dh.getValueAtColumn(i);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.data.add(dh);
        }
        if (this.data.size() > 0) {
            DataHandler dh = this.data.get(0);
            this.orderByCol = dh.getOrderByColumn();
            this.sortOrder = dh.getSortOrder();
        } else {
            this.orderByCol = 0;
            this.sortOrder = -1;
        }
    }

    public int sortRequired(int col) {
        logger.debug((Object)("sort required: " + col));
        if (this.data == null || this.data.size() == 0) {
            return 0;
        }
        int orderByCol = 0;
        int sortOrder = 0;
        DataHandler dh = this.data.get(0);
        if (dh.getOrderByColumn() == col) {
            sortOrder = dh.getSortOrder() == -1 ? 1 : -1;
            orderByCol = col;
        } else {
            orderByCol = col;
            sortOrder = -1;
        }
        this.orderByCol = orderByCol;
        this.sortOrder = sortOrder;
        TreeSet<DataHandler> ts = new TreeSet<DataHandler>();
        for (DataHandler dh2 : this.data) {
            dh2.setOrderByColumn(orderByCol, sortOrder);
            ts.add(dh2);
        }
        this.setData(ts);
        this.fireTableStructureChanged();
        return sortOrder;
    }

    public int getOrderByCol() {
        return this.orderByCol;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public String getCsvBuffer(String fieldSeparator, boolean exportAll, int[] selectedRows) {
        String lineSeparator = System.getProperty("line.separator");
        DecimalFormat df = new DecimalFormat("#0.00");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        StringBuffer buff = new StringBuffer();
        for (ChampModel cm : this.lrm.getListeChamps()) {
            buff.append(cm.getLibelle()).append(fieldSeparator);
        }
        buff.append(lineSeparator);
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!exportAll && Arrays.binarySearch(selectedRows, row) < 0) continue;
            for (int col = 0; col < this.getColumnCount(); ++col) {
                Object value = this.getValueAt(row, col);
                String strVal = null;
                if (value instanceof Float) {
                    strVal = df.format((Float)value);
                    strVal = strVal.replaceAll("\\.", ",");
                    logger.debug((Object)("double: " + strVal));
                } else if (value instanceof Amount) {
                    strVal = df.format((Amount)value);
                    strVal = strVal.replaceAll("\\.", ",");
                    logger.debug((Object)("amount: " + strVal));
                } else if (value instanceof Date) {
                    strVal = sdf.format((Date)value);
                } else {
                    strVal = value == null ? "" : value.toString();
                    boolean shouldQuote = strVal.indexOf("\"") >= 0 || strVal.indexOf(fieldSeparator) >= 0 || strVal.startsWith(" ") || strVal.endsWith(" ");
                    strVal = strVal.replaceAll("\"", "\"\"");
                    if (shouldQuote) {
                        strVal = "\"".concat(strVal).concat("\"");
                    }
                }
                buff.append(strVal).append(fieldSeparator);
            }
            buff.append(lineSeparator);
        }
        return buff.toString();
    }

    public String getCsvBuffer(String fieldSeparator, String lineHeader) {
        String lineSeparator = System.getProperty("line.separator");
        DecimalFormat df = new DecimalFormat("#0.00");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        StringBuffer buff = new StringBuffer();
        for (int row = 0; row < this.getRowCount(); ++row) {
            buff.append(lineHeader);
            for (int col = 0; col < this.getColumnCount(); ++col) {
                Object value = this.getValueAt(row, col);
                String strVal = null;
                if (value instanceof Float) {
                    strVal = df.format((Float)value);
                    strVal = strVal.replaceAll("\\.", ",");
                    logger.debug((Object)("double: " + strVal));
                } else if (value instanceof Amount) {
                    strVal = df.format((Amount)value);
                    strVal = strVal.replaceAll("\\.", ",");
                    logger.debug((Object)("amount: " + strVal));
                } else {
                    strVal = value instanceof Date ? sdf.format((Date)value) : (value == null ? "" : value.toString());
                }
                buff.append(strVal).append(fieldSeparator);
            }
            buff.append(lineSeparator);
        }
        return buff.toString();
    }

    public void dispose() {
        this.lrm = null;
        this.data.clear();
        this.data = null;
        if (this.datatypes != null) {
            for (int i = 0; i < this.datatypes.length; ++i) {
                this.datatypes[i] = null;
            }
        }
    }

    public DataResultSet getResultSet() {
        return this.rs;
    }

    public boolean isSumOperationPermittedOnColumn(int columnIndex) {
        ChampModel cm;
        boolean result = false;
        Vector listeChamps = this.lrm.getListeChamps();
        if (columnIndex <= listeChamps.size() && ((cm = (ChampModel)listeChamps.get(columnIndex)).getDatatype().equals("integer") || cm.getDatatype().equals("decimal") || cm.getDatatype().equals("amount") || cm.getDatatype().equals("date")) && cm.isSommePossible()) {
            result = true;
        }
        return result;
    }

    public String getColumnDatatype(int columnIndex) {
        String result = "";
        Vector listeChamps = this.lrm.getListeChamps();
        if (columnIndex <= listeChamps.size()) {
            ChampModel cm = (ChampModel)listeChamps.get(columnIndex);
            result = cm.getDatatype();
        }
        return result;
    }

    public String getColumnXPath(int columnIndex) {
        String result = "";
        Vector listeChamps = this.lrm.getListeChamps();
        if (columnIndex <= listeChamps.size()) {
            ChampModel cm = (ChampModel)listeChamps.get(columnIndex);
            result = this.lrm.getParent().getPath().getFormattedPath() + "/" + cm.getPath().getFormattedPath();
        }
        return result;
    }

    public String getColumnHeader(int columnIndex) {
        String result = "";
        Vector listeChamps = this.lrm.getListeChamps();
        if (columnIndex <= listeChamps.size()) {
            ChampModel cm = (ChampModel)listeChamps.get(columnIndex);
            result = cm.getLibelle();
        }
        return result;
    }

    public Vector<ChampModel> getListeChamps() {
        return this.lrm.getListeChamps();
    }

    public Vector<HiddenModel> getHiddens() {
        return this.lrm.getHiddens();
    }

    public ListeResultatModel getListeResultat() {
        return this.lrm;
    }

    public Pair getCollectivite() {
        return this.rs.getCollectivite();
    }

    public Pair getBudget() {
        return this.rs.getBudget();
    }
}

