/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.collectivites;

import fr.gouv.finances.cp.xemelios.ui.collectivites.DlgSelectCollectivite;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.SpecialKeyModel;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DlgSelectNavigationTarget
extends DlgSelectCollectivite {
    private static final Logger logger = Logger.getLogger(DlgSelectCollectivite.class);
    ArrayList<JComboBox> specialKeysLists;
    ArrayList<SpecialKeyModel> models;
    ArrayList<Pair> specialKeys;
    private JComboBox cbxBudget;

    public DlgSelectNavigationTarget(DocumentModel dm, XemeliosUser user, JFrame parent) {
        super(dm, user, parent);
        this.setTitle("Choisir une collectivit\u00e9, un budget ...");
    }

    public Pair getBudget() {
        return (Pair)this.cbxBudget.getSelectedItem();
    }

    public List<Pair> getSpecialKeys() {
        return this.specialKeys;
    }

    @Override
    public void addComplementElements(JPanel collPane, GridBagConstraints cstr) {
        this.getCbxCollectivite().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    DlgSelectNavigationTarget.this.cbxBudget.removeAllItems();
                } else {
                    try {
                        Vector data = DataLayerManager.getImplementation().getBudgets(DlgSelectNavigationTarget.this.getDm(), DlgSelectNavigationTarget.this.getCollectivite(), DlgSelectNavigationTarget.this.getUser());
                        for (Pair p : data) {
                            DlgSelectNavigationTarget.this.cbxBudget.addItem(p);
                        }
                        DlgSelectNavigationTarget.this.cbxBudget.setSelectedIndex(0);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"while getting budgets:", (Throwable)ex);
                    }
                }
            }
        });
        ++cstr.gridy;
        cstr.gridx = 0;
        cstr.gridwidth = 1;
        cstr.weightx = 1.0;
        cstr.anchor = 13;
        collPane.add((Component)new JLabel("Budget"), cstr);
        this.cbxBudget = new JComboBox();
        cstr.gridx = 1;
        cstr.weightx = 0.0;
        cstr.gridwidth = 2;
        cstr.anchor = 17;
        collPane.add((Component)this.cbxBudget, cstr);
        if (!this.getDm().getSpecialKeys().isEmpty()) {
            this.cbxBudget.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    try {
                        if (DlgSelectNavigationTarget.this.getBudget() != null) {
                            Vector data = DataLayerManager.getImplementation().getSpecialKeys1(DlgSelectNavigationTarget.this.getDm(), DlgSelectNavigationTarget.this.getCollectivite(), DlgSelectNavigationTarget.this.getBudget(), true, DlgSelectNavigationTarget.this.getUser());
                            JComboBox cbx = DlgSelectNavigationTarget.this.specialKeysLists.get(0);
                            cbx.removeAllItems();
                            for (Pair p : data) {
                                cbx.addItem(p);
                            }
                            cbx.setSelectedIndex(0);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)"while getting keys1:", (Throwable)ex);
                    }
                }
            });
            this.specialKeysLists = new ArrayList();
            this.models = new ArrayList();
            this.specialKeys = new ArrayList();
            for (SpecialKeyModel skm : this.getDm().getSpecialKeys()) {
                ++cstr.gridy;
                cstr.gridx = 0;
                cstr.gridwidth = 1;
                cstr.weightx = 1.0;
                cstr.anchor = 13;
                collPane.add((Component)new JLabel(skm.getLibelle()), cstr);
                JComboBox cbx = new JComboBox();
                cstr.gridx = 1;
                cstr.weightx = 0.0;
                cstr.gridwidth = 2;
                cstr.anchor = 17;
                collPane.add(cbx, cstr);
                this.specialKeysLists.add(cbx);
                cbx.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        block11: {
                            int rank;
                            JComboBox thisOne;
                            block12: {
                                block10: {
                                    thisOne = (JComboBox)e.getItemSelectable();
                                    rank = DlgSelectNavigationTarget.this.specialKeysLists.indexOf(thisOne);
                                    if (e.getStateChange() != 2) break block10;
                                    for (int i = rank + 1; i < DlgSelectNavigationTarget.this.specialKeysLists.size(); ++i) {
                                        JComboBox cbx = DlgSelectNavigationTarget.this.specialKeysLists.get(i);
                                        cbx.removeAllItems();
                                    }
                                    while (DlgSelectNavigationTarget.this.specialKeys.size() > rank) {
                                        DlgSelectNavigationTarget.this.specialKeys.remove(rank);
                                    }
                                    break block11;
                                }
                                DlgSelectNavigationTarget.this.specialKeys.add((Pair)thisOne.getSelectedItem());
                                if (rank != 0) break block12;
                                try {
                                    Vector data = DataLayerManager.getImplementation().getSpecialKeys2(DlgSelectNavigationTarget.this.getDm(), DlgSelectNavigationTarget.this.getCollectivite(), DlgSelectNavigationTarget.this.getBudget(), (Pair)thisOne.getSelectedItem(), true, DlgSelectNavigationTarget.this.getUser());
                                    JComboBox cbx = DlgSelectNavigationTarget.this.specialKeysLists.get(1);
                                    for (Pair p : data) {
                                        cbx.addItem(p);
                                    }
                                    cbx.setSelectedIndex(0);
                                }
                                catch (IndexOutOfBoundsException aioobEx) {
                                }
                                catch (Exception ex) {
                                    logger.error((Object)"while getting keys2:", (Throwable)ex);
                                }
                                break block11;
                            }
                            if (rank != 1) break block11;
                            JComboBox previousOne = DlgSelectNavigationTarget.this.specialKeysLists.get(0);
                            try {
                                Vector data = DataLayerManager.getImplementation().getSpecialKeys3(DlgSelectNavigationTarget.this.getDm(), DlgSelectNavigationTarget.this.getCollectivite(), DlgSelectNavigationTarget.this.getBudget(), (Pair)thisOne.getSelectedItem(), (Pair)previousOne.getSelectedItem(), true, DlgSelectNavigationTarget.this.getUser());
                                JComboBox cbx = DlgSelectNavigationTarget.this.specialKeysLists.get(2);
                                for (Pair p : data) {
                                    cbx.addItem(p);
                                }
                                cbx.setSelectedIndex(0);
                            }
                            catch (IndexOutOfBoundsException aioobEx) {
                            }
                            catch (Exception ex) {
                                logger.error((Object)"while getting keys3:", (Throwable)ex);
                            }
                        }
                    }
                });
            }
        }
    }
}

