/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.utils.ui.VerticalFlowLayout;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.xemelios.ui.CriteriaViewer;
import fr.gouv.finances.cp.xemelios.ui.DlgEditEnvironment;
import fr.gouv.finances.cp.xemelios.ui.DlgSelectRequest;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.ui.collectivites.DlgSelectCollectivite;
import fr.gouv.finances.cp.xemelios.ui.export.DlgSearchConfig;
import fr.gouv.finances.cp.xemelios.ui.resulttable.EtatResultTableModel;
import fr.gouv.finances.cp.xemelios.ui.resulttable.PageSeeker;
import fr.gouv.finances.cp.xemelios.ui.search.SearchThread;
import fr.gouv.finances.cp.xemelios.ui.searchParams.DlgSearchParams;
import fr.gouv.finances.dgfip.utils.IoUtils;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.DematTransform;
import fr.gouv.finances.dgfip.xemelios.common.ToolException;
import fr.gouv.finances.dgfip.xemelios.common.config.CritereModel;
import fr.gouv.finances.dgfip.xemelios.common.config.CritereRefModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EnvironmentDomain;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PluginModel;
import fr.gouv.finances.dgfip.xemelios.common.config.RechercheModel;
import fr.gouv.finances.dgfip.xemelios.common.config.SavedRequestsModel;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.ui.ListDisplayable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SearchWindow
extends JInternalFrame {
    private static final long serialVersionUID = 3257002159676469814L;
    private static Logger logger = Logger.getLogger(SearchWindow.class);
    private JPanel scroller;
    private JScrollPane sc;
    private JPanel mainPane = null;
    private JComboBox colls;
    private JComboBox budgets;
    private JTextField dfCollectivite;
    private JTable table = null;
    private JSplitPane splitter = null;
    private JButton pbSearch;
    private JButton pbValidateHeader;
    private JButton pbSearchBackground;
    private JButton pbClear;
    private JButton pbSaveRequest;
    private PageSeeker ps = null;
    private JTextField bottomField;
    public MainWindow parentFrame;
    private ElementModel em;
    private Pair currentBudget;
    private Pair currentCollectivite;
    private String title;
    private ActionListener lineAdder;
    private Vector<CriteriaViewer> criterias;
    private boolean canExport = false;
    private static int frameCount = 1;
    private int rank = 0;
    private PluginModel plugin;
    private boolean pluginSearchEnabled = false;
    private Vector<CritereModel> criteresOp;
    private DocumentModel dm = null;
    private XemeliosUser user;

    public SearchWindow(MainWindow pf, DocumentModel dm, ElementModel em, XemeliosUser user) throws ToolException {
        super("Recherche - " + em.getTitre() + " <" + frameCount + ">", true, true, true);
        this.parentFrame = pf;
        this.user = user;
        this.rank = frameCount;
        this.title = "Recherche - " + em.getTitre() + " <" + frameCount++ + ">";
        this.em = em;
        this.dm = dm;
        this.initComponents();
        em.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("mode".equals(evt.getPropertyName())) {
                    SearchWindow.this.clearAll();
                }
            }
        });
    }

    protected void initComponents() throws ToolException {
        this.mainPane = new JPanel(new BorderLayout());
        IhmFactory iF = IhmFactory.newInstance();
        this.pbValidateHeader = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/add2.png"));
        this.pbValidateHeader.setToolTipText("Ajouter un crit\u00e8re de recherche");
        this.lineAdder = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.addLine();
            }
        };
        this.pbValidateHeader.addActionListener(this.lineAdder);
        this.pbSearch = new JButton((Icon)IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/search2.png")){
            private static final long serialVersionUID = 1L;

            public void fireActionPerformed(ActionEvent event) {
                SearchWindow.this.parentFrame.startWaiter();
                super.fireActionPerformed(event);
            }
        };
        this.pbSearch.setToolTipText("Chercher");
        this.pbSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.search();
            }
        });
        this.pbSearch.setEnabled(false);
        this.budgets = new JComboBox();
        int collCount = 0;
        try {
            collCount = DataLayerManager.getImplementation().getCollectivitesCount(this.dm, this.user);
        }
        catch (Exception ex) {
            logger.error((Object)"while getting collectivites count:", (Throwable)ex);
        }
        if (this.dm.getCollectivitePath().getParentsCount() == 0 || collCount < 5) {
            try {
                Vector collectivites = DataLayerManager.getImplementation().getCollectivites(this.dm, null, this.user);
                this.colls = new JComboBox(collectivites);
                this.colls.setSelectedIndex(0);
                this.colls.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Pair bd = (Pair)SearchWindow.this.colls.getSelectedItem();
                        SearchWindow.this.currentCollectivite = bd;
                        Vector data = new Vector();
                        try {
                            data = DataLayerManager.getImplementation().getBudgets(SearchWindow.this.dm, SearchWindow.this.currentCollectivite, SearchWindow.this.user);
                        }
                        catch (Exception ex) {
                            Container comp2;
                            for (comp2 = SearchWindow.this; comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
                            }
                            if (comp2 != null) {
                                new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)ex);
                            }
                            ex.printStackTrace();
                        }
                        SearchWindow.this.budgets.removeAllItems();
                        for (Pair c : data) {
                            SearchWindow.this.budgets.addItem(c);
                        }
                        if (data.size() > 0) {
                            SearchWindow.this.budgets.setSelectedIndex(0);
                        }
                        SearchWindow.this.clearAll();
                        SearchWindow.this.pluginSearchEnabled = false;
                        SearchWindow.this.addLine();
                        SearchWindow.this.pbSaveRequest.setEnabled(true);
                    }
                });
                this.currentCollectivite = (Pair)this.colls.getItemAt(0);
            }
            catch (Exception ex) {
                Container comp2;
                for (comp2 = this; comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
                }
                if (comp2 != null) {
                    new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)ex);
                } else {
                    ex.printStackTrace();
                }
                throw new ToolException(8);
            }
        } else {
            this.dfCollectivite = new JTextField();
            this.dfCollectivite.setColumns(15);
            this.dfCollectivite.setEditable(false);
            this.pbValidateHeader.setEnabled(false);
        }
        this.criterias = new Vector();
        this.pbSaveRequest = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/save2.png"));
        this.pbSaveRequest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.saveRequest();
            }
        });
        this.pbSaveRequest.setToolTipText("Enregistrer les crit\u00e8res de recherche");
        JButton pbOpenRequest = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/openRequest2.png"));
        pbOpenRequest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.openRequest();
            }
        });
        pbOpenRequest.setToolTipText("Ouvrir une recherche pr\u00e9-enregistr\u00e9e");
        this.pbSearchBackground = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/search_bg2.png"));
        this.pbSearchBackground.setToolTipText("Rechercher en t\u00e2che de fond");
        this.pbSearchBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.searchBackground();
            }
        });
        this.pbSearchBackground.setEnabled(false);
        JToolBar tb = new JToolBar();
        tb.setRollover(true);
        tb.setFloatable(false);
        tb.add(iF.newLabel(this.em.getParent().getParent().getLibelleCollectivite(), "normal"));
        if (this.colls != null) {
            tb.add(this.colls);
        } else {
            tb.add(this.dfCollectivite);
            JButton pbChooseCollectivite = new JButton("...");
            pbChooseCollectivite.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DlgSelectCollectivite dlg = new DlgSelectCollectivite(SearchWindow.this.dm, SearchWindow.this.user, SearchWindow.this.getParentFrame());
                    if (dlg.run()) {
                        SearchWindow.this.currentCollectivite = dlg.getCollectivite();
                        SearchWindow.this.dfCollectivite.setText(((SearchWindow)SearchWindow.this).currentCollectivite.libelle);
                        Vector data = new Vector();
                        try {
                            data = DataLayerManager.getImplementation().getBudgets(SearchWindow.this.dm, SearchWindow.this.currentCollectivite, SearchWindow.this.user);
                        }
                        catch (Exception ex) {
                            Container comp2;
                            for (comp2 = SearchWindow.this; comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
                            }
                            if (comp2 != null) {
                                new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)ex);
                            }
                            ex.printStackTrace();
                        }
                        SearchWindow.this.budgets.removeAllItems();
                        for (Pair c : data) {
                            SearchWindow.this.budgets.addItem(c);
                        }
                        if (data.size() > 0) {
                            SearchWindow.this.budgets.setSelectedIndex(0);
                        }
                        SearchWindow.this.clearAll();
                        SearchWindow.this.pluginSearchEnabled = false;
                        SearchWindow.this.addLine();
                        SearchWindow.this.pbSaveRequest.setEnabled(true);
                        SearchWindow.this.pbValidateHeader.setEnabled(true);
                    }
                }
            });
            tb.add(pbChooseCollectivite);
        }
        tb.addSeparator();
        tb.add(iF.newLabel("Code Budget ", "normal"));
        tb.add(this.budgets);
        this.mainPane.add((Component)tb, "First");
        tb = new JToolBar(1);
        tb.setRollover(true);
        tb.add(this.pbValidateHeader);
        tb.add(this.pbSearch);
        tb.add(this.pbSearchBackground);
        this.pbClear = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/clearAll2.png"));
        tb.add(this.pbClear);
        if (this.em.getParent() == null) {
            throw new RuntimeException("elementModel.getParent() is null");
        }
        if (this.em.getParent().getParent() == null) {
            throw new RuntimeException("etatModel.getParent() is null");
        }
        if (this.em.getParent().getParent().getReferentielXsltFile() != null) {
            tb.addSeparator();
            JButton pbShowReferentiel = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/referentiel2.png"));
            tb.add(pbShowReferentiel);
            pbShowReferentiel.setToolTipText("Afficher la nomenclature");
            pbShowReferentiel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SearchWindow.this.showReferentiel();
                }
            });
        }
        tb.addSeparator();
        tb.add(this.pbSaveRequest);
        tb.add(pbOpenRequest);
        tb.addSeparator();
        JButton pbEnvironment = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/environment2.png"));
        tb.add(pbEnvironment);
        pbEnvironment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgEditEnvironment dee = new DlgEditEnvironment((Frame)SearchWindow.this.getParentFrame(), (EnvironmentDomain)SearchWindow.this.em, 2);
                dee.setVisible(true);
            }
        });
        pbEnvironment.setToolTipText("Modifier les param\u00e8tres d'environnement de recherche.");
        JButton pbSortFields = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/searchParams.png"));
        pbSortFields.setToolTipText("Champs et tris");
        pbSortFields.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DlgSearchParams dsp = new DlgSearchParams((Frame)MainWindow.instance, true, SearchWindow.this.em.getListeResultat());
                dsp.setVisible(true);
            }
        });
        tb.addSeparator();
        tb.add(pbSortFields);
        this.mainPane.add((Component)tb, "Before");
        this.pbClear.setEnabled(false);
        this.pbClear.setToolTipText("Supprimer tous les crit\u00e8res");
        this.pbClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.clearAll();
                SearchWindow.this.pluginSearchEnabled = false;
                SearchWindow.this.addLine();
                SearchWindow.this.pbSaveRequest.setEnabled(true);
            }
        });
        this.scroller = new JPanel(new VerticalFlowLayout(0, 0, 0));
        this.sc = new JScrollPane(this.scroller);
        this.validateHeader();
        this.sc.setVerticalScrollBarPolicy(22);
        this.splitter = new JSplitPane(0);
        this.splitter.setLeftComponent(this.sc);
        this.splitter.setRightComponent(new JPanel());
        this.mainPane.add((Component)this.splitter, "Center");
        JPanel bottomPane = new JPanel(new BorderLayout());
        this.bottomField = new JTextField();
        this.bottomField.setEditable(false);
        this.bottomField.setBackground(bottomPane.getBackground());
        this.bottomField.setBorder(BorderFactory.createEmptyBorder());
        this.bottomField.setColumns(50);
        bottomPane.add((Component)this.bottomField, "West");
        this.ps = new PageSeeker(this);
        bottomPane.add((Component)this.ps, "East");
        this.mainPane.add((Component)bottomPane, "South");
        this.getRootPane().setDefaultButton(this.pbSearch);
        InternalFrameAdapter adapter = new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                SearchWindow.this.clearResources();
                SearchWindow.this.notifyParentStateChanged();
            }

            public void internalFrameIconified(InternalFrameEvent e) {
                SearchWindow.this.setTitle(SearchWindow.this.em.getTitre() + " <" + SearchWindow.this.rank + ">");
                SearchWindow.this.notifyParentStateChanged();
            }

            public void internalFrameDeiconified(InternalFrameEvent e) {
                SearchWindow.this.setTitle(SearchWindow.this.title);
                SearchWindow.this.notifyParentStateChanged();
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                SearchWindow.this.moveToFront();
                SearchWindow.this.notifyParentStateChanged();
            }
        };
        this.addInternalFrameListener(adapter);
        this.setContentPane(this.mainPane);
        this.setIconifiable(true);
        if (this.colls != null) {
            Vector data = new Vector();
            try {
                data = DataLayerManager.getImplementation().getBudgets(this.dm, this.currentCollectivite, this.user);
            }
            catch (Exception ex) {
                Container comp2;
                for (comp2 = this; comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
                }
                if (comp2 != null) {
                    new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)ex);
                }
                ex.printStackTrace();
            }
            this.budgets.removeAllItems();
            for (Pair c : data) {
                this.budgets.addItem(c);
            }
            if (data.size() > 0) {
                this.budgets.setSelectedIndex(0);
            }
            this.validateHeader();
        }
        this.budgets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.clearAll();
                SearchWindow.this.validateHeader();
            }
        });
        this.pack();
        this.splitter.setDividerLocation(100);
    }

    protected void clearResources() {
        this.em = null;
        this.dm = null;
        if (this.table != null) {
            JXTable latable = (JXTable)this.table;
            EtatResultTableModel etrm = (EtatResultTableModel)latable.getModel();
            etrm.getResultSet().clear();
            etrm.dispose();
        }
    }

    protected void validateHeader() {
        this.currentBudget = (Pair)this.budgets.getSelectedItem();
        if (this.currentBudget != null && this.currentCollectivite != null) {
            this.pbSearch.setEnabled(true);
            this.pbSearchBackground.setEnabled(true);
            this.addLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search() {
        SearchThread searcher = null;
        this.setSearchEnabled(false);
        try {
            this.setCursor(new Cursor(3));
            searcher = new SearchThread(this, this.em, this.currentCollectivite, this.currentBudget, this.criterias, this.plugin);
            SwingUtilities.invokeLater(searcher);
        }
        catch (OutOfMemoryError oomErr) {
            searcher.exceptionDuringProcess = oomErr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchBackground() {
        SearchThread searcher = null;
        this.setSearchEnabled(false);
        try {
            searcher = new SearchThread(this, this.em, this.currentCollectivite, this.currentBudget, this.criterias, this.plugin, true);
            SwingUtilities.invokeLater(searcher);
        }
        catch (OutOfMemoryError oomErr) {
            searcher.exceptionDuringProcess = oomErr;
        }
    }

    public CriteriaViewer addLine() {
        CriteriaViewer cv = null;
        cv = this.pluginSearchEnabled ? new CriteriaViewer(this, this.em, this.currentCollectivite, this.currentBudget, this.criterias.size() == 0, this.criteresOp) : new CriteriaViewer(this, this.em, this.currentCollectivite, this.currentBudget, this.criterias.size() == 0);
        this.criterias.add(cv);
        if (this.pbClear != null) {
            this.pbClear.setEnabled(true);
            this.setSearchEnabled(true);
        }
        if (this.scroller != null) {
            this.scroller.add(cv);
        }
        if (this.isVisible()) {
            cv.setVisible(true);
            this.scroller.validate();
            Rectangle rect = cv.getBounds();
            Point p = new Point(0, (int)((double)this.criterias.size() * rect.getHeight()) - 1);
            this.sc.getViewport().setViewPosition(p);
            this.repaintCriterias();
        }
        return cv;
    }

    protected CriteriaViewer addLineNoCriteria() {
        CriteriaViewer cv = new CriteriaViewer(this, this.em, this.currentCollectivite, this.currentBudget, true, true);
        CriteriaViewer lastCrit = this.criterias.size() > 0 ? this.criterias.get(this.criterias.size() - 1) : cv;
        this.criterias.add(cv);
        if (this.pbClear != null) {
            this.pbClear.setEnabled(true);
            this.setSearchEnabled(true);
        }
        if (this.scroller != null) {
            this.scroller.add(cv);
        }
        if (this.isVisible()) {
            cv.setVisible(true);
            this.scroller.validate();
            Rectangle rect = lastCrit.getBounds();
            Point p = new Point(0, (int)((double)this.criterias.size() * rect.getHeight()) - 1);
            this.sc.getViewport().setViewPosition(p);
            this.repaintCriterias();
        }
        return cv;
    }

    protected void removeLine(CriteriaViewer whichOne) {
        this.scroller.remove(whichOne);
        this.criterias.remove(whichOne);
        if (this.criterias.size() == 0) {
            this.setSearchEnabled(false);
        }
        this.repaintCriterias();
    }

    protected void repaintCriterias() {
        if (!this.isVisible()) {
            return;
        }
        this.scroller.getSize();
        this.sc.setViewportView(this.scroller);
        this.getDesktopPane().getDesktopManager().beginResizingFrame(this, 0);
        Rectangle r = this.getBounds();
        this.getDesktopPane().getDesktopManager().resizeFrame(this, r.x, r.y, r.width, r.height);
        this.getDesktopPane().getDesktopManager().endResizingFrame(this);
    }

    public void exportCSV() {
        if (!this.canExport()) {
            return;
        }
        EtatResultTableModel ertm = (EtatResultTableModel)this.table.getModel();
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith(".CSV");
            }

            public String getDescription() {
                return "Fichier CSV";
            }
        });
        ExportOptionPane eop = new ExportOptionPane();
        fc.setAccessory(eop);
        if (fc.showSaveDialog(this) == 0) {
            int len;
            File f = fc.getSelectedFile();
            String fileName = f.getAbsolutePath();
            if (fileName.substring((len = fileName.length()) - 4).indexOf(46) < 0) {
                fileName = fileName + ".CSV";
                f = new File(fileName);
            }
            if (f.exists() && JOptionPane.showConfirmDialog(this.getParentFrame(), fileName + "\nCe fichier existe d\u00e9j\u00e0. Voulez-vous l'\u00e9craser ?", "Ecrasement", 0) == 1) {
                return;
            }
            MainWindow.fieldSeparator = eop.getSeparator();
            String out = null;
            int[] selectedRows = this.table.getSelectedRows();
            out = ertm.getCsvBuffer(MainWindow.fieldSeparator, eop.getExportAll(), selectedRows);
            try {
                FileWriter fw = new FileWriter(f);
                fw.write(out);
                fw.flush();
                fw.close();
            }
            catch (IOException ioEx) {
                Container comp;
                for (comp = this; comp != null && !(comp instanceof JFrame); comp = comp.getParent()) {
                }
                new DisplayExceptionDlg((Frame)((JFrame)comp), (Throwable)ioEx);
            }
        }
    }

    public void exportXLS() {
        if (!this.canExport()) {
            return;
        }
        EtatResultTableModel ertm = (EtatResultTableModel)this.table.getModel();
        DocumentsModel dmsTmp = new DocumentsModel(DocumentsModel.QN);
        DocumentModel dmTmp = this.dm.clone();
        HashMap hTmp = dmTmp.getHEtats();
        HashMap<String, EtatModel> hTmp2 = new HashMap<String, EtatModel>();
        Vector<EtatModel> vTmp2 = new Vector<EtatModel>();
        for (String k : hTmp.keySet()) {
            EtatModel emTmp = (EtatModel)hTmp.get(k);
            if (emTmp.getElementById(this.em.getId()) == null) continue;
            hTmp2.put(emTmp.getId(), emTmp);
            vTmp2.add(emTmp);
            dmTmp.setVEtats(vTmp2);
            dmTmp.setHEtats(hTmp2);
            break;
        }
        try {
            dmsTmp.addChild((XmlMarshallable)dmTmp, DocumentModel.QN);
        }
        catch (Throwable t) {
            // empty catch block
        }
        DlgSearchConfig sc = new DlgSearchConfig(this.getParentFrame(), dmsTmp, 1, this.user);
        sc.setErtm(ertm);
        sc.setEm(this.em);
        sc.setDm(this.dm);
        sc.setVisible(true);
    }

    public boolean canExport() {
        return this.canExport && !this.isIcon();
    }

    public void notifyParentStateChanged() {
        MainWindow mw = this.parentFrame;
        mw.innerWindowChanged();
        System.gc();
    }

    public void clearAll() {
        this.plugin = null;
        this.pbValidateHeader.setEnabled(true);
        if (this.criterias == null) {
            return;
        }
        while (this.criterias.size() > 0) {
            this.removeLine(this.criterias.elementAt(this.criterias.size() - 1));
        }
    }

    protected void showReferentiel() {
        try {
            int i;
            Vector vXmlData = DataLayerManager.getImplementation().getRepositorysAsDom(this.dm, this.currentCollectivite, this.user);
            if (vXmlData.size() == 0) {
                JOptionPane.showMessageDialog(this.parentFrame, "Pas de nomenclature disponible");
                return;
            }
            XPath xp = XPathFactory.newInstance().newXPath();
            xp.setNamespaceContext(new LocalNSCtx(this.em.getParent().getParent().getNamespaces().getNamespaceURI("n")));
            Vector<Node> vRepository = new Vector<Node>();
            for (Document docXml : vXmlData) {
                Node repository = (Node)xp.evaluate("//n:" + this.em.getParent().getParent().getReferentiel(), docXml.getDocumentElement(), XPathConstants.NODE);
                vRepository.add(repository);
            }
            Document docRoot = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element el = docRoot.createElementNS(((Document)vXmlData.get(0)).getDocumentElement().getNamespaceURI(), ((Document)vXmlData.get(0)).getDocumentElement().getNodeName());
            docRoot.appendChild(el);
            for (i = 0; i < ((Document)vXmlData.get(0)).getDocumentElement().getChildNodes().getLength(); ++i) {
                Node current = ((Document)vXmlData.get(0)).getDocumentElement().getChildNodes().item(i);
                if (current.getNodeName().equals("Nomenclatures") || 3 == current.getNodeType()) continue;
                docRoot.adoptNode(current);
                docRoot.getDocumentElement().appendChild(current);
            }
            if (vRepository != null && vRepository.size() > 0) {
                for (i = 0; i < vRepository.size(); ++i) {
                    Node nomencl = (Node)vRepository.get(i);
                    if (nomencl == null) continue;
                    docRoot.adoptNode(nomencl);
                    docRoot.getDocumentElement().appendChild(nomencl);
                }
            }
            File f = new File(new File(this.dm.getBaseDirectory()), this.dm.getReferentielXsltFile());
            InputStream is = IoUtils.getInputStream((String)f.getPath());
            InputStream htmlStream = DematTransform.transform((Node)docRoot.getDocumentElement(), (InputStream)is, (String)f.getParentFile().toURI().toURL().toExternalForm());
            this.parentFrame.displayHtmlStream(htmlStream, this.em.getParent(), this.getDesktopPane());
        }
        catch (Exception ex) {
            new DisplayExceptionDlg((Frame)this.parentFrame, (Throwable)ex);
        }
    }

    private void saveRequest() {
        String requestName = this.getRequestName();
        if (requestName == null || requestName.length() == 0) {
            return;
        }
        RechercheModel rm = new RechercheModel(RechercheModel.QN, requestName);
        for (CriteriaViewer cv : this.criterias) {
            try {
                rm.addChild(cv.getXmlMarshallable(), CritereModel.QN);
            }
            catch (SAXException ignore) {
                ignore.printStackTrace();
            }
        }
        this.parentFrame.getSavedRequest(this.em).add(rm);
        try {
            DataLayerManager.getImplementation().saveRequest(this.getELementModel(), rm, this.getUser());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    private void openRequest() {
        String persistence = null;
        try {
            persistence = DataLayerManager.getImplementation().getLayerName();
        }
        catch (Throwable t) {
            // empty catch block
        }
        SavedRequestsModel srm = this.parentFrame.getSavedRequest(this.em);
        TreeSet<PluginModel> data = new TreeSet<PluginModel>();
        data.addAll(srm.getRecherches());
        Vector plugins = this.em.getPlugins();
        for (PluginModel pm : plugins) {
            if (!pm.getPluginType().equals("search") && !pm.getPluginType().equals("export") || !pm.isAvailableFor(persistence)) continue;
            data.add(pm);
        }
        Vector<PluginModel> vData = new Vector<PluginModel>();
        vData.addAll(data);
        DlgSelectRequest dsr = new DlgSelectRequest(this.parentFrame, vData, this.em);
        if (dsr.run()) {
            ListDisplayable xm = (ListDisplayable)dsr.getSelectedItem();
            if (xm instanceof RechercheModel) {
                this.pluginSearchEnabled = false;
                RechercheModel rm = (RechercheModel)xm;
                this.clearAll();
                for (CritereModel cm : rm.getCriteres()) {
                    CriteriaViewer cv = this.addLine();
                    cv.changeCritereModel(cm);
                }
                this.pbSaveRequest.setEnabled(true);
            } else if (xm instanceof PluginModel) {
                this.pluginSearchEnabled = true;
                PluginModel pm = (PluginModel)xm;
                this.clearAll();
                this.plugin = pm.clone();
                this.pbValidateHeader.setEnabled(false);
                for (CritereModel cm : pm.getCriteres()) {
                    CriteriaViewer cv = this.addLineNoCriteria();
                    cv.changeCritereModel(cm.clone());
                    this.criterias.add(cv);
                }
                if (pm.getCriteresOp().size() > 0) {
                    this.pbValidateHeader.setEnabled(true);
                }
                this.criteresOp = new Vector();
                for (CritereRefModel cmr : pm.getCriteresOp()) {
                    CritereModel cm = this.em.getCritere(cmr.getIdRef());
                    this.criteresOp.add(cm);
                }
                this.pbSaveRequest.setEnabled(false);
            }
        }
    }

    public void setSearchEnabled(boolean enableIt) {
        this.pbSearch.setEnabled(enableIt);
        this.pbSearchBackground.setEnabled(enableIt);
    }

    public String getRequestName() {
        return JOptionPane.showInputDialog(this, "Veuillez saisir un nom pour cette recherche :", "Valeur par d\u00e9faut");
    }

    public void redisplayTitle() {
        this.setTitle(this.title);
    }

    public void setBottomText(String txt) {
        this.bottomField.setText(txt);
    }

    public void setCanExport(boolean how) {
        this.canExport = how;
    }

    public MainWindow getParentFrame() {
        return this.parentFrame;
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public JTable getTable() {
        return this.table;
    }

    public JSplitPane getSplitter() {
        return this.splitter;
    }

    public PageSeeker getPageSeeker() {
        return this.ps;
    }

    public ElementModel getELementModel() {
        return this.em;
    }

    public Pair getCurrentCollectivite() {
        return this.currentCollectivite;
    }

    public Pair getCurrentBudget() {
        return this.currentBudget;
    }

    public PluginModel getPluginModel() {
        return this.plugin;
    }

    public DocumentModel getDocumentModel() {
        return this.dm;
    }

    public void setVisible(boolean visible) {
        Iterator it;
        if (!visible && this.em != null && (it = this.em.getPropertyListeners()) != null) {
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        super.setVisible(visible);
    }

    public void setCollectivite(Pair collectivite) {
        this.colls.setSelectedItem(collectivite);
    }

    public void setBudget(Pair budget) {
        this.budgets.setSelectedItem(budget);
    }

    public boolean isEtatExportable() {
        if (this.dm == null) {
            return false;
        }
        for (EtatModel etat : this.dm.getEtats()) {
            ElementModel elem = etat.getElementById(this.em.getId());
            if (elem == null || !etat.isExportable()) continue;
            return true;
        }
        return false;
    }

    public XemeliosUser getUser() {
        return this.user;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringIterator<String>
    implements Iterator<String> {
        private String s;
        private boolean get = false;

        public StringIterator(String s) {
            this.s = s;
        }

        @Override
        public boolean hasNext() {
            return !this.get;
        }

        @Override
        public String next() {
            this.get = true;
            return this.s;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class LocalNSCtx
    implements NamespaceContext {
        private static String URI;

        public LocalNSCtx(String uri) {
            URI = uri;
        }

        public String getNamespaceURI(String prefix) {
            if ("".equals(prefix)) {
                return "";
            }
            if ("n".equals(prefix)) {
                return URI;
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if ("xmlns".equals(prefix)) {
                return "http://www.w3.org/2000/xmlns/";
            }
            return "";
        }

        public String getPrefix(String namespaceURI) {
            if (URI.equals(namespaceURI)) {
                return "n";
            }
            if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                return "xml";
            }
            if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                return "xmlns";
            }
            return "";
        }

        public Iterator getPrefixes(String namespaceURI) {
            return new StringIterator<String>(this.getPrefix(namespaceURI));
        }
    }

    public static class ExportOptionPaneXLS
    extends JPanel {
        private static final long serialVersionUID = 1L;
        boolean allSelection = false;
        private JRadioButton rbAll;
        private JRadioButton rbSelection;

        public ExportOptionPaneXLS() {
            this.initComponents();
        }

        private void initComponents() {
            FormLayout fl = new FormLayout("1dlu,pref,1dlu", "1dlu,pref,1dlu,pref,4dlu,pref,1dlu,pref,1dlu");
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(fl, (JPanel)this);
            IhmFactory iF = IhmFactory.newInstance();
            int col = 2;
            int start = 2;
            this.rbSelection = new JRadioButton("S\u00e9l\u00e9ction");
            pb.add((Component)this.rbSelection, cc.xy(col, 4 + start));
            this.rbAll = new JRadioButton("Tout");
            pb.add((Component)this.rbAll, cc.xy(col, 6 + start));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbSelection);
            bg.add(this.rbAll);
            this.rbAll.setSelected(true);
            this.setVisible(true);
        }

        public boolean getExportAll() {
            return this.rbAll.isSelected();
        }
    }

    private class ExportOptionPane
    extends JPanel {
        private static final long serialVersionUID = 1L;
        boolean allSelection = false;
        String separator = MainWindow.fieldSeparator;
        private JTextField fldSep;
        private JRadioButton rbAll;
        private JRadioButton rbSelection;

        public ExportOptionPane() {
            this.initComponents();
        }

        private void initComponents() {
            FormLayout fl = new FormLayout("1dlu,pref,1dlu", "1dlu,pref,1dlu,pref,4dlu,pref,1dlu,pref,1dlu");
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(fl, (JPanel)this);
            IhmFactory iF = IhmFactory.newInstance();
            int col = 2;
            int start = 2;
            pb.add((Component)iF.newLabel("S\u00e9parateur"), cc.xy(col, 0 + start));
            this.fldSep = new JTextField(this.separator);
            pb.add((Component)this.fldSep, cc.xy(col, 2 + start));
            this.rbSelection = new JRadioButton("S\u00e9l\u00e9ction");
            pb.add((Component)this.rbSelection, cc.xy(col, 4 + start));
            this.rbAll = new JRadioButton("Tout");
            pb.add((Component)this.rbAll, cc.xy(col, 6 + start));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbSelection);
            bg.add(this.rbAll);
            this.rbAll.setSelected(true);
            this.setVisible(true);
        }

        public String getSeparator() {
            String sep = this.fldSep.getText();
            if ("\\t".equals(sep)) {
                sep = "\t";
            }
            return sep;
        }

        public boolean getExportAll() {
            return this.rbAll.isSelected();
        }
    }

    public static class DisplayErrorSearchThread
    implements Runnable {
        private SearchWindow sw;
        private Object obj;
        private ToolException tEx;

        public DisplayErrorSearchThread(SearchWindow sw, ToolException tEx, Object objToFocus) {
            this.sw = sw;
            this.obj = objToFocus;
            this.tEx = tEx;
        }

        public void run() {
            JOptionPane.showMessageDialog(this.sw, this.tEx.getMessage(), "", 2);
            this.sw.setSearchEnabled(true);
            if (this.obj != null) {
                ((CriteriaViewer)this.obj).doFocusOnError();
            }
        }
    }
}

