/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.ui.DlgSelectFromList;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.ui.SearchWindow;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.UnauthorizedException;
import fr.gouv.finances.dgfip.xemelios.common.ToolException;
import fr.gouv.finances.dgfip.xemelios.common.config.CritereModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.InputModel;
import fr.gouv.finances.dgfip.xemelios.common.config.OptionModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PropertyModel;
import fr.gouv.finances.dgfip.xemelios.common.config.RecherchePaireModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ResourceModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ResourceRefModel;
import fr.gouv.finances.dgfip.xemelios.common.config.SelectModel;
import fr.gouv.finances.dgfip.xemelios.common.config.SpecialKeyEntryModel;
import fr.gouv.finances.dgfip.xemelios.data.DataAccessException;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaViewer
extends JPanel
implements ActionListener {
    public static final transient String OR_ASSOCIATOR = "||";
    public static final transient String AND_ASSOCIATOR = "&&";
    public static final String DATE_FORMAT = System.getProperty("xemelios.date.format", "yyyy-MM-dd");
    public static final SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
    private static Logger logger = Logger.getLogger(CriteriaViewer.class);
    static IhmFactory iF = IhmFactory.newInstance();
    static ImageIcon deleteImg = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/deleteRow.png");
    static ImageIcon blankImg = null;
    private static final long serialVersionUID = 3258412820227045174L;
    private ElementModel em;
    private DocumentModel dm;
    private Pair collectivite;
    private Pair budget;
    private Hashtable<String, InputData> inputs;
    private ArrayList<InputData> orderedInputs;
    private boolean hideRemoveIcon;
    private boolean hideChoice;
    private JComboBox cbxAndOr;
    private JComboBox cbxTypeCritere;
    private Container replaceMe;
    private SearchWindow parent;
    private JComponent componentToFocus = null;
    private JCheckBox chkDisplayOptionnal = null;
    private CritereModel currentCritereModel = null;
    private JLabel defaultLabel = null;
    private JLabel deleteMe = null;

    public CriteriaViewer(SearchWindow parent, ElementModel em, Pair collectivite, Pair budget, boolean hideRemoveIcon, Vector<CritereModel> criteresOp) {
        this.parent = parent;
        this.hideRemoveIcon = hideRemoveIcon;
        this.em = em;
        this.dm = em.getParent().getParent();
        this.collectivite = collectivite;
        this.budget = budget;
        this.hideChoice = false;
        if (blankImg == null) {
            BufferedImage img = new BufferedImage(deleteImg.getIconWidth(), deleteImg.getIconHeight(), 1);
            Graphics2D gr = (Graphics2D)((Image)img).getGraphics();
            gr.setBackground(parent.getBackground());
            gr.clearRect(0, 0, deleteImg.getIconWidth(), deleteImg.getIconWidth());
            blankImg = new ImageIcon(img);
        }
        this.initialize(hideRemoveIcon, false, criteresOp);
    }

    public CriteriaViewer(SearchWindow parent, ElementModel em, Pair collectivite, Pair budget, boolean hideRemoveIcon) {
        this(parent, em, collectivite, budget, hideRemoveIcon, false);
    }

    public CriteriaViewer(SearchWindow parent, ElementModel em, Pair collectivite, Pair budget, boolean hideRemoveIcon, boolean hideChoice) {
        this.parent = parent;
        this.hideRemoveIcon = hideRemoveIcon;
        this.em = em;
        this.dm = em.getParent().getParent();
        this.collectivite = collectivite;
        this.budget = budget;
        this.hideChoice = hideChoice;
        if (blankImg == null) {
            BufferedImage img = new BufferedImage(deleteImg.getIconWidth(), deleteImg.getIconHeight(), 1);
            Graphics2D gr = (Graphics2D)((Image)img).getGraphics();
            gr.setBackground(parent.getBackground());
            gr.clearRect(0, 0, deleteImg.getIconWidth(), deleteImg.getIconWidth());
            blankImg = new ImageIcon(img);
        }
        this.initialize(hideRemoveIcon, hideChoice);
    }

    protected void initialize(boolean hideRemoveIcon, boolean hideChoice) {
        FormLayout fl = new FormLayout("3dlu,pref,3dlu,25dlu,3dlu,110dlu,3dlu,pref:grow(1.0),3dlu", "0dlu,pref");
        PanelBuilder pb = new PanelBuilder(fl, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        if (!hideRemoveIcon) {
            final AbstractAction act = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    CriteriaViewer.this.parent.removeLine(CriteriaViewer.this);
                }
            };
            this.deleteMe = new JFocusableLabel((Icon)deleteImg, act);
            this.deleteMe.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    act.actionPerformed(null);
                }
            });
            this.deleteMe.setToolTipText("Supprimer ce crit\u00e8re");
            pb.add((Component)this.deleteMe, cc.xy(2, 2));
            Pair[] data = new Pair[]{new Pair(AND_ASSOCIATOR, "ET"), new Pair(OR_ASSOCIATOR, "OU")};
            this.cbxAndOr = new JComboBox<Pair>(data);
            pb.add(this.cbxAndOr, cc.xy(4, 2));
        } else {
            JLabel blank = new JLabel(blankImg);
            blank.setBorder(new EmptyBorder(2, 2, 2, 2));
            pb.add((Component)blank, cc.xy(2, 2));
        }
        if (!hideChoice) {
            this.cbxTypeCritere = new JComboBox(this.em.getAvailableCriteres());
            pb.add(this.cbxTypeCritere, cc.xy(6, 2));
            this.cbxTypeCritere.addActionListener(this);
        } else {
            this.defaultLabel = new JLabel("XXXX");
            pb.add((Component)this.defaultLabel, cc.xy(6, 2));
        }
        this.replaceMe = new JPanel(new FlowLayout());
        pb.add((Component)this.replaceMe, cc.xy(8, 2));
        if (!hideChoice && this.cbxTypeCritere.getItemCount() > 0) {
            this.cbxTypeCritere.setSelectedIndex(0);
        } else {
            this.inputs = new Hashtable();
            this.orderedInputs = new ArrayList();
        }
    }

    protected void initialize(boolean hideRemoveIcon, boolean hideChoice, Vector<CritereModel> criteresOp) {
        FormLayout fl = new FormLayout("3dlu,pref,3dlu,25dlu,3dlu,110dlu,3dlu,pref:grow(1.0),3dlu", "0dlu,pref");
        PanelBuilder pb = new PanelBuilder(fl, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        if (!hideRemoveIcon) {
            final AbstractAction act = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    CriteriaViewer.this.parent.removeLine(CriteriaViewer.this);
                }
            };
            this.deleteMe = new JFocusableLabel((Icon)deleteImg, act);
            this.deleteMe.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    act.actionPerformed(null);
                }
            });
            this.deleteMe.setToolTipText("Supprimer ce crit\u00e8re");
            pb.add((Component)this.deleteMe, cc.xy(2, 2));
            Pair[] data = new Pair[]{new Pair(AND_ASSOCIATOR, "ET"), new Pair(OR_ASSOCIATOR, "OU")};
            this.cbxAndOr = new JComboBox<Pair>(data);
            pb.add(this.cbxAndOr, cc.xy(4, 2));
        } else {
            JLabel blank = new JLabel(blankImg);
            blank.setBorder(new EmptyBorder(2, 2, 2, 2));
            pb.add((Component)blank, cc.xy(2, 2));
        }
        if (!hideChoice) {
            this.cbxTypeCritere = new JComboBox<CritereModel>(criteresOp);
            pb.add(this.cbxTypeCritere, cc.xy(6, 2));
            this.cbxTypeCritere.addActionListener(this);
        } else {
            this.defaultLabel = new JLabel("XXXX");
            pb.add((Component)this.defaultLabel, cc.xy(6, 2));
        }
        this.replaceMe = new JPanel(new FlowLayout());
        pb.add((Component)this.replaceMe, cc.xy(8, 2));
        if (!hideChoice && this.cbxTypeCritere.getItemCount() > 0) {
            this.cbxTypeCritere.setSelectedIndex(0);
        } else {
            this.inputs = new Hashtable();
            this.orderedInputs = new ArrayList();
        }
    }

    public void focusOnDelete() {
        this.deleteMe.grabFocus();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.cbxTypeCritere) {
            this.inputs = new Hashtable();
            this.orderedInputs = new ArrayList();
            CritereModel cm = (CritereModel)this.cbxTypeCritere.getSelectedItem();
            this.changeCritereModel(cm.clone());
        }
    }

    public void changeCritereModel(CritereModel newCm) {
        try {
            CritereModel cm = null;
            if (!this.hideChoice) {
                for (int i = 0; i < this.cbxTypeCritere.getModel().getSize(); ++i) {
                    Object other = this.cbxTypeCritere.getModel().getElementAt(i);
                    if (!newCm.equals(other)) continue;
                    cm = (CritereModel)other;
                    break;
                }
            } else {
                cm = newCm.clone();
            }
            if (cm == null) {
                return;
            }
            if (!this.hideChoice && !this.cbxTypeCritere.getSelectedItem().equals(cm)) {
                this.cbxTypeCritere.removeActionListener(this);
                this.cbxTypeCritere.setSelectedItem(cm);
                this.cbxTypeCritere.addActionListener(this);
            }
            this.currentCritereModel = cm.clone();
            this.replaceMe.removeAll();
            if (this.hideChoice) {
                this.defaultLabel.setText(cm.getLibelle());
            }
            if (this.currentCritereModel.hasBlank()) {
                this.replaceMe.add(Box.createHorizontalGlue());
            }
            for (XmlMarshallable xm : cm.getInputs()) {
                if (xm instanceof InputModel) {
                    final ArrayList<Component> al = new ArrayList<Component>();
                    final InputModel im = (InputModel)xm;
                    if (im.getLibelle() != null) {
                        al.add(CriteriaViewer.getLabel(im.getLibelle()));
                    }
                    String datatype = im.getDatatype();
                    Pair[] pairs = null;
                    if (datatype != null && !im.hasToRemoveOperator()) {
                        try {
                            pairs = DataLayerManager.getImplementation().getOperators(datatype);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        if (pairs.length > 0) {
                            final MComboBox opers = new MComboBox(pairs);
                            opers.setName("OPERATEUR:" + im.getId());
                            al.add(opers);
                            opers.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    MTextField mtf;
                                    Pair item = (Pair)opers.getSelectedItem();
                                    InputData id = (InputData)CriteriaViewer.this.inputs.get("VALEUR:" + im.getId());
                                    JButton pbHelp = null;
                                    if (id != null) {
                                        for (Component comp : al) {
                                            if (!(comp instanceof JHelpButton)) continue;
                                            pbHelp = (JButton)comp;
                                            break;
                                        }
                                    }
                                    if (item.key.equals("xem:StringIsNull") || item.key.equals("xem:StringIsNotNull")) {
                                        if (id != null && id instanceof MTextField) {
                                            mtf = (MTextField)id;
                                            mtf.setText("--");
                                            mtf.setEnabled(false);
                                            if (pbHelp != null) {
                                                pbHelp.setEnabled(false);
                                            }
                                        }
                                    } else if (id instanceof MTextField) {
                                        mtf = (MTextField)id;
                                        mtf.setText("");
                                        mtf.setEnabled(true);
                                        if (pbHelp != null) {
                                            pbHelp.setEnabled(true);
                                        }
                                    }
                                }
                            });
                            String opValue = MainWindow.getInstance().getCriteriaInputValue(im.getKeyName() + ".OPERATEUR");
                            if (opValue != null) {
                                int opIndex = -1;
                                try {
                                    opIndex = Integer.parseInt(opValue);
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                                if (opIndex != -1 && opIndex < opers.getItemCount()) {
                                    opers.setSelectedIndex(opIndex);
                                }
                            }
                        }
                    }
                    MTextField jf = new MTextField(im);
                    jf.setName("VALEUR:" + im.getId());
                    jf.setColumns(10);
                    al.add(jf);
                    String helpPath = im.getHelpPath();
                    if (helpPath != null) {
                        JHelpButton pbHelp = new JHelpButton(jf, this.em, this.collectivite, this.budget, helpPath);
                        al.add(pbHelp);
                    }
                    if (im.getValue() != null) {
                        jf.setText(im.getValue());
                    } else if (MainWindow.getInstance().getCriteriaInputValue(im.getKeyName()) != null) {
                        jf.setText(MainWindow.getInstance().getCriteriaInputValue(im.getKeyName()));
                    }
                    for (Component c : al) {
                        this.replaceMe.add(c);
                        if (c.getName() == null) continue;
                        this.inputs.put(c.getName(), (InputData)((Object)c));
                        this.orderedInputs.add((InputData)((Object)c));
                    }
                    continue;
                }
                if (xm instanceof SelectModel) {
                    SelectModel sm = (SelectModel)xm;
                    Collection data = null;
                    ArrayList<FocusListener> focusListeners = new ArrayList<FocusListener>();
                    data = sm.getNewRecipient();
                    if (sm.isDependantRepository()) {
                        try {
                            Vector vRepository = DataLayerManager.getImplementation().getListeCodeLibelleRepository(this.dm, this.collectivite, this.parent.getUser());
                            if (vRepository.size() > 1) {
                                MComboBox mcb = new MComboBox(vRepository);
                                mcb.setName("ListRepository_" + sm.getId());
                                this.replaceMe.add(mcb);
                                MComboBox mcbListeCorresLibelle = this.remplirListe(sm, data, focusListeners);
                                mcb.addItemListener(new MComboBoxItemListener(this, sm, this.collectivite, mcb, mcbListeCorresLibelle));
                                continue;
                            }
                            this.remplirListe(sm, data, focusListeners);
                        }
                        catch (Exception dbEx) {
                            Container comp2;
                            for (comp2 = this; comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
                            }
                            if (comp2 != null) {
                                new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)dbEx);
                                continue;
                            }
                            dbEx.printStackTrace();
                        }
                        continue;
                    }
                    if (sm.getOptions() != null) {
                        for (OptionModel om : sm.getOptions()) {
                            data.add(new Pair(om.getValue(), om.getLibelle()));
                        }
                    }
                    for (RecherchePaireModel rpm : sm.getRecherches()) {
                        if (rpm.getPath() == null) continue;
                        try {
                            Collection localData = null;
                            localData = rpm.getNewRecipient();
                            localData.addAll(DataLayerManager.getImplementation().queryRepository(this.dm, this.collectivite, rpm, this.parent.getUser()));
                            data.addAll(localData);
                        }
                        catch (Exception dbEx) {
                            Container comp2;
                            for (comp2 = this; comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
                            }
                            if (comp2 != null) {
                                new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)dbEx);
                                continue;
                            }
                            dbEx.printStackTrace();
                        }
                    }
                    for (SpecialKeyEntryModel skem : sm.getSpecialKeys()) {
                        if (!skem.isDepends()) {
                            try {
                                data.addAll(DataLayerManager.getImplementation().getSpecialKeys1(this.dm, this.collectivite, this.budget, skem.isDistinct(), this.parent.getUser()));
                            }
                            catch (DataAccessException daEx) {
                                new DisplayExceptionDlg((Frame)this.parent.parentFrame, (Throwable)daEx);
                            }
                            catch (DataConfigurationException dcEx) {
                                new DisplayExceptionDlg((Frame)this.parent.parentFrame, (Throwable)dcEx);
                            }
                            continue;
                        }
                        SpecialKeyFocusAdapter fl = new SpecialKeyFocusAdapter(this, skem, sm, this.collectivite, this.budget);
                        focusListeners.add(fl);
                    }
                    for (ResourceRefModel rrm : sm.getResources()) {
                        ResourceModel rm = this.dm.getResource(rrm.getRefId());
                        for (XmlMarshallable ob : rm.getData()) {
                            if (!(ob instanceof OptionModel)) continue;
                            OptionModel om = (OptionModel)ob;
                            data.add(new Pair(om.getValue(), om.getLibelle()));
                        }
                    }
                    Vector<Pair> vData = new Vector<Pair>();
                    for (Pair p : data) {
                        vData.add(p);
                    }
                    MComboBox cbxData = new MComboBox(vData, sm);
                    cbxData.setName("VALEUR:" + sm.getId());
                    if (!focusListeners.isEmpty()) {
                        for (FocusListener fl : focusListeners) {
                            cbxData.addFocusListener(fl);
                        }
                    }
                    if (sm.getLibelle() != null) {
                        this.replaceMe.add(CriteriaViewer.getLabel(sm.getLibelle()));
                    }
                    this.replaceMe.add(cbxData);
                    if (sm.getValue() != null) {
                        Pair p;
                        p = new Pair(sm.getValue(), "");
                        cbxData.setSelectedItem(p);
                    }
                    this.inputs.put(cbxData.getName(), cbxData);
                    this.orderedInputs.add(cbxData);
                    continue;
                }
                logger.warn((Object)("classe non traitee: " + xm.getClass().getName()));
            }
            String idAffichage = cm.getIdAffichage();
            if (idAffichage != null && idAffichage.length() > 0) {
                this.chkDisplayOptionnal = new JCheckBox("Afficher le champ");
                if (cm.isDisplayOptional()) {
                    this.chkDisplayOptionnal.setSelected(true);
                }
                this.replaceMe.add(this.chkDisplayOptionnal);
            } else {
                this.chkDisplayOptionnal = null;
            }
            this.parent.repaintCriterias();
            if (newCm.getValeurs() != null) {
                for (PropertyModel pm : newCm.getValeurs()) {
                    JComboBox cbx;
                    String key = pm.getName();
                    InputData id = this.inputs.get(key);
                    if (id == null) {
                        if (key.equals("AND_OR") && this.cbxAndOr != null) {
                            Pair p = new Pair(pm.getValue(), OR_ASSOCIATOR.equals(pm.getValue()) ? "OU" : "ET");
                            this.cbxAndOr.setSelectedItem(p);
                            continue;
                        }
                        logger.debug((Object)("id not found: " + key));
                        continue;
                    }
                    if (id instanceof MComboBox && (cbx = (JComboBox)((Object)id)).isShowing()) {
                        cbx.dispatchEvent(new FocusEvent(cbx, 1004));
                    }
                    id.setInputValue(pm.getValue());
                }
            }
            if (this.replaceMe.getComponentCount() == 0) {
                this.removeAll();
                this.setLayout(new FlowLayout());
                this.add(new JLabel(cm.getLibelle()));
            }
        }
        catch (UnauthorizedException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Droits insuffisants", 2);
        }
    }

    private MComboBox remplirListe(SelectModel sm, Collection<Pair> data, ArrayList<FocusListener> focusListeners) {
        try {
            if (sm.getOptions() != null) {
                for (OptionModel om : sm.getOptions()) {
                    data.add(new Pair(om.getValue(), om.getLibelle()));
                }
            }
            for (RecherchePaireModel rpm : sm.getRecherches()) {
                if (rpm.getPath() == null) continue;
                try {
                    Collection localData = null;
                    localData = rpm.getNewRecipient();
                    localData.addAll(DataLayerManager.getImplementation().queryRepository(this.dm, this.collectivite, rpm, this.parent.getUser()));
                    data.addAll(localData);
                }
                catch (Exception dbEx) {
                    Container comp2;
                    for (comp2 = this; comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
                    }
                    if (comp2 != null) {
                        new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)dbEx);
                        continue;
                    }
                    dbEx.printStackTrace();
                }
            }
            for (SpecialKeyEntryModel skem : sm.getSpecialKeys()) {
                if (!skem.isDepends()) {
                    try {
                        data.addAll(DataLayerManager.getImplementation().getSpecialKeys1(this.dm, this.collectivite, this.budget, skem.isDistinct(), this.parent.getUser()));
                    }
                    catch (DataAccessException daEx) {
                        new DisplayExceptionDlg((Frame)this.parent.parentFrame, (Throwable)daEx);
                    }
                    catch (DataConfigurationException dcEx) {
                        new DisplayExceptionDlg((Frame)this.parent.parentFrame, (Throwable)dcEx);
                    }
                    continue;
                }
                SpecialKeyFocusAdapter fl = new SpecialKeyFocusAdapter(this, skem, sm, this.collectivite, this.budget);
                focusListeners.add(fl);
            }
            for (ResourceRefModel rrm : sm.getResources()) {
                ResourceModel rm = this.dm.getResource(rrm.getRefId());
                for (XmlMarshallable ob : rm.getData()) {
                    if (!(ob instanceof OptionModel)) continue;
                    OptionModel om = (OptionModel)ob;
                    data.add(new Pair(om.getValue(), om.getLibelle()));
                }
            }
            Vector<Pair> vData = new Vector<Pair>();
            for (Pair p : data) {
                vData.add(p);
            }
            MComboBox cbxData = new MComboBox(vData, sm);
            cbxData.setName("VALEUR:" + sm.getId());
            if (!focusListeners.isEmpty()) {
                for (FocusListener fl : focusListeners) {
                    cbxData.addFocusListener(fl);
                }
            }
            if (sm.getLibelle() != null) {
                this.replaceMe.add(CriteriaViewer.getLabel(sm.getLibelle()));
            }
            this.replaceMe.add(cbxData);
            if (sm.getValue() != null) {
                Pair p;
                p = new Pair(sm.getValue(), "");
                cbxData.setSelectedItem(p);
            }
            this.inputs.put(cbxData.getName(), cbxData);
            this.orderedInputs.add(cbxData);
            return cbxData;
        }
        catch (UnauthorizedException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Droits insuffisants", 2);
            return null;
        }
    }

    private MComboBox refreshListe(SelectModel sm, Collection<Pair> data, ArrayList<FocusListener> focusListeners, Pair repository) {
        this.inputs.clear();
        this.orderedInputs.clear();
        for (RecherchePaireModel rpm : sm.getRecherches()) {
            if (rpm.getPath() == null) continue;
            try {
                Collection localData = null;
                localData = rpm.getNewRecipient();
                localData.addAll(DataLayerManager.getImplementation().queryRepository(this.dm, this.collectivite, rpm, repository, this.parent.getUser()));
                data.addAll(localData);
            }
            catch (Exception dbEx) {
                Container comp2;
                for (comp2 = this; comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
                }
                if (comp2 != null) {
                    new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)dbEx);
                    continue;
                }
                dbEx.printStackTrace();
            }
        }
        Vector<Pair> vData = new Vector<Pair>();
        for (Pair p : data) {
            vData.add(p);
        }
        MComboBox cbxData = new MComboBox(vData, sm);
        cbxData.setName("VALEUR:" + sm.getId());
        if (!focusListeners.isEmpty()) {
            for (FocusListener fl : focusListeners) {
                cbxData.addFocusListener(fl);
            }
        }
        if (sm.getLibelle() != null) {
            this.replaceMe.add(CriteriaViewer.getLabel(sm.getLibelle()));
        }
        this.replaceMe.add(cbxData);
        if (sm.getValue() != null) {
            Pair p;
            p = new Pair(sm.getValue(), "");
            cbxData.setSelectedItem(p);
        }
        this.inputs.put(cbxData.getName(), cbxData);
        this.orderedInputs.add(cbxData);
        return cbxData;
    }

    public static Component getLabel(String lbl) {
        return iF.newLabel(lbl, "normal");
    }

    public boolean isOptionalDisplayChecked() {
        boolean result = false;
        if (this.chkDisplayOptionnal != null) {
            result = this.chkDisplayOptionnal.isSelected();
        }
        return result;
    }

    public String getXPathExpr() throws ToolException {
        String expr = ((CritereModel)this.cbxTypeCritere.getSelectedItem()).getPath().getPath();
        int ix = expr.indexOf("##");
        while (ix >= 0) {
            String sTmp = expr.substring(ix + 2);
            int pos = sTmp.indexOf("##");
            if (pos < 0) {
                throw new ToolException("Expression mal formee: " + expr, 5);
            }
            String middle = sTmp.substring(0, pos);
            InputData id = this.inputs.get(middle);
            if (id == null) {
                throw new ToolException("input " + middle + " not found", 5);
            }
            if (id.getInputValue() == null || id.getInputValue().length() == 0) {
                this.componentToFocus = (JComponent)((Object)id);
                throw new ToolException("Le champ d\u00e9sign\u00e9 par le curseur doit \u00eatre rempli.", 6);
            }
            if (id.getInputValue() != null && id.getInputValue().indexOf(34) >= 0) {
                this.componentToFocus = (JComponent)((Object)id);
                throw new ToolException("Le champ d\u00e9sign\u00e9 par le curseur ne doit pas contenir de guillemets.", 6);
            }
            if (id instanceof MTextField) {
                MTextField df = (MTextField)id;
                if ("numeric".equals(df.getDatatype())) {
                    try {
                        Float.parseFloat(df.getText());
                    }
                    catch (NumberFormatException mfEx) {
                        throw new ToolException("Le champ d\u00e9sign\u00e9 par le curseur doit contenir une valeur num\u00e9rique.", 6);
                    }
                } else if ("date".equals(df.getDatatype())) {
                    expr = expr.replace("##" + middle + "##", id.getXmlFormattedDate());
                }
                if (df.getMarshallModel() instanceof InputModel) {
                    InputData op;
                    InputModel im = (InputModel)df.getMarshallModel();
                    MainWindow.getInstance().setCriteriaInputValue(im.getKeyName(), df.isEditable() ? id.getInputValue() : null);
                    if (im.getDatatype() != null && !im.hasToRemoveOperator() && (op = this.inputs.get("OPERATEUR:" + im.getId())) instanceof MComboBox) {
                        MComboBox cbxOp = (MComboBox)op;
                        int selectedIx = cbxOp.getSelectedIndex();
                        MainWindow.getInstance().setCriteriaInputValue(im.getKeyName() + ".OPERATEUR", Integer.toString(selectedIx));
                    }
                }
            }
            expr = expr.replace("##" + middle + "##", id.getInputValue());
            ix = expr.indexOf("##");
        }
        expr = expr.replaceAll("\\{", "[").replaceAll("\\}", "]");
        return expr;
    }

    public Hashtable<String, String> getParameters() throws ToolException {
        Hashtable<String, String> ret = new Hashtable<String, String>();
        Enumeration<InputData> enumer = this.inputs.elements();
        while (enumer.hasMoreElements()) {
            InputData id = enumer.nextElement();
            if (id.getInputValue() == null || id.getInputValue().length() == 0) {
                this.componentToFocus = (JComponent)((Object)id);
                throw new ToolException("Le champ d\u00e9sign\u00e9 par le curseur doit \u00eatre rempli.", 6);
            }
            if (id.getInputValue() != null && id.getInputValue().indexOf(34) >= 0) {
                this.componentToFocus = (JComponent)((Object)id);
                throw new ToolException("Le champ d\u00e9sign\u00e9 par le curseur ne doit pas contenir de guillemets.", 6);
            }
            if (id instanceof MTextField) {
                MTextField df = (MTextField)id;
                if ("numeric".equals(df.getDatatype())) {
                    try {
                        Float.parseFloat(df.getText());
                    }
                    catch (NumberFormatException mfEx) {
                        this.componentToFocus = df;
                        throw new ToolException("Le champ d\u00e9sign\u00e9 par le curseur doit contenir une valeur num\u00e9rique.", 6);
                    }
                }
                if ("date".equals(df.getDatatype())) {
                    try {
                        sdf.parse(df.getText());
                    }
                    catch (ParseException pEx) {
                        this.componentToFocus = df;
                        throw new ToolException("Le champ d\u00e9sign\u00e9 par le curseur doit contenir une date au format " + DATE_FORMAT, 6);
                    }
                }
            }
            String name = id.getName();
            ret.put(name, id.getInputValue());
        }
        return ret;
    }

    public String getAndOrEr() {
        if (this.hideRemoveIcon) {
            return "";
        }
        return ((Pair)this.cbxAndOr.getSelectedItem()).key;
    }

    public void doFocusOnError() {
        if (this.componentToFocus != null) {
            this.componentToFocus.grabFocus();
        }
    }

    public XmlMarshallable getXmlMarshallable() {
        this.currentCritereModel.getValeurs().removeAllElements();
        this.currentCritereModel.removeAllProperties();
        this.currentCritereModel.setDisplayOptional(this.isOptionalDisplayChecked());
        if (this.cbxAndOr != null && this.cbxAndOr.getSelectedItem() != null) {
            try {
                this.currentCritereModel.addChild((XmlMarshallable)new PropertyModel("AND_OR", ((Pair)this.cbxAndOr.getSelectedItem()).key), PropertyModel.QN);
            }
            catch (SAXException saxEx) {
                // empty catch block
            }
        }
        for (InputData id : this.orderedInputs) {
            try {
                this.currentCritereModel.addChild((XmlMarshallable)new PropertyModel(id.getName(), id.getInputValue()), PropertyModel.QN);
            }
            catch (SAXException sAXException) {}
        }
        return this.currentCritereModel;
    }

    public CritereModel getModel() {
        return (CritereModel)this.getXmlMarshallable();
    }

    public void setInputValue(String inputId, String value) {
        InputData id = this.inputs.get(inputId);
        if (id != null) {
            id.setInputValue(value);
        }
    }

    public CritereModel getCurrentCritereModel() {
        return this.currentCritereModel;
    }

    public boolean isHideRemoveIcon() {
        return this.hideRemoveIcon;
    }

    private class JFocusableLabel
    extends JLabel {
        public JFocusableLabel(Icon icon, Action act) {
            super(icon);
            this.setFocusable(true);
            this.setBorder(new EmptyBorder(2, 2, 2, 2));
            this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "CLICK");
            this.getActionMap().put("CLICK", act);
            this.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ((JFocusableLabel)e.getComponent()).paintFocus();
                }

                public void focusLost(FocusEvent e) {
                    ((JFocusableLabel)e.getComponent()).paintFocus();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    JFocusableLabel.this.requestFocus();
                }
            });
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintFocus(g);
        }

        protected void paintFocus(Graphics g) {
            if (g == null) {
                return;
            }
            if (this.isFocusOwner()) {
                g.setColor(UIManager.getColor("Button.focus"));
            } else {
                g.setColor(UIManager.getColor("Label.background"));
            }
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }

        protected void paintFocus() {
            this.paintFocus(this.getGraphics());
        }

        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            this.invalidate();
        }
    }

    private class MComboBoxItemListener
    implements ItemListener {
        private SelectModel sm;
        private DocumentModel dm;
        private Pair collectivite;
        private MComboBox mcb;
        private MComboBox mcbListeCorresLib;

        public MComboBoxItemListener(CriteriaViewer cv, SelectModel sm, Pair collectivite, MComboBox mcbox, MComboBox mcboxListeCorrsLib) {
            this.sm = sm;
            this.collectivite = collectivite;
            this.dm = cv.dm;
            this.mcb = mcbox;
            this.mcbListeCorresLib = mcboxListeCorrsLib;
        }

        public void itemStateChanged(ItemEvent evt) {
            try {
                Pair repository = (Pair)this.mcb.getSelectedItem();
                Vector vRepository = (Vector)DataLayerManager.getImplementation().queryRepository(this.dm, this.collectivite, (RecherchePaireModel)this.sm.getRecherches().get(0), repository, CriteriaViewer.this.parent.getUser());
                this.mcbListeCorresLib.setData(vRepository);
            }
            catch (UnauthorizedException ex) {
                JOptionPane.showMessageDialog(CriteriaViewer.this, ex.getMessage(), "Droits insuffisants", 2);
            }
            catch (DataConfigurationException e) {
                e.printStackTrace();
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private class SpecialKeyFocusAdapter
    extends FocusAdapter {
        private CriteriaViewer cv;
        private SelectModel sm;
        private SpecialKeyEntryModel skem;
        private DocumentModel dm;
        private Pair collectivite;
        private Pair budget;

        public SpecialKeyFocusAdapter(CriteriaViewer cv, SpecialKeyEntryModel skem, SelectModel sm, Pair collectivite, Pair budget) {
            this.cv = cv;
            this.skem = skem;
            this.sm = sm;
            this.collectivite = collectivite;
            this.budget = budget;
            this.dm = cv.dm;
        }

        public void focusGained(FocusEvent evt) {
            JComboBox cbx = (JComboBox)evt.getSource();
            cbx.removeFocusListener(this);
            cbx.removeAllItems();
            Vector<Pair> data = new Vector<Pair>();
            try {
                if (this.sm.getOptions() != null) {
                    for (OptionModel om : this.sm.getOptions()) {
                        data.add(new Pair(om.getValue(), om.getLibelle()));
                    }
                }
                for (ResourceRefModel rrm : this.sm.getResources()) {
                    ResourceModel rm = this.dm.getResource(rrm.getRefId());
                    for (XmlMarshallable ob : rm.getData()) {
                        if (!(ob instanceof OptionModel)) continue;
                        OptionModel om = (OptionModel)ob;
                        data.add(new Pair(om.getValue(), om.getLibelle()));
                    }
                }
                for (RecherchePaireModel rpm : this.sm.getRecherches()) {
                    if (rpm.getPath() == null) continue;
                    try {
                        data.addAll(DataLayerManager.getImplementation().queryRepository(this.dm, this.collectivite, rpm, CriteriaViewer.this.parent.getUser()));
                    }
                    catch (Exception dbEx) {
                        Container comp2;
                        for (comp2 = cbx; comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
                        }
                        if (comp2 != null) {
                            new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)dbEx);
                            continue;
                        }
                        dbEx.printStackTrace();
                    }
                }
                String key1 = null;
                String key2 = null;
                String path = this.skem.getKey1().getData();
                String itemName = path.substring(2, path.length() - 2);
                InputData id = (InputData)this.cv.inputs.get(itemName);
                if (id.getInputValue() != null && id.getInputValue().length() > 0) {
                    key1 = id.getInputValue();
                }
                Collection tmp = this.sm.getNewRecipient();
                if (this.skem.getPos() == 2) {
                    tmp.addAll(DataLayerManager.getImplementation().getSpecialKeys2(this.dm, this.collectivite, this.budget, new Pair(key1, key1), this.skem.isDistinct(), CriteriaViewer.this.parent.getUser()));
                } else {
                    path = this.skem.getKey1().getData();
                    itemName = path.substring(2, path.length() - 2);
                    id = (InputData)this.cv.inputs.get(itemName);
                    if (id.getInputValue() != null && id.getInputValue().length() > 0) {
                        key2 = id.getInputValue();
                    }
                    tmp.addAll(DataLayerManager.getImplementation().getSpecialKeys3(this.dm, this.collectivite, this.budget, new Pair(key1, key1), new Pair(key2, key2), this.skem.isDistinct(), CriteriaViewer.this.parent.getUser()));
                }
                data.addAll(tmp);
                for (Pair p : data) {
                    cbx.addItem(p);
                }
                cbx.setPopupVisible(true);
                cbx.grabFocus();
                cbx.addFocusListener(this);
            }
            catch (UnauthorizedException ex) {
                JOptionPane.showMessageDialog(CriteriaViewer.this, ex.getMessage(), "Droits insuffisants", 2);
            }
            catch (DataConfigurationException dcEx) {
                logger.error((Object)"dans focusGained", (Throwable)dcEx);
            }
            catch (DataAccessException daEx) {
                logger.error((Object)"dans focusGained", (Throwable)daEx);
            }
        }
    }

    private class JHelpButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private JTextField targetField;
        private String path;
        private Pair collectivite;
        private Pair budget;
        private ElementModel em;

        JHelpButton(JTextField targetField, ElementModel elementModel, Pair collectivite, Pair budget, String path) {
            super("...");
            this.targetField = targetField;
            this.path = path;
            this.em = elementModel;
            this.collectivite = collectivite;
            this.budget = budget;
            Dimension fieldSize = targetField.getPreferredSize();
            this.setPreferredSize(new Dimension((int)fieldSize.getHeight(), (int)fieldSize.getHeight()));
            this.setToolTipText("Liste des \u00e9l\u00e9ments");
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JHelpButton.this.displayHelpBox();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void displayHelpBox() {
            TreeSet<String> values = new TreeSet<String>();
            try {
                Container c;
                this.setCursor(new Cursor(3));
                values.addAll(DataLayerManager.getImplementation().getDistinctValues(this.em, this.collectivite, this.budget, this.path, CriteriaViewer.this.parent.getUser()));
                for (c = CriteriaViewer.this.parent; c != null && !(c instanceof JFrame); c = c.getParent()) {
                }
                JFrame parent = (JFrame)c;
                DlgSelectFromList dsfl = new DlgSelectFromList((Frame)parent, values);
                if (dsfl.run()) {
                    this.targetField.setText(dsfl.getSelectedValue());
                }
            }
            catch (Throwable t) {
                Container c;
                for (c = CriteriaViewer.this.parent; c != null && !(c instanceof JFrame); c = c.getParent()) {
                }
                new DisplayExceptionDlg((Frame)((JFrame)c), t);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private class DateFilteredField
    extends PlainDocument {
        private static final long serialVersionUID = 2758758288192923608L;
        private String format = null;

        public DateFilteredField(String format) {
            this.format = format;
        }

        public DateFilteredField() {
            this(DATE_FORMAT);
        }

        public String getFormat() {
            return this.format;
        }

        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getFormat() == null || this.getFormat().length() == 0) {
                return;
            }
            if (offset >= this.getFormat().length()) {
                return;
            }
            char aChar = str.charAt(0);
            char fChar = this.getFormat().charAt(offset);
            if (Character.isDigit(aChar) == Character.isLetter(fChar) && Character.isLetterOrDigit(fChar)) {
                super.insertString(offset, str, attr);
                if (++offset < this.getFormat().length()) {
                    char bChar = this.getFormat().charAt(offset);
                    String sChar = Character.toString(bChar);
                    if (!Character.isLetterOrDigit(bChar) && !sChar.equals(this.getText(offset, 1))) {
                        super.insertString(offset, sChar, attr);
                    }
                }
            }
        }

        public void remove(int offset, int len) throws BadLocationException {
            if (this.getFormat() == null || this.getFormat().length() == 0) {
                return;
            }
            super.remove(offset, len);
            char bChar = this.getFormat().charAt(offset);
            if (!Character.isLetterOrDigit(bChar)) {
                super.remove(--offset, 1);
            }
        }
    }

    private class UppercaseFilteredField
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private UppercaseFilteredField() {
        }

        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            str = str.toUpperCase();
            super.insertString(offset, str, attr);
        }
    }

    class MTextField
    extends JTextField
    implements InputData {
        private static final long serialVersionUID = 1L;
        private InputModel im;

        public MTextField(InputModel im) {
            this.im = im;
            if (im.isUppercase()) {
                this.setDocument(new UppercaseFilteredField());
            } else if ("date".equals(im.getDatatype())) {
                this.setDocument(new DateFilteredField());
                this.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        try {
                            Date d = sdf.parse(MTextField.this.getText());
                            MTextField.this.setText(sdf.format(d));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            if (im != null) {
                this.addCaretListener(new CaretListener(){

                    public void caretUpdate(CaretEvent e) {
                        MTextField.this.im.setValue(MTextField.this.getText());
                    }
                });
            }
        }

        public String getXmlFormattedDate() {
            SimpleDateFormat sdfxml = new SimpleDateFormat(this.im.getXmlDateFormat());
            try {
                Date d = sdf.parse(this.getText());
                return sdfxml.format(d);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public String getDatatype() {
            return this.im.getDatatype();
        }

        public String getInputValue() {
            return this.getText();
        }

        public void setInputValue(String data) {
            this.setText(data);
        }

        public XmlMarshallable getMarshallModel() {
            this.im.setValue(this.getInputValue());
            return this.im;
        }

        public Date getDate() {
            if (this.getDatatype().equals("date")) {
                try {
                    return sdf.parse(this.getText());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MComboBox
    extends JComboBox
    implements InputData {
        private static final long serialVersionUID = 1L;
        private SelectModel sm;
        private Hashtable<String, Pair> innerData;

        public MComboBox(Vector<Pair> data) {
            this(data, null);
        }

        public MComboBox(Vector<Pair> data, SelectModel sm) {
            super(data);
            this.setEditable(false);
            this.sm = sm;
            if (sm != null) {
                this.addListener();
            }
            this.innerData = new Hashtable();
            for (Pair p : data) {
                this.innerData.put(p.key, p);
            }
        }

        public MComboBox(Pair[] data) {
            this(data, null);
        }

        public MComboBox(Pair[] data, SelectModel sm) {
            super(data);
            this.setEditable(false);
            this.sm = sm;
            if (sm != null) {
                this.addListener();
            }
            this.innerData = new Hashtable();
            for (int i = 0; i < data.length; ++i) {
                this.innerData.put(data[i].key, data[i]);
            }
        }

        private void addListener() {
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (MComboBox.this.getSelectedItem() != null) {
                        MComboBox.this.sm.setValue(((Pair)MComboBox.this.getSelectedItem()).key);
                    }
                }
            });
        }

        @Override
        public String getInputValue() {
            Object item = this.getSelectedItem();
            if (item == null) {
                return null;
            }
            if (item instanceof Pair) {
                return ((Pair)item).key;
            }
            return item.toString();
        }

        @Override
        public void setInputValue(String data) {
            Pair p;
            if (this.getItemCount() == 0) {
                this.grabFocus();
            }
            if ((p = this.innerData.get(data)) == null) {
                p = new Pair(data, data);
                this.addItem(p);
            }
            if (p != null) {
                this.setSelectedItem(p);
            }
        }

        @Override
        public XmlMarshallable getMarshallModel() {
            if (this.sm == null) {
                return null;
            }
            this.sm.setValue(this.getInputValue());
            return this.sm;
        }

        @Override
        public String getXmlFormattedDate() {
            return "";
        }

        public void setData(Vector<Pair> vpair) {
            this.removeAllItems();
            for (int i = 0; i < vpair.size(); ++i) {
                this.addItem(vpair.get(i));
                this.innerData.put(vpair.get((int)i).key, vpair.get(i));
            }
        }
    }

    static interface InputData {
        public String getInputValue();

        public void setInputValue(String var1);

        public XmlMarshallable getMarshallModel();

        public String getName();

        public String getXmlFormattedDate();
    }
}

