/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugins;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.xemelios.importers.ImportServiceSwingProvider;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.ui.SearchWindow;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PluginModel;
import fr.gouv.finances.dgfip.xemelios.plugins.ExportPlugin;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XemeliosPlugin
extends SwingWorker<Object, String>
implements ExportPlugin.ProgressListener {
    private static final Logger logger = Logger.getLogger(XemeliosPlugin.class);
    public static final int TYPE_SEARCH = 1;
    public static final int TYPE_EXPORT = 2;
    private ElementModel elementModel;
    private EtatModel etatModel;
    private DocumentModel documentModel;
    private Hashtable<String, String> params;
    private PluginModel pm;
    private int maxProgress;
    private String progressMessage;
    private ProgressDlg progress = null;
    private long start;
    private SearchWindow sw;
    private Pair collectivite = null;
    private Pair budget = null;
    private Pair refenrenceNomenclature = null;
    private MainWindow owner;

    public abstract int getPluginType();

    public void setOwner(MainWindow owner) {
        this.owner = owner;
    }

    public JFrame getOwner() {
        return this.owner;
    }

    public void setElementModel(ElementModel em) {
        this.elementModel = em;
        this.etatModel = this.elementModel.getParent();
        this.documentModel = this.etatModel.getParent();
    }

    protected final ElementModel getElementModel() {
        return this.elementModel;
    }

    protected final EtatModel getEtatModel() {
        return this.etatModel;
    }

    protected final DocumentModel getDocumentModel() {
        return this.documentModel;
    }

    public void setParameters(Hashtable<String, String> params) {
        this.params = params;
    }

    protected final Hashtable<String, String> getParameters() {
        return this.params;
    }

    public void setModel(PluginModel pm) {
        this.pm = pm;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getStart() {
        return this.start;
    }

    protected final PluginModel getPluginModel() {
        return this.pm;
    }

    public void setCollectivite(Pair collectivite) {
        this.collectivite = collectivite;
    }

    public void setBudget(Pair budget) {
        this.budget = budget;
    }

    public Pair getBudget() {
        return this.budget;
    }

    public Pair getCollectivite() {
        return this.collectivite;
    }

    public void setProgressInfos(int maxProgress, String progressMessage) {
        this.maxProgress = maxProgress;
        this.progressMessage = progressMessage;
    }

    public void pushProgress() {
        if (this.progress != null) {
            this.progress.pushProgress();
        }
    }

    public void setProgressVisible(boolean show) {
        if (show) {
            this.progress = new ProgressDlg(this.owner, this.maxProgress, this.progressMessage);
            this.progress.setVisible(true);
        } else if (this.progress != null) {
            this.progress.setDefaultCloseOperation(2);
            this.progress.setVisible(false);
        }
    }

    public void done() {
        this.owner.stopWaiter();
    }

    public void setSearchWindow(SearchWindow sw) {
        this.sw = sw;
    }

    public SearchWindow getSearchWindow() {
        return this.sw;
    }

    public final class ProgressDlg
    extends JDialog
    implements ExportPlugin.ProgressListener {
        private static final long serialVersionUID = 1L;
        public static final String DEFAULT_TEXT = "Recherche en cours : ";
        private ImportServiceSwingProvider.PaintableProgress globalProgress;
        private int maxProgress;
        private int value;
        private String progressMessage;

        public ProgressDlg(JFrame owner, int maxProgress, String progressMessage) {
            super((Frame)owner, DEFAULT_TEXT);
            this.value = 0;
            this.maxProgress = maxProgress;
            this.progressMessage = progressMessage;
            this.initComponents();
        }

        protected void initComponents() {
            IhmFactory iF = IhmFactory.newInstance();
            FormLayout fl = null;
            fl = new FormLayout("3dlu,pref,3dlu", "3dlu,pref,1dlu,pref,3dlu");
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(fl);
            pb.add((Component)iF.newLabel(this.progressMessage, "normal"), cc.xy(2, 2));
            this.globalProgress = new ImportServiceSwingProvider.PaintableProgress(0, 100);
            this.globalProgress.setStringPainted(true);
            this.globalProgress.setMaximum(this.maxProgress);
            pb.add((Component)this.globalProgress, cc.xy(2, 4));
            this.setContentPane(pb.getPanel());
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
            this.setVisible(true);
            Graphics g = this.getGraphics();
            g.setClip(0, 0, this.getWidth(), this.getHeight());
            this.paint(g);
        }

        public void repaintImmediatly() {
            Runnable code = new Runnable(){

                public void run() {
                    ProgressDlg.this.globalProgress.paintImmediatly();
                    Graphics g = ProgressDlg.this.getGraphics();
                    g.setClip(0, 0, ProgressDlg.this.getWidth(), ProgressDlg.this.getHeight());
                    if (ProgressDlg.this.isLightweight()) {
                        ProgressDlg.this.paint(g);
                    } else {
                        ProgressDlg.this.update(g);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                code.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(code);
                }
                catch (Throwable t) {
                    logger.error((Object)"repaintImmediatly", t);
                }
            }
        }

        public void pushProgress() {
            ++this.value;
            this.globalProgress.setValue(this.value);
            this.repaintImmediatly();
        }

        public void setProgressInfos(int maxProgress, String progressMessage) {
        }

        public void setProgressVisible(boolean show) {
        }
    }
}

