/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.tech;

import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.models.DocumentControlModel;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModelTech;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TECH04
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(TECH04.class);
    public static final transient String CTRL_ID = "TECH04";
    private Vector<Anomalie> anos = new Vector();
    public String baliseCourante = "";
    public StringBuffer message = new StringBuffer();
    public StringBuffer domaines = new StringBuffer();
    private DocumentModel docModel;
    private DocumentControlModel docControlModel;
    private String severity = "BLOQUANT";
    private Vector<ParamModelTech> parameters;
    private String id_Unique = "";

    protected void createAnomalie(String nodeId, String lengthError, String lengthOk, String numLigne, String name) {
        String path = "@ano:unique-id='" + this.id_Unique + "'";
        Anomalie anomalie = new Anomalie(IdGenerator.nextId(), CTRL_ID, this.docControlModel.getControlTechById(CTRL_ID).getLibelle(), this.docModel.getId(), this.getParameter("ETAT"), this.getParameter("ELEMENT_IMPORTABLE"), "", "", "Ligne n\u00b0" + numLigne + " : Longueur incorrecte : " + lengthError + ".", "&lt;b&gt;Ligne n\u00b0" + numLigne + "&lt;/b&gt; : La ligne&#160;&lt;b&gt;'" + name + "'&lt;/b&gt;&#160;a une longueur de&#160;&lt;b&gt;" + lengthError + "&lt;/b&gt;&#160;alors qu'elle devrait \u00eatre de&#160;&lt;b&gt;" + lengthOk + "&lt;/b&gt;.", "La ligne doit avoir une longueur correcte.", this.severity, this.id_Unique.length() > 0 ? path : "xpath namespacise", new Hashtable<String, Object>());
        anomalie.addNode(new Node(nodeId));
        this.anos.add(anomalie);
    }

    private String addMessage(SAXParseException e) {
        return "&lt;b&gt;Line n\u00b0" + e.getLineNumber() + " : &lt;/b&gt;" + e.getMessage().replaceAll("<", "").replaceAll(">", "").replaceAll("/", "");
    }

    @Override
    public void startDocument() throws SAXException {
        logger.info((Object)"In TECH04");
        this.parameters = this.getParams();
    }

    @Override
    public void startElement(String URI2, String localName, String rawName, Attributes attributs) throws SAXException {
        if (this.baliseIsToControl(localName)) {
            String lengths;
            String nodeId = attributs.getValue("ano:node-id");
            String numLigne = attributs.getValue("txt2xml:LineTxt");
            String string = lengths = attributs.getValue("txt2xml:Length") != null ? attributs.getValue("txt2xml:Length") : "";
            if (lengths.length() > 0 && lengths.contains(";")) {
                String[] tabLengths = lengths.split(";");
                this.createAnomalie(nodeId, tabLengths[0], tabLengths[1], numLigne, localName);
            }
        } else if (localName.equals(this.baliseToLink())) {
            this.id_Unique = attributs.getValue("ano:unique-id");
        }
    }

    public void setDocumentModel(DocumentModel dm) {
        this.docModel = dm;
    }

    public void setDocumentControlModel(DocumentControlModel dcm) {
        this.docControlModel = dcm;
        this.severity = this.docControlModel.getControlTechById(CTRL_ID).getSeverity();
    }

    public Vector<Anomalie> getAnomalies() {
        return this.anos;
    }

    private Vector<ParamModelTech> getParams() {
        return this.docControlModel.getControlTechById(CTRL_ID).getParams();
    }

    private boolean baliseIsToControl(String name) {
        for (ParamModelTech param : this.parameters) {
            if (!param.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private String baliseToLink() {
        for (ParamModelTech param : this.parameters) {
            if (!param.getId().equals("BALISE_TO_LINK_PATH")) continue;
            return param.getValue();
        }
        return "";
    }

    private String getParameter(String id) {
        for (ParamModelTech param : this.parameters) {
            if (!param.getId().equals(id)) continue;
            return param.getValue();
        }
        return "";
    }
}

