/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.models;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.controls.ControlParser;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModelTech;
import fr.gouv.finances.dgfip.xemelios.common.config.TextModel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlModelTech
implements XmlMarshallable {
    public static final transient String TAG = "controlTech";
    public static final transient QName QN = new QName("controlTech");
    public String id;
    public String libelle;
    public String severity;
    public Vector<ParamModelTech> params = new Vector();
    private Hashtable<String, ParamModelTech> indexedParamsTech = new Hashtable();
    private ArrayList<TextModel> ignoreRegexp = new ArrayList();

    public ControlModelTech(QName tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (ParamModelTech.QN.equals(tagName)) {
            ParamModelTech cm = (ParamModelTech)child;
            if (this.indexedParamsTech.containsKey(cm.getId())) {
                ParamModelTech old = this.indexedParamsTech.get(cm.getId());
                this.params.remove(old);
                this.indexedParamsTech.remove(old.getId());
            }
            this.params.add(cm);
            this.indexedParamsTech.put(cm.getId(), cm);
        } else if (ControlParser.IGNORE_REGEXP.equals(tagName)) {
            this.ignoreRegexp.add((TextModel)child);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.libelle = attributes.getValue("libelle");
        this.severity = attributes.getValue("severity");
        return this;
    }

    public void validate() throws InvalidXmlDefinition {
        for (ParamModelTech pcm : this.params) {
            pcm.validate();
        }
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        output.addAttribute("libelle", this.libelle);
        output.addAttribute("severity", this.severity);
        for (ParamModelTech pcm : this.params) {
            pcm.marshall(output);
        }
        for (TextModel ir : this.ignoreRegexp) {
            ir.marshall(output);
        }
        output.endTag(TAG);
    }

    public String getId() {
        return this.id;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public String getSeverity() {
        return this.severity;
    }

    public Vector<ParamModelTech> getParams() {
        return this.params;
    }

    public ParamModelTech getParamTechById(String ctrlId) {
        return this.indexedParamsTech.get(ctrlId);
    }

    public ControlModelTech clone() {
        ControlModelTech cm = new ControlModelTech(QN);
        cm.id = this.id;
        cm.libelle = this.libelle;
        cm.severity = this.severity;
        for (ParamModelTech pmt : this.getParams()) {
            try {
                this.addChild(pmt.clone(), ParamModelTech.QN);
            }
            catch (SAXException ignore) {}
        }
        return cm;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        if (ParamModelTech.QN.equals(new QName(uri, localName))) {
            return this.indexedParamsTech.get(atts.getValue("id"));
        }
        return null;
    }

    public QName getQName() {
        return QN;
    }

    public ArrayList<TextModel> getIgnoreRegexp() {
        return this.ignoreRegexp;
    }
}

