/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.models;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModel;
import fr.gouv.finances.cp.xemelios.controls.processors.Processor;
import fr.gouv.finances.dgfip.utils.xml.XmlAttributesImpl;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AddOnModel
implements XmlMarshallable {
    private static final Logger logger = Logger.getLogger(AddOnModel.class);
    public static final transient String TAG = "add-on";
    public static final transient QName QN = new QName("add-on");
    private Hashtable<String, ParamModel> parameters = new Hashtable();
    private String name;
    private Processor processor;

    public AddOnModel(QName qn) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tag) throws SAXException {
        if (tag.equals(ParamModel.QN)) {
            ParamModel p = (ParamModel)child;
            this.parameters.put(p.getId(), p);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.name = attributes.getValue("name");
        return this;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        if (atts.getValue("name") != null) {
            return this.parameters.get(atts.getValue("name"));
        }
        return null;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(QN);
        output.addAttribute("name", this.name);
        for (ParamModel p : this.parameters.values()) {
            p.marshall(output);
        }
        output.endTag(QN);
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public QName getQName() {
        return QN;
    }

    public AddOnModel clone() {
        AddOnModel other = new AddOnModel(QN);
        other.name = this.name;
        for (ParamModel p : this.parameters.values()) {
            try {
                other.addChild(p, ParamModel.QN);
            }
            catch (Throwable t) {}
        }
        return other;
    }

    public boolean isConcernedBy(Processor.EVENT evt, String uri, String localName, String qName) {
        boolean ret = true;
        String targetEvent = (String)this.parameters.get("event").getValue();
        if (!"*".equals(targetEvent)) {
            switch (evt) {
                case START_DOCUMENT: {
                    ret = targetEvent.contains("start.document");
                    break;
                }
                case START_ELEMENT: {
                    ret = targetEvent.contains("start.element");
                    break;
                }
                case END_ELEMENT: {
                    ret = targetEvent.contains("end.element");
                    break;
                }
                case END_DOCUMENT: {
                    ret = targetEvent.contains("end.document");
                    break;
                }
                default: {
                    ret = false;
                }
            }
            if (!ret) {
                logger.debug((Object)(this.name + " is not concerned by " + qName));
            }
        }
        if (ret && (evt == Processor.EVENT.START_ELEMENT || evt == Processor.EVENT.END_ELEMENT)) {
            ret = this.parameters.get("element.name").getValue().equals(localName);
        }
        return ret;
    }

    public Processor getProcessor() {
        if (this.processor == null) {
            try {
                Class<?> clazz = Class.forName((String)this.parameters.get("processor").getValue());
                this.processor = (Processor)clazz.newInstance();
                ArrayList<ParamModel> params = new ArrayList<ParamModel>();
                for (ParamModel p : this.parameters.values()) {
                    params.add(p);
                }
                this.processor.setParameters(params);
            }
            catch (Throwable t) {
                logger.error((Object)"getProcessor()", t);
            }
        }
        return this.processor;
    }

    public void process(Processor.EVENT evt, String uri, String localName, String qName, XmlAttributesImpl atts) {
        this.getProcessor().process(evt, uri, localName, qName, atts);
    }

    public void process(Processor.EVENT evt, String uri, String localName, String qName) {
        this.getProcessor().process(evt, uri, localName, qName);
    }

    public void process(Processor.EVENT evt) {
        this.getProcessor().process(evt);
    }
}

