/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.editors;

import fr.gouv.finances.cp.utils.StartUrl;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.xemelios.ui.HtmlViewer;
import fr.gouv.finances.cp.xemelios.ui.UpdatableToolbar;
import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.LocalException;
import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.XemeliosUserAgent;
import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.XemeliosXhtmlPanel;
import fr.gouv.finances.dgfip.utils.Base64;
import fr.gouv.finances.dgfip.utils.Dest;
import fr.gouv.finances.dgfip.utils.IoUtils;
import fr.gouv.finances.dgfip.utils.NavigationContext;
import fr.gouv.finances.dgfip.utils.xml.NamespaceContextImpl;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.DematTransform;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.utils.AbstractUriTransformer;
import fr.gouv.finances.dgfip.xemelios.utils.FileUtils;
import fr.gouv.finances.dgfip.xemelios.utils.XmlUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.TransformerFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.swing.ScaleChangeEvent;
import org.xhtmlrenderer.swing.ScaleChangeListener;
import org.xhtmlrenderer.swing.SelectionHighlighter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorHtmlViewer
extends JFrame
implements UpdatableToolbar,
ScaleChangeListener {
    public static String DEFAULT_TITLE = "Document Xemelios";
    private Hashtable<String, File> documents = null;
    private DocumentsModel documentsModel = null;
    private XemeliosUserAgent userAgent = null;
    private final XemeliosXhtmlPanel xhtmlRenderer;
    private JComboBox cbxZoom;
    private HtmlViewer.ScaleFactor[] availableScales;
    private JButton pbPrint;
    private JButton pbPrevious;
    private JButton pbNext;
    private JTextField dfUrl;
    private SelectionHighlighter highlighter;
    private JButton pbCopy;

    public EditorHtmlViewer(Hashtable<String, File> documents, DocumentsModel documentsModel, String uri, XemeliosUser user) {
        super(DEFAULT_TITLE);
        this.documents = documents;
        this.documentsModel = documentsModel;
        this.userAgent = new LocalUserAgent(this, this, this.documentsModel, this.documents, user);
        this.xhtmlRenderer = new XemeliosXhtmlPanel((UserAgentCallback)this.userAgent, this){

            public void setDocument(File file) throws Exception {
                super.setDocument(file);
                this.setScalePolicy(0);
            }

            public void setDocument(Document doc, String url) {
                super.setDocument(doc, url);
                this.setScalePolicy(0);
            }

            public void setDocument(InputStream stream, String url) throws Exception {
                super.setDocument(stream, url);
                this.setScalePolicy(0);
            }
        };
        this.initializeComponents(uri);
        this.setDefaultCloseOperation(3);
    }

    public void scaleChanged(ScaleChangeEvent evt) {
        if (evt.getComponent() == this.xhtmlRenderer) {
            ItemListener[] iListeners;
            double scale = evt.getScale();
            int ix = -1;
            for (int i = 0; i < this.availableScales.length; ++i) {
                HtmlViewer.ScaleFactor sf = this.availableScales[i];
                if (sf.getFactor() != scale) continue;
                ix = i;
                break;
            }
            for (ItemListener il : iListeners = this.cbxZoom.getItemListeners()) {
                this.cbxZoom.removeItemListener(il);
            }
            if (ix == -1) {
                int scalePolicy = this.xhtmlRenderer.getScalePolicy();
                switch (scalePolicy) {
                    case 1: {
                        ix = 8;
                        break;
                    }
                    case 2: {
                        ix = 9;
                        break;
                    }
                    case 3: {
                        ix = 10;
                    }
                }
            }
            this.cbxZoom.setSelectedIndex(ix);
            for (ItemListener il : iListeners) {
                this.cbxZoom.addItemListener(il);
            }
        }
    }

    protected void initializeComponents(String uri) {
        HtmlViewer.ScaleFactor[] scales = HtmlViewer.initializeScales();
        this.availableScales = scales;
        IhmFactory iF = IhmFactory.newInstance();
        this.xhtmlRenderer.addScaleChangeListener(this);
        MouseListener[] lls = this.xhtmlRenderer.getMouseListeners();
        this.highlighter = new SelectionHighlighter();
        this.highlighter.install((XHTMLPanel)this.xhtmlRenderer);
        this.xhtmlRenderer.addMouseListener((MouseListener)this.highlighter);
        this.getContentPane().setLayout(new BorderLayout());
        JToolBar tb = new JToolBar();
        this.pbPrevious = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/previous.png"));
        tb.add(this.pbPrevious);
        this.pbNext = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/next.png"));
        tb.add(this.pbNext);
        this.pbPrint = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/print.png"));
        tb.add(this.pbPrint);
        AbstractAction copyAction = new AbstractAction(null, IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/edit-copy.png")){

            public void actionPerformed(ActionEvent e) {
                try {
                    DocumentFragment df = EditorHtmlViewer.this.highlighter.getSelectionRange().extractContents();
                    StringSelection ss = new StringSelection(XmlUtils.getStringRepresentation((DocumentFragment)df));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.pbCopy = new JButton(copyAction);
        tb.add(this.pbCopy);
        this.pbCopy.setToolTipText("Copier");
        AbstractAction selectAllAction = new AbstractAction(null, IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/edit-select-all.png")){

            public void actionPerformed(ActionEvent e) {
                EditorHtmlViewer.this.highlighter.selectAll();
            }
        };
        JButton pbSelectAll = new JButton(selectAllAction);
        pbSelectAll.setToolTipText("Tout s\u00e9lectionner");
        tb.add(pbSelectAll);
        this.getRootPane().registerKeyboardAction(copyAction, "copy", KeyStroke.getKeyStroke("ctrl C"), 2);
        this.getRootPane().registerKeyboardAction(selectAllAction, "selectAll", KeyStroke.getKeyStroke("ctrl A"), 2);
        tb.addSeparator();
        tb.add(iF.newLabel("URL ", "normal"));
        this.dfUrl = new JTextField();
        tb.add(this.dfUrl);
        this.dfUrl.setEditable(false);
        Dimension dim = this.dfUrl.getMinimumSize();
        this.dfUrl.setMinimumSize(new Dimension(100, (int)dim.getHeight()));
        tb.addSeparator();
        tb.add(iF.newLabel("Zoom ", "normal"));
        this.cbxZoom = new JComboBox<HtmlViewer.ScaleFactor>(scales);
        this.cbxZoom.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    HtmlViewer.ScaleFactor factor = (HtmlViewer.ScaleFactor)e.getItem();
                    if (factor.getFactor() == -2.0) {
                        EditorHtmlViewer.this.xhtmlRenderer.setScalePolicy(1);
                        EditorHtmlViewer.this.xhtmlRenderer.doLayout();
                    } else if (factor.getFactor() == -3.0) {
                        EditorHtmlViewer.this.xhtmlRenderer.setScalePolicy(2);
                        EditorHtmlViewer.this.xhtmlRenderer.doLayout();
                    } else if (factor.getFactor() == -4.0) {
                        EditorHtmlViewer.this.xhtmlRenderer.setScalePolicy(3);
                        EditorHtmlViewer.this.xhtmlRenderer.doLayout();
                    } else {
                        EditorHtmlViewer.this.xhtmlRenderer.setScale(factor.getFactor());
                    }
                }
            }
        });
        this.cbxZoom.setSelectedIndex(2);
        tb.add(this.cbxZoom);
        this.getContentPane().add((Component)tb, "First");
        FSScrollPane scroller = new FSScrollPane((JPanel)((Object)this.xhtmlRenderer));
        this.getContentPane().add((Component)scroller, "Center");
        scroller.setMinimumSize(new Dimension(1, 2));
        scroller.setPreferredSize(new Dimension(1, 2));
        scroller.setIgnoreRepaint(false);
        this.pbPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorHtmlViewer.this.printToPDF();
            }
        });
        this.pbPrint.setToolTipText("Imprimer");
        this.pbPrevious.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorHtmlViewer.this.goBack();
            }
        });
        this.pbNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorHtmlViewer.this.goForward();
            }
        });
        this.pbPrevious.setEnabled(false);
        this.pbNext.setEnabled(false);
        if (uri != null) {
            try {
                String eForm = this.userAgent.resolveURI(uri);
                if (eForm != null) {
                    this.dfUrl.setText(eForm);
                    this.xhtmlRenderer.setDocument(eForm);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(1);
            }
        }
        this.pack();
        this.setSize(700, 600);
    }

    protected void printToPDF() {
        try {
            File fToPDFize;
            File tmp = File.createTempFile("xemelios-data-", ".pdf", FileUtils.getTempDir());
            FileOutputStream os = new FileOutputStream(tmp);
            ITextRenderer renderer = new ITextRenderer();
            String fileName = this.dfUrl.getText();
            int posDiez = fileName.indexOf("#");
            if (posDiez != -1) {
                fileName = fileName.substring(0, posDiez);
            }
            if ((fToPDFize = new File(new URL(fileName).toURI())).exists()) {
                renderer.setDocument(fToPDFize);
                renderer.layout();
                renderer.createPDF((OutputStream)os, true);
                os.flush();
                ((OutputStream)os).close();
                StartUrl.startUrl(tmp.toURI().toURL().toExternalForm());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void goBack() {
        if (this.userAgent.hasBack()) {
            this.xhtmlRenderer.setDocument(this.userAgent.getBack());
        } else {
            this.updateToolbarButtons();
        }
    }

    protected void goForward() {
        if (this.userAgent.hasForward()) {
            this.xhtmlRenderer.setDocument(this.userAgent.getForward());
        } else {
            this.updateToolbarButtons();
        }
    }

    @Override
    public void updateToolbarButtons() {
        this.pbPrevious.setEnabled(this.userAgent.hasBack());
        this.pbNext.setEnabled(this.userAgent.hasForward());
    }

    @Override
    public void setBaseUrl(String url) {
        this.dfUrl.setText(url);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LocalUserAgent
    extends XemeliosUserAgent {
        private DocumentBuilder db;
        private DocumentsModel documentsModel;
        private Hashtable<String, File> documents;

        public LocalUserAgent(Component parent, UpdatableToolbar tb, DocumentsModel docs, Hashtable<String, File> documents, XemeliosUser user) {
            super(null, parent, tb, user);
            this.db = null;
            this.documentsModel = null;
            this.documents = null;
            this.documentsModel = docs;
            this.documents = documents;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            try {
                this.db = dbf.newDocumentBuilder();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }

        @Override
        public Dest calculateQuery(String query) {
            DocumentModel dm;
            AbstractUriTransformer uriTransformer = null;
            NavigationContext ctx = null;
            ctx = this.nc == null ? new NavigationContext() : this.nc.clone();
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            params.put("browser-destination", "internal");
            String servlet = null;
            String sTmp = query;
            int start = query.indexOf(63);
            if (start >= 0) {
                servlet = query.substring(query.indexOf("/") + 1, start);
                sTmp = query.substring(start + 1);
            }
            if ("query".equals(servlet)) {
                StringTokenizer st = new StringTokenizer(sTmp, "&");
                while (st.hasMoreTokens()) {
                    String data = st.nextToken();
                    int pos = data.indexOf(61);
                    if (pos <= 0) continue;
                    String paramName = data.substring(0, pos);
                    String paramValue = null;
                    try {
                        paramValue = URLDecoder.decode(data.substring(pos + 1), "UTF-8");
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if ("docId".equals(paramName)) {
                        ctx.setDocId(paramValue);
                        String className = this.documentsModel.getDocumentById(paramValue).getGlobalUriTransformer();
                        if (className != null) {
                            try {
                                Class<?> clazz = Class.forName(className);
                                Object o = clazz.newInstance();
                                if (o instanceof AbstractUriTransformer) {
                                    uriTransformer = (AbstractUriTransformer)o;
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace(System.err);
                            }
                        }
                    } else if ("etatId".equals(paramName)) {
                        ctx.setEtatId(paramValue);
                    } else if ("elementId".equals(paramName)) {
                        ctx.setElementId(paramValue);
                    } else if ("collectivite".equals(paramName)) {
                        ctx.setCollectivite(paramValue);
                    } else if ("budget".equals(paramName)) {
                        ctx.setBudget(paramValue);
                    } else if ("sp1".equals(paramName)) {
                        ctx.setSp1(paramValue);
                    } else if ("sp2".equals(paramName)) {
                        ctx.setSp2(paramValue);
                    } else if ("path".equals(paramName)) {
                        ctx.setPath(paramValue);
                    } else if (paramName.startsWith("xsl:param")) {
                        int virg = paramValue.indexOf(44);
                        String pName = paramValue.substring(1, virg);
                        String pValue = paramValue.substring(virg + 1, paramValue.length() - 1);
                        params.put(pName, pValue);
                    }
                    if (uriTransformer == null) continue;
                    uriTransformer.transformUriParam(paramName, paramValue, params);
                }
                return this.generateDestContext(ctx, params, false);
            }
            if ("resource".equals(servlet)) {
                Dest ret = null;
                try {
                    File resourceDir = new File(System.getProperty("xemelios.resources.location"));
                    File res = new File(resourceDir, sTmp);
                    ret = new Dest(res.toURL(), false);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return ret;
            }
            if ("attachment".equals(servlet) && (dm = this.documentsModel.getDocumentById(ctx.getDocId())).getId().equals("PES_Aller")) {
                File fDoc = this.documents.get(ctx.getDocId());
                if (fDoc == null) {
                    JOptionPane.showMessageDialog(EditorHtmlViewer.this, "Aucun " + dm.getTitre() + " disponible.", "Erreur", 0);
                }
                try {
                    String[] args = sTmp.split("&");
                    String idUnique = null;
                    for (String s : args) {
                        if (!s.startsWith("pjId")) continue;
                        idUnique = s.substring(5);
                        break;
                    }
                    Document doc = this.db.parse(fDoc);
                    XPathFactory xpf = XPathFactory.newInstance();
                    XPath xp = xpf.newXPath();
                    NamespaceContextImpl ns = new NamespaceContextImpl();
                    ns.addMapping("n", "http://www.minefi.gouv.fr/cp/helios/pes_v2/Rev0/aller");
                    xp.setNamespaceContext((NamespaceContext)ns);
                    Element pj = (Element)xp.evaluate("//n:PJ[n:IdUnique/@V='" + idUnique + "']", doc, XPathConstants.NODE);
                    if (pj != null) {
                        String nomFichier = xp.evaluate("//n:PJ[n:IdUnique/@V='" + idUnique + "']/n:NomPJ/@V", pj);
                        nomFichier = nomFichier.replaceAll(" ", "_");
                        Element contenu = (Element)xp.evaluate("//n:PJ[n:IdUnique/@V='" + idUnique + "']/n:Contenu", pj, XPathConstants.NODE);
                        if (contenu != null) {
                            Element pesFacture;
                            File tmp = new File(FileUtils.getTempDir(), nomFichier);
                            if (tmp.exists()) {
                                tmp.delete();
                            }
                            if ((pesFacture = (Element)xp.evaluate("n:PESFacture", contenu, XPathConstants.NODE)) != null) {
                                TransformerFactory tFactory = TransformerFactoryImpl.newInstance();
                                Transformer t = tFactory.newTransformer();
                                t.transform(new DOMSource(pesFacture), new StreamResult(tmp));
                            } else {
                                String text = xp.evaluate("//n:PJ[n:IdUnique/@V='" + idUnique + "']/n:Contenu/n:Fichier/text()", contenu);
                                byte[] buffer = Base64.decode((String)text);
                                GZIPInputStream gz = new GZIPInputStream(new ByteArrayInputStream(buffer));
                                FileOutputStream fos = new FileOutputStream(tmp);
                                byte[] array = new byte[1024];
                                int read = gz.read(array);
                                while (read > 0) {
                                    fos.write(array, 0, read);
                                    read = gz.read(array);
                                }
                                fos.flush();
                                fos.close();
                            }
                            StartUrl.startUrl(tmp.toURI().toURL().toExternalForm());
                        } else {
                            JOptionPane.showMessageDialog(EditorHtmlViewer.this, "Le contenu de la PJ n'est pas fournit", "Erreur", 0);
                        }
                    } else {
                        JOptionPane.showMessageDialog(EditorHtmlViewer.this, "La PJ " + idUnique + " n'est pas disponible dans le flux.", "Erreur", 0);
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(EditorHtmlViewer.this, ex.getMessage(), ex.getClass().getName(), 0);
                    ex.printStackTrace();
                }
            }
            return null;
        }

        @Override
        public Dest generateDestContext(NavigationContext ctx, Hashtable<String, Object> params, boolean toExternalDest) {
            boolean noException = false;
            Dest ret = null;
            try {
                DocumentModel dm = this.documentsModel.getDocumentById(ctx.getDocId());
                if (dm == null) {
                    throw new LocalException("doc " + ctx.getDocId() + " inconnu");
                }
                EtatModel em = dm.getEtatById(ctx.getEtatId());
                if (em == null) {
                    throw new LocalException("etat " + ctx.getEtatId() + " inconnu");
                }
                ElementModel element = ctx.getElementId() != null ? em.getElementById(ctx.getElementId()) : em.getBrowsableElement();
                File fDoc = this.documents.get(dm.getId());
                if (fDoc == null) {
                    throw new LocalException("Aucun " + dm.getTitre() + " disponible.");
                }
                Document doc = this.db.parse(fDoc);
                File f = null;
                f = new File(new File(new File(System.getProperty("user.home")), "xemelios/documents-def-ovrrd"), element.getXslt());
                if (!f.exists()) {
                    f = new File(em.getParent().getBaseDirectory(), element.getXslt());
                }
                InputStream is = IoUtils.getInputStream((String)f.getPath());
                Hashtable<String, Object> parameters = new Hashtable<String, Object>();
                parameters.putAll(params);
                if (parameters.get("browser-destination") == null) {
                    parameters.put("browser-destination", em.useExternalBrowser() ? "external" : "internal");
                }
                parameters.put("repository", doc);
                parameters.put("config", this.documentsModel.getSmallDOM());
                if (ctx.getCollectivite() != null) {
                    parameters.put("collectivite", ctx.getCollectivite());
                }
                if (ctx.getBudget() != null) {
                    parameters.put("budget", ctx.getBudget());
                }
                InputStream htmlStream = DematTransform.transform((Node)doc, (InputStream)is, parameters, (String)f.getParentFile().toURI().toURL().toExternalForm());
                File tmp = File.createTempFile("xemelios-data-", ".html", FileUtils.getTempDir());
                BufferedInputStream bis = new BufferedInputStream(htmlStream);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmp));
                byte[] buff = new byte[1024];
                int lengthRead = bis.read(buff);
                while (lengthRead > 0) {
                    bos.write(buff, 0, lengthRead);
                    lengthRead = bis.read(buff);
                }
                bos.flush();
                bos.close();
                URL url = tmp.toURL();
                this.nc = ctx;
                ret = new Dest(url, toExternalDest);
            }
            catch (LocalException lEx) {
                JOptionPane.showMessageDialog(this.getViewer(), lEx.getMessage(), "Erreur de param\u00ef\u00bf\u00bdtrage", 0);
            }
            catch (Exception ex) {
                Component comp2;
                for (comp2 = this.getViewer(); comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
                }
                if (comp2 != null) {
                    new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)ex);
                }
                new DisplayExceptionDlg((Frame)null, (Throwable)ex);
            }
            return ret;
        }
    }
}

