/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls;

import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.RapportWriter;
import fr.gouv.finances.cp.xemelios.controls.models.ControlModel;
import fr.gouv.finances.dgfip.utils.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Anomalie
implements Comparable<Anomalie> {
    public static final String ANOMALY_NS_URI = "http://projets.admisource.gouv.fr/xemelios/namespaces#anomally";
    private String idAnomalie;
    private String controleID;
    private String controleLibelle;
    private String documentID;
    private String etatID;
    private String elementImportable;
    private String idElementImportable;
    private String elementEnAnomalie;
    private String libelleLien;
    private String message;
    private String regle;
    private String severity;
    private String xPath;
    private Hashtable<String, Object> xslParams;
    private ArrayList<Node> nodes;
    private boolean visible = true;

    public Anomalie(String idAnomalie, String controleID, String controleLibelle, String docID, String etatID, String elementImportable, String idElementImportable, String elementEnAnomalie, String libelleLien, String message, String regle, String severity, String xPath, Hashtable<String, Object> xslParams) {
        this.idAnomalie = idAnomalie;
        this.controleID = controleID;
        this.controleLibelle = controleLibelle;
        this.documentID = docID;
        this.etatID = etatID;
        this.elementImportable = elementImportable;
        this.idElementImportable = idElementImportable;
        this.elementEnAnomalie = elementEnAnomalie;
        this.libelleLien = libelleLien;
        this.message = message;
        this.regle = regle;
        this.severity = severity;
        this.xPath = xPath;
        this.xslParams = xslParams;
        this.nodes = new ArrayList();
    }

    public Anomalie(String idAnomalie, ControlModel ctrl, String docID, String etatID, String elementImportable, String idElementImportable, String elementEnAnomalie, String libelleLien, String message, String regle, String severity, String xPath, Hashtable<String, Object> xslParams) {
        this.idAnomalie = idAnomalie;
        this.controleID = ctrl.getId();
        this.controleLibelle = ctrl.getLibelle();
        this.documentID = docID;
        this.etatID = etatID;
        this.elementImportable = elementImportable;
        this.idElementImportable = idElementImportable;
        this.elementEnAnomalie = elementEnAnomalie;
        this.libelleLien = libelleLien;
        this.message = message;
        this.regle = regle;
        this.severity = severity;
        this.xPath = xPath;
        this.xslParams = xslParams;
        this.nodes = new ArrayList();
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public void addAll(Collection<Node> node) {
        this.nodes.addAll(node);
    }

    public String getSeverity() {
        return this.severity;
    }

    public Collection<Node> getNodes() {
        return this.nodes;
    }

    public String getControleID() {
        return this.controleID;
    }

    public void setControleID(String controleID) {
        this.controleID = controleID;
    }

    public String getControleLibelle() {
        return this.controleLibelle;
    }

    public void setControleLibelle(String controleLibelle) {
        this.controleLibelle = controleLibelle;
    }

    public String getDocumentID() {
        return this.documentID;
    }

    public void setDocumentID(String documentID) {
        this.documentID = documentID;
    }

    public String getelementImportable() {
        return this.elementImportable;
    }

    public void setelementImportable(String elementImportable) {
        this.elementImportable = elementImportable;
    }

    public String getelementEnAnomalie() {
        return this.elementEnAnomalie;
    }

    public void setelementEnAnomalie(String elementEnAnomalie) {
        this.elementEnAnomalie = elementEnAnomalie;
    }

    public String getEtatID() {
        return this.etatID;
    }

    public void setEtatID(String etatID) {
        this.etatID = etatID;
    }

    public String getIdAnomalie() {
        return this.idAnomalie;
    }

    public void setIdAnomalie(String idAnomalie) {
        this.idAnomalie = idAnomalie;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRegle() {
        return this.regle;
    }

    public void setRegle(String regle) {
        this.regle = regle;
    }

    public String getXPath() {
        return this.xPath;
    }

    public void setxPath(String pathNameSpacise) {
        this.xPath = pathNameSpacise;
    }

    public Hashtable<String, Object> getXslParams() {
        return this.xslParams;
    }

    public void setXslParams(Hashtable<String, Object> xslParams) {
        this.xslParams = xslParams;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getElementEnAnomalie() {
        return this.elementEnAnomalie;
    }

    public void setElementEnAnomalie(String elementEnAnomalie) {
        this.elementEnAnomalie = elementEnAnomalie;
    }

    public String getElementImportable() {
        return this.elementImportable;
    }

    public void setElementImportable(String elementImportable) {
        this.elementImportable = elementImportable;
    }

    public String getIdElementImportable() {
        return this.idElementImportable;
    }

    public void setIdElementImportable(String idElementImportable) {
        this.idElementImportable = idElementImportable;
    }

    public String getLibelleLien() {
        return this.libelleLien;
    }

    public void setLibelleLien(String libelleLien) {
        this.libelleLien = libelleLien;
    }

    @Override
    public int compareTo(Anomalie other) {
        String id1 = other.getControleID();
        String id2 = this.getControleID();
        return id1.compareTo(id2);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void marshall(RapportWriter writer) {
        writer.openElement("Anomalie");
        writer.writeElement("Id", new Pair("V", this.getIdAnomalie()));
        writer.writeElement("Visibility", new Pair("V", this.isVisible() ? "visible" : "hidden"));
        writer.writeElement("IdCtrl", new Pair("V", this.getControleID()));
        writer.writeElement("LibelleCtrl", new Pair("V", this.getControleLibelle()));
        writer.writeElement("EtatId", new Pair("V", this.getEtatID()));
        writer.writeElement("ElementImportable", new Pair("V", this.getelementImportable()));
        writer.writeElement("IdElementImportable", new Pair("V", this.getIdElementImportable()));
        writer.writeElement("ElementEnAnomalie", new Pair("V", this.getelementEnAnomalie()));
        writer.writeElement("LibelleLien", new Pair("V", this.getLibelleLien()));
        writer.openElement("Message");
        writer.writeData("<![CDATA[");
        try {
            writer.getWriter().getWriter().write(this.getMessage());
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        writer.writeData("]]>");
        writer.closeElement("Message");
        writer.openElement("Regle");
        writer.writeData("<![CDATA[");
        try {
            writer.getWriter().getWriter().write(this.getRegle());
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        writer.writeData("]]>");
        writer.closeElement("Regle");
        writer.writeElement("Severity", new Pair("V", this.getSeverity()));
        if (this.getXPath() != null) {
            writer.writeElement("XPath", new Pair("V", this.getXPath()));
        }
        if (this.getXslParams() != null && this.getXslParams().size() > 0) {
            for (String key : this.getXslParams().keySet()) {
                String value = this.getXslParams().get(key).toString();
                writer.openElement("XslParam");
                writer.writeElement("Key", new Pair("V", key));
                writer.writeElement("Value", new Pair("V", value));
                writer.closeElement("XslParam");
            }
        }
        writer.closeElement("Anomalie");
    }
}

