/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios;

import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.utils.ui.UiUtils;
import fr.gouv.finances.cp.xemelios.debug.CheckThreadViolationRepaintManager;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.dgfip.xemelios.common.listeners.StartListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.RepaintManager;

public class Splash
extends JWindow
implements StartListener {
    private static final long serialVersionUID = 3257570598480654904L;
    private static final int MAX_PROGRESS = 46;
    public static Splash instance = null;
    private JProgressBar progress;
    private int requiredProgress = 0;

    public Splash() {
        this.initialize();
        instance = this;
    }

    protected void initialize() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        ImageIcon ii = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/montage3.jpg");
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)new JLabel(ii), "Center");
        this.progress = new JProgressBar(0, 0, 46);
        pane.add((Component)this.progress, "South");
        this.getContentPane().add(pane);
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(screen.getWidth() - (double)this.getWidth()) / 2, (int)(screen.getHeight() - (double)this.getHeight()) / 2);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Splash.this.toFront();
            }

            public void focusLost(FocusEvent e) {
                Splash.this.toFront();
            }
        });
    }

    public void pushProgress() {
        Thread runner = new Thread(){

            public void run() {
                int p = Splash.this.requiredProgress;
                if (++p < 46) {
                    Splash.this.progress.setValue(p);
                } else if (p == 46) {
                    Splash.this.progress.setValue(46);
                }
                Splash.this.requiredProgress = p;
            }
        };
        UiUtils.invokeInEDT(runner, true);
    }

    public void completeProgress() {
        Thread runner = new Thread(){

            public void run() {
                Splash.this.progress.setValue(46);
            }
        };
        UiUtils.invokeInEDT(runner, true);
    }

    public void notifyMessage(String msg) {
    }

    public void notifyProgress(int progress) {
        if (progress >= 0 && progress <= 100) {
            this.progress.setValue(progress);
        }
    }

    public static void main(String[] args) {
        Splash splash = null;
        Displayer displayer = new Displayer();
        UiUtils.invokeInEDT(displayer, true);
        splash = displayer.getSplash();
        Starter starter = new Starter(args, splash);
        starter.run();
    }

    static {
        if ("true".equals(System.getProperty("xemelios.debug.ui"))) {
            RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager());
        }
    }

    private static final class Starter
    implements Runnable {
        Splash sl;
        String[] args = null;

        public Starter(String[] args, Splash sl) {
            this.args = args;
            this.sl = sl;
        }

        public void run() {
            try {
                Thread.sleep(100L);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (this.sl != null) {
                this.sl.pushProgress();
            }
            Thread runner = new Thread(){

                public void run() {
                    new MainWindow("XEMELIOS", Starter.this.sl, Starter.this.args);
                }
            };
            UiUtils.invokeInEDT(runner, true);
            try {
                Thread.sleep(1000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.sl != null) {
                this.sl.setVisible(false);
                this.sl.dispose();
            }
        }
    }

    private static final class Displayer
    extends Thread {
        private Splash splash = null;

        private Displayer() {
        }

        public void run() {
            this.splash = new Splash();
            this.splash.setVisible(true);
        }

        public Splash getSplash() {
            return this.splash;
        }
    }
}

