/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils;

import java.text.ParseException;

public class StringUtilities {
    public static String removeFileNameSuffix(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("null file name");
        }
        int pos = fileName.lastIndexOf(46);
        if (pos > 0 && pos < fileName.length() - 1) {
            return fileName.substring(0, pos);
        }
        return fileName;
    }

    public static String getFileNameSuffix(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos > 0 && pos < fileName.length() - 1) {
            return fileName.substring(pos + 1);
        }
        return fileName;
    }

    public static String changeFileNameToClassName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null File Name");
        }
        String className = null;
        if (name.toLowerCase().endsWith(".class")) {
            className = name.replace('/', '.');
            className = className.replace('\\', '.');
            className = className.substring(0, className.length() - 6);
        }
        return className;
    }

    public static int getClosingParenthesisPos(String source, int openningPos) throws ParseException {
        int current;
        int count = 0;
        int length = source.length();
        boolean found = false;
        for (current = openningPos; !found && current < length; ++current) {
            char c = source.charAt(current);
            if (c == '(') {
                ++count;
                continue;
            }
            if (c != ')' || --count != 0) continue;
            found = true;
        }
        if (!found) {
            throw new ParseException("closing ')' not found for openning '(' at " + openningPos, openningPos);
        }
        return current - 1;
    }

    public static String escapeSpecialsCharactersToDecimal(String s) {
        StringBuffer sb = new StringBuffer();
        block13: for (char c : s.toCharArray()) {
            switch (c) {
                case '\"': {
                    sb.append("&#034;");
                    continue block13;
                }
                case '&': {
                    sb.append("&#038;");
                    continue block13;
                }
                case '\'': {
                    sb.append("&#039;");
                    continue block13;
                }
                case '<': {
                    sb.append("&#060;");
                    continue block13;
                }
                case '>': {
                    sb.append("&#062;");
                    continue block13;
                }
                case '@': {
                    sb.append("&#064;");
                    continue block13;
                }
                case '!': {
                    sb.append("&#033;");
                    continue block13;
                }
                case '#': {
                    sb.append("&#035;");
                    continue block13;
                }
                case '$': {
                    sb.append("&#036;");
                    continue block13;
                }
                case '%': {
                    sb.append("&#037;");
                    continue block13;
                }
                case '*': {
                    sb.append("&#042;");
                    continue block13;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeSpecialsCharactersAndAccentsToDecimal(String s) {
        StringBuffer sb = new StringBuffer();
        block16: for (char c : s.toCharArray()) {
            switch (c) {
                case '\"': {
                    sb.append("&#034;");
                    continue block16;
                }
                case '&': {
                    sb.append("&#038;");
                    continue block16;
                }
                case '\'': {
                    sb.append("&#039;");
                    continue block16;
                }
                case '<': {
                    sb.append("&#060;");
                    continue block16;
                }
                case '>': {
                    sb.append("&#062;");
                    continue block16;
                }
                case '@': {
                    sb.append("&#064;");
                    continue block16;
                }
                case '!': {
                    sb.append("&#033;");
                    continue block16;
                }
                case '#': {
                    sb.append("&#035;");
                    continue block16;
                }
                case '$': {
                    sb.append("&#036;");
                    continue block16;
                }
                case '%': {
                    sb.append("&#037;");
                    continue block16;
                }
                case '*': {
                    sb.append("&#042;");
                    continue block16;
                }
                case '\u00e9': {
                    sb.append("&#233;");
                    continue block16;
                }
                case '\u00e8': {
                    sb.append("&#232;");
                    continue block16;
                }
                case '\u00e0': {
                    sb.append("&#224;");
                    continue block16;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

