/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.searchParams;

import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.xemelios.ui.searchParams.CommonDataUpdater;
import fr.gouv.finances.dgfip.xemelios.common.config.ChampModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.jdesktop.layout.GroupLayout;

public class PnlFields
extends JPanel
implements CommonDataUpdater {
    private ListeResultatModel lrm;
    private DisplayableFieldsTableModel tblModel;
    private JScrollPane jScrollPane1;
    private JButton pbDown;
    private JButton pbUp;
    private JTable tblFields;

    public PnlFields(ListeResultatModel lrm) {
        this.lrm = lrm;
        this.initComponents();
        this.tblFields.setSelectionMode(0);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tblFields = new JTable();
        this.pbUp = new JButton();
        this.pbDown = new JButton();
        this.tblModel = new DisplayableFieldsTableModel(this.lrm);
        this.tblFields.setModel(this.tblModel);
        this.jScrollPane1.setViewportView(this.tblFields);
        this.pbUp.setText("^");
        this.pbUp.setToolTipText("Monter");
        this.pbUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PnlFields.this.pbUpActionPerformed(evt);
            }
        });
        this.pbDown.setText("V");
        this.pbDown.setToolTipText("Descendre");
        this.pbDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PnlFields.this.pbDownActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 329, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.pbUp).add((Component)this.pbDown)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(13, 13, 13).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 275, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pbUp).addPreferredGap(0).add((Component)this.pbDown))).addContainerGap()));
    }

    private void pbUpActionPerformed(ActionEvent evt) {
        int i = this.tblFields.getSelectedRow();
        if (i > 0) {
            ChampModel cm = this.tblModel.getData().remove(i);
            this.tblModel.getData().insertElementAt(cm, i - 1);
            this.tblModel.fireTableDataChanged();
            this.tblFields.setRowSelectionInterval(i - 1, i - 1);
        }
    }

    private void pbDownActionPerformed(ActionEvent evt) {
        int i = this.tblFields.getSelectedRow();
        if (i < this.tblModel.getData().size() - 1) {
            ChampModel cm = this.tblModel.getData().remove(i);
            this.tblModel.getData().insertElementAt(cm, i + 1);
            this.tblModel.fireTableDataChanged();
            this.tblFields.setRowSelectionInterval(i + 1, i + 1);
        }
    }

    public void doUpdate() {
        for (int i = this.lrm.getListeChamps().size() - 1; i >= 0; --i) {
            ChampModel cm = (ChampModel)this.lrm.getListeChamps().elementAt(i);
            if (!cm.isAffichable()) continue;
            this.lrm.getChamps().remove(cm);
            this.lrm.getListeChamps().remove(cm);
        }
        for (ChampModel cm : this.tblModel.getData()) {
            try {
                this.lrm.addChild((XmlMarshallable)cm, ChampModel.QN);
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisplayableFieldsTableModel
    extends AbstractTableModel {
        Vector<ChampModel> data = new Vector();

        public DisplayableFieldsTableModel(ListeResultatModel lrm) {
            for (ChampModel cm : lrm.getListeChamps()) {
                if (!cm.isAffichable()) continue;
                this.data.add(cm);
            }
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ChampModel cm = this.data.elementAt(rowIndex);
            if (columnIndex == 0) {
                return cm.isAfficheDefaut();
            }
            return cm.getLibelle();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Afficher";
            }
            return "Champ";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ChampModel cm = this.data.elementAt(rowIndex);
            if (columnIndex == 0) {
                cm.setAfficheDefaut(((Boolean)aValue).booleanValue());
            }
        }

        public Vector<ChampModel> getData() {
            return this.data;
        }
    }
}

