/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.ia.core;

public class Template {
    public static final Template T22 = new Template(2, 2, false, false);
    public static final Template T23 = new Template(2, 3, true, true);
    public static final Template T33 = new Template(3, 3, true, true);
    public static final int STRIKE = 1;
    public static final int HIGHLIGHT = 2;
    public final int columns;
    public final int rows;
    public final int maxValue;
    public final int maxIndex;
    public final boolean symetrical;
    public final boolean reducable;
    public final String name;
    int INITIAL_VALUE;
    int FREE_VALUE;
    int MARK_MASK;
    int[] MARK1_EXTRACTOR;
    int[] MARK2_EXTRACTOR;
    int[] VALUE_AVAILABLE_EXTRACTOR;
    int ALL_AVAILABLE_EXTRACTOR;
    int VALUE_MASK;
    int ORIGINAL_POSITION;
    int MARK1_OFFSET;
    int MARK2_OFFSET;
    public int[][] COLUMNS_NEIGBOURGHOOD;
    public int[] INDEX_TO_COLUMN;
    public int[][] LINE_NEIGHBOURGHOOD;
    public int[] INDEX_TO_LINE;
    public int[][] BOXES_NEIGBOURGHOOD;
    public int[] INDEX_TO_BOX;
    public int[][][] NEIGHBOURGHOODS;

    protected void fillBaseFields() {
        this.VALUE_MASK = 15;
        this.FREE_VALUE = 15;
        this.ORIGINAL_POSITION = 16;
        this.MARK1_OFFSET = 0;
        this.MARK2_OFFSET = 0;
    }

    protected Template(int row_p, int column_p, boolean symetrical_p, boolean reducable_p) {
        this.columns = column_p;
        this.rows = row_p;
        this.symetrical = symetrical_p;
        this.reducable = reducable_p;
        this.name = new String(column_p + "x" + row_p);
        this.maxValue = row_p * column_p;
        this.maxIndex = this.maxValue * this.maxValue;
        this.fillBaseFields();
        this.fillValueExtractors();
        this.fillMarkExtractors();
        this.fillNeigbourghoods();
    }

    protected void fillMarkExtractors() {
        this.MARK1_EXTRACTOR = new int[this.maxValue];
        this.MARK2_EXTRACTOR = new int[this.maxValue];
        this.MARK_MASK = 0;
        for (int i = 0; i < this.maxValue; ++i) {
            this.MARK1_EXTRACTOR[i] = 1 << 14 + i;
            this.MARK2_EXTRACTOR[i] = 1 << 23 + i;
            this.MARK_MASK |= this.MARK1_EXTRACTOR[i];
            this.MARK_MASK |= this.MARK2_EXTRACTOR[i];
        }
    }

    protected void fillValueExtractors() {
        this.INITIAL_VALUE = this.FREE_VALUE;
        this.ALL_AVAILABLE_EXTRACTOR = 0;
        this.VALUE_AVAILABLE_EXTRACTOR = new int[this.maxValue];
        for (int i = 0; i < this.VALUE_AVAILABLE_EXTRACTOR.length; ++i) {
            this.VALUE_AVAILABLE_EXTRACTOR[i] = 1 << i + 5;
            this.INITIAL_VALUE |= this.VALUE_AVAILABLE_EXTRACTOR[i];
            this.ALL_AVAILABLE_EXTRACTOR |= this.VALUE_AVAILABLE_EXTRACTOR[i];
        }
    }

    private void fillNeigbourghoods() {
        int index;
        int col;
        int line;
        this.LINE_NEIGHBOURGHOOD = new int[this.maxValue][this.maxValue];
        this.INDEX_TO_LINE = new int[this.maxIndex];
        for (line = 0; line < this.maxValue; ++line) {
            for (col = 0; col < this.maxValue; ++col) {
                this.LINE_NEIGHBOURGHOOD[line][col] = index = line * this.maxValue + col;
                this.INDEX_TO_LINE[index] = line;
            }
        }
        this.COLUMNS_NEIGBOURGHOOD = new int[this.maxValue][this.maxValue];
        this.INDEX_TO_COLUMN = new int[this.maxIndex];
        for (line = 0; line < this.maxValue; ++line) {
            col = 0;
            while (col < this.maxValue) {
                this.COLUMNS_NEIGBOURGHOOD[col][line] = index = line * this.maxValue + col;
                this.INDEX_TO_COLUMN[index] = col++;
            }
        }
        this.BOXES_NEIGBOURGHOOD = new int[this.maxValue][this.maxValue];
        this.INDEX_TO_BOX = new int[this.maxIndex];
        for (int boxLine = 0; boxLine < this.columns; ++boxLine) {
            for (int boxCol = 0; boxCol < this.rows; ++boxCol) {
                int boxIndex = boxLine * this.rows + boxCol;
                for (int line2 = 0; line2 < this.rows; ++line2) {
                    for (int col2 = 0; col2 < this.columns; ++col2) {
                        int index2;
                        int indexInBox = line2 * this.columns + col2;
                        this.BOXES_NEIGBOURGHOOD[boxIndex][indexInBox] = index2 = (boxLine * this.rows + line2) * this.maxValue + boxCol * this.columns + col2;
                        this.INDEX_TO_BOX[index2] = boxIndex;
                    }
                }
            }
        }
        this.NEIGHBOURGHOODS = new int[this.maxIndex][3][this.maxValue];
        for (int index3 = 0; index3 < this.maxIndex; ++index3) {
            this.NEIGHBOURGHOODS[index3][0] = this.LINE_NEIGHBOURGHOOD[this.INDEX_TO_LINE[index3]];
            this.NEIGHBOURGHOODS[index3][1] = this.COLUMNS_NEIGBOURGHOOD[this.INDEX_TO_COLUMN[index3]];
            this.NEIGHBOURGHOODS[index3][2] = this.BOXES_NEIGBOURGHOOD[this.INDEX_TO_BOX[index3]];
        }
    }

    public int indexToRow(int index_p) {
        return index_p / this.maxValue;
    }

    public int indexToColumn(int index_p) {
        return index_p % this.maxValue;
    }

    public int indexToBox(int index_p) {
        int line = this.indexToRow(index_p);
        int col = this.indexToColumn(index_p);
        return (line /= this.rows) * this.rows + (col /= this.columns);
    }

    public int[] allocate() {
        return new int[this.maxIndex];
    }
}

