/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.ia;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Arrays;

public class Piece {
    private int[] images = new int[4];
    private int[] heights = new int[4];
    private int[] widths = new int[4];
    private int x;
    private int y;
    private int lastX;
    private int lastY;
    private int lastRotation;
    private Color color;
    private int idRotation;
    public static final int SQUARE_SIZE = 15;

    public Piece(int r1, int r2, int r3, int r4, Color color) {
        this.images[0] = r1;
        this.images[1] = r2;
        this.images[2] = r3;
        this.images[3] = r4;
        this.color = color;
        this.idRotation = 0;
        this.y = 0;
        this.x = 0;
        this.lastY = -1;
        this.lastX = -1;
        this.computesWH();
    }

    public Piece(int r1, int r2, int r3, int r4, Color color, int p_x, int p_y) {
        this(r1, r2, r3, r4, color);
        this.x = p_x;
        this.y = p_y;
    }

    public Piece(int[] r, Color color) {
        System.arraycopy(r, 0, this.images, 0, 4);
        this.idRotation = 0;
        this.y = 0;
        this.x = 0;
        this.lastY = -1;
        this.lastX = -1;
        this.color = color;
        this.computesWH();
    }

    public Piece(int[] r, Color color, int p_x, int p_y) {
        this(r, color);
        this.x = p_x;
        this.y = p_y;
    }

    public Piece(Piece src) {
        System.arraycopy(src.images, 0, this.images, 0, 4);
        System.arraycopy(src.widths, 0, this.widths, 0, 4);
        System.arraycopy(src.heights, 0, this.heights, 0, 4);
        this.idRotation = src.idRotation;
        this.lastX = src.lastX;
        this.lastY = src.lastY;
        this.lastRotation = src.lastRotation;
        this.x = src.x;
        this.y = src.y;
        this.color = src.color;
    }

    public void reset() {
        this.reset(0, 0);
    }

    public void reset(int p_x, int p_y) {
        this.x = p_x;
        this.y = p_y;
        this.idRotation = 0;
        this.lastY = -1;
        this.lastX = -1;
    }

    public void firstRotation() {
        this.idRotation = 0;
    }

    private void computesWH() {
        Arrays.fill(this.widths, 0);
        Arrays.fill(this.heights, 0);
        for (int cptRotations = 0; cptRotations < this.heights.length; ++cptRotations) {
            int mask = 32768;
            for (int i = 0; i < 4; ++i) {
                boolean lineOK = false;
                int j = 0;
                while (j < 4) {
                    if ((mask & this.images[cptRotations]) != 0) {
                        if (!lineOK) {
                            lineOK = true;
                            int n = cptRotations;
                            this.heights[n] = this.heights[n] + 1;
                        }
                        if (this.widths[cptRotations] < j + 1) {
                            this.widths[cptRotations] = j + 1;
                        }
                    }
                    ++j;
                    mask >>= 1;
                }
            }
        }
    }

    public void rotate() {
        this.idRotation = (this.idRotation + 1) % 4;
    }

    public void goDown() {
        this.y += 15;
    }

    public void goDown(int lines) {
        this.y += 15 * lines;
    }

    public void goLeft() {
        this.x -= 15;
    }

    public void goRight() {
        this.x += 15;
    }

    public void goUp() {
        this.y -= 15;
    }

    public void goUp(int lines) {
        this.y -= 15 * lines;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int paintx() {
        return this.lastX;
    }

    public int painty() {
        return this.lastY;
    }

    public Color getColor() {
        return this.color;
    }

    public int getHeight() {
        return this.heights[this.idRotation];
    }

    public int getHeight(int id) {
        return id >= 0 && id < 4 ? this.heights[id] : 0;
    }

    public int nextHeight() {
        return this.heights[this.idRotation >= 3 ? 0 : this.idRotation + 1];
    }

    public int getWidth() {
        return this.widths[this.idRotation];
    }

    public int getWidth(int id) {
        return id >= 0 && id < 4 ? this.widths[id] : 0;
    }

    public int nextWidth() {
        return this.widths[this.idRotation >= 3 ? 0 : this.idRotation + 1];
    }

    public int getVal() {
        return this.images[this.idRotation];
    }

    public int getVal(int id) {
        return id >= 0 && id < 4 ? this.images[id] : 0;
    }

    public int getNextVal() {
        return this.images[this.idRotation >= 3 ? 0 : this.idRotation + 1];
    }

    public Piece getNextPiece() {
        Piece np = new Piece(this);
        np.rotate();
        return np;
    }

    public synchronized void display(Graphics g) {
        int mask = 32768;
        this.lastX = this.x;
        this.lastY = this.y;
        this.lastRotation = this.idRotation;
        g.setColor(this.color);
        for (int i = 0; i < 4; ++i) {
            int j = 0;
            while (j < 4) {
                if ((mask & this.images[this.idRotation]) != 0) {
                    g.fill3DRect(this.x + j * 15, this.y + i * 15, 15, 15, true);
                }
                ++j;
                mask >>= 1;
            }
        }
    }

    public synchronized void erase(Graphics g, Color fond) {
        int mask = 32768;
        if (this.lastX == -1 || this.lastY == -1) {
            return;
        }
        g.setColor(fond);
        for (int i = 0; i < 4; ++i) {
            int j = 0;
            while (j < 4) {
                if ((mask & this.images[this.lastRotation]) != 0) {
                    g.fill3DRect(this.lastX + j * 15, this.lastY + i * 15, 15, 15, true);
                }
                ++j;
                mask >>= 1;
            }
        }
    }
}

