/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.collectivites;

import fr.gouv.finances.cp.xemelios.ui.collectivites.DlgSelectCollectivite;
import fr.gouv.finances.cp.xemelios.ui.collectivites.DlgSelectPair;
import fr.gouv.finances.cp.xemelios.ui.collectivites.ParentCollectiviteListener;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ParentModel;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PnlCollectivite
extends JPanel
implements ParentCollectiviteListener {
    private static final Logger logger = Logger.getLogger(PnlCollectivite.class);
    private DocumentModel dm;
    private ParentModel parentModel = null;
    private DlgSelectCollectivite.ParentCollectiviteContainer collectivites;
    private XemeliosUser user = null;
    private JTextField df;
    private Pair selectedPair;
    private int level;
    private JDialog parentDialog;
    private JLabel lbl;
    private JButton pb;

    PnlCollectivite(JDialog parentDialog, DocumentModel dm, ParentModel parentModel, DlgSelectCollectivite.ParentCollectiviteContainer collectivites, XemeliosUser user) {
        this.parentDialog = parentDialog;
        this.dm = dm;
        this.parentModel = parentModel;
        this.level = parentModel.getLevel();
        this.collectivites = collectivites;
        this.user = user;
        this.initComponents();
        collectivites.addListener(this);
    }

    protected void initComponents() {
        this.lbl = new JLabel(this.getLibelle());
        this.df = new JTextField();
        this.df.setEditable(false);
        this.df.setColumns(40);
        this.pb = new JButton("..."){

            public int getHeight() {
                return PnlCollectivite.this.df.getHeight();
            }

            public int getWidth() {
                return this.getHeight();
            }
        };
        this.pb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PnlCollectivite.this.collectivites.getSize() >= PnlCollectivite.this.level) {
                    Pair[] localParents = new Pair[PnlCollectivite.this.collectivites.getSize() - PnlCollectivite.this.level];
                    for (int i = PnlCollectivite.this.parentModel.getLevel(); i < PnlCollectivite.this.collectivites.getSize(); ++i) {
                        localParents[i - ((PnlCollectivite)PnlCollectivite.this).level] = PnlCollectivite.this.collectivites.getPair(i);
                    }
                    try {
                        Pair p2;
                        Vector colls = DataLayerManager.getImplementation().getParentCollectivites(PnlCollectivite.this.dm, PnlCollectivite.this.level, localParents, PnlCollectivite.this.user);
                        Vector<Pair> tmpColls = new Vector<Pair>();
                        for (Pair p2 : colls) {
                            tmpColls.add(new MyPair(p2));
                        }
                        DlgSelectPair dlg = new DlgSelectPair(PnlCollectivite.this.parentDialog, "Collectivit\u00e9s", PnlCollectivite.this.parentModel.getLibelle(), tmpColls);
                        p2 = dlg.showSelectionBox();
                        if (p2 != null) {
                            PnlCollectivite.this.selectedPair = p2;
                            PnlCollectivite.this.df.setText(PnlCollectivite.this.selectedPair.toString());
                            PnlCollectivite.this.collectivites.setPair(PnlCollectivite.this.parentModel.getLevel() - 1, PnlCollectivite.this.selectedPair);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)"looking for parents:", (Throwable)ex);
                    }
                }
            }
        });
    }

    protected String getLibelle() {
        return this.parentModel.getLibelle();
    }

    public void valueChanged(int pos, Pair newValue) {
        if (pos > this.level) {
            this.selectedPair = null;
            this.df.setText("");
        }
    }

    public JLabel getLabel() {
        return this.lbl;
    }

    public JTextField getTextField() {
        return this.df;
    }

    public JButton getButton() {
        return this.pb;
    }

    private class MyPair
    extends Pair {
        public MyPair(Pair p) {
            super(p.key, p.libelle);
        }

        public String toString() {
            if (!this.key.equals(this.libelle)) {
                return this.libelle.concat(" (").concat(this.key).concat(")");
            }
            return this.libelle;
        }
    }
}

