/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.collectivites;

import fr.gouv.finances.cp.utils.ui.VerticalFlowLayout;
import fr.gouv.finances.cp.xemelios.ui.collectivites.ParentCollectiviteListener;
import fr.gouv.finances.cp.xemelios.ui.collectivites.PnlCollectivite;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class DlgSelectCollectivite
extends JDialog
implements ParentCollectiviteListener {
    private static final Logger logger = Logger.getLogger(DlgSelectCollectivite.class);
    private DocumentModel dm;
    private XemeliosUser user;
    private JFrame parent;
    private JComboBox cbxCollectivites;
    private ParentCollectiviteContainer container;
    private boolean response;

    public DlgSelectCollectivite(DocumentModel dm, XemeliosUser user, JFrame parent) {
        super(parent, "Choisir une collectivit\u00e9", true);
        this.dm = dm;
        this.user = user;
        this.parent = parent;
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel vPane = new JPanel(new VerticalFlowLayout());
        this.container = new ParentCollectiviteContainer(this.dm.getCollectivitePath().getParentsCount());
        JPanel collPane = new JPanel(new GridBagLayout());
        GridBagConstraints cstr = new GridBagConstraints();
        cstr.ipadx = 2;
        cstr.ipady = 2;
        cstr.insets = new Insets(2, 2, 2, 2);
        cstr.gridy = 0;
        for (int i = this.dm.getCollectivitePath().getParentsCount() - 1; i >= 0; --i) {
            PnlCollectivite pnl = new PnlCollectivite(this, this.dm, this.dm.getCollectivitePath().getParent(i), this.container, this.user);
            cstr.gridx = 0;
            cstr.weightx = 1.0;
            cstr.anchor = 13;
            collPane.add((Component)pnl.getLabel(), cstr);
            cstr.gridx = 1;
            cstr.weightx = 0.0;
            cstr.anchor = 17;
            collPane.add((Component)pnl.getTextField(), cstr);
            cstr.gridx = 2;
            cstr.anchor = 10;
            collPane.add((Component)pnl.getButton(), cstr);
            ++cstr.gridy;
        }
        cstr.gridx = 0;
        cstr.weightx = 1.0;
        cstr.anchor = 13;
        collPane.add((Component)new JLabel("Collectivit\u00e9"), cstr);
        cstr.gridx = 1;
        cstr.weightx = 0.0;
        cstr.gridwidth = 2;
        cstr.anchor = 17;
        this.cbxCollectivites = new JComboBox();
        collPane.add((Component)this.cbxCollectivites, cstr);
        this.addComplementElements(collPane, cstr);
        vPane.add(collPane);
        JPanel hPane = new JPanel(new BorderLayout());
        JPanel buttonPane = new JPanel();
        JButton pbCancel = new JButton("Annuler");
        pbCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DlgSelectCollectivite.this.setVisible(false);
            }
        });
        buttonPane.add(pbCancel);
        JButton pbOk = new JButton("Ok");
        pbOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DlgSelectCollectivite.this.cbxCollectivites.getSelectedIndex() >= 0) {
                    DlgSelectCollectivite.this.response = true;
                    DlgSelectCollectivite.this.setVisible(false);
                }
            }
        });
        buttonPane.add(pbOk);
        hPane.add((Component)buttonPane, "Center");
        vPane.add(hPane);
        this.add((Component)vPane, "Center");
        this.container.addListener(this);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    public void addComplementElements(JPanel collPane, GridBagConstraints cstr) {
    }

    public void valueChanged(int pos, Pair newValue) {
        if (pos == 1) {
            this.cbxCollectivites.removeAllItems();
            try {
                Vector colls = DataLayerManager.getImplementation().getCollectivites(this.dm, this.container.getParents(), this.user);
                for (Pair p : colls) {
                    this.cbxCollectivites.addItem(new MyPair(p));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"while querying collectivites:", (Throwable)ex);
            }
        } else {
            this.cbxCollectivites.removeAllItems();
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.response = false;
        }
        super.setVisible(b);
    }

    public boolean run() {
        this.setVisible(true);
        return this.response;
    }

    public Pair getCollectivite() {
        return (Pair)this.cbxCollectivites.getSelectedItem();
    }

    public DocumentModel getDm() {
        return this.dm;
    }

    public XemeliosUser getUser() {
        return this.user;
    }

    JComboBox getCbxCollectivite() {
        return this.cbxCollectivites;
    }

    private class MyPair
    extends Pair {
        public MyPair(Pair p) {
            super(p.key, p.libelle);
        }

        public String toString() {
            return this.libelle.concat(" (").concat(this.key).concat(")");
        }
    }

    static class ParentCollectiviteContainer {
        Pair[] parentColls;
        List<ParentCollectiviteListener> listeners;
        private int size = 0;

        public ParentCollectiviteContainer(int size) {
            this.size = size;
            this.parentColls = new Pair[size];
            this.listeners = new ArrayList<ParentCollectiviteListener>();
        }

        public void setPair(int pos, Pair value) {
            this.parentColls[pos] = value;
            for (int i = pos - 1; i >= 0; --i) {
                this.parentColls[i] = null;
                this.fireValueChanged(pos + 1, value);
            }
            this.fireValueChanged(pos + 1, value);
        }

        public Pair getPair(int pos) {
            return this.parentColls[pos];
        }

        protected void fireValueChanged(int pos, Pair value) {
            for (ParentCollectiviteListener listener : this.listeners) {
                listener.valueChanged(pos, value);
            }
        }

        void addListener(ParentCollectiviteListener listener) {
            this.listeners.add(listener);
        }

        public int getSize() {
            return this.size;
        }

        public Pair[] getParents() {
            return this.parentColls;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            for (int i = 0; i < this.parentColls.length; ++i) {
                sb.append(this.parentColls[i]);
                if (i == this.parentColls.length - 1) continue;
                sb.append(",");
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

