/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.admin;

import fr.gouv.finances.cp.xemelios.ui.admin.ParamSaver;
import fr.gouv.finances.dgfip.xemelios.common.Constants;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;

public class PnlSystemProperties
extends JPanel
implements ParamSaver {
    private static final Logger logger = Logger.getLogger(PnlSystemProperties.class);
    private TreeSet<Prop> properties;
    private LM listModel;
    private Prop currentProp;
    private JTextField dfValue;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JList lstProps;
    private JButton pbSet;

    public PnlSystemProperties() {
        this.preInitComponents();
        this.initComponents();
        this.postInitComponents();
    }

    protected void preInitComponents() {
        this.properties = new TreeSet();
        for (Object key : System.getProperties().keySet()) {
            String propName = key.toString();
            if (!propName.startsWith("xemelios")) continue;
            Prop prop = new Prop(propName, System.getProperty(propName));
            this.properties.add(prop);
        }
        Class<Constants> clazz = Constants.class;
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getType().equals(String.class) || (fields[i].getModifiers() | 0x19) <= 0) continue;
            try {
                Prop p;
                String propName = fields[i].get(null).toString();
                if (!propName.startsWith("xemelios") && !fields[i].getName().startsWith("SYS_PROP") || this.properties.contains(p = new Prop(propName, null))) continue;
                this.properties.add(p);
                continue;
            }
            catch (Exception ex) {
                logger.debug((Object)"while introspecting", (Throwable)ex);
            }
        }
        this.listModel = new LM(this.properties);
    }

    protected void postInitComponents() {
        this.lstProps.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PnlSystemProperties.this.currentProp = (Prop)PnlSystemProperties.this.lstProps.getSelectedValue();
                if (PnlSystemProperties.this.currentProp != null) {
                    PnlSystemProperties.this.dfValue.setEditable(true);
                    PnlSystemProperties.this.dfValue.setText(PnlSystemProperties.this.currentProp.getPropValue());
                    PnlSystemProperties.this.pbSet.setEnabled(true);
                } else {
                    PnlSystemProperties.this.dfValue.setEditable(false);
                    PnlSystemProperties.this.dfValue.setText(null);
                    PnlSystemProperties.this.pbSet.setEnabled(false);
                }
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstProps = new JList();
        this.jLabel2 = new JLabel();
        this.dfValue = new JTextField();
        this.pbSet = new JButton();
        this.jLabel1.setText("Propri\u00e9t\u00e9s syst\u00e8mes");
        this.lstProps.setModel(this.listModel);
        this.lstProps.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lstProps);
        this.jLabel2.setText("Valeur");
        this.pbSet.setIcon(new ImageIcon(this.getClass().getResource("/fr/gouv/finances/cp/xemelios/ui/resources/edit-redo.png")));
        this.pbSet.setToolTipText("Enregistrer la valeur");
        this.pbSet.setEnabled(false);
        this.pbSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PnlSystemProperties.this.pbSetActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 374, Short.MAX_VALUE).add(1, (Component)this.jLabel1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.dfValue, -1, 287, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pbSet))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 195, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.dfValue, -2, -1, -2).add((Component)this.pbSet, -1, 28, Short.MAX_VALUE)).addContainerGap()));
    }

    private void pbSetActionPerformed(ActionEvent evt) {
        if (this.currentProp != null) {
            String value = this.dfValue.getText();
            if (value != null && value.length() == 0) {
                value = null;
            }
            this.currentProp.setPropValue(value);
            System.setProperty(this.currentProp.getPropName(), value);
        }
    }

    public void saveConfiguration() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LM
    extends AbstractListModel {
        private Prop[] data;

        public LM(TreeSet<Prop> properties) {
            this.data = new Prop[properties.size()];
            properties.toArray(this.data);
        }

        @Override
        public int getSize() {
            return this.data.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.data[index];
        }
    }

    private class Prop
    implements Comparable {
        private String propName = null;
        private String propValue = null;
        private String documentation = null;

        public Prop(String propName, String propValue) {
            this.propName = propName;
            this.propValue = propValue;
        }

        public Prop(String propName, String propValue, String documentation) {
            this(propName, propValue);
            this.documentation = documentation;
        }

        public String toString() {
            return this.propName;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public void setDocumentation(String documentation) {
            this.documentation = documentation;
        }

        public String getPropName() {
            return this.propName;
        }

        public void setPropName(String propName) {
            this.propName = propName;
        }

        public String getPropValue() {
            return this.propValue;
        }

        public void setPropValue(String propValue) {
            this.propValue = propValue;
        }

        public boolean equals(Prop other) {
            return this.propName.equals(other.getPropName());
        }

        public int compareTo(Object o) {
            Prop other = (Prop)o;
            return this.propName.compareTo(other.getPropName());
        }
    }
}

