/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import fr.gouv.finances.cp.utils.PropertiesExpansion;
import fr.gouv.finances.cp.utils.StartUrl;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.utils.ui.JWaiter;
import fr.gouv.finances.cp.utils.ui.RamViewer;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.Splash;
import fr.gouv.finances.cp.xemelios.auth.LoginDialog;
import fr.gouv.finances.cp.xemelios.controls.DlgControl;
import fr.gouv.finances.cp.xemelios.controls.MainControl;
import fr.gouv.finances.cp.xemelios.controls.extend.MainControlWrapper;
import fr.gouv.finances.cp.xemelios.importers.ImportServiceSwingProvider;
import fr.gouv.finances.cp.xemelios.starter.Bootstrap;
import fr.gouv.finances.cp.xemelios.ui.AboutBox;
import fr.gouv.finances.cp.xemelios.ui.AskDocumentType;
import fr.gouv.finances.cp.xemelios.ui.DlgCleanDatabase;
import fr.gouv.finances.cp.xemelios.ui.DlgEditEnvironment;
import fr.gouv.finances.cp.xemelios.ui.DlgExportAll;
import fr.gouv.finances.cp.xemelios.ui.HtmlViewer;
import fr.gouv.finances.cp.xemelios.ui.SearchWindow;
import fr.gouv.finances.cp.xemelios.ui.WindowMenu;
import fr.gouv.finances.cp.xemelios.ui.admin.DlgSystemConfiguration;
import fr.gouv.finances.cp.xemelios.ui.collectivites.DlgSelectNavigationTarget;
import fr.gouv.finances.cp.xemelios.ui.export.DlgSearchConfig;
import fr.gouv.finances.cp.xemelios.ui.importDialog.ImportDialog;
import fr.gouv.finances.cp.xemelios.ui.importDialog.ImportFile;
import fr.gouv.finances.cp.xemelios.updater.AbstractConfigurator;
import fr.gouv.finances.cp.xemelios.updater.UpdaterUtil;
import fr.gouv.finances.cp.xemelios.updater.script.config.ComponentModel;
import fr.gouv.finances.cp.xemelios.updater.script.config.ComponentsParser;
import fr.gouv.finances.cp.xemelios.updater.script.config.XemeliosComponentModel;
import fr.gouv.finances.cp.xemelios.updater.ui.DlgUpdate;
import fr.gouv.finances.dgfip.utils.ClassPathUtils;
import fr.gouv.finances.dgfip.utils.IoUtils;
import fr.gouv.finances.dgfip.utils.NavigationContext;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.utils.xml.xpath.FunctionResolver;
import fr.gouv.finances.dgfip.xemelios.auth.AuthEngine;
import fr.gouv.finances.dgfip.xemelios.auth.UnauthorizedException;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.DematTransform;
import fr.gouv.finances.dgfip.xemelios.common.PJRef;
import fr.gouv.finances.dgfip.xemelios.common.ToolException;
import fr.gouv.finances.dgfip.xemelios.common.components.XemeliosComponentsModel;
import fr.gouv.finances.dgfip.xemelios.common.components.XemeliosComponentsParser;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EnvironmentDomain;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import fr.gouv.finances.dgfip.xemelios.common.config.PersonnalConfigParser;
import fr.gouv.finances.dgfip.xemelios.common.config.PersonnalConfigurationModel;
import fr.gouv.finances.dgfip.xemelios.common.config.SavedRequestsModel;
import fr.gouv.finances.dgfip.xemelios.common.listeners.StartListener;
import fr.gouv.finances.dgfip.xemelios.data.DataAccessException;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataImpl;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.Pool;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.PoolManager;
import fr.gouv.finances.dgfip.xemelios.importers.EtatImporteur;
import fr.gouv.finances.dgfip.xemelios.importers.ImportServiceProvider;
import fr.gouv.finances.dgfip.xemelios.importers.XemeliosArchiveImporter;
import fr.gouv.finances.dgfip.xemelios.tools.AbstractTool;
import fr.gouv.finances.dgfip.xemelios.tools.MenuTitle;
import fr.gouv.finances.dgfip.xemelios.utils.FileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileSystemView;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.jdesktop.swingworker.SwingWorker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MainWindow
extends JFrame {
    private static Logger logger = null;
    private static final long serialVersionUID = 3977304325938558517L;
    public static final transient String MAIN_WINDOW_POSITION = "main.window.last.location";
    public static final int DEFAULT_WIDTH = 800;
    public static final int DEFAULT_HEIGHT = 600;
    private Action actExporter;
    private Action actExporterCsv;
    private Action actQuitter;
    private JDesktopPane desk;
    private JTextField statusField;
    private StartListener startListener;
    private DocumentsModel docModels;
    protected File lastInputDirectory = null;
    private JMenu searchMenu;
    private JMenu windowMenu;
    private JMenu browseMenu;
    private JMenu exportMenu;
    private JMenu importerMenu = null;
    private JMenu controlerMenu = null;
    private JMenuItem mnuClean = null;
    private JMenuItem mnuCleanPro = null;
    private JLabel backImage;
    private JWaiter waiter;
    private PersonnalConfigurationModel config;
    private XemeliosUser connectedUser = null;
    public static MainWindow instance = null;
    public XPathFactory xpf;
    private Properties criteriasInputValues;
    private String componentsModelFileName;
    private String updateUrl;
    private PropertiesExpansion pe;
    public static String fieldSeparator = ";";

    public MainWindow(String title, StartListener sl, String[] args) {
        super(title);
        if (instance != null) {
            throw new RuntimeException("Only one instance of MainWindow can exists");
        }
        instance = this;
        this.startListener = sl;
        this.startListener.pushProgress();
        try {
            this.xpf = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        }
        catch (Throwable t) {
            this.xpf = XPathFactory.newInstance();
        }
        this.xpf.setXPathFunctionResolver((XPathFunctionResolver)new FunctionResolver());
        try {
            this.loadConfig();
            this.checkUpdateScript();
            this.initComponents();
            try {
                if (!this.checkPassword()) {
                    this.startListener.completeProgress();
                    this.runExit();
                }
            }
            catch (Throwable t) {
                new DisplayExceptionDlg((Frame)this, t);
                this.runExit();
            }
            this.initMenus2();
            this.setMenusAccess();
            if (!"true".equals(System.getProperty("xemelios.skip.update.check"))) {
                this.checkUpdateAvailability();
            }
            this.startListener.completeProgress();
            if (args.length > 0) {
                this.starterImport(args);
            }
        }
        catch (DataConfigurationException dcEx) {
            Throwable ex = dcEx;
            while (ex.getCause() != null) {
                ex = ex.getCause();
            }
            ex.printStackTrace();
        }
    }

    protected void loadConfig() throws DataConfigurationException {
        if (System.getProperty("xemelios.log4j.xml") != null) {
            String log4jConfFile = System.getProperty("xemelios.log4j.xml");
            DOMConfigurator.configure((String)log4jConfFile);
            logger = Logger.getLogger(this.getClass());
            logger.info((Object)"log4J initialise");
        }
        this.pe = new PropertiesExpansion();
        for (Object key : System.getProperties().keySet()) {
            this.pe.setProperty((String)key, System.getProperty((String)key));
        }
        this.componentsModelFileName = this.pe.getProperty("xemelios.components.filename");
        this.updateUrl = this.pe.getProperty("xemelios.updater.source");
        this.docModels = this.getDocumentsInfos(this.pe.getProperty("xemelios.documents.def.dir"));
        this.initDataLayer();
        this.applyPatches();
        logger.debug((Object)"Starting auth engine");
        AuthEngine.Holder.init();
        logger.debug((Object)"Loading personnal config");
        this.loadPersonnalConfig();
    }

    protected void initComponents() {
        this.criteriasInputValues = this.loadCriteriasInputValues();
        IhmFactory iF = IhmFactory.newInstance();
        this.initActions();
        this.startListener.pushProgress();
        this.desk = new JDesktopPane();
        this.desk.setDragMode(1);
        ImageIcon image = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/montage3.jpg");
        this.backImage = new JLabel(image);
        this.backImage.setBounds(0, 0, image.getIconWidth(), image.getIconHeight());
        this.desk.add((Component)this.backImage, JLayeredPane.FRAME_CONTENT_LAYER);
        this.initMenus1();
        this.startListener.pushProgress();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                MainWindow.this.runExit();
                logger.debug((Object)"closing");
            }
        });
        this.desk.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                Dimension dim = evt.getComponent().getSize();
                Dimension imgSize = MainWindow.this.backImage.getSize();
                MainWindow.this.backImage.setLocation((int)(dim.getWidth() - imgSize.getWidth()) / 2, (int)(dim.getHeight() - imgSize.getHeight()) / 2);
            }
        });
        this.startListener.pushProgress();
        JPanel inner = new JPanel(new BorderLayout());
        JPanel status = new JPanel(new BorderLayout());
        this.startListener.pushProgress();
        this.statusField = new JTextField(30);
        status.add((Component)this.statusField, "West");
        this.startListener.pushProgress();
        this.statusField.setEditable(false);
        this.statusField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.startListener.pushProgress();
        this.waiter = new JWaiter();
        status.add((Component)this.waiter, "East");
        if ("true".equals(System.getProperty("admin.menu.gc"))) {
            status.add((Component)new RamViewer(), "Center");
        }
        if ("true".equals(System.getProperty("xemelios.display.pool.status"))) {
            status.add(new PoolStatDisplayer());
        }
        status.setBorder(new EtchedBorder(1));
        inner.add((Component)status, "South");
        this.startListener.pushProgress();
        inner.add((Component)this.desk, "Center");
        this.setContentPane(inner);
        this.startListener.pushProgress();
        File f = new File(System.getProperty("user.home"), "xemelios.properties");
        Properties props = new Properties();
        if (f.exists()) {
            try {
                props.load(new FileInputStream(f));
            }
            catch (IOException ioEx) {
                // empty catch block
            }
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        GraphicsDevice gd = gc.getDevice();
        DisplayMode dm = gd.getDisplayMode();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rect = ge.getMaximumWindowBounds();
        Rectangle lastLocation = null;
        if (props.getProperty(MAIN_WINDOW_POSITION) != null) {
            String s = props.getProperty(MAIN_WINDOW_POSITION);
            s = s.substring(1, s.length() - 1);
            String[] sa = s.split(",");
            try {
                int x = Integer.parseInt(sa[0]);
                int y = Integer.parseInt(sa[1]);
                int width = Integer.parseInt(sa[2]);
                int height = Integer.parseInt(sa[3]);
                lastLocation = new Rectangle(x, y, width, height);
                if (lastLocation.getWidth() > rect.getWidth() || lastLocation.getHeight() > rect.getHeight()) {
                    lastLocation = null;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (lastLocation != null) {
            this.setBounds(lastLocation);
        } else if (rect != null && (rect.getWidth() != (double)dm.getWidth() || rect.getHeight() != (double)dm.getHeight())) {
            this.setBounds(rect);
        } else {
            this.setLocation((int)((screenSize.getWidth() - 800.0) / 2.0), (int)((screenSize.getHeight() - 600.0) / 2.0));
            this.pack();
            this.setSize(new Dimension(800, 600));
            this.setExtendedState(6);
        }
        this.startListener.pushProgress();
        this.setDefaultCloseOperation(0);
        this.startListener.pushProgress();
        this.setVisible(true);
        this.startListener.pushProgress();
    }

    protected void initActions() {
        this.startListener.pushProgress();
        this.actExporter = new AbstractAction("Export avanc\u00e9..."){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.exporter();
            }
        };
        this.actExporter.setEnabled(false);
        this.actExporterCsv = new AbstractAction("Export..."){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.exporterCSV();
            }
        };
        this.actExporter.setEnabled(false);
        this.startListener.pushProgress();
        this.actQuitter = new AbstractAction("Quitter"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.runExit();
            }
        };
        this.startListener.pushProgress();
    }

    protected void initMenus1() {
        JMenuBar mBar = new JMenuBar();
        JMenu fileMenu = new JMenu("Fichier");
        this.importerMenu = new JMenu("Importer");
        this.controlerMenu = new JMenu("Analyser");
        fileMenu.add(this.importerMenu);
        fileMenu.add(this.controlerMenu);
        fileMenu.addSeparator();
        fileMenu.add(new JMenuItem(this.actExporterCsv));
        fileMenu.add(new JMenuItem(this.actExporter));
        fileMenu.addSeparator();
        if ("true".equals(System.getProperty("xemelios.reset.config"))) {
            JMenuItem mnuReset = new JMenuItem("Reset config ...");
            fileMenu.add(mnuReset);
            mnuReset.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainWindow.this.reloadConfiguration();
                }
            });
        }
        if ("true".equals(System.getProperty("admin.menu.gc"))) {
            this.mnuClean = new JMenuItem("Garbage collector");
            fileMenu.add(this.mnuClean);
            this.mnuClean.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.gc();
                }
            });
            this.mnuClean.setEnabled(false);
        }
        this.mnuCleanPro = new JMenuItem("Supprimer...");
        fileMenu.add(this.mnuCleanPro);
        this.mnuCleanPro.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.advancedCleanUp();
            }
        });
        fileMenu.addSeparator();
        JMenuItem mnuEnv = new JMenuItem("Environnement...");
        fileMenu.add(mnuEnv);
        mnuEnv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgEditEnvironment dee = new DlgEditEnvironment((Frame)MainWindow.this, (EnvironmentDomain)MainWindow.this.docModels, 1);
                dee.setVisible(true);
            }
        });
        fileMenu.addSeparator();
        JMenuItem mnuUpdate = new JMenuItem("Mises \u00e0 jour...");
        mnuUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new DlgUpdate(MainWindow.this);
            }
        });
        fileMenu.add(mnuUpdate);
        fileMenu.addSeparator();
        JMenuItem mnuConfig = new JMenuItem("Configuration...");
        mnuConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DlgSystemConfiguration dlg = new DlgSystemConfiguration((Frame)MainWindow.this, true);
                dlg.setVisible(true);
            }
        });
        fileMenu.add(mnuConfig);
        fileMenu.addSeparator();
        fileMenu.add(new JMenuItem(this.actQuitter));
        mBar.add(fileMenu);
        this.searchMenu = new JMenu("Recherche");
        this.browseMenu = new JMenu("Navigation");
        this.searchMenu.setEnabled(false);
        this.browseMenu.setEnabled(false);
        mBar.add(this.searchMenu);
        mBar.add(this.browseMenu);
        this.exportMenu = new JMenu("Exports");
        JMenuItem exportMenuConfig = new JMenuItem("Configurer");
        exportMenuConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.configExport();
            }
        });
        this.exportMenu.add(exportMenuConfig);
        JMenuItem exportMenuLancer = new JMenuItem("Ex\u00e9cuter");
        exportMenuLancer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.launchExport();
            }
        });
        this.exportMenu.add(exportMenuLancer);
        mBar.add(this.exportMenu);
        JMenu toolMenu = this.loadToolMenu();
        if (toolMenu != null) {
            mBar.add(toolMenu);
        }
        this.windowMenu = new WindowMenu("Fen\u00eatres", this.desk);
        mBar.add(this.windowMenu);
        mBar.add(Box.createHorizontalGlue());
        JMenu helper = new JMenu("?");
        AbstractAction aboutAction = new AbstractAction("A Propos"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                new AboutBox(MainWindow.this);
            }
        };
        helper.add(new JMenuItem(aboutAction));
        AbstractAction helpAction = new AbstractAction("Aide en ligne"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                try {
                    StartUrl.startUrl(System.getProperty("help.url"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        helper.add(helpAction);
        AbstractAction dlInfos = new AbstractAction("Rapport de configuration..."){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                try {
                    File f;
                    MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                    StringBuilder sb = new StringBuilder();
                    sb.append("Jar Files\n");
                    sb.append(ClassPathUtils.displayClassPathInfos());
                    sb.append("xemelios.properties\n-------------------\n");
                    try {
                        f = new File(MainWindow.this.getEnvProperties().replace("${xemelios.prg}/root/xemelios.properties"));
                        sb.append(FileUtils.readTextFile((File)f, (String)"ISO-8859-1")).append("\n");
                    }
                    catch (Exception ex) {
                        sb.append(" -- not readable : ").append(ex.getMessage()).append("\n");
                    }
                    sb.append("mysql.properties\n----------------\n");
                    try {
                        f = new File(MainWindow.this.getEnvProperties().replace("${xemelios.mysql.config.filename}"));
                        sb.append(FileUtils.readTextFile((File)f, (String)"ISO-8859-1")).append("\n");
                    }
                    catch (Exception ex) {
                        sb.append(" -- not readable : ").append(ex.getMessage()).append("\n");
                        logger.error((Object)"reading mysql.properties", (Throwable)ex);
                    }
                    sb.append(DataLayerManager.getImplementation().getDatalayerConfiguration());
                    sb.append("xemelios.log\n----------------\n");
                    try {
                        f = new File(MainWindow.this.getEnvProperties().replace("${xemelios.prg}/root/xemelios.log"));
                        sb.append(FileUtils.readTextFile((File)f, (String)"ISO-8859-1")).append("\n");
                    }
                    catch (Exception ex) {
                        sb.append(" -- not readable : ").append(ex.getMessage()).append("\n");
                        logger.error((Object)"reading xemelios.log", (Throwable)ex);
                    }
                    JFileChooser fc = new JFileChooser();
                    fc.setDialogTitle("Enregistrer le rapport de configuration sous...");
                    fc.addChoosableFileFilter(new javax.swing.filechooser.FileFilter(){

                        public boolean accept(File f) {
                            return f.getName().toLowerCase().endsWith(".txt");
                        }

                        public String getDescription() {
                            return "Fichier texte (.txt)";
                        }
                    });
                    MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                    if (fc.showSaveDialog(MainWindow.getInstance()) == 0) {
                        File f2 = fc.getSelectedFile();
                        PrintWriter pw = new PrintWriter(f2);
                        pw.write(sb.toString());
                        pw.flush();
                        pw.close();
                    }
                }
                catch (Throwable throwable) {
                }
                finally {
                    MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        helper.add(dlInfos);
        mBar.add(helper);
        this.setJMenuBar(mBar);
    }

    protected void initMenus2() {
        ActionImport aiArch = new ActionImport("Archive Xemelios", "xemelios.archive");
        this.importerMenu.add(new JMenuItem(aiArch));
        for (DocumentModel dm : this.docModels.getDocuments()) {
            if (!this.getConnectedUser().hasDocument(dm.getId())) {
                logger.debug((Object)(this.getConnectedUser().getId() + " is not allowed on " + dm.getId()));
                continue;
            }
            if (dm.getDisplayInMenuIf() != null && !"true".equals(System.getProperty(dm.getDisplayInMenuIf()))) continue;
            ActionImport ai = new ActionImport(dm.getTitre(), dm.getId());
            if (dm.isControlable()) {
                ActionControl ac = new ActionControl(dm.getTitre(), dm.getId());
                this.controlerMenu.add(new JMenuItem(ac));
            }
            this.importerMenu.add(new JMenuItem(ai));
            JMenu searchEntry = new JMenu(dm.getTitre());
            JMenuItem browseEntry = null;
            if (dm.isBrowsable()) {
                final DocumentModel dm2 = dm;
                browseEntry = new JMenuItem(new AbstractAction(dm.getTitre()){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent e) {
                        DlgSelectNavigationTarget dlg = new DlgSelectNavigationTarget(dm2, MainWindow.this.getConnectedUser(), instance);
                        if (dlg.run()) {
                            switch (dlg.getSpecialKeys().size()) {
                                case 0: {
                                    MainWindow.this.browse(dm2, dm2.getDefaultBrowsableEtat(), dlg.getCollectivite().key, dlg.getBudget().key, null, null);
                                    break;
                                }
                                case 1: {
                                    MainWindow.this.browse(dm2, dm2.getDefaultBrowsableEtat(), dlg.getCollectivite().key, dlg.getBudget().key, dlg.getSpecialKeys().get((int)0).key, null);
                                    break;
                                }
                                default: {
                                    MainWindow.this.browse(dm2, dm2.getDefaultBrowsableEtat(), dlg.getCollectivite().key, dlg.getBudget().key, dlg.getSpecialKeys().get((int)0).key, dlg.getSpecialKeys().get((int)1).key);
                                }
                            }
                        }
                    }
                });
            }
            int searchCount = 0;
            Enumeration enumer2 = dm.getEtats().elements();
            while (enumer2.hasMoreElements()) {
                EtatModel em = (EtatModel)enumer2.nextElement();
                if (em.getDisplayInMenuIf() != null && !"true".equals(System.getProperty(em.getDisplayInMenuIf()))) continue;
                JMenu tmpMnu = null;
                tmpMnu = !dm.isGroupMenuItem() ? new JMenu(em.getTitre()) : searchEntry;
                for (ElementModel elm : em.getSearchableElements()) {
                    if (!elm.isDisplay()) continue;
                    ActionSearch as = new ActionSearch(elm.getTitre(), dm.getId(), em.getId(), elm.getId());
                    tmpMnu.add(new JMenuItem(as));
                    ++searchCount;
                }
                if (tmpMnu == searchEntry || tmpMnu.getMenuComponentCount() <= 0) continue;
                searchEntry.add(tmpMnu);
            }
            if (searchCount > 0) {
                this.searchMenu.add(searchEntry);
            }
            if (browseEntry == null) continue;
            this.browseMenu.add(browseEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importer(String docId) {
        if ("xemelios.archive".equals(docId)) {
            this.importXemeliosArchive();
        } else {
            DocumentModel dm = this.docModels.getDocumentById(docId);
            try {
                Class<?> clazz = Class.forName(dm.getImportClass());
                Constructor<?> cc = clazz.getConstructor(XemeliosUser.class);
                Object obj = cc.newInstance(this.getConnectedUser());
                if (!(obj instanceof EtatImporteur)) {
                    JOptionPane.showMessageDialog(this, "Cette classe n'est pas un importeur.\nLe fichier de configuration qui vous a \u00e9t\u00e9 livr\u00e9 est certainement invalide.\nVeuillez contacter votre fournisseur.\n", "Erreur", 0);
                    return;
                }
                EtatImporteur ei = (EtatImporteur)obj;
                ImportContent fToImport = this.getFilesToImport(dm.getExtension(), dm.getLibelleExtension());
                this.doImport(ei, fToImport, dm, false);
            }
            catch (Exception ex) {
                logger.error((Object)"importer", (Throwable)ex);
                new DisplayExceptionDlg((Frame)this, (Throwable)ex);
            }
        }
    }

    protected void importXemeliosArchive() {
        FileSystemView fsv = FileSystemView.getFileSystemView();
        if (this.lastInputDirectory == null) {
            this.lastInputDirectory = fsv.getHomeDirectory();
        }
        JFileChooser fc = new JFileChooser(this.lastInputDirectory, fsv);
        javax.swing.filechooser.FileFilter defaultFileFilter = null;
        defaultFileFilter = new javax.swing.filechooser.FileFilter(){

            public boolean accept(File arg0) {
                return arg0.isDirectory() || arg0.getName().toUpperCase().endsWith(".XAR");
            }

            public String getDescription() {
                return "Archives Xemelios (.xar)";
            }
        };
        fc.addChoosableFileFilter(defaultFileFilter);
        fc.setFileFilter(defaultFileFilter);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle("Choisissez le premier fichier d'une archive Xemelios");
        fc.showOpenDialog(this);
        File firstArchive = fc.getSelectedFile();
        this.lastInputDirectory = firstArchive.getParentFile();
        ImportServiceSwingProvider isp = new ImportServiceSwingProvider(this, null, 0);
        isp.setDisplayFeedback(false);
        XemeliosArchiveImporter xai = new XemeliosArchiveImporter(this.docModels, firstArchive, (ImportServiceProvider)isp);
        XemeliosArchiveImporterWorker worker = new XemeliosArchiveImporterWorker(xai);
        worker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(EtatImporteur ei, ImportContent fToImport, DocumentModel dm, boolean synchronizeMe) {
        ImportServiceSwingProvider issp = new ImportServiceSwingProvider(this, ei, fToImport.filesToImport.size() + fToImport.pjs.size());
        if (synchronizeMe) {
            issp.setDisplayFeedback(false);
        }
        ei.setImpSvcProvider((ImportServiceProvider)issp);
        ei.setDocument(dm);
        this.waiter.startProgress();
        try {
            ei.setFilesToImport(fToImport.filesToImport);
            ei.setPjs(fToImport.pjs);
            if (synchronizeMe) {
                ei.run();
            } else {
                ei.execute();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"doImport", (Throwable)ex);
            new DisplayExceptionDlg((Frame)this, (Throwable)ex);
        }
        finally {
            this.waiter.stopProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(EtatImporteur ei, ImportContent fToImport, DocumentModel dm, DlgControl parentController, MainControl.Triplet triplet, boolean synchronizeMe) {
        ImportServiceSwingProvider issp = new ImportServiceSwingProvider(this, ei, fToImport.filesToImport.size() + fToImport.pjs.size());
        if (synchronizeMe) {
            issp.setDisplayFeedback(false);
        }
        ei.setImpSvcProvider((ImportServiceProvider)issp);
        ei.setDocument(dm);
        this.waiter.startProgress();
        try {
            ei.setFilesToImport(fToImport.filesToImport);
            ei.setPjs(fToImport.pjs);
            if (synchronizeMe) {
                ei.run();
            } else {
                ei.execute();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"doImport", (Throwable)ex);
            new DisplayExceptionDlg((Frame)this, (Throwable)ex);
        }
        finally {
            this.waiter.stopProgress();
        }
        try {
            ei.get();
        }
        catch (Throwable t) {
            t.printStackTrace();
            parentController.notifyImportFailed();
        }
        finally {
            parentController.notifyImportFinished(triplet);
        }
    }

    protected void controller(String docId) {
        MainControlWrapper mc = new MainControlWrapper(this.docModels.getDocumentById(docId), this.docModels, this.getConnectedUser());
        DlgControl dc = new DlgControl((Frame)this, this.docModels.getDocumentById(docId), mc);
        dc.setVisible(true);
    }

    protected void exporter() {
        SearchWindow s;
        JInternalFrame f = this.desk.getSelectedFrame();
        if (f != null && (s = (SearchWindow)f).canExport()) {
            s.exportXLS();
        }
    }

    protected void exporterCSV() {
        SearchWindow s;
        JInternalFrame f = this.desk.getSelectedFrame();
        if (f != null && (s = (SearchWindow)f).canExport()) {
            s.exportCSV();
        }
    }

    protected void runExit() {
        this.setCursor(new Cursor(3));
        JInternalFrame[] childs = this.desk.getAllFrames();
        for (int i = 0; i < childs.length; ++i) {
            this.desk.remove(childs[i]);
            childs[i].dispose();
        }
        Rectangle location = this.getBounds();
        StringBuilder propValue = new StringBuilder();
        propValue.append("(").append(Integer.toString((int)location.getX())).append(",").append(Integer.toString((int)location.getY())).append(",").append(Integer.toString((int)location.getWidth())).append(",").append(Integer.toString((int)location.getHeight())).append(")");
        File propFile = new File(System.getProperty("user.home"), "xemelios.properties");
        Properties props = new Properties();
        if (propFile.exists()) {
            try {
                props.load(new FileInputStream(propFile));
            }
            catch (IOException ioEx) {
                // empty catch block
            }
        }
        props.setProperty(MAIN_WINDOW_POSITION, propValue.toString());
        try {
            props.store(new FileOutputStream(propFile), "");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            File[] files;
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            tmpDir = new File(tmpDir, "XEMELIOS");
            for (File f : files = tmpDir.listFiles()) {
                f.delete();
            }
            tmpDir.delete();
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.savePersonnalConfig();
        this.saveCriteriasInputValues();
        System.exit(0);
    }

    public SearchWindow displaySearchWindow(ElementModel element) {
        ElementModel elm = element.clone();
        EtatModel em = element.getParent();
        DocumentModel dm = em.getParent();
        elm.setParent(em);
        try {
            if (DataLayerManager.getImplementation().canSearch(dm, em, this.getConnectedUser())) {
                if (elm == null) {
                    JOptionPane.showMessageDialog(this, "L'\u00e9tat " + em.getTitre() + " n'a pas d'\u00e9l\u00e9ment de recherche d\u00e9finit.", "Erreur de configuration", 0);
                    return null;
                }
                SearchWindow sw = new SearchWindow(this, dm, elm, this.getConnectedUser());
                this.desk.add(sw);
                this.desk.getDesktopManager().maximizeFrame(sw);
                return sw;
            }
            throw new ToolException(8);
        }
        catch (ToolException tEx) {
            if (tEx.getErrorCode() == 8) {
                JOptionPane.showMessageDialog(this, "Aucun " + em.getTitre() + " n'a \u00e9t\u00e9 import\u00e9.\nVous devez en importer au moins un avant d'effectuer une recherche.", "Erreur", 2);
            } else {
                new DisplayExceptionDlg((Frame)this, (Throwable)tEx);
            }
        }
        catch (UnauthorizedException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Droits insuffisants", 2);
        }
        catch (DataAccessException daEx) {
            new DisplayExceptionDlg((Frame)this, (Throwable)daEx);
        }
        catch (DataConfigurationException dcEx) {
            new DisplayExceptionDlg((Frame)this, (Throwable)dcEx);
        }
        return null;
    }

    protected void search(String docId, String etatId, String elementId) {
        DocumentModel dm = this.docModels.getDocumentById(docId).clone();
        EtatModel em = dm.getEtatById(etatId);
        try {
            ElementModel elm;
            if (DataLayerManager.getImplementation().canSearch(dm, em, this.getConnectedUser())) {
                elm = em.getElementById(elementId);
                if (elm == null) {
                    JOptionPane.showMessageDialog(this, "L'\u00e9tat " + em.getTitre() + " n'a pas d'\u00e9l\u00e9ment de recherche d\u00e9finit.", "Erreur de configuration", 0);
                    return;
                }
            } else {
                throw new ToolException(8);
            }
            SearchWindow sw = new SearchWindow(this, dm, elm, this.getConnectedUser());
            this.desk.add(sw);
            this.desk.getDesktopManager().maximizeFrame(sw);
            sw.show();
        }
        catch (ToolException tEx) {
            if (tEx.getErrorCode() == 8) {
                JOptionPane.showMessageDialog(this, "Aucun " + em.getTitre() + " n'a \u00e9t\u00e9 import\u00e9.\nVous devez en importer au moins un avant d'effectuer une recherche.", "Erreur", 2);
            } else {
                new DisplayExceptionDlg((Frame)this, (Throwable)tEx);
            }
        }
        catch (UnauthorizedException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Droits insuffisants", 2);
        }
        catch (DataAccessException daEx) {
            new DisplayExceptionDlg((Frame)this, (Throwable)daEx);
        }
        catch (DataConfigurationException dcEx) {
            new DisplayExceptionDlg((Frame)this, (Throwable)dcEx);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean checkPassword() throws DataAccessException {
        AuthEngine authEngine = AuthEngine.Holder.getAuthEngine();
        XemeliosUser user = null;
        if (authEngine.isLoginRequired() || authEngine.isPasswordRequired()) {
            if (this.startListener instanceof Splash) {
                Splash sp = (Splash)this.startListener;
                sp.setAlwaysOnTop(false);
                sp.setVisible(false);
            }
            for (int attempt = 0; user == null && attempt < 3; ++attempt) {
                LoginDialog loginDialog = new LoginDialog(this, authEngine.isLoginRequired(), authEngine.isPasswordRequired());
                if (loginDialog.run()) {
                    user = authEngine.createUser(loginDialog.getUserName(), loginDialog.getPassword());
                    if (user != null) continue;
                    JOptionPane.showMessageDialog(this, "Echec de l'authentification.", "Erreur", 0);
                    continue;
                }
                if (this.startListener instanceof Splash) {
                    Splash sp = (Splash)this.startListener;
                    sp.setAlwaysOnTop(true);
                    sp.setVisible(true);
                }
                return false;
            }
            if (this.startListener instanceof Splash) {
                Splash sp = (Splash)this.startListener;
                sp.setAlwaysOnTop(true);
                sp.setVisible(true);
            }
            if (user == null) {
                // empty if block
            }
        } else {
            user = authEngine.createUser(null, null);
        }
        if (user != null) {
            this.connectedUser = user;
            return true;
        }
        return false;
    }

    protected DocumentsModel getDocumentsInfos(String repertoires) {
        DocumentsModel ret = null;
        try {
            ret = Loader.getDocumentsInfos((String)repertoires);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.startListener.completeProgress();
            if (this.startListener instanceof Splash) {
                Splash sp = (Splash)this.startListener;
                sp.setAlwaysOnTop(false);
                sp.setVisible(false);
            }
            new DisplayExceptionDlg((Frame)null, (Throwable)ex);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImportContent getFilesToImport(final String extension, final String titreEtat) {
        ImportContent ic = new ImportContent();
        FileSystemView fsv = FileSystemView.getFileSystemView();
        if (this.lastInputDirectory == null) {
            this.lastInputDirectory = fsv.getHomeDirectory();
        }
        JFileChooser fc = new JFileChooser(this.lastInputDirectory, fsv);
        javax.swing.filechooser.FileFilter defaultFileFilter = null;
        defaultFileFilter = new javax.swing.filechooser.FileFilter(){

            public boolean accept(File arg0) {
                return arg0.isDirectory() || arg0.getName().toUpperCase().endsWith(extension.toUpperCase());
            }

            public String getDescription() {
                return "Fichiers " + titreEtat;
            }
        };
        fc.addChoosableFileFilter(defaultFileFilter);
        fc.addChoosableFileFilter(new javax.swing.filechooser.FileFilter(){

            public boolean accept(File arg0) {
                return arg0.isDirectory() || arg0.getName().toUpperCase().endsWith(".XML");
            }

            public String getDescription() {
                return "Fichiers XML";
            }
        });
        fc.addChoosableFileFilter(new javax.swing.filechooser.FileFilter(){

            public boolean accept(File arg0) {
                return arg0.isDirectory() || arg0.getName().toUpperCase().endsWith(".ZIP");
            }

            public String getDescription() {
                return "Archives ZIP";
            }
        });
        fc.addChoosableFileFilter(new javax.swing.filechooser.FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith(".GZ");
            }

            public String getDescription() {
                return "Fichier compress\u00e9 (GZip)";
            }
        });
        fc.setFileFilter(defaultFileFilter);
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        fc.setDialogTitle("Choisissez un fichier ou r\u00e9pertoire \u00e0 importer");
        fc.showOpenDialog(this);
        File[] ret = null;
        if (fc.getSelectedFile() != null && fc.getSelectedFile().isFile()) {
            ret = fc.getSelectedFiles();
            this.lastInputDirectory = ret[0].getParentFile();
        } else if (fc.getSelectedFile() != null && fc.getSelectedFile().isDirectory()) {
            logger.debug((Object)("path=" + fc.getSelectedFile().getAbsolutePath()));
            String[] extensions = new String[]{"xml", "zip", extension};
            ImportDialog test = new ImportDialog(this, "S\u00e9lectionnez les fichiers \u00e0 importer");
            List<ImportFile> resultats = test.startDialog(fc.getSelectedFile(), extensions);
            ret = new File[resultats.size()];
            int counter = 0;
            Iterator<ImportFile> iter = resultats.iterator();
            while (iter.hasNext()) {
                ret[counter++] = iter.next().getFile();
            }
            this.lastInputDirectory = fc.getSelectedFile();
        } else {
            ret = new File[]{};
        }
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i].getName().toLowerCase().endsWith(".zip")) {
                if (!ret[i].exists()) continue;
                ZipFile zf = null;
                try {
                    zf = new ZipFile(ret[i]);
                    Enumeration<? extends ZipEntry> enumer = zf.entries();
                    while (enumer.hasMoreElements()) {
                        ZipEntry ze = enumer.nextElement();
                        if (ze.isDirectory()) continue;
                        String fileName = ze.getName();
                        String entryName = fileName.toLowerCase();
                        fileName = fileName.replace(File.pathSeparatorChar, '_').replace(File.separatorChar, '_').replace(':', '|').replace('\'', '_').replace('/', '_');
                        logger.debug((Object)entryName);
                        if (PJRef.isPJ((ZipEntry)ze)) {
                            PJRef pj = new PJRef(ze);
                            pj.writeTmpFile(tmpDir, zf);
                            ic.pjs.add(pj);
                            continue;
                        }
                        if (!entryName.endsWith(extension.toLowerCase()) && !entryName.endsWith(".xml") || fileName.startsWith("_")) continue;
                        InputStream is = zf.getInputStream(ze);
                        BufferedInputStream bis = new BufferedInputStream(is);
                        File output = new File(tmpDir, fileName);
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(output));
                        byte[] buffer = new byte[1024];
                        int read = bis.read(buffer);
                        while (read > 0) {
                            bos.write(buffer, 0, read);
                            read = bis.read(buffer);
                        }
                        bos.flush();
                        bos.close();
                        bis.close();
                        ic.filesToImport.add(output);
                    }
                    zf.close();
                    continue;
                }
                catch (ZipException zEx) {
                    JOptionPane.showMessageDialog(this, "Le fichier " + ret[i].getName() + " n'est pas une archive ZIP valide", "Erreur", 0);
                    continue;
                }
                catch (IOException ioEx) {
                    JOptionPane.showMessageDialog(this, "Le fichier " + ret[i].getName() + " est illisible. V\u00e9rifiez que les noms des fichiers\ncontenus dans l'archive ne comportent pas de caract\u00e8res sp\u00e9ciaux ou accentu\u00e9s.", "Erreur", 0);
                    ioEx.printStackTrace();
                    continue;
                }
                finally {
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (Throwable t) {}
                    }
                }
            }
            if (ret[i].getName().toLowerCase().endsWith(".gz")) {
                try {
                    String fileName = ret[i].getName();
                    fileName = fileName.substring(0, fileName.length() - 3);
                    File output = new File(tmpDir, fileName);
                    GZIPInputStream gis = new GZIPInputStream(new FileInputStream(ret[i]));
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(output));
                    byte[] buffer = new byte[1024];
                    int read = gis.read(buffer);
                    while (read > 0) {
                        bos.write(buffer, 0, read);
                        read = gis.read(buffer);
                    }
                    bos.flush();
                    bos.close();
                    gis.close();
                    ic.filesToImport.add(output);
                }
                catch (IOException ioEx) {}
                continue;
            }
            ic.filesToImport.add(ret[i]);
        }
        return ic;
    }

    protected void checkUpdateAvailability() {
        UpdateChecker uc = new UpdateChecker();
        uc.execute();
    }

    public void innerWindowChanged() {
        JInternalFrame inner = this.desk.getSelectedFrame();
        if (inner == null) {
            this.actExporter.setEnabled(false);
            this.actExporterCsv.setEnabled(false);
        } else if (inner instanceof SearchWindow) {
            SearchWindow sw = (SearchWindow)inner;
            boolean canExport = true;
            canExport &= sw.canExport();
            canExport &= this.getConnectedUser().hasRole("EXPORT");
            this.actExporter.setEnabled(canExport &= sw.isEtatExportable());
            this.actExporterCsv.setEnabled(canExport);
        }
    }

    public void msg(String message) {
        this.statusField.setText(message);
    }

    public static final void main(String[] args) {
        new MainWindow("XEMELIOS", new EmptyStartListener(), args);
    }

    public void startWaiter() {
        this.waiter.startProgress();
    }

    public void stopWaiter() {
        this.waiter.stopProgress();
    }

    private void advancedCleanUp() {
        new DlgCleanDatabase((Frame)this, true, this.docModels, this.getConnectedUser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void starterImport(String[] args) {
        Splash splash;
        if (this.startListener instanceof Splash) {
            splash = (Splash)this.startListener;
            splash.setAlwaysOnTop(false);
            splash.setVisible(false);
        }
        if (this.connectedUser.hasRole("IMPORT")) {
            for (String fName : args) {
                File f = null;
                try {
                    f = new File(fName);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (f == null || !f.exists()) continue;
                AskDocumentType adt = new AskDocumentType(this, fName, this.docModels);
                adt.setVisible(true);
                DocumentModel dm = adt.getDocumentType();
                if (dm == null) continue;
                try {
                    Class<?> clazz = Class.forName(dm.getImportClass());
                    Constructor<?> cc = clazz.getConstructor(XemeliosUser.class);
                    Object obj = cc.newInstance(this.getConnectedUser());
                    if (!(obj instanceof EtatImporteur)) {
                        JOptionPane.showMessageDialog(this, "Cette classe n'est pas un importeur.\nLe fichier de configuration qui vous a \u00e9t\u00e9 livr\u00e9 est certainement invalide.\nVeuillez contacter votre fournisseur.", "Erreur", 0);
                        return;
                    }
                    EtatImporteur ei = (EtatImporteur)obj;
                    File[] fToImport = new File[]{f};
                    ImportServiceSwingProvider issp = new ImportServiceSwingProvider(this, ei, fToImport.length);
                    ei.setImpSvcProvider((ImportServiceProvider)issp);
                    ei.setDocument(dm);
                    this.waiter.startProgress();
                    ei.setFilesToImport(fToImport);
                    ei.setPjs(new ArrayList());
                    ei.execute();
                    this.waiter.stopProgress();
                }
                catch (Exception ex) {
                    logger.error((Object)"starterImport", (Throwable)ex);
                    new DisplayExceptionDlg((Frame)this, (Throwable)ex);
                }
                finally {
                    this.waiter.stopProgress();
                }
            }
        }
        if (this.startListener instanceof Splash) {
            splash = (Splash)this.startListener;
            splash.setAlwaysOnTop(false);
            splash.setVisible(false);
        }
    }

    public SavedRequestsModel getSavedRequest(ElementModel el) {
        return this.config.getSavedRequests(el);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePersonnalConfig() {
        File f = new File(System.getProperty("user.home"));
        File fProp = new File(f, "xemelios-config.xml");
        OutputStreamWriter w = null;
        try {
            Charset cs = Charset.forName("ISO-8859-1");
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(fProp), cs);
            XmlOutputter xo = new XmlOutputter(w, cs.name());
            this.config.marshall(xo);
        }
        catch (Throwable t) {
            logger.error((Object)"savePersonnalConfig", t);
        }
        finally {
            if (w != null) {
                try {
                    w.flush();
                    w.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void loadPersonnalConfig() {
        File[] sharedFiles;
        File f = new File(System.getProperty("user.home"));
        File fProp = new File(f, "xemelios-config.xml");
        this.config = new PersonnalConfigurationModel(PersonnalConfigurationModel.QN);
        if (fProp.exists()) {
            try {
                PersonnalConfigParser parser = new PersonnalConfigParser();
                parser.parse(fProp);
                this.config = (PersonnalConfigurationModel)parser.getMarshallable();
            }
            catch (Throwable t) {
                logger.error((Object)"loadPersonnalConfig", t);
            }
        }
        for (File share : sharedFiles = f.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("xemelios-config.xml".substring(0, "xemelios-config.xml".indexOf(46)) + "-");
            }
        })) {
            try {
                PersonnalConfigParser parser = new PersonnalConfigParser();
                parser.parse(fProp);
                PersonnalConfigurationModel sharedConfig = (PersonnalConfigurationModel)parser.getMarshallable();
                String name = share.getName().substring("xemelios-config.xml".indexOf(46) + 1);
                name = name.substring(0, name.indexOf(46));
                sharedConfig.setUnWritable(name);
                this.config.merge(sharedConfig);
            }
            catch (Throwable t) {
                logger.error((Object)"loadPersonnalConfig", t);
            }
        }
    }

    protected Properties loadCriteriasInputValues() {
        Properties props = new Properties();
        File f = new File(System.getProperty("user.home"));
        File fProp = new File(f, "xemelios-criterias-imputs.properties");
        if (fProp.exists()) {
            try {
                FileInputStream fis = new FileInputStream(fProp);
                props.load(fis);
                fis.close();
            }
            catch (IOException ioEx) {
                // empty catch block
            }
        }
        return props;
    }

    protected void saveCriteriasInputValues() {
        File f = new File(System.getProperty("user.home"));
        File fProp = new File(f, "xemelios-criterias-imputs.properties");
        try {
            FileOutputStream fos = new FileOutputStream(fProp);
            this.criteriasInputValues.store(fos, null);
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void browse(DocumentModel dm, EtatModel emParam, String collectivite, String budget, String specialKey1, String specialKey2) {
        EtatModel em = emParam == null ? dm.getDefaultBrowsableEtat() : emParam;
        NavigationContext nc = new NavigationContext(dm.getId(), em.getId(), em.getBrowsableElement().getId(), collectivite, budget, specialKey1, specialKey2, null, null);
        try {
            if (em == null) {
                throw new DataConfigurationException("No default browsable etat for " + dm.getId());
            }
            DataImpl impl = DataLayerManager.getImplementation();
            ArrayList documents = impl.getDocumentListFromSpecialKeys(em.getBrowsableElement(), collectivite, budget, specialKey1, specialKey2, null, this.getConnectedUser());
            if (documents.size() == 0) {
                JOptionPane.showMessageDialog(this, "Le document est introuvable", "", 2);
            } else if (documents.size() > 1) {
                JOptionPane.showMessageDialog(this, "Plusieurs documents r\u00e9pondant \u00e0 ces crit\u00e8res ont \u00e9t\u00e9 trouv\u00e9s.", "Erreur", 0);
            } else {
                String docName = (String)documents.get(0);
                String content = impl.getDocumentAsString(em, new Pair(collectivite, null), new Pair(budget, null), docName, this.getConnectedUser());
                String encoding = IoUtils.getEncoding((String)content);
                File f = new File(new File(new File(System.getProperty("user.home")), "xemelios/documents-def-ovrrd"), em.getXslt());
                if (!f.exists()) {
                    f = new File(new File(em.getParent().getBaseDirectory()), em.getXslt());
                }
                FileInputStream is = new FileInputStream(f);
                Hashtable<String, String> parameters = new Hashtable<String, String>();
                parameters.put("browser-destination", em.useExternalBrowser() ? "external" : "internal");
                InputStream htmlStream = DematTransform.transform((InputStream)new ByteArrayInputStream(content.getBytes(encoding)), (InputStream)is, (String)encoding, parameters);
                this.displayHtmlStream(htmlStream, em, this.desk, nc);
            }
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, t.getMessage(), "Erreur", 0);
            t.printStackTrace();
        }
    }

    public void displayHtmlStream(InputStream is, EtatModel em, JDesktopPane desk) throws IOException {
        this.displayHtmlStream(is, em, desk, null);
    }

    public void displayHtmlStream(File f, EtatModel em) {
        try {
            String prefix = System.getProperty("navigator.url.prefix");
            if (prefix == null) {
                prefix = "";
            }
            String url = f.getCanonicalPath();
            if (em.useExternalBrowser()) {
                StartUrl.startUrl(url);
            } else {
                HtmlViewer viewer = new HtmlViewer(f.toURL(), "D\u00e9tail " + em.getTitre(), null, this);
                this.desk.add(viewer);
                this.desk.getDesktopManager().maximizeFrame(viewer);
                viewer.show();
            }
        }
        catch (Exception toEx) {
            Container comp2;
            for (comp2 = this.desk; comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
            }
            if (comp2 != null) {
                new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)toEx);
            }
            toEx.printStackTrace();
        }
    }

    public void displayHtmlStream(InputStream is, EtatModel em, JDesktopPane desk, NavigationContext nc) throws IOException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        tmpDir = new File(tmpDir, "XEMELIOS");
        tmpDir.mkdirs();
        File tmp = File.createTempFile("xemelios-data-", ".html", tmpDir);
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmp));
        byte[] buff = new byte[1024];
        int lengthRead = bis.read(buff);
        while (lengthRead > 0) {
            bos.write(buff, 0, lengthRead);
            lengthRead = bis.read(buff);
        }
        bos.flush();
        bos.close();
        try {
            String prefix = System.getProperty("navigator.url.prefix");
            if (prefix == null) {
                prefix = "";
            }
            String url = tmp.getCanonicalPath();
            if (em.useExternalBrowser()) {
                StartUrl.startUrl(url);
            } else {
                HtmlViewer viewer = new HtmlViewer(tmp.toURL(), "D\u00e9tail " + em.getTitre(), nc, this);
                desk.add(viewer);
                desk.getDesktopManager().maximizeFrame(viewer);
                viewer.show();
            }
        }
        catch (Exception toEx) {
            Container comp2;
            for (comp2 = desk; comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
            }
            if (comp2 != null) {
                new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)toEx);
            }
            toEx.printStackTrace();
        }
    }

    protected void initDataLayer() throws DataConfigurationException {
        logger.debug((Object)"entering initDataLayer");
        String availableLayers = System.getProperty("xemelios.available.datalayers");
        StringTokenizer tokenizer = new StringTokenizer(availableLayers, ",");
        while (tokenizer.hasMoreTokens()) {
            String className = tokenizer.nextToken();
            logger.debug((Object)("instanciating " + className));
            try {
                Class.forName(className);
            }
            catch (Throwable t) {
                logger.error((Object)("error while initializing data layer class (" + className + ") :"), t);
            }
        }
        logger.debug((Object)("setting dataImpl to " + System.getProperty("xemelios.data.impl")));
        try {
            DataLayerManager.setDataImpl((String)System.getProperty("xemelios.data.impl"));
        }
        catch (DataConfigurationException dcEx) {
            Splash splash;
            if (this.getStartListener() instanceof Splash) {
                splash = (Splash)this.startListener;
                splash.setAlwaysOnTop(false);
                splash.setVisible(false);
            }
            JOptionPane.showMessageDialog(null, dcEx.getMessage(), "Erreur de connexion au serveur Xemelios", 0);
            if (this.getStartListener() instanceof Splash) {
                splash = (Splash)this.startListener;
                splash.setVisible(true);
                splash.setAlwaysOnTop(true);
            }
            throw dcEx;
        }
        logger.debug((Object)"exiting successfully initDataLayer");
    }

    private void reloadConfiguration() {
        PropertiesExpansion pe1 = new PropertiesExpansion();
        for (Object key : System.getProperties().keySet()) {
            pe1.setProperty((String)key, System.getProperty((String)key));
        }
        Loader.flushLoadedConfig();
        this.docModels = this.getDocumentsInfos(pe1.getProperty("xemelios.documents.def.dir"));
        try {
            DataLayerManager.getImplementation().reset();
        }
        catch (DataConfigurationException e) {
            e.printStackTrace();
            new DisplayExceptionDlg((Frame)this, (Throwable)e);
        }
    }

    public XemeliosUser getConnectedUser() {
        return this.connectedUser;
    }

    protected void checkUpdateScript() {
        File f = new File(System.getProperty("xemelios.prg"), "update-script.xml");
        if (f.exists()) {
            try {
                DocumentBuilder domBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                XPath xpath = this.xpf.newXPath();
                Document dom = domBuilder.parse(f);
                NodeList nl = (NodeList)xpath.evaluate("/update-script/*", dom, XPathConstants.NODESET);
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node node = nl.item(i);
                    if (node.getNodeType() != 1) continue;
                    String nodeName = node.getNodeName();
                    if ("component".equals(nodeName)) {
                        String id = xpath.evaluate("./@id", node);
                        String version = xpath.evaluate("./@version", node);
                        String description = xpath.evaluate("./@description", node);
                        this.installComponent(id, version, description);
                        continue;
                    }
                    if ("configurator".equals(nodeName)) {
                        String className = xpath.evaluate("./@class", node);
                        PropertiesExpansion props = new PropertiesExpansion(System.getProperties());
                        NodeList params = (NodeList)xpath.evaluate("./param", node, XPathConstants.NODESET);
                        for (int paramCount = 0; paramCount < params.getLength(); ++paramCount) {
                            Node p = params.item(paramCount);
                            String paramName = xpath.evaluate("./@name", p);
                            String paramValue = xpath.evaluate("./text()", p);
                            props.put((Object)paramName, (Object)paramValue);
                        }
                        this.executeConfigurator(className, props);
                        continue;
                    }
                    if ("remove-component".equals(nodeName)) continue;
                    logger.warn((Object)("update-script: unexpected element <" + nodeName + "/>"));
                }
            }
            catch (Throwable t) {
                new DisplayExceptionDlg((Frame)null, t);
            }
            f.delete();
        }
    }

    protected void installComponent(String id, String version, String description) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        logger.info((Object)("installing component " + id));
        XemeliosComponentModel installedComponents = null;
        File f = new File(System.getProperty("xemelios.components.filename"));
        if (f.exists()) {
            ComponentsParser parser = new ComponentsParser();
            parser.parse(f);
            installedComponents = (XemeliosComponentModel)parser.getMarshallable();
        } else {
            installedComponents = new XemeliosComponentModel(XemeliosComponentModel.QN);
        }
        ComponentModel cm = new ComponentModel(id, version, description);
        String cVersion = installedComponents.getComponentVersion(cm.getId());
        if (cVersion == null) {
            installedComponents.addChild(cm, ComponentModel.QN);
        } else {
            installedComponents.remove(cm.getId());
            installedComponents.addChild(cm, ComponentModel.QN);
        }
        OutputStreamWriter fos = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "ISO-8859-1");
        XmlOutputter output = new XmlOutputter(fos, "ISO-8859-1");
        installedComponents.marshall(output);
        fos.flush();
        fos.close();
    }

    protected void executeConfigurator(String className, PropertiesExpansion props) throws Exception {
        logger.info((Object)("executing configurator " + className));
        Class<?> clazz = Class.forName(className);
        Constructor<?> cons = clazz.getConstructor(new Class[0]);
        Object o = cons.newInstance(new Object[0]);
        if (!(o instanceof AbstractConfigurator)) {
            throw new Exception(className + " does not extends " + AbstractConfigurator.class.getName());
        }
        AbstractConfigurator ac = (AbstractConfigurator)o;
        ac.setProperties(props);
        ac.setMainWindow(this);
        ac.doConfigure();
    }

    public String getCriteriaInputValue(String criteriaId) {
        if (criteriaId == null) {
            return null;
        }
        return (String)this.criteriasInputValues.get(criteriaId);
    }

    public synchronized void setCriteriaInputValue(String criteriaId, String value) {
        if (criteriaId == null) {
            return;
        }
        if (value != null && value.length() > 0) {
            this.criteriasInputValues.put(criteriaId, value);
        } else {
            this.criteriasInputValues.remove(criteriaId);
        }
    }

    public DocumentsModel getDocModels() {
        return this.docModels;
    }

    protected void setMenusAccess() {
        Runnable updater = new Runnable(){

            public void run() {
                MainWindow.this.searchMenu.setEnabled(MainWindow.this.getConnectedUser().hasRole("SEARCH"));
                MainWindow.this.browseMenu.setEnabled(MainWindow.this.getConnectedUser().hasRole("BROWSE"));
                if (MainWindow.this.importerMenu != null) {
                    MainWindow.this.importerMenu.setEnabled(MainWindow.this.getConnectedUser().hasRole("IMPORT"));
                }
                if (MainWindow.this.controlerMenu != null) {
                    MainWindow.this.controlerMenu.setEnabled(MainWindow.this.getConnectedUser().hasRole("IMPORT"));
                }
                if (MainWindow.this.mnuClean != null) {
                    MainWindow.this.mnuClean.setEnabled(MainWindow.this.getConnectedUser().hasRole("CLEAN"));
                }
                if (MainWindow.this.mnuCleanPro != null) {
                    MainWindow.this.mnuCleanPro.setEnabled(MainWindow.this.getConnectedUser().hasRole("CLEAN"));
                }
                MainWindow.this.actExporter.setEnabled(MainWindow.this.getConnectedUser().hasRole("EXPORT"));
                MainWindow.this.actExporterCsv.setEnabled(MainWindow.this.getConnectedUser().hasRole("EXPORT"));
                if (MainWindow.this.exportMenu != null) {
                    MainWindow.this.exportMenu.setEnabled(MainWindow.this.getConnectedUser().hasRole("EXPORT"));
                }
            }
        };
        SwingUtilities.invokeLater(updater);
    }

    public StartListener getStartListener() {
        return this.startListener;
    }

    public static MainWindow getInstance() {
        return instance;
    }

    protected void finalize() {
        instance = null;
        try {
            if (DataLayerManager.getImplementation() != null) {
                DataLayerManager.getImplementation().shutdown();
            }
        }
        catch (DataConfigurationException dce) {
            logger.error((Object)dce, (Throwable)dce);
        }
    }

    protected void applyPatches() {
        AbstractConfigurator ac = null;
        try {
            Class<?> clazz = Class.forName("fr.gouv.finances.cp.xemelios.patches.Core4000");
            ac = (AbstractConfigurator)clazz.newInstance();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (ac != null) {
            try {
                PropertiesExpansion props = new PropertiesExpansion(System.getProperties());
                ac.setProperties(props);
                ac.run();
            }
            catch (Exception ex) {
                logger.error((Object)"while applying patches", (Throwable)ex);
                System.exit(2);
            }
        }
    }

    public JDesktopPane getDesk() {
        return this.desk;
    }

    private void configExport() {
        DlgSearchConfig sc = new DlgSearchConfig(this, this.docModels, 2, this.getConnectedUser());
        sc.setVisible(true);
    }

    private void launchExport() {
        DlgExportAll dga = new DlgExportAll((Frame)this, true, this.docModels, this.getConnectedUser());
        dga.setVisible(true);
    }

    protected JMenu loadToolMenu() {
        String sDir;
        logger.debug((Object)"looking for tools");
        JMenu ret = new JMenu("Outils");
        PropertiesExpansion pe1 = new PropertiesExpansion();
        pe1.putAll((Map)System.getProperties());
        XemeliosComponentsModel components = null;
        try {
            XemeliosComponentsParser parser = new XemeliosComponentsParser();
            parser.parse(new File(pe1.getProperty("xemelios.components.filename")));
            components = (XemeliosComponentsModel)parser.getMarshallable();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (components == null) {
            components = new XemeliosComponentsModel(XemeliosComponentsModel.QN);
        }
        if ((sDir = pe1.getProperty("xemelios.tools.directory")) != null) {
            String[] directories;
            for (String currentDirectory : directories = sDir.split(",")) {
                File[] jars;
                currentDirectory = pe1.replace(currentDirectory);
                logger.debug((Object)("looking for tool into " + currentDirectory));
                File dir = new File(currentDirectory);
                if (!dir.exists() || !dir.isDirectory()) continue;
                for (File jar : jars = dir.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().toUpperCase().endsWith(".JAR");
                    }
                })) {
                    logger.debug((Object)("found " + jar.getAbsolutePath()));
                    try {
                        JarFile jf = new JarFile(jar);
                        Manifest mn = jf.getManifest();
                        String toolClassName = mn.getMainAttributes().getValue("Tool-Class");
                        String toolRequires = mn.getMainAttributes().getValue("Tool-Requires");
                        String toolDescription = null;
                        String toolIcon = mn.getMainAttributes().getValue("Tool-Icon");
                        jf.close();
                        if (toolClassName == null || toolClassName.length() <= 0) continue;
                        try {
                            ImageIcon img;
                            if (toolRequires != null && toolRequires.length() > 3) {
                                String[] requiredComps;
                                for (String comp : requiredComps = toolRequires.split(";")) {
                                    String[] compDetails = comp.split(",");
                                    if (compDetails.length != 2) continue;
                                    fr.gouv.finances.dgfip.xemelios.common.components.ComponentModel installedComp = components.getComponent(compDetails[0]);
                                    if (installedComp == null) {
                                        throw new Exception("Component " + compDetails[0] + " (" + compDetails[1] + ") required");
                                    }
                                    if (installedComp.isNewerOrEqualThan(compDetails[1])) continue;
                                    throw new Exception(installedComp.getId() + " " + installedComp.getVersion() + ") to old: " + compDetails[1] + " required");
                                }
                            }
                            if (!"true".equals(pe1.getProperty("xemelios.tools.avoid-jar-loading"))) {
                                Bootstrap.addFile((File)jar);
                            }
                            Class<?> clazz = null;
                            try {
                                clazz = Class.forName(toolClassName);
                                MenuTitle mt = clazz.getAnnotation(MenuTitle.class);
                                if (mt != null) {
                                    toolDescription = mt.value();
                                } else {
                                    logger.error((Object)("Plugin Class " + toolClassName + " doesn't provide annotation @MenuTitle"));
                                }
                            }
                            catch (Exception ex) {
                                logger.error((Object)ex.getMessage(), (Throwable)ex);
                            }
                            if (toolDescription == null || toolDescription.length() <= 0) continue;
                            ActionPlugin a = null;
                            a = toolIcon != null ? ((img = IhmFactory.getIconFromResource(toolIcon)) != null ? new ActionPlugin(toolClassName, toolDescription, img) : new ActionPlugin(toolClassName, toolDescription)) : new ActionPlugin(toolClassName, toolDescription);
                            JMenuItem mnuItem = new JMenuItem(a);
                            ret.add(mnuItem);
                        }
                        catch (Exception ex) {
                            logger.info((Object)("can not install plugin " + toolClassName + ": " + ex.getMessage()));
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
            if (ret.getItemCount() > 0) {
                return ret;
            }
        }
        return null;
    }

    public PropertiesExpansion getEnvProperties() {
        return this.pe;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XemeliosArchiveImporterWorker
    extends SwingWorker<XemeliosArchiveImporter.Errors, String> {
        private XemeliosArchiveImporter importer;
        private XemeliosArchiveImporter.Errors errors;

        public XemeliosArchiveImporterWorker(XemeliosArchiveImporter importer) {
            this.importer = importer;
        }

        protected XemeliosArchiveImporter.Errors doInBackground() throws Exception {
            this.errors = this.importer.doImport();
            return this.errors;
        }

        protected void done() {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            logger.debug((Object)("Fin import archive a " + sdf.format(new Date())));
            StringBuilder sb = new StringBuilder();
            if (this.errors != null) {
                for (XemeliosArchiveImporter.Error error : this.errors.getErrors()) {
                    sb.append("<").append(error.getSeverityMessage()).append("> ").append(error.getMessage()).append("\n");
                }
            }
            if (sb.length() > 0) {
                JOptionPane.showMessageDialog(MainWindow.this, sb.toString());
            } else {
                JOptionPane.showMessageDialog(MainWindow.this, this.importer.getFileInfo().toString(MainWindow.this.docModels));
            }
        }
    }

    private class PoolStatDisplayer
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel lblActive = null;
        private JLabel lblIdle = null;

        public PoolStatDisplayer() {
            this.add(new JLabel("Active(s): "));
            this.lblActive = new JLabel("0");
            this.add(this.lblActive);
            this.add(new JLabel("  Idle(s): "));
            this.lblIdle = new JLabel("0");
            this.add(this.lblIdle);
            Timer timer = new Timer(500, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        if (PoolManager.getInstance() != null && PoolManager.getInstance().getPool() != null) {
                            Pool pool = PoolManager.getInstance().getPool();
                            PoolStatDisplayer.this.lblActive.setText(Integer.toString(pool.getNumActive()));
                            PoolStatDisplayer.this.lblIdle.setText(Integer.toString(pool.getNumIdle()));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            timer.start();
        }
    }

    private class ActionPlugin
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private String className;

        public ActionPlugin(String className, String desc) {
            super(desc);
            this.className = null;
            this.className = className;
        }

        public ActionPlugin(String className, String desc, Icon icon) {
            super(desc, icon);
            this.className = null;
            this.className = className;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Class<?> clazz = Class.forName(this.className);
                Object o = clazz.newInstance();
                if (!(o instanceof AbstractTool)) {
                    throw new Exception(this.className + " does not extends " + AbstractTool.class.getName());
                }
                AbstractTool at = (AbstractTool)o;
                at.run();
            }
            catch (Exception ex) {
                new DisplayExceptionDlg((Frame)instance, (Throwable)ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UpdateChecker
    extends SwingWorker<Boolean, Object> {
        protected Boolean doInBackground() {
            UpdaterUtil uu = new UpdaterUtil(instance.updateUrl, instance.componentsModelFileName);
            return new Boolean(uu.areThereUpdatesAvailable());
        }

        protected void done() {
            try {
                if (((Boolean)this.get()).booleanValue()) {
                    String message = "<html>Des mises \u00e0 jour sont disponibles.<br><br>Pour les installer, allez dans<br>le menu Fichier / Mises \u00e0 jour,<br>puis cliquez sur Rechercher.</html>";
                    JOptionPane.showMessageDialog(instance, message, "Information", 1);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportContent {
        ArrayList<File> filesToImport = new ArrayList();
        ArrayList<PJRef> pjs = new ArrayList();

        public void setFilesToImport(ArrayList<File> array) {
            this.filesToImport = array;
        }

        public ArrayList<File> getFilesToImport() {
            return this.filesToImport;
        }

        public ArrayList<PJRef> getPjs() {
            return this.pjs;
        }
    }

    private final class ActionSearch
    extends AbstractAction {
        private static final long serialVersionUID = 3617860763465560632L;
        String docId;
        String etatId;
        String elementId;

        public ActionSearch(String titre, String docId, String etatId, String elementId) {
            super(titre);
            this.docId = docId;
            this.etatId = etatId;
            this.elementId = elementId;
        }

        public void actionPerformed(ActionEvent evt) {
            MainWindow.this.search(this.docId, this.etatId, this.elementId);
        }
    }

    private final class ActionControl
    extends AbstractAction {
        private static final long serialVersionUID = 3833182540793198128L;
        String docId;
        String etatId;

        public ActionControl(String titre, String docId) {
            super(titre);
            this.docId = docId;
        }

        public void actionPerformed(ActionEvent evt) {
            MainWindow.this.controller(this.docId);
        }
    }

    private final class ActionImport
    extends AbstractAction {
        private static final long serialVersionUID = 3833182540793198128L;
        String docId;
        String etatId;

        public ActionImport(String titre, String docId) {
            super(titre);
            this.docId = docId;
        }

        public void actionPerformed(ActionEvent evt) {
            MainWindow.this.importer(this.docId);
        }
    }

    private static class EmptyStartListener
    implements StartListener {
        private EmptyStartListener() {
        }

        public void notifyMessage(String msg) {
        }

        public void notifyProgress(int progress) {
        }

        public void pushProgress() {
        }

        public void completeProgress() {
        }

        public void setVisible(boolean visible) {
        }
    }
}

