/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.export;

import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.xemelios.export.ExportUndertaker;
import fr.gouv.finances.cp.xemelios.ui.export.DlgSearchConfig;
import fr.gouv.finances.dgfip.utils.xml.dompath.DomPath;
import fr.gouv.finances.dgfip.xemelios.common.config.ChampModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.SimpleElement;
import fr.gouv.finances.dgfip.xemelios.data.DataHandler;
import fr.gouv.finances.dgfip.xemelios.data.DataResultSet;
import fr.gouv.finances.dgfip.xemelios.export.ConfigModel;
import fr.gouv.finances.dgfip.xemelios.export.ExportChampModel;
import fr.gouv.finances.dgfip.xemelios.export.ExportElementModel;
import fr.gouv.finances.dgfip.xemelios.utils.HashSwap;
import fr.gouv.finances.dgfip.xemelios.utils.LongueurMax;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JDialog;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jdesktop.swingworker.SwingWorker;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exporter
extends SwingWorker {
    static Logger logger = Logger.getLogger(Exporter.class);
    private JDialog parentFrame = null;
    private DataResultSet drs = null;
    File fDest;
    private ConfigModel cf = null;
    private DocumentModel dm = null;
    private String etatId;
    private ElementModel em = null;
    double timeStartGenerate = 0.0;
    double timeEndGenerate = 0.0;
    double gapGenerate = 0.0;
    private ExportUndertaker undertaker;
    private Hashtable<String, HashSwap<ExportedElementTag>> exportedElements = new Hashtable();
    private Hashtable<String, Integer> lignesExporteesForElement = new Hashtable();
    String firstSheetId = "";

    protected ExportUndertaker getUndertaker() {
        String undertakerClassName = System.getProperty("xemelios.exporter.class", "fr.gouv.finances.cp.xemelios.export.JxlExporter");
        try {
            Class<?> undertakerClass = Class.forName(undertakerClassName);
            Class[] exporterArgsClass = new Class[]{Exporter.class};
            Object[] exporterArgs = new Object[]{this};
            Constructor<?> constructor = undertakerClass.getConstructor(exporterArgsClass);
            ExportUndertaker undertaker = (ExportUndertaker)constructor.newInstance(exporterArgs);
            return undertaker;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    private void addLine(String el) {
        Integer l = this.lignesExporteesForElement.get(el);
        if (l == null) {
            l = new Integer(0);
        }
        l = new Integer(l + 1);
        this.lignesExporteesForElement.put(el, l);
        this.undertaker.flushLine(el);
    }

    int getLastLine(String el) {
        Integer l = this.lignesExporteesForElement.get(el);
        if (l == null) {
            l = new Integer(0);
        }
        return l;
    }

    public Exporter(File f, DataResultSet drs, DocumentModel dm, String etatId, ElementModel em, ConfigModel cf) {
        this.drs = drs;
        this.fDest = f;
        this.dm = dm;
        this.etatId = etatId;
        this.em = em;
        this.cf = cf;
    }

    protected Object doInBackground() throws Exception {
        this.doExport();
        if (!this.isCancelled()) {
            ((DlgSearchConfig)this.getParentFrame()).showXLS();
        } else {
            ((DlgSearchConfig)this.getParentFrame()).getGlassPane().setVisible(false);
        }
        return null;
    }

    protected void done() {
        super.done();
        this.timeEndGenerate = System.currentTimeMillis();
        this.gapGenerate = this.timeEndGenerate - this.timeStartGenerate;
        System.gc();
        Enumeration<String> cles = this.exportedElements.keys();
        while (cles.hasMoreElements()) {
            String k = cles.nextElement();
            HashSwap<ExportedElementTag> val = this.exportedElements.get(k);
            try {
                val.destruct();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.exportedElements.clear();
        this.exportedElements = null;
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport() {
        try {
            this.undertaker = this.getUndertaker();
            this.timeStartGenerate = System.currentTimeMillis();
            this.undertaker.initialize();
            for (ExportElementModel eem : this.cf.getExportModel().getEnfants()) {
                if (!this.shouldEEMBeExported(eem)) continue;
                this.undertaker.buildSheet(eem);
            }
            int ligne = 2;
            ListeResultatModel lrm = this.drs.getListeResultatModel();
            ListeResultatModel lrmClone = lrm.clone();
            lrmClone.setParent(lrm.getParent());
            String tridefault = lrmClone.getTriDefaut();
            lrmClone.removeAllChamps();
            this.addAllExportableChamps(lrmClone, this.drs.getListeResultatModel().getParent(), tridefault);
            this.drs.setListeResultatModel(lrmClone);
            this.drs.firstPage();
            int page = 0;
            do {
                if (page++ != 0) {
                    this.drs.nextPage();
                }
                while (this.drs.hasNext() && !this.isCancelled()) {
                    DataHandler dh = (DataHandler)this.drs.next();
                    this.exportEM(this.drs.getListeResultatModel().getParent(), dh, this.drs.getListeResultatModel().getParent().getId(), ligne);
                    ++ligne;
                }
            } while (this.drs.hasNextPage() && !this.isCancelled());
            if (!this.isCancelled()) {
                this.undertaker.finish();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exporter Error catched", (Throwable)e);
        }
        finally {
            this.undertaker.close();
        }
    }

    private void addAllExportableChamps(ListeResultatModel l, ElementModel e, String tridefault) throws Exception {
        Vector<String> tri = new Vector<String>();
        for (String s : tridefault.split(",")) {
            tri.add(s);
        }
        for (ChampModel c : e.getListeResultat().getListeChamps()) {
            if (!c.isExportable() && !tri.contains(c.getId())) continue;
            l.addChild((XmlMarshallable)c, ChampModel.QN);
        }
    }

    private void exportEM(ElementModel _em, DataHandler _dh, String sheetId, int _ligne) throws Exception {
        ExportElementModel e;
        ExportElementModel eem = null;
        Iterator i$ = this.cf.getExportModel().getEnfants().iterator();
        while (i$.hasNext() && (eem = this.getEEMFromId(e = (ExportElementModel)i$.next(), _em.getId())) == null) {
        }
        Vector<SimpleElement> parents = this.pushParents(_em, "");
        this.exportParents(parents, _dh);
        int col = 0;
        int oldCol = 0;
        if (this.undertaker.sheetExists(sheetId)) {
            String vId;
            HashSwap h;
            for (int i = parents.size() - 1; i >= 0; --i) {
                col = this.writeCellsOfParent(this.dm.getEtatById(this.etatId).getElementById(parents.get(i).getElement()), parents.get(i).getPseudoCompletePath(), _dh, sheetId, _ligne, col, _ligne <= 2, false);
                this.undertaker.mergeCells(sheetId, oldCol, 0, col - 1, 0);
                oldCol = col;
            }
            boolean firstCol = true;
            for (ExportChampModel ecm : eem.getChamps()) {
                int index;
                if (!ecm.isSelectionne()) continue;
                if (_ligne == 2) {
                    if (firstCol) {
                        this.undertaker.writeCell(sheetId, _em.getTitre(), 0, col, true);
                    }
                    this.undertaker.writeCell(sheetId, ecm.getLibelle(), 1, col, true);
                }
                if ((index = this.getColumnIndex(ecm.getId(), _em)) < 0) {
                    throw new Exception("champ " + ecm.getId() + " not found in " + _em.getConfigXPath());
                }
                this.undertaker.writeCell(sheetId, _dh.getValueAtColumn(index), _ligne, col, false);
                ++col;
                firstCol = false;
            }
            this.undertaker.mergeCells(sheetId, oldCol, 0, col - 1, 0);
            if (this.hasChildrenToExport(this.em)) {
                this.exportEnfants(parents, this.em, _dh);
            }
            if ((h = this.exportedElements.get(_em.getId())) == null) {
                logger.info((Object)"new  HashSwap..");
                h = new HashSwap(ExportedElementTag.class);
                logger.info((Object)"done");
                this.exportedElements.put(_em.getId(), (HashSwap<ExportedElementTag>)h);
            }
            if (!h.containsKey(vId = this.getIdentifiant(_dh, _em))) {
                h.put(vId, (Object)new ExportedElementTag(1));
            }
            this.addLine(sheetId);
        }
    }

    private void exportEnfants(Vector<SimpleElement> parents, ElementModel _em, DataHandler _dh) throws Exception {
        if (_em.getEnfant() != null) {
            for (String s : _em.getEnfant().getEnfants().keySet()) {
                ExportElementModel e;
                ExportElementModel e2;
                SimpleElement enfantToExport = (SimpleElement)_em.getEnfant().getEnfants().get(s);
                ExportElementModel eem = null;
                Iterator i$ = this.cf.getExportModel().getEnfants().iterator();
                while (i$.hasNext() && (eem = this.getEEMFromId(e2 = (ExportElementModel)i$.next(), s)) == null) {
                }
                ExportElementModel eemP = null;
                Iterator i$2 = this.cf.getExportModel().getEnfants().iterator();
                while (i$2.hasNext() && (eemP = this.getEEMFromId(e = (ExportElementModel)i$2.next(), _em.getId())) == null) {
                }
                if (!this.shouldEEMBeExported(eem)) continue;
                enfantToExport.setPseudoCompletePath("./" + enfantToExport.getPath());
                Vector<Object> parentsValues = this.getParentsValues(parents, _dh);
                for (ExportChampModel ecm : eemP.getChamps()) {
                    if (!ecm.isIdentifiant()) continue;
                    parentsValues.add(_dh.getValueAtColumn(this.getColumnIndex(ecm.getId(), _em)));
                }
                this.exportEnfant(parentsValues, enfantToExport.getPseudoCompletePath(), enfantToExport, _dh.getElement(), enfantToExport.getElement(), _dh);
            }
        }
    }

    private Vector<Object> getParentsValues(Vector<SimpleElement> parents, DataHandler _dh) throws Exception {
        Vector<Object> ret = new Vector<Object>();
        for (int p = parents.size() - 1; p >= 0; --p) {
            ret.addAll(this.getParentValues(parents.get(p), _dh));
        }
        return ret;
    }

    private Vector<Object> getParentValues(SimpleElement parent, DataHandler _dh) throws Exception {
        XPathFactory xpf;
        Vector<Object> ret = new Vector<Object>();
        ElementModel em = this.getEMFromId(parent.getElement());
        try {
            xpf = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        }
        catch (Throwable t) {
            xpf = XPathFactory.newInstance();
        }
        XPath xp = xpf.newXPath();
        xp.setNamespaceContext((NamespaceContext)this.dm.getNamespaces());
        Node n = (Node)xp.evaluate(parent.getPseudoCompletePath(), _dh.getElement(), XPathConstants.NODE);
        for (ChampModel cm : em.getListeResultat().getListeChamps()) {
            if (!cm.isIdentifiant()) continue;
            DomPath dp = new DomPath(cm.getPath().getPath(), (NamespaceContext)this.dm.getNamespaces());
            ret.add(dp.getValue(n, false));
        }
        return ret;
    }

    private Vector<Object> getParentId(ElementModel parent, Object rootElement) throws Exception {
        Vector<Object> ret = new Vector<Object>();
        for (ChampModel cm : parent.getListeResultat().getListeChamps()) {
            if (!cm.isIdentifiant()) continue;
            DomPath dp = new DomPath(cm.getPath().getPath(), (NamespaceContext)this.dm.getNamespaces());
            ret.add(dp.getValue((Node)rootElement, false));
        }
        return ret;
    }

    private void exportEnfant(Vector<Object> parentsValues, String pathToEnfant, SimpleElement enfantToExport, Object rootElement, String sheetId, DataHandler _dh) throws Exception {
        int ligne = this.undertaker.getLastLineLastSheet(sheetId);
        Vector<Node> nodes = this.writeCellsOfEnfant(parentsValues, this.getEMFromId(enfantToExport.getElement()), rootElement, pathToEnfant, sheetId, ligne, ligne <= 2);
        ElementModel e = this.getEMFromId(enfantToExport.getElement());
        if (e.getEnfant() != null) {
            for (String s : e.getEnfant().getEnfants().keySet()) {
                ExportElementModel m;
                SimpleElement se = (SimpleElement)e.getEnfant().getEnfants().get(s);
                ExportElementModel eem = null;
                Iterator<Object> i$ = this.cf.getExportModel().getEnfants().iterator();
                while (i$.hasNext() && (eem = this.getEEMFromId(m = (ExportElementModel)i$.next(), se.getElement())) == null) {
                }
                if (!this.shouldEEMBeExported(eem)) break;
                for (Node n : nodes) {
                    Vector<Object> newParentsValues = new Vector<Object>();
                    newParentsValues.addAll(parentsValues);
                    newParentsValues.addAll(this.getParentId(this.getEMFromId(enfantToExport.getElement()), n));
                    this.exportEnfant(newParentsValues, se.getPath(), se, n, se.getElement(), _dh);
                }
            }
        }
    }

    private void exportParents(Vector<SimpleElement> parents, DataHandler _dh) throws Exception {
        for (int i = 0; i < parents.size(); ++i) {
            SimpleElement parentToExport = parents.get(i);
            if (!this.undertaker.sheetExists(parentToExport.getElement())) continue;
            int ligne = this.getLastLine(parentToExport.getElement());
            this.exportParent(parentToExport, parents, i, parentToExport.getElement(), _dh, ligne, true);
        }
    }

    private int exportParent(SimpleElement parentToExport, Vector<SimpleElement> parents, int indInParents, String sheetId, DataHandler _dh, int ligne, boolean doCheckMAJ) throws Exception {
        ElementModel em = this.getEMFromId(parentToExport.getElement());
        String parentPath = parentToExport.getPseudoCompletePath();
        if (doCheckMAJ && this.isExporte(parentToExport.getElement(), this.getIdentifiant(_dh, parentPath, em))) {
            return 0;
        }
        int col = 0;
        if (indInParents == parents.size() - 1) {
            if (ligne < 2) {
                // empty if block
            }
            col += this.writeCellsOfParent(em, parentToExport.getPseudoCompletePath(), _dh, sheetId, ligne, col, ligne <= 2, this.firstSheetId.equals(sheetId));
            if (doCheckMAJ) {
                this.majExportes(parentToExport.getElement(), _dh, parentPath, em);
            }
        } else {
            col += this.exportParent(parents.get(indInParents + 1), parents, indInParents + 1, sheetId, _dh, ligne, false);
            if (indInParents == parents.size() - 1) {
                if (ligne < 2) {
                    // empty if block
                }
                col += this.writeCellsOfParent(em, parentToExport.getPseudoCompletePath(), _dh, sheetId, ligne, col, ligne <= 2, true);
                if (doCheckMAJ) {
                    this.majExportes(parentToExport.getElement(), _dh, parentPath, em);
                }
            }
        }
        return col;
    }

    private boolean isExporte(String idColl, String id) {
        boolean ret = false;
        HashSwap<ExportedElementTag> h = this.exportedElements.get(idColl);
        if (h == null) {
            return false;
        }
        try {
            if (h.containsKey(id)) {
                ret = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private void majExportes(String id, DataHandler _dh, String parentPath, ElementModel em) throws Exception {
        String vId;
        HashSwap h = this.exportedElements.get(id);
        if (h == null) {
            logger.info((Object)"new  HashSwap..");
            h = new HashSwap(ExportedElementTag.class);
            logger.info((Object)"done");
            this.exportedElements.put(id, (HashSwap<ExportedElementTag>)h);
        }
        if (!h.containsKey(vId = this.getIdentifiant(_dh, parentPath, em))) {
            h.put(vId, (Object)new ExportedElementTag(1));
        }
    }

    private Vector<SimpleElement> pushParents(ElementModel _em, String parentPath) {
        Vector<SimpleElement> ret = new Vector<SimpleElement>();
        SimpleElement parent = _em.getSimpleParent();
        if (parent != null) {
            parent.setPseudoCompletePath(parent.getPath() + (!parentPath.equals("") ? "/" + parentPath : ""));
            ret.add(parent);
            ret.addAll(this.pushParents(this.dm.getEtatById(this.etatId).getElementById(parent.getElement()), parent.getPseudoCompletePath()));
        }
        return ret;
    }

    private int writeCellsOfParent(ElementModel parent, String parentPath, DataHandler _dh, String sheetId, int _ligne, int _col, boolean firstLine, boolean completeLine) throws Exception {
        XPathFactory xpf;
        int oldCol = _col;
        try {
            xpf = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        }
        catch (Throwable t) {
            xpf = XPathFactory.newInstance();
        }
        XPath xp = xpf.newXPath();
        xp.setNamespaceContext((NamespaceContext)this.dm.getNamespaces());
        Node n = (Node)xp.evaluate(parentPath, _dh.getElement(), XPathConstants.NODE);
        boolean firstCol = true;
        for (ChampModel cm : parent.getListeResultat().getListeChamps()) {
            if (!cm.isIdentifiant()) continue;
            DomPath dp = new DomPath(cm.getPath().getPath(), (NamespaceContext)this.dm.getNamespaces());
            Object o = dp.getValue(n, false);
            if (firstLine) {
                if (firstCol) {
                    this.undertaker.writeCell(sheetId, parent.getTitre(), 0, _col, true);
                }
                this.undertaker.writeCell(sheetId, cm.getLibelle(), 1, _col, true);
            }
            if (_ligne < 2) {
                _ligne += 2;
            }
            Comparable value = cm.getValueOf(o);
            this.undertaker.writeCell(sheetId, value, _ligne, _col++, false);
            firstCol = false;
        }
        if (completeLine) {
            this.addLine(sheetId);
        }
        if (firstLine) {
            this.undertaker.mergeCells(sheetId, oldCol, 0, _col - 1, 0);
        }
        return _col;
    }

    private Vector<Node> writeCellsOfEnfant(Vector<Object> parentsValues, ElementModel enfant, Object rootElement, String enfantPath, String sheetId, int _ligne, boolean firstLine) throws Exception {
        Vector<Node> ret;
        block26: {
            int maxCol;
            int macolonne;
            int maligne;
            boolean firstCol;
            ExportElementModel eem;
            Object xpathRet;
            block25: {
                ExportElementModel e;
                XPathFactory xpf;
                ret = new Vector<Node>();
                try {
                    xpf = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
                }
                catch (Throwable t) {
                    xpf = XPathFactory.newInstance();
                }
                XPath xp = xpf.newXPath();
                xp.setNamespaceContext((NamespaceContext)this.dm.getNamespaces());
                xpathRet = xp.evaluate(enfantPath, rootElement, XPathConstants.NODESET);
                eem = null;
                Iterator i$ = this.cf.getExportModel().getEnfants().iterator();
                while (i$.hasNext() && (eem = this.getEEMFromId(e = (ExportElementModel)i$.next(), enfant.getId())) == null) {
                }
                if (firstLine) {
                    Stack<ExportElementModel> s = new Stack<ExportElementModel>();
                    ExportElementModel tmp = eem;
                    while (true) {
                        ExportElementModel p;
                        tmp = p = tmp.getParent();
                        if (p == null) break;
                        s.push(p);
                    }
                    ExportElementModel ptmp = null;
                    int oldColTitre = 0;
                    int colTitre = 0;
                    while (!s.empty()) {
                        ptmp = (ExportElementModel)s.pop();
                        oldColTitre = colTitre;
                        this.undertaker.writeCell(sheetId, ptmp.getLibelle(), 0, colTitre, true);
                        for (ExportChampModel ecm : ptmp.getChamps()) {
                            if (!ecm.isIdentifiant()) continue;
                            this.undertaker.writeCell(sheetId, ecm.getLibelle(), 1, colTitre++, true);
                        }
                        this.undertaker.mergeCells(sheetId, oldColTitre, 0, colTitre - 1, 0);
                    }
                }
                firstCol = true;
                maligne = _ligne;
                macolonne = 0;
                maxCol = 0;
                if (!(xpathRet instanceof NodeList)) break block25;
                NodeList nodeListe = (NodeList)xpathRet;
                for (int n = 0; n < nodeListe.getLength(); ++n) {
                    int col = 0;
                    for (int p = 0; p < parentsValues.size(); ++p) {
                        this.undertaker.writeCell(sheetId, parentsValues.get(p), maligne, col++, false);
                    }
                    macolonne = col;
                    Node node = nodeListe.item(n);
                    ret.add(node);
                    for (ExportChampModel ecm : eem.getChamps()) {
                        if (!ecm.isSelectionne()) continue;
                        DomPath dp = new DomPath(((ChampModel)enfant.getListeResultat().getChamps().get(ecm.getId())).getPath().getPath(), (NamespaceContext)this.dm.getNamespaces());
                        Object o = "";
                        try {
                            o = dp.getValue(node, false);
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        if (firstLine) {
                            if (firstCol) {
                                this.undertaker.writeCell(sheetId, enfant.getTitre(), 0, macolonne, true);
                            }
                            this.undertaker.writeCell(sheetId, ecm.getLibelle(), 1, macolonne, true);
                        }
                        try {
                            Comparable computed = ((ChampModel)enfant.getListeResultat().getChamps().get(ecm.getId())).getValueOf(o);
                            this.undertaker.writeCell(sheetId, computed, maligne, macolonne++, false);
                        }
                        catch (Exception ex) {
                            logger.error((Object)("while exporting " + enfant.getId() + "." + ecm.getId()));
                        }
                        firstCol = false;
                    }
                    this.addLine(sheetId);
                    ++maligne;
                    maxCol = macolonne;
                    macolonne = col;
                    if (!firstLine) continue;
                    firstLine = false;
                    this.undertaker.mergeCells(sheetId, col, 0, maxCol - 1, 0);
                }
                break block26;
            }
            if (!(xpathRet instanceof List)) break block26;
            List l = (List)xpathRet;
            Iterator it = l.iterator();
            while (it.hasNext()) {
                int col = 0;
                for (int p = 0; p < parentsValues.size(); ++p) {
                    this.undertaker.writeCell(sheetId, parentsValues.get(p), maligne, col++, false);
                }
                macolonne = col;
                Node node = (Node)it.next();
                ret.add(node);
                for (ExportChampModel ecm : eem.getChamps()) {
                    if (!ecm.isSelectionne()) continue;
                    DomPath dp = new DomPath(((ChampModel)enfant.getListeResultat().getChamps().get(ecm.getId())).getPath().getPath(), (NamespaceContext)this.dm.getNamespaces());
                    Object o = "";
                    try {
                        o = dp.getValue(node, false);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (firstLine) {
                        if (firstCol) {
                            this.undertaker.writeCell(sheetId, enfant.getTitre(), 0, macolonne, true);
                        }
                        this.undertaker.writeCell(sheetId, ecm.getLibelle(), 1, macolonne, true);
                    }
                    try {
                        Comparable computed = ((ChampModel)enfant.getListeResultat().getChamps().get(ecm.getId())).getValueOf(o);
                        this.undertaker.writeCell(sheetId, computed, maligne, macolonne++, false);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("while exporting " + enfant.getId() + "." + ecm.getId()));
                    }
                    firstCol = false;
                }
                this.addLine(sheetId);
                ++maligne;
                maxCol = macolonne;
                macolonne = col;
                if (!firstLine) continue;
                firstLine = false;
                this.undertaker.mergeCells(sheetId, col, 0, maxCol - 1, 0);
            }
        }
        return ret;
    }

    private String getIdentifiant(DataHandler _dh, String parentPath, ElementModel _em) throws Exception {
        XPathFactory xpf;
        String ret = "";
        try {
            xpf = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        }
        catch (Throwable t) {
            xpf = XPathFactory.newInstance();
        }
        XPath xp = xpf.newXPath();
        xp.setNamespaceContext((NamespaceContext)this.dm.getNamespaces());
        Node node = (Node)xp.evaluate(parentPath, _dh.getElement(), XPathConstants.NODE);
        for (ChampModel cm : _em.getListeResultat().getListeChamps()) {
            DomPath dp;
            Object o;
            if (!cm.isIdentifiant() || (o = (dp = new DomPath(cm.getPath().getPath(), (NamespaceContext)this.dm.getNamespaces())).getValue(node, false)) == null) continue;
            if (ret.length() > 0) {
                ret = ret + "-";
            }
            ret = ret + String.valueOf(o);
        }
        return ret;
    }

    private String getIdentifiant(DataHandler _dh, ElementModel _em) throws Exception {
        String ret = "";
        for (ChampModel cm : _em.getListeResultat().getListeChamps()) {
            Object o;
            if (!cm.isIdentifiant() || (o = _dh.getValueAtColumn(this.getColumnIndex(cm.getId(), _em))) == null) continue;
            if (ret.length() > 0) {
                ret = ret + "-";
            }
            ret = ret + String.valueOf(o);
        }
        return ret;
    }

    private ExportElementModel getEEMFromId(ExportElementModel _eem, String id) {
        ExportElementModel ret = null;
        if (_eem.getId().equals(id)) {
            ret = _eem;
        } else {
            ExportElementModel e;
            Iterator i$ = _eem.getEnfants().iterator();
            while (i$.hasNext() && (ret = this.getEEMFromId(e = (ExportElementModel)i$.next(), id)) == null) {
            }
        }
        return ret;
    }

    ElementModel getEMFromId(String id) {
        return this.dm.getEtatById(this.etatId).getElementById(id);
    }

    private int getColumnIndex(String id, ElementModel em) {
        int ret = -1;
        int j = 0;
        Vector<String> tri = new Vector<String>();
        String tridefault = em.getListeResultat().getTriDefaut();
        for (String s : tridefault.split(",")) {
            tri.add(s);
        }
        for (ChampModel cm : em.getListeResultat().getListeChamps()) {
            if (!cm.isExportable() && !tri.contains(cm.getId())) continue;
            if (id.equals(cm.getId())) {
                ret = j;
                break;
            }
            ++j;
        }
        return ret;
    }

    private boolean shouldEEMBeExported(ExportElementModel _eem) {
        if (_eem != null) {
            for (ExportChampModel ecm : _eem.getChamps()) {
                if (!ecm.isSelectionne()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasChildrenToExport(ElementModel _em) {
        if (_em.getEnfant() == null) {
            return false;
        }
        for (String s : _em.getEnfant().getEnfants().keySet()) {
            ExportElementModel e;
            SimpleElement se = (SimpleElement)_em.getEnfant().getEnfants().get(s);
            ExportElementModel eem = null;
            Iterator i$ = this.cf.getExportModel().getEnfants().iterator();
            while (i$.hasNext() && (eem = this.getEEMFromId(e = (ExportElementModel)i$.next(), se.getElement())) == null) {
            }
            if (!this.shouldEEMBeExported(eem)) continue;
            return true;
        }
        return false;
    }

    public JDialog getParentFrame() {
        return this.parentFrame;
    }

    public void setParentFrame(JDialog parentFrame) {
        this.parentFrame = parentFrame;
    }

    public class ExportedElementTag {
        @LongueurMax(value=1)
        public int dummy;

        public ExportedElementTag(int i) {
            this.dummy = i;
        }
    }
}

