/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.export;

import fr.gouv.finances.cp.utils.StringUtilities;
import fr.gouv.finances.cp.xemelios.export.ExportUndertaker;
import fr.gouv.finances.cp.xemelios.export.Exporter;
import fr.gouv.finances.dgfip.utils.Amount;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.export.ExportElementModel;
import fr.gouv.finances.dgfip.xemelios.utils.CSVWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CsvExporter
extends ExportUndertaker {
    private static final Logger logger = Logger.getLogger(CsvExporter.class);
    private static final int MAX_ROWS_PER_SHEET = 65000;
    private Hashtable<String, Vector<CsvSheet>> sheets = new Hashtable();
    private Exporter caller;
    private String workbookPrefix = null;
    private SimpleDateFormat df = new SimpleDateFormat(System.getProperty("xemelios.date.format", "dd/MM/yyyy"));

    public CsvExporter(Exporter caller) {
        this.caller = caller;
    }

    void initialize() throws Exception {
        FileWriter xl = new FileWriter(this.caller.fDest);
        xl.close();
        this.workbookPrefix = StringUtilities.removeFileNameSuffix(this.caller.fDest.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recopieFichier(String src, String dst, boolean overwrite) {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            in = new FileInputStream(src).getChannel();
            out = new FileOutputStream(dst).getChannel();
            in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    void buildSheet(ExportElementModel eem) throws Exception {
        Vector<CsvSheet> v = this.sheets.get(eem.getId());
        if (v == null) {
            v = new Vector();
        }
        this.sheets.put(eem.getId(), v);
        String fileName = this.workbookPrefix + "_" + eem.getLibelle();
        CsvSheet sheet = new CsvSheet();
        sheet.open(fileName);
        v.add(sheet);
        for (ExportElementModel e : eem.getEnfants()) {
            this.buildSheet(e);
        }
        this.caller.firstSheetId = eem.getId();
    }

    void finish() throws Exception {
    }

    void close() {
        Enumeration<String> elems = this.sheets.keys();
        while (elems.hasMoreElements()) {
            String k = elems.nextElement();
            Vector<CsvSheet> v = this.sheets.get(k);
            for (CsvSheet s : v) {
                s.close();
            }
        }
    }

    boolean sheetExists(String sheetId) {
        Vector<CsvSheet> v = this.sheets.get(sheetId);
        return v != null;
    }

    int getLastLineLastSheet(String sheetId) {
        CsvSheet ws = this.getLastSheet(sheetId);
        return ws.getRows() < 2 ? 2 : ws.getRows();
    }

    void writeCell(String sheetId, Object o, int line, int col, boolean bypassLineRenum) throws Exception {
        int newline = 0;
        if (bypassLineRenum) {
            newline = line;
        } else {
            int _ligne = this.caller.getLastLine(sheetId);
            if (_ligne >= 65000 * this.sheets.get(sheetId).size()) {
                this.splitSheet(sheetId);
            }
            newline = _ligne;
            newline = _ligne % 65000 + 2;
        }
        CsvSheet sheet = this.getLastSheet(sheetId);
        String s = this.formatted(o, line);
        if (line == 0) {
            sheet.addTitle(s, col);
        } else if (line == 1) {
            sheet.addName(s, col);
        } else {
            sheet.addEntry(s, col);
        }
    }

    void mergeCells(String sheetId, int col1, int row1, int col2, int row2) {
    }

    void flushLine(String sheetId) {
        CsvSheet _ws = this.getLastSheet(sheetId);
        _ws.flushLine();
    }

    protected String formatted(Object o, Integer line) {
        String rawStr;
        if (o instanceof Integer) {
            rawStr = ((Integer)o).toString();
        } else if (o instanceof Float) {
            rawStr = ((Float)o).toString();
        } else if (o instanceof Date) {
            rawStr = this.df.format(o);
        } else if (o instanceof Amount) {
            Double d = new Double(((Amount)o).doubleValue());
            rawStr = d.toString();
        } else {
            rawStr = o instanceof String ? (String)o : (String)o;
        }
        return rawStr;
    }

    protected int afterSheet(String id) {
        return 1;
    }

    protected CsvSheet getLastSheet(String sheetId) {
        Vector<CsvSheet> v = this.sheets.get(sheetId);
        if (v != null) {
            return v.get(v.size() - 1);
        }
        return null;
    }

    protected CsvSheet getRootSheetBefore(String id) {
        CsvSheet ret = null;
        ElementModel e = this.caller.getEMFromId(id);
        if (e.getSimpleParent() != null) {
            String pName = e.getSimpleParent().getElement();
            ret = this.sheets.get(pName).get(0);
        }
        return ret;
    }

    protected CsvSheet splitSheet(String id) {
        Vector<CsvSheet> v = this.sheets.get(id);
        CsvSheet wsRef = v.get(0);
        CsvSheet otherRef = this.getLastSheet(id);
        wsRef.close();
        CsvSheet ws = new CsvSheet();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(2);
        nf.setMaximumIntegerDigits(3);
        String sb = nf.format(v.size());
        String fname = wsRef.getName() + "_" + sb;
        ws.open(fname);
        this.addRefInMainSheet(fname, false);
        ws.titles = wsRef.titles;
        ws.names = wsRef.names;
        ws.maxTitle = wsRef.maxTitle;
        ws.maxName = wsRef.maxName;
        ws.flushTitles();
        ws.flushNames();
        v.add(ws);
        return ws;
    }

    void addRefInMainSheet(String libelle, boolean addPrefix) {
        String fileName = addPrefix ? this.workbookPrefix + "_" + libelle + ".csv" : libelle + ".csv";
        String href = "<A HREF=\"file:///" + fileName + "\">" + libelle + "</A>";
    }

    protected class CsvSheet {
        String name;
        CSVWriter writer;
        String[] titles;
        String[] names;
        String[] entries;
        int curTitle;
        int curName;
        int curEntry;
        int colCount;
        int rowCount;
        int maxTitle;
        int maxName;
        int maxEntry;
        boolean titlesFlushed;
        boolean namesFlushed;

        protected CsvSheet() {
        }

        void open(String fname) {
            try {
                FileWriter out = new FileWriter(fname + ".csv");
                this.writer = new CSVWriter((Writer)out);
            }
            catch (IOException e) {
                logger.error((Object)("HtmlSheet.open(" + fname + ")"), (Throwable)e);
            }
            this.name = fname;
            this.titles = new String[100];
            this.names = new String[100];
            this.entries = new String[100];
            this.maxTitle = 0;
            this.maxName = 0;
            this.maxEntry = 0;
            this.rowCount = 0;
            this.titlesFlushed = false;
            this.namesFlushed = false;
        }

        void close() {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    logger.error((Object)"HtmlSheet.close()", (Throwable)e);
                }
                this.writer = null;
            }
        }

        String getName() {
            return this.name;
        }

        int getRows() {
            return this.rowCount;
        }

        void addTitle(String s, int col) {
            if (!this.titlesFlushed) {
                if (col >= this.titles.length || this.maxTitle >= this.titles.length) {
                    int oldlength = this.titles.length;
                    int newlength = oldlength + oldlength / 2;
                    String[] tm = new String[newlength];
                    for (int i = 0; i < oldlength; ++i) {
                        tm[i] = this.titles[i];
                    }
                    this.titles = tm;
                }
                while (this.maxTitle + 1 < col) {
                    ++this.maxTitle;
                    this.titles[this.maxTitle] = CsvExporter.this.formatted("", 0);
                }
                this.titles[col] = s;
                if (col > this.maxTitle) {
                    this.maxTitle = col;
                }
            }
        }

        void addName(String s, int col) {
            if (!this.namesFlushed) {
                if (col >= this.names.length || this.maxName >= this.names.length) {
                    int oldlength = this.names.length;
                    int newlength = oldlength + oldlength / 2;
                    String[] tm = new String[newlength];
                    for (int i = 0; i < oldlength; ++i) {
                        tm[i] = this.names[i];
                    }
                    this.names = tm;
                }
                while (this.maxName + 1 < col) {
                    ++this.maxName;
                    this.names[this.maxName] = CsvExporter.this.formatted("", 1);
                }
                this.names[col] = s;
                if (col > this.maxName) {
                    this.maxName = col;
                }
            }
        }

        void addEntry(String s, int col) {
            if (col >= this.entries.length || this.maxEntry >= this.entries.length) {
                int oldlength = this.entries.length;
                int newlength = oldlength + oldlength / 2;
                String[] tm = new String[newlength];
                for (int i = 0; i < oldlength; ++i) {
                    tm[i] = this.entries[i];
                }
                this.entries = tm;
            }
            while (this.maxEntry + 1 < col) {
                ++this.maxEntry;
                this.entries[this.maxEntry] = CsvExporter.this.formatted("", 999);
            }
            this.entries[col] = s;
            if (col > this.maxEntry) {
                this.maxEntry = col;
            }
        }

        void mergeCells(int col1, int row1, int col2, int row2) {
        }

        void flushTitles() {
            this.writer.writeNext(this.titles, Integer.valueOf(this.maxTitle));
            this.titlesFlushed = true;
            ++this.rowCount;
        }

        void flushNames() {
            this.writer.writeNext(this.names, Integer.valueOf(this.maxName));
            this.namesFlushed = true;
            ++this.rowCount;
        }

        void flushLine() {
            if (!this.titlesFlushed) {
                this.flushTitles();
            }
            if (!this.namesFlushed) {
                this.flushNames();
            }
            this.writer.writeNext(this.entries, Integer.valueOf(this.maxEntry));
            this.maxEntry = 0;
            ++this.rowCount;
        }
    }
}

