/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.processors.impl;

import fr.gouv.finances.cp.xemelios.controls.processors.impl.IdGenerator;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class TstampIPUniqueId
implements IdGenerator {
    private static long lastTime = System.currentTimeMillis();
    private static int count = 0;
    private String ip;

    public TstampIPUniqueId() {
        if (this.ip == null) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                byte[] ipAddr = addr.getAddress();
                StringBuffer sb = new StringBuffer();
                for (byte i : ipAddr) {
                    sb.append(Byte.toString(i)).append(".");
                }
                this.ip = sb.toString();
                this.ip = this.ip.substring(0, this.ip.length() - 1);
            }
            catch (UnknownHostException e) {
                this.ip = "127.0.0.1";
            }
        }
    }

    public String generateId() {
        long now = System.currentTimeMillis();
        if (now == lastTime) {
            ++count;
        } else {
            lastTime = now;
            count = 0;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.ip).append("-").append(Long.toString(now)).append("-").append(Integer.toBinaryString(count));
        return sb.toString();
    }
}

