/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.models;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.controls.models.DocumentControlModel;
import fr.gouv.finances.cp.xemelios.controls.models.MessageRapportModel;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlsModel
implements XmlMarshallable {
    public static final transient String TAG = "controls";
    public static final transient QName QN = new QName("controls");
    private Vector<DocumentControlModel> documents = new Vector();
    private Hashtable<String, DocumentControlModel> hDocuments = new Hashtable();
    private MessageRapportModel message;

    public ControlsModel(QName tag) {
    }

    public void addCharacterData(String cData) throws SAXException {
        throw new SAXException("pas de CDATA attendu");
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (DocumentControlModel.QN.equals(tagName)) {
            DocumentControlModel dcm = (DocumentControlModel)child;
            if (this.hDocuments.containsKey(dcm.getDocumentId())) {
                DocumentControlModel old = this.hDocuments.get(dcm.getDocumentId());
                this.documents.remove(old);
                this.hDocuments.remove(old.getDocumentId());
            }
            this.documents.add(dcm);
            this.hDocuments.put(dcm.getDocumentId(), dcm);
        } else if (MessageRapportModel.QN.equals(tagName)) {
            this.message = (MessageRapportModel)child;
        } else {
            throw new SAXException(tagName + ": tag non attendu");
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        if (this.message != null) {
            this.message.marshall(output);
        }
        for (DocumentControlModel dm : this.documents) {
            dm.marshall(output);
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
        for (DocumentControlModel dm : this.documents) {
            dm.validate();
        }
    }

    public Vector<DocumentControlModel> getDocuments() {
        return this.documents;
    }

    public DocumentControlModel getDocumentById(String docId) {
        return this.hDocuments.get(docId);
    }

    public ControlsModel clone() {
        ControlsModel dom = new ControlsModel(QN);
        for (DocumentControlModel dm : this.documents) {
            try {
                dom.addChild(dm, DocumentControlModel.QN);
            }
            catch (Exception ex) {}
        }
        try {
            if (this.message != null) {
                dom.addChild(this.message, MessageRapportModel.QN);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return dom;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        if (DocumentControlModel.QN.equals(qName)) {
            return this.hDocuments.get(atts.getValue("id"));
        }
        if (MessageRapportModel.QN.equals(qName)) {
            return this.message;
        }
        return null;
    }

    public QName getQName() {
        return QN;
    }

    public MessageRapportModel getMessage() {
        return this.message;
    }

    public void setMessage(MessageRapportModel message) {
        this.message = message;
    }
}

