/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls;

import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.dgfip.utils.Pair;
import java.io.IOException;

public class RapportWriter {
    private XmlOutputter rapport;

    public RapportWriter(XmlOutputter rapportxml) {
        this.rapport = rapportxml;
        this.startRapport();
    }

    private void startRapport() {
        this.rapport.startTag("ano:DocumentRapport");
        this.rapport.addAttribute("xmlns:ano", "http://projets.admisource.gouv.fr/xemelios/namespaces#anomally");
    }

    public void endRapport() throws IOException {
        this.rapport.endTag("ano:DocumentRapport");
        this.rapport.close();
    }

    public void writeElement(String name, Pair ... attrs) {
        this.rapport.startTag("ano:" + name);
        if (attrs.length != 0) {
            for (Pair p : attrs) {
                this.rapport.addAttribute("ano:" + p.key, p.libelle);
            }
        }
        this.rapport.endTag("ano:" + name);
    }

    public void writeData(String data) {
        this.rapport.addCharacterData(data);
    }

    public void openElement(String name, Pair ... attrs) {
        this.rapport.startTag("ano:" + name);
        if (attrs.length != 0) {
            for (Pair p : attrs) {
                this.rapport.addAttribute(p.libelle, p.key);
            }
        }
    }

    public void openElement(String name) {
        this.rapport.startTag("ano:" + name);
    }

    public void closeElement(String name) {
        this.rapport.endTag("ano:" + name);
    }

    public XmlOutputter getWriter() {
        return this.rapport;
    }
}

