/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom4j;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom4j.DocumentWrapper;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SiblingCountingNode;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;

public class NodeWrapper
implements NodeInfo,
VirtualNode,
SiblingCountingNode {
    protected Object node;
    protected short nodeKind;
    private NodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;

    protected NodeWrapper(Object object, NodeWrapper nodeWrapper, int n) {
        this.node = object;
        this.parent = nodeWrapper;
        this.index = n;
    }

    protected NodeWrapper makeWrapper(Object object, DocumentWrapper documentWrapper) {
        return this.makeWrapper(object, documentWrapper, null, -1);
    }

    protected NodeWrapper makeWrapper(Object object, DocumentWrapper documentWrapper, NodeWrapper nodeWrapper, int n) {
        NodeWrapper nodeWrapper2;
        if (object instanceof Document) {
            return documentWrapper;
        }
        if (object instanceof Element) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeKind = 1;
        } else if (object instanceof Attribute) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeKind = (short)2;
        } else if (object instanceof String || object instanceof Text || object instanceof CDATA) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeKind = (short)3;
        } else if (object instanceof Comment) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeKind = (short)8;
        } else if (object instanceof ProcessingInstruction) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeKind = (short)7;
        } else if (object instanceof Namespace) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeKind = (short)13;
        } else {
            throw new IllegalArgumentException("Bad node type in dom4j! " + object.getClass() + " instance " + object.toString());
        }
        nodeWrapper2.docWrapper = documentWrapper;
        return nodeWrapper2;
    }

    public Object getUnderlyingNode() {
        return this.node;
    }

    public NamePool getNamePool() {
        return this.docWrapper.getNamePool();
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator((Item)((AtomicValue)this.atomize()));
    }

    public Value atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    public int getTypeAnnotation() {
        if (this.getNodeKind() == 2) {
            return 642;
        }
        return 641;
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof NodeWrapper)) {
            return false;
        }
        NodeWrapper nodeWrapper = (NodeWrapper)nodeInfo;
        return this.node.equals(nodeWrapper.node);
    }

    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    public void setSystemId(String string) {
        this.docWrapper.baseURI = string;
    }

    public String getBaseURI() {
        if (this.getNodeKind() == 13) {
            return null;
        }
        NodeWrapper nodeWrapper = this;
        if (this.getNodeKind() != 1) {
            nodeWrapper = nodeWrapper.getParent();
        }
        while (nodeWrapper != null) {
            String string = nodeWrapper.getAttributeValue(385);
            if (string != null) {
                return string;
            }
            nodeWrapper = nodeWrapper.getParent();
        }
        return this.docWrapper.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        return Navigator.compareOrder((SiblingCountingNode)this, (SiblingCountingNode)((SiblingCountingNode)nodeInfo));
    }

    public String getStringValue() {
        return NodeWrapper.getStringValue(this.node);
    }

    public CharSequence getStringValueCS() {
        return NodeWrapper.getStringValue(this.node);
    }

    private static String getStringValue(Object object) {
        if (object instanceof Document) {
            return ((Document)object).getStringValue();
        }
        if (object instanceof Element) {
            return ((Element)object).getStringValue();
        }
        if (object instanceof Attribute) {
            return ((Attribute)object).getValue();
        }
        if (object instanceof Text) {
            return ((Text)object).getText();
        }
        if (object instanceof CDATA) {
            return ((CDATA)object).getText();
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Comment) {
            return ((Comment)object).getText();
        }
        if (object instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)object).getStringValue();
        }
        if (object instanceof Namespace) {
            return ((Namespace)object).getURI();
        }
        return "";
    }

    public int getNameCode() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: 
            case 13: {
                return this.docWrapper.getNamePool().allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
            }
        }
        return -1;
    }

    public int getFingerprint() {
        return this.getNameCode() & 0xFFFFF;
    }

    public String getLocalPart() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getName();
            }
            case 2: {
                return ((Attribute)this.node).getName();
            }
            case 3: 
            case 8: 
            case 9: {
                return "";
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
            case 13: {
                return ((Namespace)this.node).getPrefix();
            }
        }
        return null;
    }

    public String getPrefix() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespacePrefix();
            }
            case 2: {
                return ((Attribute)this.node).getNamespacePrefix();
            }
        }
        return "";
    }

    public String getURI() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespaceURI();
            }
            case 2: {
                return ((Attribute)this.node).getNamespaceURI();
            }
        }
        return "";
    }

    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getQualifiedName();
            }
            case 2: {
                return ((Attribute)this.node).getQualifiedName();
            }
            case 7: 
            case 13: {
                return this.getLocalPart();
            }
        }
        return "";
    }

    public NodeInfo getParent() {
        if (this.parent == null) {
            if (this.node instanceof Element) {
                this.parent = ((Element)this.node).isRootElement() ? this.makeWrapper(((Element)this.node).getDocument(), this.docWrapper) : this.makeWrapper(((Element)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Text) {
                this.parent = this.makeWrapper(((Text)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof CDATA) {
                this.parent = this.makeWrapper(((CDATA)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Comment) {
                this.parent = this.makeWrapper(((Comment)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof ProcessingInstruction) {
                this.parent = this.makeWrapper(((ProcessingInstruction)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Attribute) {
                this.parent = this.makeWrapper(((Attribute)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Document) {
                this.parent = null;
            } else {
                if (this.node instanceof Namespace) {
                    throw new UnsupportedOperationException("Cannot find parent of DOM4J namespace node");
                }
                throw new IllegalStateException("Unknown DOM4J node type " + this.node.getClass());
            }
        }
        return this.parent;
    }

    public int getSiblingPosition() {
        if (this.index == -1) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator;
            int n = 0;
            this.getParent();
            switch (this.nodeKind) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    axisIterator = this.parent.iterateAxis((byte)3);
                    break;
                }
                case 2: {
                    axisIterator = this.parent.iterateAxis((byte)2);
                    break;
                }
                case 13: {
                    axisIterator = this.parent.iterateAxis((byte)8);
                    break;
                }
                default: {
                    this.index = 0;
                    return this.index;
                }
            }
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (nodeInfo.isSameNodeInfo((NodeInfo)this)) {
                    this.index = n;
                    return this.index;
                }
                ++n;
            }
            throw new IllegalStateException("DOM4J node not linked to parent node");
        }
        return this.index;
    }

    public AxisIterator iterateAxis(byte by) {
        return this.iterateAxis(by, (NodeTest)AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: {
                if (this.nodeKind == 9) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter((AxisIterator)new Navigator.AncestorEnumeration((NodeInfo)this, false), nodeTest);
            }
            case 1: {
                if (this.nodeKind == 9) {
                    return Navigator.filteredSingleton((NodeInfo)this, (NodeTest)nodeTest);
                }
                return new Navigator.AxisFilter((AxisIterator)new Navigator.AncestorEnumeration((NodeInfo)this, true), nodeTest);
            }
            case 2: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter((AxisIterator)new AttributeEnumeration(this), nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new Navigator.AxisFilter((AxisIterator)new ChildEnumeration(this, true, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.hasChildNodes()) {
                    return new Navigator.AxisFilter((AxisIterator)new Navigator.DescendantEnumeration((NodeInfo)this, false, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.DescendantEnumeration((NodeInfo)this, true, true), nodeTest);
            }
            case 6: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.FollowingEnumeration((NodeInfo)this), nodeTest);
            }
            case 7: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter((AxisIterator)new ChildEnumeration(this, false, true), nodeTest);
            }
            case 8: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter((AxisIterator)new NamespaceEnumeration(this), nodeTest);
            }
            case 9: {
                this.getParent();
                return Navigator.filteredSingleton((NodeInfo)this.parent, (NodeTest)nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.PrecedingEnumeration((NodeInfo)this, false), nodeTest);
            }
            case 11: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter((AxisIterator)new ChildEnumeration(this, false, false), nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton((NodeInfo)this, (NodeTest)nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.PrecedingEnumeration((NodeInfo)this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public String getAttributeValue(int n) {
        if (this.nodeKind == 1) {
            Iterator iterator = ((Element)this.node).attributes().iterator();
            NamePool namePool = this.docWrapper.getNamePool();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                int n2 = namePool.allocate(attribute.getNamespacePrefix(), attribute.getNamespaceURI(), attribute.getName());
                if (n != (n2 & 0xFFFFF)) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    public boolean hasChildNodes() {
        switch (this.nodeKind) {
            case 9: {
                return true;
            }
            case 1: {
                List list = ((Element)this.node).content();
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) instanceof Namespace) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void generateId(FastStringBuffer fastStringBuffer) {
        Navigator.appendSequentialKey((SiblingCountingNode)this, (FastStringBuffer)fastStringBuffer, (boolean)true);
    }

    public int getDocumentNumber() {
        return this.getParent().getDocumentNumber();
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        Navigator.copy((NodeInfo)this, (Receiver)receiver, (NamePool)this.docWrapper.getNamePool(), (int)n, (boolean)bl, (int)n2);
    }

    public void outputNamespaceNodes(Receiver receiver, boolean bl) throws XPathException {
        if (this.nodeKind == 1) {
            NodeWrapper nodeWrapper;
            NamePool namePool = this.docWrapper.getNamePool();
            AxisIterator axisIterator = this.iterateAxis((byte)8);
            while ((nodeWrapper = (NodeWrapper)axisIterator.next()) != null && (bl || nodeWrapper.getParent().isSameNodeInfo((NodeInfo)this))) {
                Namespace namespace = (Namespace)nodeWrapper.node;
                int n = namePool.allocateNamespaceCode(namespace.getPrefix(), namespace.getURI());
                receiver.namespace(n, 0);
            }
        }
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof NodeWrapper)) {
            return false;
        }
        NodeWrapper nodeWrapper = (NodeWrapper)nodeInfo;
        if (this.node instanceof Namespace) {
            return this.getLocalPart().equals(nodeWrapper.getLocalPart()) && this.getParent().isSameNodeInfo(nodeWrapper.getParent());
        }
        return this.node.equals(nodeWrapper.node);
    }

    public Configuration getConfiguration() {
        return this.docWrapper.getConfiguration();
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        if (this.node instanceof Element) {
            Element element = (Element)this.node;
            List list = element.declaredNamespaces();
            if (list == null || list.size() == 0) {
                return NodeInfo.EMPTY_NAMESPACE_LIST;
            }
            int n = list.size();
            if (n == 0) {
                return NodeInfo.EMPTY_NAMESPACE_LIST;
            }
            int[] nArray2 = n > nArray.length ? new int[n] : nArray;
            NamePool namePool = this.getNamePool();
            int n2 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Namespace namespace = (Namespace)iterator.next();
                String string = namespace.getPrefix();
                String string2 = namespace.getURI();
                nArray2[n2++] = namePool.allocateNamespaceCode(string, string2);
            }
            if (n < nArray2.length) {
                nArray2[n] = -1;
            }
            return nArray2;
        }
        return null;
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        Navigator.sendNamespaceDeclarations((NodeInfo)this, (Receiver)receiver, (boolean)bl);
    }

    private final class ChildEnumeration
    extends Navigator.BaseEnumeration {
        private NodeWrapper start;
        private NodeWrapper commonParent;
        private ListIterator children;
        private int ix = 0;
        private boolean downwards;
        private boolean forwards;

        public ChildEnumeration(NodeWrapper nodeWrapper2, boolean bl, boolean bl2) {
            this.start = nodeWrapper2;
            this.downwards = bl;
            this.forwards = bl2;
            this.commonParent = bl ? nodeWrapper2 : (NodeWrapper)nodeWrapper2.getParent();
            this.children = this.commonParent.getNodeKind() == 9 ? ((Document)this.commonParent.node).content().listIterator() : ((Element)this.commonParent.node).content().listIterator();
            if (bl) {
                if (!bl2) {
                    while (this.children.hasNext()) {
                        this.children.next();
                        ++this.ix;
                    }
                }
            } else {
                this.ix = nodeWrapper2.getSiblingPosition();
                if (bl2) {
                    for (int i = 0; i <= this.ix; ++i) {
                        this.children.next();
                    }
                    ++this.ix;
                } else {
                    for (int i = 0; i < this.ix; ++i) {
                        this.children.next();
                    }
                    --this.ix;
                }
            }
        }

        public void advance() {
            if (this.forwards) {
                if (this.children.hasNext()) {
                    Object e = this.children.next();
                    if (e instanceof DocumentType || e instanceof Namespace) {
                        this.advance();
                        return;
                    }
                    if (e instanceof Entity) {
                        throw new IllegalStateException("Unexpanded entity in DOM4J tree");
                    }
                    this.current = this.isAtomizing() ? new UntypedAtomicValue((CharSequence)NodeWrapper.getStringValue(NodeWrapper.this.node)) : NodeWrapper.this.makeWrapper(e, NodeWrapper.this.docWrapper, this.commonParent, this.ix++);
                } else {
                    this.current = null;
                }
            } else if (this.children.hasPrevious()) {
                Object e = this.children.previous();
                if (e instanceof DocumentType || e instanceof Namespace) {
                    this.advance();
                    return;
                }
                if (e instanceof Entity) {
                    throw new IllegalStateException("Unexpanded entity in DOM4J tree");
                }
                this.current = this.isAtomizing() ? new UntypedAtomicValue((CharSequence)NodeWrapper.getStringValue(NodeWrapper.this.node)) : NodeWrapper.this.makeWrapper(e, NodeWrapper.this.docWrapper, this.commonParent, this.ix--);
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new ChildEnumeration(this.start, this.downwards, this.forwards);
        }
    }

    private final class NamespaceEnumeration
    extends Navigator.BaseEnumeration {
        private HashMap nslist = new HashMap();
        private Iterator prefixes;
        private int ix = 0;
        private NodeWrapper start;

        public NamespaceEnumeration(NodeWrapper nodeWrapper2) {
            this.start = nodeWrapper2;
            NodeWrapper nodeWrapper3 = nodeWrapper2;
            do {
                List list;
                Element element = (Element)nodeWrapper3.node;
                Namespace namespace = element.getNamespace();
                String string = namespace.getPrefix();
                String string2 = namespace.getURI();
                if (!(string.equals("") && string2.equals("") || this.nslist.containsKey(string))) {
                    this.nslist.put(namespace.getPrefix(), namespace);
                }
                if ((list = element.additionalNamespaces()).size() <= 0) continue;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    namespace = (Namespace)iterator.next();
                    if (this.nslist.containsKey(namespace.getPrefix())) continue;
                    this.nslist.put(namespace.getPrefix(), namespace);
                }
            } while ((nodeWrapper3 = (NodeWrapper)nodeWrapper3.getParent()).getNodeKind() == 1);
            this.nslist.put("xml", Namespace.XML_NAMESPACE);
            this.prefixes = this.nslist.keySet().iterator();
        }

        public void advance() {
            if (this.prefixes.hasNext()) {
                String string = (String)this.prefixes.next();
                Namespace namespace = (Namespace)this.nslist.get(string);
                this.current = NodeWrapper.this.makeWrapper(namespace, NodeWrapper.this.docWrapper, this.start, this.ix++);
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new NamespaceEnumeration(this.start);
        }
    }

    private final class AttributeEnumeration
    extends Navigator.BaseEnumeration {
        private Iterator atts;
        private int ix = 0;
        private NodeWrapper start;

        public AttributeEnumeration(NodeWrapper nodeWrapper2) {
            this.start = nodeWrapper2;
            this.atts = ((Element)nodeWrapper2.node).attributes().iterator();
        }

        public void advance() {
            this.current = this.atts.hasNext() ? NodeWrapper.this.makeWrapper(this.atts.next(), NodeWrapper.this.docWrapper, this.start, this.ix++) : null;
        }

        public SequenceIterator getAnother() {
            return new AttributeEnumeration(this.start);
        }
    }
}

