/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.TigerDigest;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S1ParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.DESParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.provider.JCEPBEKey;

public interface PBE {
    public static final int MD5 = 0;
    public static final int SHA1 = 1;
    public static final int RIPEMD160 = 2;
    public static final int TIGER = 3;
    public static final int SHA256 = 4;
    public static final int PKCS5S1 = 0;
    public static final int PKCS5S2 = 1;
    public static final int PKCS12 = 2;
    public static final int OPENSSL = 3;

    public static class Util {
        private static PBEParametersGenerator makePBEGenerator(int n, int n2) {
            PBEParametersGenerator pBEParametersGenerator;
            block12: {
                block14: {
                    block13: {
                        block11: {
                            if (n != 0) break block11;
                            switch (n2) {
                                case 0: {
                                    pBEParametersGenerator = new PKCS5S1ParametersGenerator(new MD5Digest());
                                    break block12;
                                }
                                case 1: {
                                    pBEParametersGenerator = new PKCS5S1ParametersGenerator(new SHA1Digest());
                                    break block12;
                                }
                                default: {
                                    throw new IllegalStateException("PKCS5 scheme 1 only supports only MD5 and SHA1.");
                                }
                            }
                        }
                        if (n != 1) break block13;
                        pBEParametersGenerator = new PKCS5S2ParametersGenerator();
                        break block12;
                    }
                    if (n != 2) break block14;
                    switch (n2) {
                        case 0: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new MD5Digest());
                            break block12;
                        }
                        case 1: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new SHA1Digest());
                            break block12;
                        }
                        case 2: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new RIPEMD160Digest());
                            break block12;
                        }
                        case 3: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new TigerDigest());
                            break block12;
                        }
                        case 4: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new SHA256Digest());
                            break block12;
                        }
                        default: {
                            throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                        }
                    }
                }
                pBEParametersGenerator = new OpenSSLPBEParametersGenerator();
            }
            return pBEParametersGenerator;
        }

        static CipherParameters makePBEParameters(JCEPBEKey jCEPBEKey, AlgorithmParameterSpec algorithmParameterSpec, String string) {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(jCEPBEKey.getType(), jCEPBEKey.getDigest());
            byte[] byArray = jCEPBEKey.getEncoded();
            if (jCEPBEKey.shouldTryWrongPKCS12()) {
                byArray = new byte[2];
            }
            pBEParametersGenerator.init(byArray, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            CipherParameters cipherParameters = jCEPBEKey.getIvSize() != 0 ? pBEParametersGenerator.generateDerivedParameters(jCEPBEKey.getKeySize(), jCEPBEKey.getIvSize()) : pBEParametersGenerator.generateDerivedParameters(jCEPBEKey.getKeySize());
            if (string.startsWith("DES")) {
                KeyParameter keyParameter;
                if (cipherParameters instanceof ParametersWithIV) {
                    keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                    DESParameters.setOddParity(keyParameter.getKey());
                } else {
                    keyParameter = (KeyParameter)cipherParameters;
                    DESParameters.setOddParity(keyParameter.getKey());
                }
            }
            int n = 0;
            while (n != byArray.length) {
                byArray[n] = 0;
                ++n;
            }
            return cipherParameters;
        }

        static CipherParameters makePBEMacParameters(JCEPBEKey jCEPBEKey, AlgorithmParameterSpec algorithmParameterSpec) {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(jCEPBEKey.getType(), jCEPBEKey.getDigest());
            byte[] byArray = jCEPBEKey.getEncoded();
            if (jCEPBEKey.shouldTryWrongPKCS12()) {
                byArray = new byte[2];
            }
            pBEParametersGenerator.init(byArray, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            CipherParameters cipherParameters = pBEParametersGenerator.generateDerivedMacParameters(jCEPBEKey.getKeySize());
            int n = 0;
            while (n != byArray.length) {
                byArray[n] = 0;
                ++n;
            }
            return cipherParameters;
        }
    }
}

