/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.utils;

import fr.gouv.finances.cp.xemelios.utils.HashSwapEngine;
import fr.gouv.finances.cp.xemelios.utils.HashSwapEngineException;
import java.util.Hashtable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HTHashSwapEngine<T>
extends HashSwapEngine<T> {
    private Hashtable<String, T> ht = new Hashtable();

    HTHashSwapEngine() {
    }

    @Override
    void put(String key, T value) throws HashSwapEngineException {
        try {
            this.ht.put(key, value);
        }
        catch (UnsupportedOperationException e) {
            throw new HashSwapEngineException(e, 1);
        }
        catch (ClassCastException e) {
            throw new HashSwapEngineException(e, 2);
        }
        catch (IllegalArgumentException e) {
            throw new HashSwapEngineException(e, 3);
        }
        catch (NullPointerException e) {
            throw new HashSwapEngineException(e, 4);
        }
    }

    @Override
    int size() {
        return this.ht.size();
    }

    @Override
    T get(String key) throws HashSwapEngineException {
        T ret = null;
        try {
            ret = this.ht.get(key);
            return ret;
        }
        catch (ClassCastException e) {
            throw new HashSwapEngineException(e, 2);
        }
        catch (NullPointerException e) {
            throw new HashSwapEngineException(e, 4);
        }
        finally {
            return ret;
        }
    }

    @Override
    T getFilled(String key, T objToFill) throws HashSwapEngineException {
        return this.get(key);
    }

    Set<String> keySet() {
        Set<String> ret = null;
        try {
            ret = this.ht.keySet();
            return ret;
        }
        catch (ClassCastException e) {
            throw new HashSwapEngineException(e, 2);
        }
        finally {
            return ret;
        }
    }

    @Override
    boolean containsKey(String key) throws HashSwapEngineException {
        boolean ret = false;
        try {
            ret = this.ht.containsKey(key);
            return ret;
        }
        catch (ClassCastException e) {
            throw new HashSwapEngineException(e, 2);
        }
        catch (NullPointerException e) {
            throw new HashSwapEngineException(e, 4);
        }
        finally {
            return ret;
        }
    }

    @Override
    T remove(String key) throws HashSwapEngineException {
        T ret = null;
        try {
            ret = this.ht.remove(key);
            return ret;
        }
        catch (ClassCastException e) {
            throw new HashSwapEngineException(e, 2);
        }
        catch (NullPointerException e) {
            throw new HashSwapEngineException(e, 4);
        }
        catch (UnsupportedOperationException e) {
            throw new HashSwapEngineException(e, 1);
        }
        finally {
            return ret;
        }
    }

    @Override
    void destruct() throws HashSwapEngineException {
    }
}

