/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.utils;

import fr.gouv.finances.cp.xemelios.utils.HashSwapAttributesPicker;
import fr.gouv.finances.cp.xemelios.utils.HashSwapEngine;
import fr.gouv.finances.cp.xemelios.utils.HashSwapEngineException;
import fr.gouv.finances.cp.xemelios.utils.HashSwapPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBHashSwapEngine<T>
extends HashSwapEngine<T> {
    HashSwapPersister<T> persister;

    DBHashSwapEngine(Class<T> tclass) {
        try {
            HashSwapAttributesPicker<T> picker = new HashSwapAttributesPicker<T>(tclass);
            this.persister = new HashSwapPersister<T>(picker);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    void put(String key, T value) throws HashSwapEngineException {
        this.persister.storeAt(key, value);
    }

    @Override
    int size() throws HashSwapEngineException {
        int ret = -1;
        try {
            ret = this.persister.size();
            return ret;
        }
        catch (ClassCastException e) {
            throw new HashSwapEngineException(e, 2);
        }
        catch (NullPointerException e) {
            throw new HashSwapEngineException(e, 4);
        }
        finally {
            return ret;
        }
    }

    @Override
    T get(String key) throws HashSwapEngineException {
        T ret = null;
        try {
            ret = this.persister.readFromStorage(key);
            return ret;
        }
        catch (ClassCastException e) {
            throw new HashSwapEngineException(e, 2);
        }
        catch (NullPointerException e) {
            throw new HashSwapEngineException(e, 4);
        }
        finally {
            return ret;
        }
    }

    @Override
    T getFilled(String key, T objToFill) throws HashSwapEngineException {
        T ret = null;
        try {
            ret = this.persister.fillFromStorage(key, objToFill);
            return ret;
        }
        catch (ClassCastException e) {
            throw new HashSwapEngineException(e, 2);
        }
        catch (NullPointerException e) {
            throw new HashSwapEngineException(e, 4);
        }
        finally {
            return ret;
        }
    }

    @Override
    boolean containsKey(String key) throws HashSwapEngineException {
        boolean ret = false;
        try {
            ret = this.persister.exists(key);
            return ret;
        }
        catch (ClassCastException e) {
            throw new HashSwapEngineException(e, 2);
        }
        catch (NullPointerException e) {
            throw new HashSwapEngineException(e, 4);
        }
        finally {
            return ret;
        }
    }

    @Override
    T remove(String key) throws HashSwapEngineException {
        T ret = null;
        try {
            ret = this.persister.readFromStorage(key);
            if (ret != null) {
                this.persister.delete(key);
            }
        }
        catch (ClassCastException e) {
            throw new HashSwapEngineException(e, 2);
        }
        catch (NullPointerException e) {
            throw new HashSwapEngineException(e, 4);
        }
        catch (UnsupportedOperationException e) {
            throw new HashSwapEngineException(e, 1);
        }
        finally {
            return ret;
        }
    }

    @Override
    void destruct() throws HashSwapEngineException {
        try {
            if (this.persister != null) {
                this.persister.destruct();
            }
            this.persister = null;
        }
        catch (Exception e) {
            throw new HashSwapEngineException(e, 4);
        }
    }

    protected void finalize() throws Throwable {
        this.destruct();
        super.finalize();
    }
}

