/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.updater.ui;

import fr.gouv.finances.cp.utils.PropertiesExpansion;
import fr.gouv.finances.cp.utils.StartUrl;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.utils.ui.InfiniteGlassPane;
import fr.gouv.finances.cp.utils.ui.SameSizeVerticalFlowLayout;
import fr.gouv.finances.cp.utils.ui.VerticalFlowLayout;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.xemelios.common.NetAccess;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.updater.UpdaterException;
import fr.gouv.finances.cp.xemelios.updater.UpdaterUtil;
import fr.gouv.finances.cp.xemelios.updater.config.ComponentModel;
import fr.gouv.finances.cp.xemelios.updater.config.ComponentRefModel;
import fr.gouv.finances.cp.xemelios.updater.config.ConfigurationModel;
import fr.gouv.finances.cp.xemelios.updater.config.DeleteModel;
import fr.gouv.finances.cp.xemelios.updater.config.FileListModel;
import fr.gouv.finances.cp.xemelios.updater.config.FileModel;
import fr.gouv.finances.cp.xemelios.updater.config.ParamModel;
import fr.gouv.finances.cp.xemelios.updater.config.SiteModel;
import fr.gouv.finances.cp.xemelios.updater.config.UpdateParser;
import fr.gouv.finances.cp.xemelios.updater.config.XemeliosUpdateModel;
import fr.gouv.finances.cp.xemelios.updater.ui.DlgComponentDetail;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import jonelo.jacksum.algorithm.MD;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DlgUpdate
extends JDialog {
    private static final long serialVersionUID = 3532748822800835233L;
    private static Logger logger = Logger.getLogger(DlgUpdate.class);
    private static final transient String XEMELIOS_TT = "Composant Xemelios";
    private static final transient String CONFIG_TT = "Configuration";
    private static final transient String FEATURE_TT = "Fonctionnalit\u00e9";
    private PropertiesExpansion sysProps;
    private ComponentHolder installedComponents;
    private UpdatePanel updateTab;
    private Vector<ComponentModel> updateComps = new Vector();
    private Hashtable<String, ComponentModel> updateCompsById = new Hashtable();
    private XPathFactory xpf = null;
    private DocumentBuilderFactory domFactory;

    public DlgUpdate(Frame owner) {
        super(owner, "Mise \u00e0 jour de Xemelios", false);
        try {
            this.xpf = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
            this.domFactory = DocumentBuilderFactory.newInstance();
        }
        catch (Throwable t) {
            this.xpf = XPathFactory.newInstance();
            t.printStackTrace();
        }
        this.sysProps = new PropertiesExpansion();
        this.sysProps.putAll((Map)System.getProperties());
        this.initComponents();
    }

    private void initComponents() {
        Exception initException = null;
        try {
            this.loadComponentList();
        }
        catch (Exception ex) {
            initException = ex;
        }
        JPanel mainPane = new JPanel(new BorderLayout());
        JPanel centerPane = new JPanel(new VerticalFlowLayout());
        JTabbedPane tab = new JTabbedPane(1, 1);
        tab.addTab("Composants install\u00e9s", this.getComponentsTab());
        tab.addTab("Mises \u00e0 jour disponibles", this.getUpdateTab());
        centerPane.add(tab);
        HyperLink releaseNotes = new HyperLink("Notes de version...", "http://www.xemelios.org/release-notes.html");
        centerPane.add(releaseNotes);
        mainPane.add((Component)centerPane, "Center");
        JPanel buttonPane = new JPanel(new FlowLayout(1));
        JButton pbClose = new JButton("Fermer");
        pbClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DlgUpdate.this.setVisible(false);
            }
        });
        buttonPane.add(pbClose);
        mainPane.add((Component)buttonPane, "South");
        this.setContentPane(mainPane);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(this.getParent());
        this.setGlassPane(new InfiniteGlassPane());
        this.setVisible(true);
        if (initException != null) {
            new DisplayExceptionDlg((Dialog)this, (Throwable)initException);
        }
    }

    private JPanel getComponentsTab() {
        JPanel ret = new JPanel();
        JTable tbl = new JTable(new ComponentsTableModel(this.installedComponents));
        ret.add(new JScrollPane(tbl));
        return ret;
    }

    private JPanel getUpdateTab() {
        this.updateTab = new UpdatePanel(this);
        return this.updateTab;
    }

    private void loadUpdateList() throws Exception {
        String prop = System.getProperty("xemelios.updater.source");
        this.updateComps = new Vector();
        this.updateFromUrl(prop);
        ((UpdCompTableModel)this.updateTab.tblComponents.getModel()).setData(this.updateComps);
        this.updateTab.pbUpdate.setEnabled(this.updateComps.size() > 0);
    }

    private void updateFromUrl(String urlLocation) throws Exception {
        GetMethod meth;
        HttpClient client = NetAccess.getHttpClient();
        int httpRet = client.executeMethod((HttpMethod)(meth = new GetMethod(urlLocation)));
        if (httpRet > 300) {
            throw new Exception(meth.getStatusText());
        }
        InputStream is = meth.getResponseBodyAsStream();
        UpdateParser up = new UpdateParser();
        up.parse(is);
        is.close();
        XemeliosUpdateModel xum = (XemeliosUpdateModel)up.getMarshallable();
        if (xum.getXemeliosUpdates() != null) {
            this.addNewComponents(1, xum.getXemeliosUpdates().getComponents());
        }
        if (xum.getConfigUpdates() != null) {
            this.addNewComponents(2, xum.getConfigUpdates().getComponents());
        }
        if (xum.getFeaturesUpdates() != null) {
            this.addNewComponents(3, xum.getFeaturesUpdates().getComponents());
        }
        if (xum.getForeignSites() != null) {
            for (SiteModel site : xum.getForeignSites().getSites()) {
                try {
                    this.updateFromUrl(site.getText());
                }
                catch (IOException ioEx) {
                    JOptionPane.showMessageDialog(this, "Site de mise \u00e0 jour introuvable :\n" + ioEx.getMessage(), "Erreur", 0);
                }
            }
        }
    }

    private void addNewComponents(int componentType, Iterable<ComponentModel> cps) {
        for (ComponentModel cm : cps) {
            if (UpdaterUtil.compareReleases(this.getInstalledcomponentVersion(cm.getId()), cm.getRelease().getV()) >= 0) continue;
            cm.type = componentType;
            ComponentModel oldRelease = this.updateCompsById.get(cm.getId());
            if (oldRelease != null) {
                this.updateComps.remove(oldRelease);
                this.updateCompsById.remove(cm.getId());
            }
            this.updateComps.add(cm);
            this.updateCompsById.put(cm.getId(), cm);
        }
    }

    private int compareReleases(String r1, String r2) {
        String[] s1 = this.splitRelease(r1);
        String[] s2 = this.splitRelease(r2);
        int ret = 0;
        for (int i = 0; i < Math.min(s1.length, s2.length); ++i) {
            int a = -1;
            int b = -1;
            try {
                a = Integer.parseInt(s1[i]);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                b = Integer.parseInt(s2[i]);
            }
            catch (Throwable t) {
                // empty catch block
            }
            ret = a != -1 && b != -1 ? (a < b ? -1 : (a == b ? 0 : 1)) : s1[i].compareTo(s2[i]);
            if (ret == 0) continue;
            return ret;
        }
        if (s1.length > s2.length) {
            ret = 1;
        } else if (s1.length < s2.length) {
            ret = -1;
        }
        return ret;
    }

    private String[] splitRelease(String r) {
        return r.split("\\.");
    }

    private static String printArray(String[] s) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < s.length; ++i) {
            sb.append("\"").append(s[i]).append("\"");
            if (i + 1 >= s.length) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    protected void doUpdate() throws NoSuchAlgorithmException {
        boolean bRet = false;
        this.getGlassPane().setVisible(true);
        ComponentHolder ch = new ComponentHolder(this.updateComps);
        try {
            for (ComponentModel cm : this.updateComps) {
                if (!cm.selected) continue;
                ch.addComponent(cm);
            }
        }
        catch (DataConfigurationException dcEx) {
            this.getGlassPane().setVisible(false);
            JOptionPane.showMessageDialog(this, dcEx.getMessage(), "Erreur", 0);
            return;
        }
        if (ch.comps.size() == 0) {
            this.getGlassPane().setVisible(false);
            JOptionPane.showMessageDialog(this, "Vous devez cocher au moins un composant \u00e0 installer.", "Erreur", 0);
            return;
        }
        for (ComponentModel cm : ch.comps) {
            cm.selected = true;
        }
        this.updateTab.tblComponents.tableChanged(new TableModelEvent(this.updateTab.tblComponents.getModel()));
        Downloader downloader = new Downloader(ch);
        try {
            downloader.execute();
            bRet = (Boolean)downloader.get();
        }
        catch (Exception ex) {
            // empty catch block
        }
        String msg = "Le t\u00e9l\u00e9chargement des nouveaux composants est termin\u00e9.\nPour les installer, vous devez red\u00e9marrer Xemelios.";
        if (bRet) {
            this.updateTab.pbDetails.setEnabled(false);
            this.updateTab.pbLoad.setEnabled(false);
            this.updateTab.pbUpdate.setEnabled(false);
            JOptionPane.showMessageDialog(this, msg);
        } else if (downloader.getException() != null) {
            DisplayExceptionDlg.displayException(this, (Throwable)downloader.getException());
        } else if (downloader.getErrorMessage() != null) {
            JOptionPane.showMessageDialog(this, downloader.getErrorMessage(), "ERREUR", 0);
        }
    }

    private File getLocalFileName(String filePath, String fileName) {
        String ret = filePath;
        int pos = ret.indexOf("${");
        while (pos >= 0) {
            String before = ret.substring(0, pos);
            int end = ret.indexOf("}");
            String after = ret.substring(end + 1);
            String key = ret.substring(pos + 2, end);
            ret = before + System.getProperty(key) + after;
            pos = ret.indexOf("${");
        }
        File f = new File(new File(ret), fileName);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    private void loadComponentList() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        this.installedComponents = new ComponentHolder(new Vector<ComponentModel>());
        String fileName = System.getProperty("xemelios.components.filename");
        InputSource is = new InputSource(new FileReader(new File(fileName)));
        DocumentBuilder domBuilder = this.domFactory.newDocumentBuilder();
        Document dom = domBuilder.parse(is);
        try {
            XPath xp = this.xpf.newXPath();
            Object o = xp.evaluate("//component", dom, XPathConstants.NODESET);
            if (o instanceof NodeList) {
                NodeList nl = (NodeList)o;
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    try {
                        this.installedComponents.addComponent(new XemeliosComponent(el));
                        continue;
                    }
                    catch (DataConfigurationException dcEx) {
                        // empty catch block
                    }
                }
            } else if (o instanceof List) {
                List l = (List)o;
                for (Object obj : l) {
                    if (obj instanceof Element) {
                        try {
                            this.installedComponents.addComponent(new XemeliosComponent((Element)obj));
                        }
                        catch (DataConfigurationException dcEx) {}
                        continue;
                    }
                    Class<?> clazz = obj.getClass();
                    Class<?>[] interfaces = clazz.getInterfaces();
                    for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                    }
                }
            }
        }
        catch (XPathFactoryConfigurationException e) {
            logger.error((Object)"in loadComponentList()", (Throwable)e);
        }
    }

    private String getInstalledcomponentVersion(String cid) {
        String ret = this.installedComponents.getComponentVersion(cid);
        return ret == null ? "0" : ret;
    }

    private String unescapePath(String path) {
        return this.sysProps.replace(path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Downloader
    extends SwingWorker<Boolean, Integer> {
        private ComponentHolder ch;
        protected String errorMsg = null;
        protected Exception exception = null;

        public Exception getException() {
            return this.exception;
        }

        public String getErrorMessage() {
            return this.errorMsg;
        }

        private Downloader(ComponentHolder ch) {
            this.ch = ch;
        }

        protected Boolean doInBackground() throws Exception {
            logger.debug((Object)"in doInBackground");
            boolean bRet = true;
            try {
                File tmpDir = new File(DlgUpdate.this.unescapePath("${xemelios.dir}/tmp-upd"));
                logger.debug((Object)("tmpDir=" + tmpDir.getPath()));
                tmpDir.mkdirs();
                StringBuilder sb = new StringBuilder();
                HttpClient client = NetAccess.getHttpClient();
                for (ComponentModel cm : this.ch.comps) {
                    for (FileListModel fl : cm.getFileLists()) {
                        String root = fl.getRoot();
                        for (XmlMarshallable x : fl.getFiles()) {
                            if (x instanceof FileModel) {
                                FileModel fm = (FileModel)x;
                                File localFile = DlgUpdate.this.getLocalFileName(fm.getDest(), fm.getName());
                                if (localFile != null) {
                                    MD localChecksum = new MD("MD5");
                                    FileInputStream fis = new FileInputStream(localFile);
                                    byte[] buffer = new byte[1024];
                                    int read = fis.read(buffer);
                                    while (read > 0) {
                                        localChecksum.update(buffer, 0, read);
                                        read = fis.read(buffer);
                                    }
                                    fis.close();
                                    if (localChecksum.getFormattedValue().equals(fm.getMd5())) {
                                        logger.info((Object)("local " + fm.getName() + " is the same than remote one."));
                                        continue;
                                    }
                                }
                                String sUrl = root + "/" + fm.getSource();
                                URL url = new URL(sUrl);
                                MD checksum = new MD("MD5");
                                File tmpFile = File.createTempFile("upd-", null, tmpDir);
                                sb.append("copy|").append(tmpFile.getName()).append("|").append(fm.getDest() + "/" + fm.getName()).append("\n");
                                FileOutputStream fos = new FileOutputStream(tmpFile);
                                logger.info((Object)("downloading " + sUrl + " to " + tmpFile.getPath()));
                                GetMethod meth = new GetMethod(sUrl);
                                int returnCode = client.executeMethod((HttpMethod)meth);
                                if (returnCode <= 300) {
                                    InputStream is = meth.getResponseBodyAsStream();
                                    byte[] buffer = new byte[1024];
                                    int read = is.read(buffer);
                                    while (read > 0) {
                                        fos.write(buffer, 0, read);
                                        checksum.update(buffer, 0, read);
                                        read = is.read(buffer);
                                    }
                                    is.close();
                                    fos.flush();
                                    fos.close();
                                    if (fm.getMd5().equals(checksum.getFormattedValue())) continue;
                                    logger.error((Object)("File " + fm.getName() + ":\n\texpected  : " + fm.getMd5() + "\n\tcalculated: " + checksum.getFormattedValue()));
                                    throw new UpdaterException("Signature de fichier t\u00e9l\u00e9charg\u00e9 invalide - " + fm.getName());
                                }
                                this.errorMsg = " " + returnCode + " : " + meth.getStatusText() + " : " + sUrl;
                                bRet = false;
                                throw new IOException();
                            }
                            if (!(x instanceof DeleteModel)) continue;
                            DeleteModel dm = (DeleteModel)x;
                            sb.append("delete|").append(dm.getName()).append("\n");
                        }
                    }
                    if (cm.getConfiguration() != null) {
                        ConfigurationModel conf = cm.getConfiguration();
                        sb.append("configuration|").append(conf.getClassName()).append("");
                        if (conf.getParams().size() == 0) {
                            sb.append("\n");
                        } else {
                            for (ParamModel pm : conf.getParams()) {
                                sb.append("|").append(pm.getName()).append("|").append(pm.getParamValue());
                            }
                            sb.append("\n");
                        }
                    }
                    sb.append("install-component|").append(cm.getId()).append("|").append(cm.getRelease().getV()).append("|").append(cm.getDescription().getText()).append("\n");
                }
                bRet = true;
                File batch = new File(tmpDir, "update-script.xem");
                FileOutputStream fos = new FileOutputStream(batch);
                StringBuilder header = new StringBuilder("# update of ").append(DateFormat.getDateTimeInstance(1, 1).format(new Date())).append("\n");
                fos.write(header.toString().getBytes("ISO-8859-1"));
                fos.write(sb.toString().getBytes("ISO-8859-1"));
                fos.flush();
                fos.close();
            }
            catch (UpdaterException uex) {
                this.exception = uex;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DataConfigurationException dcEx) {
                this.errorMsg = dcEx.getMessage();
            }
            return new Boolean(bRet);
        }

        protected void done() {
            DlgUpdate.this.getGlassPane().setVisible(false);
        }
    }

    public class HyperLink
    extends JLabel {
        private String uri;
        private Action act;

        public HyperLink(String text, String uri) {
            super(text);
            this.uri = uri;
            this.act = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        StartUrl.startUrl(HyperLink.this.uri);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.setForeground(new Color(0, 51, 255));
            this.setFocusable(true);
            this.setBorder(new EmptyBorder(2, 2, 2, 2));
            this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "CLICK");
            this.getActionMap().put("CLICK", this.act);
            this.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ((HyperLink)e.getComponent()).paintFocus();
                }

                public void focusLost(FocusEvent e) {
                    ((HyperLink)e.getComponent()).paintFocus();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    HyperLink.this.act.actionPerformed(null);
                }

                public void mouseEntered(MouseEvent e) {
                    super.mouseEntered(e);
                    HyperLink.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                public void mouseExited(MouseEvent e) {
                    super.mouseExited(e);
                    HyperLink.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.getForeground());
            int height = this.getFontMetrics(this.getFont()).getAscent() + 2;
            g.drawLine(0, height, this.getWidth(), height);
            this.paintFocus(g);
        }

        protected void paintFocus(Graphics g) {
            if (g == null) {
                return;
            }
            if (this.isFocusOwner()) {
                g.setColor(UIManager.getColor("Button.focus"));
            } else {
                g.setColor(UIManager.getColor("Label.background"));
            }
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }

        protected void paintFocus() {
            this.paintFocus(this.getGraphics());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentHolder {
        private HashMap<String, String> compList = new HashMap();
        private Vector<ComponentModel> updateComps;
        private ArrayList<ComponentModel> comps = new ArrayList();

        public ComponentHolder(Vector<ComponentModel> updateComps) {
            this.updateComps = updateComps;
        }

        public boolean isComponentPresent(String cid) {
            return this.compList.get(cid) != null;
        }

        public String getComponentVersion(String cid) {
            return this.compList.get(cid);
        }

        public boolean isComponentAlreadySelected(String cid, String version) {
            return this.isComponentPresent(cid) && this.getComponentVersion(cid).compareTo(version) >= 0;
        }

        public void addComponent(ComponentModel cm) throws DataConfigurationException {
            int ret;
            if (this.isComponentAlreadySelected(cm.getId(), cm.getRelease().getV())) {
                return;
            }
            if (this.isComponentPresent(cm.getId()) && (ret = UpdaterUtil.compareReleases(this.getComponentVersion(cm.getId()), cm.getRelease().getV())) < 0) {
                XemeliosComponent xc = new XemeliosComponent(cm.getId(), this.getComponentVersion(cm.getId()));
                this.comps.remove(xc);
                this.compList.remove(cm.getId());
            }
            this.comps.add(cm);
            this.compList.put(cm.getId(), cm.getRelease().getV());
            if (cm.getRequires() != null) {
                for (ComponentRefModel cRef : cm.getRequires().getComponents()) {
                    String installedVersion = DlgUpdate.this.installedComponents.getComponentVersion(cRef.getId());
                    if (installedVersion != null && UpdaterUtil.compareReleases(installedVersion, cRef.getVersion()) >= 0) continue;
                    ComponentModel dep = (ComponentModel)DlgUpdate.this.updateCompsById.get(cRef.getId());
                    if (dep != null && UpdaterUtil.compareReleases(dep.getRelease().getV(), cRef.getVersion()) >= 0) {
                        this.addComponent(dep);
                        continue;
                    }
                    throw new DataConfigurationException("Composant requis introuvable: " + cRef.getId() + " (" + cRef.getVersion() + ")");
                }
            }
        }

        public void removeComponent(String cid) {
            String version = this.getComponentVersion(cid);
            XemeliosComponent xc = new XemeliosComponent(cid, version);
            this.comps.remove(xc);
            this.compList.remove(cid);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdCompTableModel
    extends AbstractTableModel {
        private Vector<ComponentModel> components;
        private ImageIcon xemeliosIcon;
        private ImageIcon configIcon;
        private ImageIcon featureIcon;

        public UpdCompTableModel(Vector<ComponentModel> components) {
            this.components = components;
            this.xemeliosIcon = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/xemelios-comp.png");
            this.configIcon = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/config-comp.png");
            this.featureIcon = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/feature-comp.png");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Icon.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ComponentModel cm = this.components.elementAt(rowIndex);
            cm.selected = (Boolean)aValue;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.components.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ComponentModel cm = this.components.elementAt(rowIndex);
            if (columnIndex == 0) {
                switch (cm.type) {
                    case 1: {
                        return this.xemeliosIcon;
                    }
                    case 2: {
                        return this.configIcon;
                    }
                    case 3: {
                        return this.featureIcon;
                    }
                }
                return null;
            }
            return cm.toString();
        }

        public void setData(Vector<ComponentModel> data) {
            this.components = data;
            this.fireTableDataChanged();
        }

        public void selectAll() {
            for (ComponentModel cm : this.components) {
                cm.selected = true;
            }
            this.fireTableDataChanged();
        }
    }

    private class ComponentsTableModel
    extends AbstractTableModel {
        private Vector<ComponentModel> data = new Vector();

        public ComponentsTableModel(ComponentHolder comps) {
            this.data.addAll(comps.comps);
        }

        public int getRowCount() {
            return this.data.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            ComponentModel c = this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return c.getDescription().getText();
                }
                case 1: {
                    return c.getRelease().getV();
                }
            }
            return null;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Composant";
                }
                case 1: {
                    return "Version";
                }
            }
            return "";
        }
    }

    private class XemeliosComponent
    extends ComponentModel {
        public XemeliosComponent(Element el) throws XPathExpressionException, XPathFactoryConfigurationException {
            super(null);
            XPath xp = DlgUpdate.this.xpf.newXPath();
            this.setId((String)xp.evaluate("./@id", el, XPathConstants.STRING));
            this.setRelease((String)xp.evaluate("./@version", el, XPathConstants.STRING));
            this.setDescription((String)xp.evaluate("./@description", el, XPathConstants.STRING));
        }

        public XemeliosComponent(String cid, String version) {
            super(null);
            this.setId(cid);
            this.setRelease(version);
        }
    }

    private class ActionLoad
    extends AbstractAction {
        private DlgUpdate dialog;

        public ActionLoad(DlgUpdate dialog) {
            super("Rechercher");
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.dialog.loadUpdateList();
            }
            catch (Exception ex) {
                new DisplayExceptionDlg((Dialog)this.dialog, (Throwable)ex);
            }
        }
    }

    private class UpdatePanel
    extends JPanel {
        JXTable tblComponents;
        private DlgUpdate parent;
        private JButton pbDetails;
        private JButton pbLoad;
        private JButton pbUpdate;
        private JButton pbCheckAll;

        public UpdatePanel(DlgUpdate parent) {
            this.parent = parent;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.tblComponents = new JXTable(){
                private static final long serialVersionUID = 1L;

                protected void configureEnclosingScrollPane() {
                    Container gp;
                    Container p = this.getParent();
                    if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
                        JScrollPane scrollPane = (JScrollPane)gp;
                        JViewport viewport = scrollPane.getViewport();
                        if (viewport == null || viewport.getView() != this) {
                            return;
                        }
                        scrollPane.getViewport().setScrollMode(2);
                        scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
                    }
                }

                public String getToolTipText(MouseEvent evt) {
                    int row = this.rowAtPoint(evt.getPoint());
                    int column = this.columnAtPoint(evt.getPoint());
                    if (column == 0) {
                        ComponentModel cm = (ComponentModel)DlgUpdate.this.updateComps.elementAt(row);
                        switch (cm.type) {
                            case 1: {
                                return DlgUpdate.XEMELIOS_TT;
                            }
                            case 2: {
                                return DlgUpdate.CONFIG_TT;
                            }
                            case 3: {
                                return DlgUpdate.FEATURE_TT;
                            }
                        }
                        return null;
                    }
                    return null;
                }
            };
            this.tblComponents.setShowGrid(false);
            this.tblComponents.setShowHorizontalLines(true);
            this.tblComponents.setSelectionMode(0);
            final UpdCompTableModel model = new UpdCompTableModel(new Vector<ComponentModel>());
            this.tblComponents.setModel((TableModel)model);
            this.tblComponents.getColumnModel().getColumn(0).setMaxWidth(20);
            this.tblComponents.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int row = UpdatePanel.this.tblComponents.getSelectedRow();
                    UpdatePanel.this.pbDetails.setEnabled(row >= 0);
                }
            });
            model.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    Object source = e.getSource();
                    if (source instanceof JTable) {
                        JTable table = (JTable)source;
                        UpdatePanel.this.pbCheckAll.setEnabled(table.getRowCount() > 0);
                    } else if (source instanceof TableModel) {
                        TableModel tm = (TableModel)source;
                        UpdatePanel.this.pbCheckAll.setEnabled(tm.getRowCount() > 0);
                    }
                }
            });
            this.add((Component)new JScrollPane((Component)this.tblComponents), "Center");
            JPanel buttonPane = new JPanel(new SameSizeVerticalFlowLayout(0));
            this.pbLoad = new JButton(new ActionLoad(this.parent));
            buttonPane.add(this.pbLoad);
            this.pbDetails = new JButton("D\u00e9tails");
            this.pbDetails.setEnabled(false);
            this.pbDetails.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    new DlgComponentDetail(DlgUpdate.this, (ComponentModel)DlgUpdate.this.updateComps.elementAt(UpdatePanel.this.tblComponents.getSelectedRow()));
                }
            });
            buttonPane.add(this.pbDetails);
            this.pbUpdate = new JButton("Installer");
            this.pbUpdate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        UpdatePanel.this.pbCheckAll.doClick();
                        DlgUpdate.this.doUpdate();
                    }
                    catch (Throwable t) {
                        new DisplayExceptionDlg((Dialog)DlgUpdate.this, t);
                    }
                }
            });
            this.pbUpdate.setEnabled(false);
            buttonPane.add(this.pbUpdate);
            buttonPane.add(Box.createVerticalGlue());
            this.pbCheckAll = new JButton("Tout s\u00e9lectionner");
            this.pbCheckAll.setEnabled(false);
            this.pbCheckAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    model.selectAll();
                }
            });
            this.add((Component)buttonPane, "East");
            this.setMinimumSize(new Dimension(240, 140));
        }
    }
}

