/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.importDialog;

import fr.gouv.finances.cp.xemelios.ui.importDialog.ImportFile;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportFileTreeTableModel
extends DefaultTreeTableModel {
    private static final Logger logger = Logger.getLogger(ImportFileTreeTableModel.class);
    private static final int NOM_FICHIER = 0;
    private static final int A_IMPORTER = 1;

    public ImportFileTreeTableModel(TreeNode node) {
        super(node);
    }

    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int column) {
        if (column == 1) {
            return Boolean.class;
        }
        return super.getColumnClass(column);
    }

    public Object getValueAt(Object node, int column) {
        DefaultMutableTreeNode defNode;
        Object result = null;
        if (node instanceof DefaultMutableTreeNode && (defNode = (DefaultMutableTreeNode)node).getUserObject() instanceof ImportFile) {
            ImportFile fichier = (ImportFile)defNode.getUserObject();
            switch (column) {
                case 0: {
                    result = fichier.getName();
                    break;
                }
                case 1: {
                    result = new Boolean(fichier.isToBeImported());
                }
            }
        }
        return result;
    }

    public String getColumnName(int column) {
        String res = "";
        switch (column) {
            case 0: {
                res = "Nom de fichier";
                break;
            }
            case 1: {
                res = "Importer";
            }
        }
        return res;
    }

    public boolean isCellEditable(Object node, int column) {
        return column == 1;
    }

    public void setValueAt(Object value, Object node, int column) {
        DefaultMutableTreeNode defNode;
        if (node instanceof DefaultMutableTreeNode && (defNode = (DefaultMutableTreeNode)node).getUserObject() instanceof ImportFile) {
            ImportFile fichier = (ImportFile)defNode.getUserObject();
            switch (column) {
                case 0: {
                    break;
                }
                case 1: {
                    boolean valeur = (Boolean)value;
                    ((ImportFile)defNode.getUserObject()).setToBeImported(valeur);
                    if (valeur) {
                        this.propagateCheckValueAbove(valeur, defNode);
                    }
                    if (!fichier.isFile()) {
                        this.propagateCheckValueBelow(valeur, defNode);
                    }
                    this.nodesChanged((DefaultMutableTreeNode)this.getRoot(), null);
                }
            }
        }
    }

    private void propagateCheckValueAbove(boolean value, DefaultMutableTreeNode node) {
        ((ImportFile)node.getUserObject()).setToBeImported(value);
        if (node.getParent() != null) {
            this.propagateCheckValueAbove(value, (DefaultMutableTreeNode)node.getParent());
        }
    }

    private void propagateCheckValueBelow(boolean value, DefaultMutableTreeNode node) {
        ((ImportFile)node.getUserObject()).setToBeImported(value);
        if (node.getChildCount() > 0) {
            Enumeration<TreeNode> enumerator = node.children();
            while (enumerator.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumerator.nextElement();
                this.propagateCheckValueBelow(value, child);
            }
        }
    }

    public List<ImportFile> getFilesToImportList() {
        Vector<ImportFile> result = new Vector<ImportFile>();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> enumerator = root.depthFirstEnumeration();
        while (enumerator.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumerator.nextElement();
            ImportFile f = (ImportFile)node.getUserObject();
            if (!f.isFile() || !f.isToBeImported()) continue;
            result.add(f);
        }
        return result;
    }

    public void selectAll() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> enumerator = root.depthFirstEnumeration();
        while (enumerator.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumerator.nextElement();
            ImportFile f = (ImportFile)node.getUserObject();
            f.setToBeImported(true);
        }
        this.nodesChanged(root, null);
    }

    public void selectNone() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        Enumeration<TreeNode> enumerator = root.depthFirstEnumeration();
        while (enumerator.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumerator.nextElement();
            ImportFile f = (ImportFile)node.getUserObject();
            f.setToBeImported(false);
        }
        this.nodesChanged(root, null);
    }

    public boolean isLeaf(TreeNode node) {
        boolean ret = super.isLeaf((Object)node);
        logger.debug((Object)("isLeaf(" + node + ") -> " + ret));
        return ret;
    }
}

