/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.ia.core;

import fr.gouv.finances.cp.xemelios.ui.ia.core.Template;
import fr.gouv.finances.cp.xemelios.ui.ia.core.TemplateFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class State
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] _states;
    protected Template _template = Template.T33;

    public State(Template template_p) {
        this._template = template_p;
        this._states = this._template.allocate();
        for (int i = 0; i < this._template.maxIndex; ++i) {
            this._states[i] = this._template.INITIAL_VALUE;
        }
    }

    public State(State state_p) {
        this._template = state_p._template;
        this._states = this._template.allocate();
        this.loadFrom(state_p);
    }

    public void loadFrom(State state_p) {
        System.arraycopy(state_p._states, 0, this._states, 0, this._states.length);
    }

    public void play(int index_p, int value_p) {
        this.clearBits(index_p, this._template.VALUE_MASK);
        this.clearBits(index_p, this._template.ALL_AVAILABLE_EXTRACTOR);
        this.markBits(index_p, value_p);
        int[][] indexes = this._template.NEIGHBOURGHOODS[index_p];
        int extractor = this._template.VALUE_AVAILABLE_EXTRACTOR[value_p];
        for (int value = 0; value < this._template.maxValue; ++value) {
            for (int cIndex = 0; cIndex < 3; ++cIndex) {
                this.clearBits(indexes[cIndex][value], extractor);
            }
        }
    }

    public boolean playWhilePossible(int index_p, int value_p) {
        this.clearBits(index_p, this._template.VALUE_MASK | this._template.ALL_AVAILABLE_EXTRACTOR);
        this.markBits(index_p, value_p);
        int[][] indexes = this._template.NEIGHBOURGHOODS[index_p];
        int extractor = this._template.VALUE_AVAILABLE_EXTRACTOR[value_p];
        for (int value = 0; value < this._template.maxValue; ++value) {
            for (int cIndex = 0; cIndex < 3; ++cIndex) {
                int finalIndex = indexes[cIndex][value];
                this.clearBits(finalIndex, extractor);
                if (!this.isFree(finalIndex) || (this._states[finalIndex] & this._template.ALL_AVAILABLE_EXTRACTOR) != 0) continue;
                return false;
            }
        }
        return true;
    }

    public void clean(int index_p) {
        State clean = new State(this._template);
        this.markBits(index_p, this._template.FREE_VALUE);
        for (int i = 0; i < this._template.maxIndex; ++i) {
            if (!this.isFree(i)) {
                clean.play(i, this.getValue(i));
            }
            clean.markBits(i, this._states[i] & this._template.ORIGINAL_POSITION);
            clean.markBits(i + this._template.MARK1_OFFSET, this._states[i + this._template.MARK1_OFFSET] & this._template.MARK_MASK);
            clean.markBits(i + this._template.MARK2_OFFSET, this._states[i + this._template.MARK2_OFFSET] & this._template.MARK_MASK);
        }
        this._states = clean._states;
    }

    public boolean isFree(int index_p) {
        return this.checkBit(index_p, this._template.FREE_VALUE);
    }

    public boolean isAllowed(int index_p, int value_p) {
        return this.checkBit(index_p, this._template.VALUE_AVAILABLE_EXTRACTOR[value_p]);
    }

    public int getValue(int index_p) {
        return this._states[index_p] & this._template.VALUE_MASK;
    }

    public int getMark(int index_p, int value_p) {
        int output = 0;
        if (this.checkBit(index_p + this._template.MARK1_OFFSET, this._template.MARK1_EXTRACTOR[value_p])) {
            output = 1;
        }
        if (this.checkBit(index_p + this._template.MARK2_OFFSET, this._template.MARK2_EXTRACTOR[value_p])) {
            output += 2;
        }
        return output;
    }

    public void setMark(int index_p, int value_p, int mark_p) {
        if ((mark_p & 1) != 0) {
            this.markBits(index_p + this._template.MARK1_OFFSET, this._template.MARK1_EXTRACTOR[value_p]);
        } else {
            this.clearBits(index_p + this._template.MARK1_OFFSET, this._template.MARK1_EXTRACTOR[value_p]);
        }
        if ((mark_p & 2) != 0) {
            this.markBits(index_p + this._template.MARK2_OFFSET, this._template.MARK2_EXTRACTOR[value_p]);
        } else {
            this.clearBits(index_p + this._template.MARK2_OFFSET, this._template.MARK2_EXTRACTOR[value_p]);
        }
    }

    public void registerOriginalPosition() {
        for (int index = 0; index < this._template.maxIndex; ++index) {
            if (this.isFree(index)) {
                this.clearBits(index, this._template.ORIGINAL_POSITION);
                continue;
            }
            this.markBits(index, this._template.ORIGINAL_POSITION);
        }
    }

    public boolean isOriginalPosition(int index_p) {
        return this.checkBit(index_p, this._template.ORIGINAL_POSITION);
    }

    public Template getTemplate() {
        return this._template;
    }

    private boolean checkBit(int index_p, int bit_p) {
        return (this._states[index_p] & bit_p) == bit_p;
    }

    private void clearBits(int index_p, int bits_p) {
        this._states[index_p] = this._states[index_p] & ~bits_p;
    }

    private void markBits(int index, int bits_p) {
        this._states[index] = this._states[index] | bits_p;
    }

    int[] getRaw() {
        return this._states;
    }

    public boolean isAvailable(int index_p, int value_p) {
        return this.isFree(index_p) && this.isAllowed(index_p, value_p) && (this.getMark(index_p, value_p) & 1) == 0;
    }

    public void clearMarks() {
        for (int index = 0; index < this._template.maxIndex; ++index) {
            this.clearBits(index + this._template.MARK1_OFFSET, this._template.MARK_MASK);
            this.clearBits(index + this._template.MARK2_OFFSET, this._template.MARK_MASK);
        }
    }

    private void writeObject(ObjectOutputStream out_p) throws IOException {
        out_p.writeShort(this._template.rows);
        out_p.writeShort(this._template.columns);
        for (int i = 0; i < this._states.length; ++i) {
            int aValue = this._states[i];
            out_p.writeInt(aValue);
        }
    }

    private void readObject(ObjectInputStream in_p) throws IOException, ClassNotFoundException {
        short rows = in_p.readShort();
        short columns = in_p.readShort();
        this._template = TemplateFactory.getTemplate(rows, columns);
        this._states = this._template.allocate();
        for (int i = 0; i < this._states.length; ++i) {
            this._states[i] = in_p.readInt();
        }
    }

    private State() {
    }
}

