/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.ia.core;

import fr.gouv.finances.cp.xemelios.ui.ia.core.ISolverListener;
import fr.gouv.finances.cp.xemelios.ui.ia.core.State;

public class Solver {
    State[] _states;
    ISolverListener _listener;
    private int _maxIndex;
    private int _maxValue;

    public Solver(ISolverListener listener_p) {
        this._listener = listener_p;
    }

    public void solve(State state_p) {
        this._maxIndex = state_p.getTemplate().maxIndex;
        this._maxValue = state_p.getTemplate().maxValue;
        this._states = new State[this._maxIndex + 1];
        for (int i = 0; i < this._states.length; ++i) {
            this._states[i] = new State(state_p.getTemplate());
        }
        this._states[0].loadFrom(state_p);
        this.study(0);
    }

    private boolean study(int index_p) {
        State state = this._states[index_p];
        if (index_p == this._maxIndex) {
            return this._listener.foundASolution(state);
        }
        if (!this._listener.levelIs(index_p, state)) {
            return false;
        }
        if (state.isFree(index_p)) {
            for (int value = 0; value < this._maxValue; ++value) {
                if (!state.isAvailable(index_p, value)) continue;
                this._states[index_p + 1].loadFrom(state);
                boolean answer = this._states[index_p + 1].playWhilePossible(index_p, value);
                if (!answer) continue;
                answer = this.study(index_p + 1);
                if (!this._listener.levelIs(index_p, state)) {
                    return false;
                }
                if (answer) continue;
                return false;
            }
            return true;
        }
        this._states[index_p + 1].loadFrom(state);
        return this.study(index_p + 1);
    }
}

