/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.ia.core;

import fr.gouv.finances.cp.xemelios.ui.ia.core.Builder;
import fr.gouv.finances.cp.xemelios.ui.ia.core.StateModel;
import fr.gouv.finances.cp.xemelios.ui.ia.core.TemplateFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;

public class DlgCore
extends JDialog {
    private Action actNew;
    private Action actClose;
    private SGrid grid;

    public DlgCore(Frame parent) {
        super(parent, false);
        this.initActions();
        this.newGame();
        this.initComponents();
    }

    protected void initActions() {
        this.actNew = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DlgCore.this.newGame();
            }
        };
        this.actClose = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DlgCore.this.setVisible(false);
            }
        };
    }

    protected void newGame() {
        Builder bd = new Builder();
        this.grid = new SGrid(new StateModel(bd.buildOne(TemplateFactory.getTemplate(3, 3))));
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DlgCore dialog = new DlgCore(new JFrame());
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private static boolean isInSameSquare(int i, int j, int row, int col) {
        return Math.floor((float)i / 3.0f) == Math.floor((float)row / 3.0f) && Math.floor((float)j / 3.0f) == Math.floor((float)col / 3.0f);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        StringBuffer sb = new StringBuffer();
        sb.append("XEMELIOS").append(" S").append("u").append("d").append("o").append("k").append("u");
        this.setTitle(sb.toString());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.grid, -1, 380, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.grid, -1, 320, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private class SCase
    extends JComponent {
        private StateModel sm;
        private int row;
        private int col;
        private boolean selected = false;
        private boolean hadFocus = false;
        private SGrid grid;

        public SCase(final StateModel sm, final SGrid grid, final int row, final int col) {
            this.sm = sm;
            this.grid = grid;
            this.row = row;
            this.col = col;
            this.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    if ((e.getModifiersEx() & 0x80) > 0) {
                        char c = e.getKeyChar();
                        if ('1' <= c && c <= '9') {
                            grid.highLight(Character.toString(c));
                        }
                    } else if (sm.isWritable(row, col)) {
                        if (sm.isValueAllowed(row, col, Character.toString(e.getKeyChar()))) {
                            sm.setValueAt(row, col, Character.toString(e.getKeyChar()));
                            e.consume();
                            SCase.this.repaint();
                            grid.checkGridFinished();
                        } else if (e.getKeyChar() == ' ' || e.getKeyChar() == '\u007f' || e.getKeyChar() == '\b') {
                            sm.setValueAt(row, col, " ");
                            e.consume();
                            SCase.this.repaint();
                        }
                    }
                }

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 37) {
                        if (col > 0) {
                            grid.grid[row][col - 1].grabFocus();
                            e.consume();
                        }
                    } else if (e.getKeyCode() == 39) {
                        if (col < 8) {
                            grid.grid[row][col + 1].grabFocus();
                            e.consume();
                        }
                    } else if (e.getKeyCode() == 38) {
                        if (row > 0) {
                            grid.grid[row - 1][col].grabFocus();
                            e.consume();
                        }
                    } else if (e.getKeyCode() == 40 && row < 8) {
                        grid.grid[row + 1][col].grabFocus();
                        e.consume();
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    SCase.this.requestFocus();
                }
            });
            this.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    grid.notifyFocusGained(row, col);
                }
            });
        }

        public void paint(Graphics g) {
            if (this.selected) {
                g.setColor(UIManager.getColor("TextField.selectionBackground"));
            } else {
                g.setColor(UIManager.getColor("TextField.background"));
            }
            g.fillRect(1, 1, this.getWidth() - 1, this.getHeight() - 1);
            if (this.hasFocus() | this.isTopComponentFocused()) {
                g.setColor(Color.GRAY);
            } else {
                g.setColor(Color.BLACK);
            }
            g.drawLine(0, 0, this.getWidth() - 1, 0);
            if (this.hasFocus() | this.isLeftComponentFocused()) {
                g.setColor(Color.GRAY);
            } else {
                g.setColor(Color.BLACK);
            }
            g.drawLine(0, 0, 0, this.getHeight() - 1);
            if (this.row % 3 == 2) {
                if (this.isRightComponentFocused()) {
                    g.setColor(Color.GRAY);
                } else {
                    g.setColor(Color.BLACK);
                }
                g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            }
            if (this.col % 3 == 2) {
                if (this.isBottomComponentFocused()) {
                    g.setColor(Color.GRAY);
                } else {
                    g.setColor(Color.BLACK);
                }
                g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            if (this.sm.getValueAt(this.row, this.col) != null) {
                Font originalF = g.getFont();
                g.setColor(Color.BLACK);
                Font ft = g.getFont();
                Font nf = ft.deriveFont((float)this.getHeight() * 0.5f);
                if (this.sm.isWritable(this.row, this.col)) {
                    nf = nf.deriveFont(2);
                }
                g.setFont(nf);
                String s = this.sm.getValueAt(this.row, this.col);
                Rectangle2D rect = g.getFontMetrics().getStringBounds(s, g);
                g.drawString(s, (int)(((double)this.getWidth() - rect.getWidth()) / 2.0), (int)((double)this.getHeight() - rect.getHeight() / 2.0));
                g.setFont(originalF);
            }
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public void setHadFocus(boolean hadFocus) {
            this.hadFocus = hadFocus;
        }

        public boolean isBottomComponentFocused() {
            if (this.row == 8) {
                return false;
            }
            return this.grid.grid[this.row + 1][this.col].hasFocus();
        }

        public boolean isRightComponentFocused() {
            if (this.col == 8) {
                return false;
            }
            return this.grid.grid[this.row][this.col + 1].hasFocus();
        }

        public boolean isLeftComponentFocused() {
            if (this.col == 0) {
                return false;
            }
            return this.grid.grid[this.row][this.col - 1].hasFocus();
        }

        public boolean isTopComponentFocused() {
            if (this.row == 0) {
                return false;
            }
            return this.grid.grid[this.row - 1][this.col].hasFocus();
        }

        public Dimension getMinimumSize() {
            return new Dimension(20, 20);
        }
    }

    private class SGrid
    extends JPanel {
        SCase[][] grid;
        private StateModel sm;

        public SGrid(StateModel sm) {
            this.sm = sm;
            this.initComponents();
        }

        public int getHeight() {
            return super.getWidth();
        }

        protected void initComponents() {
            this.setLayout(new GridLayout(9, 9, 0, 0));
            this.grid = new SCase[9][9];
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.grid[i][j] = new SCase(this.sm, this, i, j);
                    this.add(this.grid[i][j]);
                }
            }
        }

        public void notifyFocusGained(int row, int col) {
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.grid[i][j].setSelected(i == row || j == col || DlgCore.isInSameSquare(i, j, row, col));
                    this.grid[i][j].setHadFocus(row == i && col == j);
                }
            }
            this.paintImmediately(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }

        public void checkGridFinished() {
            boolean gridFilled = true;
            block0: for (int i = 0; i < 9 && gridFilled; ++i) {
                for (int j = 0; j < 9; ++j) {
                    String s = this.sm.getValueAt(i, j);
                    if (s != null) continue;
                    gridFilled = false;
                    continue block0;
                }
            }
            if (gridFilled) {
                JOptionPane.showMessageDialog(this.getParent(), "F\u00e9licitations !");
            }
        }

        public void highLight(String s) {
            int j;
            int i;
            for (i = 0; i < 9; ++i) {
                for (j = 0; j < 9; ++j) {
                    this.grid[i][j].setSelected(this.sm.getValueAt(i, j) == null);
                }
            }
            for (i = 0; i < 9; ++i) {
                for (j = 0; j < 9; ++j) {
                    if (!s.equals(this.sm.getValueAt(i, j))) continue;
                    for (int k = 0; k < 9; ++k) {
                        this.grid[i][k].setSelected(false);
                        this.grid[k][j].setSelected(false);
                    }
                    int xStart = (int)Math.floor((float)i / 3.0f) * 3;
                    int yStart = (int)Math.floor((float)j / 3.0f) * 3;
                    int xEnd = xStart + 3;
                    int yEnd = yStart + 3;
                    for (int i1 = xStart; i1 < xEnd; ++i1) {
                        for (int j1 = yStart; j1 < yEnd; ++j1) {
                            this.grid[i1][j1].setSelected(false);
                        }
                    }
                }
            }
            this.paintImmediately(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
    }
}

