/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.ia.core;

import fr.gouv.finances.cp.xemelios.ui.ia.core.ISolverListener;
import fr.gouv.finances.cp.xemelios.ui.ia.core.NoSymetrizer;
import fr.gouv.finances.cp.xemelios.ui.ia.core.RandomTool;
import fr.gouv.finances.cp.xemelios.ui.ia.core.Solver;
import fr.gouv.finances.cp.xemelios.ui.ia.core.State;
import fr.gouv.finances.cp.xemelios.ui.ia.core.Symetrizer;
import fr.gouv.finances.cp.xemelios.ui.ia.core.Template;
import java.util.ArrayList;

public class Builder
extends RandomTool
implements ISolverListener {
    State _initialPosition = null;
    State _solution;
    private boolean _noRemove;
    private int _count;
    private int _opsCount;
    private int _maxValue;
    private int _maxIndex;
    private Symetrizer _symetrizer;

    public State buildOne(Template tpl_p) {
        this._initialPosition = new State(tpl_p);
        this._maxIndex = this._initialPosition.getTemplate().maxIndex;
        this._maxValue = this._initialPosition.getTemplate().maxValue;
        this._symetrizer = tpl_p.symetrical ? new Symetrizer(tpl_p) : new NoSymetrizer(tpl_p);
        this.initializeState();
        this._solution = null;
        Solver solver = new Solver(this);
        while (this._solution == null) {
            this._noRemove = false;
            this._opsCount = this.getMaxOpsCount(tpl_p);
            solver.solve(this._initialPosition);
            if (this._solution != null || this._noRemove) continue;
            this.removeFromInitialPosition();
        }
        State output = new State(this._initialPosition);
        output.registerOriginalPosition();
        return output;
    }

    private int getMaxOpsCount(Template tpl_p) {
        int size = tpl_p.maxValue;
        int base = 1000000;
        if (size < 10) {
            return base;
        }
        if (size < 13) {
            return base * 10;
        }
        return base * 100;
    }

    private void initializeState() {
        int i;
        this._count = 0;
        ArrayList<Integer> columns = new ArrayList<Integer>();
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (i = 0; i < this._maxValue; ++i) {
            columns.add(new Integer(i));
            rows.add(new Integer(i));
        }
        for (i = 0; i < this._maxValue; ++i) {
            int l = this.random(rows);
            int c = this.random(columns);
            int index = l * this._maxValue + c;
            int symIndex = this._symetrizer.getIndex(index);
            int dontRunAllNight = this._maxValue;
            while (this._initialPosition.isFree(index) && this._initialPosition.isFree(symIndex) && dontRunAllNight-- > 0) {
                int value = this.random(this._maxValue);
                if (!this._initialPosition.isAllowed(index, value)) continue;
                if (this._initialPosition.playWhilePossible(index, value)) {
                    ++this._count;
                    if (symIndex == index) continue;
                    boolean rewind = true;
                    for (int maxTry = this._maxValue * 2; maxTry > 0; --maxTry) {
                        value = this.random(this._maxValue);
                        if (!this._initialPosition.isAllowed(symIndex, value)) continue;
                        if (this._initialPosition.playWhilePossible(symIndex, value)) {
                            ++this._count;
                            rewind = false;
                            break;
                        }
                        this._initialPosition.clean(symIndex);
                    }
                    if (!rewind) continue;
                    this._initialPosition.clean(index);
                    this._initialPosition.clearMarks();
                    --this._count;
                    continue;
                }
                this._initialPosition.clean(index);
            }
        }
    }

    private void removeFromInitialPosition() {
        ArrayList<Integer> candidates = new ArrayList<Integer>();
        for (int i = 0; i < this._maxIndex; ++i) {
            if (this._initialPosition.isFree(i)) continue;
            candidates.add(new Integer(i));
        }
        int index = this.random(candidates);
        --this._count;
        this._initialPosition.clean(index);
        int symIndex = this._symetrizer.getIndex(index);
        if (symIndex != index) {
            --this._count;
            this._initialPosition.clean(symIndex);
        }
        this._initialPosition.clearMarks();
    }

    public boolean foundASolution(State state_p) {
        if (this._solution == null) {
            this._solution = new State(state_p);
            return true;
        }
        this.addAMoveToOriginalPosition(state_p);
        this._solution = null;
        this._noRemove = true;
        return false;
    }

    private void addAMoveToOriginalPosition(State state_p) {
        ArrayList<Integer> candidates = new ArrayList<Integer>();
        for (int i = 0; i < this._maxIndex; ++i) {
            if (state_p.getValue(i) == this._solution.getValue(i)) continue;
            candidates.add(new Integer(i));
        }
        int index = this.random(candidates);
        ++this._count;
        this._initialPosition.play(index, state_p.getValue(index));
        int symIndex = this._symetrizer.getIndex(index);
        if (symIndex != index) {
            ++this._count;
            this._initialPosition.play(symIndex, state_p.getValue(symIndex));
        }
    }

    public boolean levelIs(int level_p, State state_p) {
        --this._opsCount;
        if (this._opsCount % 1000000 == 0) {
            // empty if block
        }
        boolean giveUp = this._opsCount < 0 && this._solution == null;
        return !giveUp;
    }
}

