/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.ia;

import fr.gouv.finances.cp.xemelios.ui.ia.Plateau;
import java.awt.Color;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class Joueur {
    private static int[][] vrx = new int[3][3];
    private static int[][] vry = new int[3][3];
    private int[][] rep = new int[10][10];
    private int[][] val = new int[10][10];
    private String marque;
    private Icon icon;

    public Joueur(String s, Icon icon) {
        this.marque = s;
        this.icon = icon;
    }

    public void joue(JPanel jPanelJeu) {
        this.modelise(jPanelJeu);
        this.decide(jPanelJeu);
    }

    public int sgn(int i) {
        return i == 0 ? 0 : (i < 0 ? -1 : 1);
    }

    public int compte_pion(int dx, int dy, int fx, int fy, int v) {
        boolean cnt = true;
        int cpt = 0;
        while ((dx != fx || dy != fy) && cnt) {
            dx += this.sgn(fx - dx);
            dy += this.sgn(fy - dy);
            if (dx >= 0 && dx <= 9 && dy >= 0 && dy <= 9 && this.rep[dx][dy] == v) {
                ++cpt;
                continue;
            }
            cnt = false;
        }
        return cpt;
    }

    public int compte_case(int dx, int dy, int fx, int fy) {
        int cpt = 0;
        if (dx >= 0 && dx <= 9 && dy >= 0 && dy <= 9) {
            ++cpt;
        }
        while (dx != fx || dy != fy) {
            dx += this.sgn(fx - dx);
            dy += this.sgn(fy - dy);
            if (dx < 0 || dx > 9 || dy < 0 || dy > 9) continue;
            ++cpt;
        }
        return cpt;
    }

    public int evalue(int dx, int dy, int fx, int fy, int v) {
        boolean cnt = true;
        int cpt = 0;
        int ind = 0;
        while ((dx != fx || dy != fy) && cnt) {
            dx += this.sgn(fx - dx);
            dy += this.sgn(fy - dy);
            ++ind;
            if (dx >= 0 && dx <= 9 && dy >= 0 && dy <= 9 && this.rep[dx][dy] == v) {
                cpt += this.rep[dx][dy] * (5 - ind);
                continue;
            }
            if (dx >= 0 && dx <= 9 && dy >= 0 && dy <= 9) {
                cnt = this.rep[dx][dy] == 0;
                cpt += this.rep[dx][dy] * (5 - ind);
                continue;
            }
            cnt = false;
        }
        return cpt;
    }

    public void valorise(int x, int y) {
        for (int i = 0; i < 4; ++i) {
            int cpt = 1;
            cpt += this.compte_pion(x, y, vrx[i % 3][i / 3] + x, vry[i % 3][i / 3] + y, this.rep[x][y]);
            if ((cpt += this.compte_pion(x, y, vrx[(8 - i) % 3][(8 - i) / 3] + x, vry[(8 - i) % 3][(8 - i) / 3] + y, this.rep[x][y])) <= Math.abs(this.val[x][y])) continue;
            this.val[x][y] = cpt;
        }
    }

    public void modelise(JPanel jp) {
        int i;
        for (i = 0; i < jp.getComponentCount(); ++i) {
            ((JButton)jp.getComponent(i)).setBackground(Plateau.BACK_COLOR);
            this.rep[i % 10][i / 10] = ((JButton)jp.getComponent(i)).getActionCommand() == "" ? 0 : (((JButton)jp.getComponent(i)).getActionCommand() == this.marque ? 1 : -1);
        }
        for (i = 0; i < 10; ++i) {
            Arrays.fill(this.val[i], 0);
        }
    }

    public void projete(int x, int y) {
        for (int i = 0; i < 4; ++i) {
            int pls = 0;
            int mns = 0;
            if (this.compte_case(vrx[i % 3][i / 3] + x, vry[i % 3][i / 3] + y, vrx[(8 - i) % 3][(8 - i) / 3] + x, vry[(8 - i) % 3][(8 - i) / 3] + y) >= 5) {
                mns += this.evalue(x, y, vrx[i % 3][i / 3] + x, vry[i % 3][i / 3] + y, -1);
                mns += this.evalue(x, y, vrx[(8 - i) % 3][(8 - i) / 3] + x, vry[(8 - i) % 3][(8 - i) / 3] + y, -1);
                pls += this.evalue(x, y, vrx[i % 3][i / 3] + x, vry[i % 3][i / 3] + y, 1);
                pls += this.evalue(x, y, vrx[(8 - i) % 3][(8 - i) / 3] + x, vry[(8 - i) % 3][(8 - i) / 3] + y, 1);
            }
            if (Math.abs(mns) > Math.abs(this.val[x][y])) {
                this.val[x][y] = mns;
            }
            if (Math.abs(pls) <= Math.abs(this.val[x][y])) continue;
            this.val[x][y] = pls;
        }
    }

    public void decide(JPanel jPanelJeu) {
        int j;
        int i;
        int scr = 0;
        int scp = 50;
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 10; ++j) {
                if (this.rep[j][i] != 0) continue;
                this.projete(j, i);
            }
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 10; ++j) {
                if (this.rep[j][i] != 0) continue;
                if (Math.abs(this.val[j][i]) > scr) {
                    scr = Math.abs(this.val[j][i]);
                    scp = j + i * 10;
                    continue;
                }
                if (Math.abs(this.rep[j][i]) != scr || this.val[j][i] < this.val[scp % 10][scp / 10]) continue;
                scp = j + i * 10;
            }
        }
        this.rep[scp % 10][scp / 10] = 1;
        ((JButton)jPanelJeu.getComponent(scp)).setActionCommand(this.marque);
        ((JButton)jPanelJeu.getComponent(scp)).setIcon(this.icon);
        ((JButton)jPanelJeu.getComponent(scp)).setForeground(Color.red);
        ((JButton)jPanelJeu.getComponent(scp)).setBackground(Color.white);
    }

    public boolean victoire(JPanel jp) {
        int j;
        int i;
        boolean cnt = false;
        for (i = 0; i < jp.getComponentCount(); ++i) {
            this.rep[i % 10][i / 10] = ((JButton)jp.getComponent(i)).getActionCommand() == "" ? 0 : (((JButton)jp.getComponent(i)).getActionCommand() == this.marque ? 1 : -1);
        }
        for (i = 0; i < 10; ++i) {
            Arrays.fill(this.val[i], 0);
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 10; ++j) {
                if (this.rep[j][i] == 0) continue;
                this.valorise(j, i);
            }
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 10; ++j) {
                if (Math.abs(this.val[j][i]) != 5) continue;
                ((JButton)jp.getComponent(j + i * 10)).setBackground(Color.white);
                cnt = true;
            }
        }
        return cnt;
    }

    public String getMarque() {
        return this.marque;
    }

    public Icon getIcon() {
        return this.icon;
    }

    static {
        for (int i = 0; i < 9; ++i) {
            Joueur.vrx[i % 3][i / 3] = 4 * (i % 3 - 1);
            Joueur.vry[i % 3][i / 3] = 4 * (i / 3 - 1);
        }
    }
}

