/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.admin;

import fr.gouv.finances.cp.utils.PropertiesExpansion;
import fr.gouv.finances.cp.xemelios.common.Scramble;
import fr.gouv.finances.cp.xemelios.ui.admin.ParamSaver;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;

public class PnlProxy
extends JPanel
implements ParamSaver {
    private static final String URL_TO_REACH = "http://www.xemelios.org/updates33/update.xml";
    private static final Logger logger = Logger.getLogger(PnlProxy.class);
    private JCheckBox chkAuthenticationRequired;
    private JCheckBox chkUseProxy;
    private JPasswordField dfProxyPassword;
    private JTextField dfProxyPort;
    private JTextField dfProxyServer;
    private JTextField dfProxyUser;
    private JLabel lblPassword;
    private JLabel lblPort;
    private JLabel lblServer;
    private JLabel lblUser;
    private JButton pbLoadOld;
    private JButton pbTest;

    public PnlProxy() {
        this.initComponents();
        this.initValues();
    }

    private void initValues() {
        String proxyServer = System.getProperty("xemelios.proxy.server");
        String proxyPort = System.getProperty("xemelios.proxy.port");
        String proxyUser = System.getProperty("xemelios.proxy.user");
        String proxyPassword = System.getProperty("xemelios.proxy.password");
        this.setValues(proxyServer, proxyPort, proxyUser, proxyPassword);
    }

    private void setValues(String server, String port, String user, String password) {
        if (server != null) {
            this.dfProxyServer.setText(server);
            this.chkUseProxy.setSelected(true);
        } else {
            this.dfProxyServer.setText("");
            this.chkUseProxy.setSelected(false);
        }
        this.enableProxyControls(this.chkUseProxy.isSelected());
        this.dfProxyPort.setText(port != null ? port : "");
        if (user != null) {
            this.dfProxyUser.setText(user);
            this.chkAuthenticationRequired.setSelected(true);
        } else {
            this.dfProxyUser.setText("");
            this.chkAuthenticationRequired.setSelected(false);
        }
        this.enableAuthenticationControls(this.chkAuthenticationRequired.isSelected());
        this.dfProxyPassword.setText(password != null ? Scramble.unScramblePassword(password) : "");
    }

    private void runTest() {
        String proxyHost = null;
        String proxyPort = null;
        String proxyUser = null;
        String proxyPasswd = null;
        int intProxyPort = 0;
        if (this.dfProxyServer.getText() != null && this.dfProxyServer.getText().length() > 0) {
            proxyHost = this.dfProxyServer.getText();
        }
        if (this.dfProxyPort.getText() != null && this.dfProxyPort.getText().length() > 0) {
            proxyPort = this.dfProxyPort.getText();
        }
        if (this.dfProxyUser.getText() != null && this.dfProxyUser.getText().length() > 0) {
            proxyUser = this.dfProxyUser.getText();
        }
        if (this.dfProxyPassword.getPassword().length > 0) {
            proxyPasswd = new String(this.dfProxyPassword.getPassword());
        }
        if (proxyPort != null) {
            try {
                intProxyPort = Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException nfEx) {
                JOptionPane.showMessageDialog(this, proxyPort + " n'est pas un num\u00e9ro de port valide.", "ERREUR", 0);
                return;
            }
        }
        URL url = null;
        try {
            url = new URL(URL_TO_REACH);
        }
        catch (MalformedURLException muEx) {
            JOptionPane.showMessageDialog(this, "URL not valid : http://www.xemelios.org/updates33/update.xml", "ERROR", 0);
            return;
        }
        HttpClient client = new HttpClient();
        HostConfiguration hc = new HostConfiguration();
        if (proxyHost != null) {
            hc.setProxy(proxyHost, intProxyPort);
            client.setHostConfiguration(hc);
        }
        if (proxyUser != null) {
            client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPasswd));
        }
        GetMethod meth = new GetMethod(URL_TO_REACH);
        int ret = 0;
        try {
            ret = client.executeMethod((HttpMethod)meth);
            if (ret > 300) {
                JOptionPane.showMessageDialog(this, " " + ret + " : " + meth.getStatusText(), "ERREUR", 0);
                return;
            }
            String resp = meth.getResponseBodyAsString();
            JOptionPane.showMessageDialog(this, "Connexion r\u00e9ussie !", "Ok, \u00e7a marche...", 1);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, t.getMessage(), t.getClass().getName(), 0);
        }
    }

    private void initComponents() {
        this.chkAuthenticationRequired = new JCheckBox();
        this.chkUseProxy = new JCheckBox();
        this.pbTest = new JButton();
        this.lblServer = new JLabel();
        this.dfProxyServer = new JTextField();
        this.lblPort = new JLabel();
        this.dfProxyPort = new JTextField();
        this.lblUser = new JLabel();
        this.dfProxyUser = new JTextField();
        this.lblPassword = new JLabel();
        this.dfProxyPassword = new JPasswordField();
        this.pbLoadOld = new JButton();
        this.chkAuthenticationRequired.setText("Mon serveur proxy requiert une authentification");
        this.chkAuthenticationRequired.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkAuthenticationRequired.setMargin(new Insets(0, 0, 0, 0));
        this.chkAuthenticationRequired.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PnlProxy.this.chkAuthenticationRequiredActionPerformed(evt);
            }
        });
        this.chkUseProxy.setText("J'utilise un serveur proxy pour me connecter \u00e0 internet");
        this.chkUseProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkUseProxy.setMargin(new Insets(0, 0, 0, 0));
        this.chkUseProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PnlProxy.this.chkUseProxyActionPerformed(evt);
            }
        });
        this.pbTest.setText("Tester");
        this.pbTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PnlProxy.this.pbTestActionPerformed(evt);
            }
        });
        this.lblServer.setText("Serveur");
        this.lblPort.setText("Port");
        this.lblUser.setText("Utilisateur");
        this.lblPassword.setText("Mot de passe");
        this.pbLoadOld.setText("Charger l'ancien param\u00e9trage");
        this.pbLoadOld.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PnlProxy.this.pbLoadOldActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.pbTest).addPreferredGap(0, 121, Short.MAX_VALUE).add((Component)this.pbLoadOld)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblUser).add((Component)this.lblPassword)).add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.dfProxyUser, -1, 298, Short.MAX_VALUE).add((Component)this.dfProxyPassword, -1, 298, Short.MAX_VALUE))).add(1, (Component)this.chkAuthenticationRequired))).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(29, 29, 29).add((Component)this.lblServer).addPreferredGap(0).add((Component)this.dfProxyServer, -1, 245, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lblPort)).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.chkUseProxy))).addPreferredGap(0).add((Component)this.dfProxyPort, -2, 40, -2).add(1, 1, 1))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.chkUseProxy).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblServer).add((Component)this.dfProxyServer, -2, -1, -2).add((Component)this.lblPort).add((Component)this.dfProxyPort, -2, -1, -2)).add(16, 16, 16).add((Component)this.chkAuthenticationRequired).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblUser).add((Component)this.dfProxyUser, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblPassword).add((Component)this.dfProxyPassword, -2, -1, -2)).addPreferredGap(0, 44, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.pbTest).add((Component)this.pbLoadOld)).addContainerGap()));
    }

    private void pbLoadOldActionPerformed(ActionEvent evt) {
        this.setValues(System.getProperty("http.proxyHost"), System.getProperty("http.proxyPort"), null, null);
    }

    private void pbTestActionPerformed(ActionEvent evt) {
        this.runTest();
    }

    private void chkUseProxyActionPerformed(ActionEvent evt) {
        boolean selected = this.chkUseProxy.isSelected();
        this.enableProxyControls(selected);
    }

    private void chkAuthenticationRequiredActionPerformed(ActionEvent evt) {
        boolean selected = this.chkAuthenticationRequired.isSelected();
        this.enableAuthenticationControls(selected);
    }

    private void enableProxyControls(boolean state) {
        this.lblServer.setEnabled(state);
        this.dfProxyServer.setEnabled(state);
        this.lblPort.setEnabled(state);
        this.dfProxyPort.setEnabled(state);
        this.chkAuthenticationRequired.setEnabled(state);
        if (state) {
            this.enableAuthenticationControls(this.chkAuthenticationRequired.isSelected());
        } else {
            this.enableAuthenticationControls(false);
        }
    }

    private void enableAuthenticationControls(boolean state) {
        this.lblUser.setEnabled(state);
        this.dfProxyUser.setEnabled(state);
        this.lblPassword.setEnabled(state);
        this.dfProxyPassword.setEnabled(state);
    }

    public void saveConfiguration() {
        PropertiesExpansion props = new PropertiesExpansion(System.getProperties());
        Properties xemProps = new Properties();
        File xemPropsFile = new File(props.replace("${xemelios.prg}/root/xemelios.properties"));
        logger.debug((Object)("xemPropsFile is " + xemPropsFile.getPath()));
        if (xemPropsFile.exists()) {
            try {
                xemProps.load(new FileInputStream(xemPropsFile));
                String proxyHost = null;
                String proxyPort = null;
                String proxyUser = null;
                String proxyPasswd = null;
                if (this.dfProxyServer.getText() != null && this.dfProxyServer.getText().length() > 0) {
                    proxyHost = this.dfProxyServer.getText();
                }
                if (this.dfProxyPort.getText() != null && this.dfProxyPort.getText().length() > 0) {
                    proxyPort = this.dfProxyPort.getText();
                }
                if (this.dfProxyUser.getText() != null && this.dfProxyUser.getText().length() > 0) {
                    proxyUser = this.dfProxyUser.getText();
                }
                if (this.dfProxyPassword.getPassword().length > 0) {
                    proxyPasswd = new String(this.dfProxyPassword.getPassword());
                }
                if (proxyHost != null) {
                    xemProps.put("xemelios.proxy.server", proxyHost);
                    xemProps.put("xemelios.proxy.port", proxyPort);
                    System.setProperty("xemelios.proxy.server", proxyHost);
                    System.setProperty("xemelios.proxy.port", proxyPort);
                    if (proxyUser != null) {
                        xemProps.put("xemelios.proxy.user", proxyUser);
                        xemProps.put("xemelios.proxy.password", Scramble.scramblePassword(proxyPasswd));
                        System.setProperty("xemelios.proxy.user", proxyUser);
                        System.setProperty("xemelios.proxy.password", Scramble.scramblePassword(proxyPasswd));
                    } else {
                        xemProps.remove("xemelios.proxy.user");
                        xemProps.remove("xemelios.proxy.password");
                        System.getProperties().remove("xemelios.proxy.user");
                        System.getProperties().remove("xemelios.proxy.password");
                    }
                } else {
                    xemProps.remove("xemelios.proxy.server");
                    xemProps.remove("xemelios.proxy.port");
                    xemProps.remove("xemelios.proxy.user");
                    xemProps.remove("xemelios.proxy.password");
                    System.getProperties().remove("xemelios.proxy.server");
                    System.getProperties().remove("xemelios.proxy.port");
                    System.getProperties().remove("xemelios.proxy.user");
                    System.getProperties().remove("xemelios.proxy.password");
                }
                xemProps.store(new FileOutputStream(xemPropsFile), "");
            }
            catch (IOException ioEx) {
                logger.error((Object)"while saving proxy configuration: ", (Throwable)ioEx);
            }
        }
    }
}

