/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.common.config.Loader;
import fr.gouv.finances.cp.xemelios.controls.editors.EditorHtmlViewer;
import fr.gouv.finances.cp.xemelios.ui.AskDocumentType;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ViewXemeliosDocument {
    private DocumentsModel config = null;
    public static final transient String USAGE = "ViewXemeliosDocument [<fileToDisplay> [docId]]\nwhere\n\t<fileToDisplay> is the file to display\n\tdocId is the id of doc-type.\n";

    private void init() throws Exception {
        this.config = Loader.getDocumentsInfos(System.getProperty("xemelios.documents.def.dir"));
    }

    public ViewXemeliosDocument() throws Exception {
        this.init();
        JFileChooser jfc = new JFileChooser(System.getProperty("user.home"));
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".xml");
            }

            public String getDescription() {
                return "Fichiers XML";
            }
        });
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return true;
            }

            public String getDescription() {
                return "Tous les fichiers";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            File f = jfc.getSelectedFile();
            AskDocumentType adt = new AskDocumentType(null, f.getName(), this.config);
            adt.setVisible(true);
            DocumentModel dm = adt.getDocumentType();
            this.openFile(f.getAbsolutePath(), dm.getId());
        }
    }

    public ViewXemeliosDocument(String inFileName) throws Exception {
        this.init();
        AskDocumentType adt = new AskDocumentType(null, inFileName, this.config);
        adt.setVisible(true);
        DocumentModel dm = adt.getDocumentType();
        this.openFile(inFileName, dm.getId());
    }

    public ViewXemeliosDocument(String inFileName, String docId) throws Exception {
        this.init();
        this.openFile(inFileName, docId);
    }

    protected void openFile(String inFileName, String docId) throws Exception {
        DocumentModel docConfig = this.config.getDocumentById(docId);
        if (docConfig == null) {
            JOptionPane.showMessageDialog(null, docId + ": configuration non trouv\u00e9e.", "Erreur", 0);
            return;
        }
        Hashtable<String, File> documents = new Hashtable<String, File>();
        StringBuffer uri = new StringBuffer();
        File fileToRead = new File(inFileName);
        File fichierEnrichi = null;
        if (docConfig.getGlobalImportXsltFile() != null) {
            fichierEnrichi = new File(new File(System.getProperty("java.io.tmpdir")), "_" + fileToRead.getName() + "_");
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer tr = tFactory.newTransformer(new StreamSource(new File(docConfig.getBaseDirectory(), docConfig.getGlobalImportXsltFile())));
            StreamResult result = new StreamResult(fichierEnrichi);
            tr.transform(new StreamSource(fileToRead), result);
            result.getOutputStream().flush();
            result.getOutputStream().close();
        } else {
            fichierEnrichi = fileToRead;
        }
        documents.put(docId, fichierEnrichi);
        uri.append("xemelios:/query?docId=" + docId + "&etatId=" + docConfig.getDefaultEtatGlobal());
        EditorHtmlViewer ehv = new EditorHtmlViewer(documents, this.config, uri.toString());
        ehv.setLocationRelativeTo(null);
        ehv.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            if (args.length > 1 && !args[0].equals("") && !args[1].equals("")) {
                new ViewXemeliosDocument(args[0], args[1]);
            } else if (args.length >= 1 && !args[0].equals("")) {
                new ViewXemeliosDocument(args[0]);
            } else {
                new ViewXemeliosDocument();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

