/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.RechercheModel;
import fr.gouv.finances.cp.xemelios.ui.ListDisplayable;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DlgSelectRequest
extends JDialog {
    private static final long serialVersionUID = 3256721779816151348L;
    private static final Logger logger = Logger.getLogger(DlgSelectRequest.class);
    private Action escapeAction;
    private Vector<? extends Object> data;
    private boolean ret = false;
    private JList list = null;
    private MainWindow parentFrame = null;
    private ElementModel elementModel = null;
    private static ImageIcon searchSaved;
    private static ImageIcon searchPlugin;
    private static ImageIcon exportPlugin;

    public DlgSelectRequest(MainWindow parent, Vector<? extends ListDisplayable> data, ElementModel elementModel) {
        super((Frame)parent, true);
        this.data = data;
        this.parentFrame = parent;
        this.elementModel = elementModel;
        this.initComponents();
    }

    protected void initComponents() {
        int sepInfo = 2;
        int lineInfo = sepInfo + 2;
        int sepData = lineInfo + 2;
        int listLine = sepData + 2;
        int buttonLine1 = listLine + 2;
        JTextArea area = null;
        FormLayout fl = new FormLayout("3dlu,20dlu,160dlu,3dlu", "7dlu,pref,3dlu,pref,7dlu,pref,3dlu,90dlu,7dlu,pref,7dlu");
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(fl);
        this.list = new JList<Object>(this.data);
        pb.addSeparator("Informations", cc.xyw(2, sepInfo, 2));
        area = new JTextArea();
        pb.add((Component)area, cc.xy(3, lineInfo));
        pb.addSeparator("Recherches", cc.xyw(2, sepData, 2));
        pb.add((Component)new JScrollPane(this.list), cc.xy(3, listLine, "fill, fill"));
        final JButton pbOk = new JButton("Ok");
        JPanel bPane = new JPanel(new FlowLayout(1));
        bPane.add(pbOk);
        JButton pbCancel = new JButton(this.escapeAction);
        bPane.add(pbCancel);
        pb.add((Component)bPane, cc.xyw(2, buttonLine1, 2));
        area.setEditable(false);
        area.setLineWrap(true);
        area.setRows(3);
        area.setBackground(this.getBackground());
        area.setText("S\u00e9lectionnez dans la liste ci-dessous\nla recherche que vous souhaitez r\u00e9afficher.");
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new MyCellRenderer());
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2 && evt.getButton() == 1) {
                    pbOk.doClick();
                } else if (evt.getClickCount() == 1 && (evt.getButton() == 2 || evt.getButton() == 3)) {
                    Point clickPos = evt.getPoint();
                    int index = DlgSelectRequest.this.list.locationToIndex(clickPos);
                    final ListDisplayable ld = (ListDisplayable)DlgSelectRequest.this.list.getModel().getElementAt(index);
                    if (ld.isDeletable()) {
                        JPopupMenu pm = new JPopupMenu();
                        JMenuItem mnu = new JMenuItem("Supprimer cette requ\u00eate");
                        mnu.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                if (JOptionPane.showConfirmDialog(DlgSelectRequest.this, "Voulez-vous vraiment supprimer cette requ\u00eate :\n" + ld.getDisplayName() + " ?") == 0) {
                                    logger.debug((Object)"suppression");
                                    RechercheModel rm = (RechercheModel)ld;
                                    DlgSelectRequest.this.parentFrame.getSavedRequest(DlgSelectRequest.this.elementModel).delete(rm);
                                    DlgSelectRequest.this.data.remove(rm);
                                    DlgSelectRequest.this.list.setListData(DlgSelectRequest.this.data);
                                }
                            }
                        });
                        pm.add(mnu);
                        pm.show(DlgSelectRequest.this.list, clickPos.x, clickPos.y);
                    }
                }
            }
        });
        this.getRootPane().setDefaultButton(pbCancel);
        this.setContentPane(pb.getPanel());
        pbOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (DlgSelectRequest.this.list.getSelectedValue() != null) {
                    DlgSelectRequest.this.ret = true;
                    DlgSelectRequest.this.setVisible(false);
                }
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean run() {
        this.setVisible(true);
        return this.ret;
    }

    public Object getSelectedItem() {
        return this.list.getSelectedValue();
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractAction("Annuler"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                DlgSelectRequest.this.setVisible(false);
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ks, 2);
        return rp;
    }

    static {
        exportPlugin = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/list-export-plug.png");
        searchPlugin = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/list-search-plug.png");
        searchSaved = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/list-search-saved.png");
    }

    private class MyCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel ancestor = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ListDisplayable ld = (ListDisplayable)value;
            ImageIcon ii = null;
            JLabel ret = null;
            if (ld.getResource() == null) {
                ret = new JLabel(ld.getDisplayName());
            } else if (ld.getResource().equals("fr/gouv/finances/cp/xemelios/ui/resources/list-export-plug.png")) {
                ii = exportPlugin;
            } else if (ld.getResource().equals("fr/gouv/finances/cp/xemelios/ui/resources/list-search-plug.png")) {
                ii = searchPlugin;
            } else if (ld.getResource().equals("fr/gouv/finances/cp/xemelios/ui/resources/list-search-saved.png")) {
                ii = searchSaved;
            }
            ret = new JLabel(ld.getDisplayName(), ii, 2);
            ret.setBorder(ancestor.getBorder());
            ret.setBackground(ancestor.getBackground());
            ret.setForeground(ancestor.getForeground());
            return ret;
        }
    }
}

