/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.data.DatabaseTreeDataDonnee;
import fr.gouv.finances.cp.xemelios.data.ExportableData;
import fr.gouv.finances.cp.xemelios.data.WaitableUI;
import fr.gouv.finances.cp.xemelios.ui.DlgChooseDocuments;
import fr.gouv.finances.cp.xemelios.ui.PanelChooseDatabaseDonnees;
import fr.gouv.finances.cp.xemelios.ui.PanelChooseDatabaseFichier;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdesktop.swingworker.SwingWorker;

public class DlgCleanDatabase
extends DlgChooseDocuments
implements WaitableUI {
    private static Logger logger = Logger.getLogger(DlgCleanDatabase.class);

    public DlgCleanDatabase(Frame parent, boolean modal, DocumentsModel _dm) {
        super(parent, modal, _dm, true);
        this.setTitle("Suppression");
        this.setBActionLibelle("Supprimer");
        this.setVisible(true);
    }

    protected void doAction(ActionEvent evt) {
        if (this.getJTabbedPane1().getSelectedComponent() instanceof PanelChooseDatabaseDonnees) {
            this.purge(((PanelChooseDatabaseDonnees)this.getJTabbedPane1().getSelectedComponent()).getJTree1().getSelectionPath());
        }
        if (this.getJTabbedPane1().getSelectedComponent() instanceof PanelChooseDatabaseFichier) {
            this.purgeFichiers();
        }
    }

    protected void purgeFichiers() {
        if (JOptionPane.showConfirmDialog(this, "Etes-vous sur de vouloir supprimer les informations d\u00e9finitivement ?\n\nCette op\u00e9ration peut prendre beaucoup de temps\nsi le nombre d'\u00e9l\u00e9ments \u00e0 supprimer est important.", "Suppression", 0) == 0) {
            ExportableData datas = ((PanelChooseDatabaseFichier)this.getJTabbedPane1().getSelectedComponent()).getData().getData();
            for (ExportableData d : datas.getChilds()) {
                this.inspectSelectionOfChilds(d);
                this.purgeData(d);
            }
        }
    }

    protected boolean inspectSelectionOfChilds(ExportableData d) {
        if (d.getChilds().size() == 0) {
            return d.isSelected();
        }
        boolean hasAllChildsSelected = true;
        for (ExportableData dd : d.getChilds()) {
            hasAllChildsSelected &= this.inspectSelectionOfChilds(dd);
        }
        d.setSelected(d.isSelected() || hasAllChildsSelected);
        return hasAllChildsSelected;
    }

    protected void purgeData(ExportableData datas) {
        if (datas.isSelected()) {
            this.doSuppressData(datas);
        } else {
            for (ExportableData d : datas.getChilds()) {
                this.purgeData(d);
            }
        }
    }

    public void doSuppressData(ExportableData d) {
        Runnable process = null;
        switch (d.getLevel()) {
            case 1: {
                final DocumentModel dm = this.getDm().getDocumentById(d.getKey());
                logger.debug((Object)("deleting DOC : " + dm.getId()));
                process = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeDocumentModel(dm);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                        finally {
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                    }
                };
                break;
            }
            case 2: {
                StringTokenizer st = new StringTokenizer(d.getKey(), "|");
                final DocumentModel dm = this.getDm().getDocumentById(st.nextToken());
                final Pair collectivite = new Pair(st.nextToken(), "");
                logger.debug((Object)("deleting COL : " + dm.getId() + ", " + collectivite.key));
                process = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeCollectivite(dm, collectivite);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                        finally {
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                    }
                };
                break;
            }
            case 3: {
                StringTokenizer st = new StringTokenizer(d.getKey(), "|");
                final DocumentModel dm = this.getDm().getDocumentById(st.nextToken());
                final Pair collectivite = new Pair(st.nextToken(), "");
                final Pair budget = new Pair(st.nextToken(), "");
                logger.debug((Object)("deleting BUD : " + dm.getId() + ", " + collectivite.key + ", " + budget.key));
                process = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeBudget(dm, collectivite, budget);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                        finally {
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                    }
                };
                break;
            }
            case 6: {
                StringTokenizer st = new StringTokenizer(d.getKey(), "|");
                final DocumentModel dm = this.getDm().getDocumentById(st.nextToken());
                Pair collectivite = new Pair(st.nextToken(), "");
                Pair budget = new Pair(st.nextToken(), "");
                final String fichier = st.nextToken();
                logger.debug((Object)("deleting FIC : " + dm.getId() + ", " + collectivite.key + ", " + budget.key + ", " + fichier));
                process = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeFichier(dm, fichier);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                        finally {
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                    }
                };
                break;
            }
        }
        if (process != null) {
            logger.debug((Object)"deleting");
            Deleter deleter = new Deleter(process, this);
            deleter.execute();
        }
    }

    protected void purge(TreePath tp) {
        if (tp == null) {
            return;
        }
        DatabaseTreeDataDonnee.DataNode node = (DatabaseTreeDataDonnee.DataNode)tp.getLastPathComponent();
        if (JOptionPane.showConfirmDialog(this, "Etes-vous sur de vouloir supprimer les informations\nconcernant " + node + " d\u00e9finitivement ?\n\nCette op\u00e9ration peut prendre beaucoup de temps\nsi le nombre d'\u00e9l\u00e9ments \u00e0 supprimer est important.", "Suppression", 0) == 0) {
            this.purge(node);
        }
    }

    protected void purge(DatabaseTreeDataDonnee.DataNode dn) {
        int level = dn.getType();
        Runnable process = null;
        switch (level) {
            case 1: {
                final DocumentModel dm = (DocumentModel)dn.getData();
                process = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeDocumentModel(dm);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                        finally {
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                    }
                };
                break;
            }
            case 2: {
                final DocumentModel dm = (DocumentModel)dn.getParent().getData();
                final Pair collectivite = (Pair)dn.getData();
                process = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeCollectivite(dm, collectivite);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                        finally {
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                    }
                };
                break;
            }
            case 3: {
                final Pair budget = (Pair)dn.getData();
                final Pair collectivite = (Pair)dn.getParent().getData();
                final DocumentModel dm = (DocumentModel)dn.getParent().getParent().getData();
                process = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeBudget(dm, collectivite, budget);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                        finally {
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                    }
                };
                break;
            }
            case 4: {
                final Pair perso1 = (Pair)dn.getData();
                final Pair budget = (Pair)dn.getParent().getData();
                final Pair collectivite = (Pair)dn.getParent().getParent().getData();
                final DocumentModel dm = (DocumentModel)dn.getParent().getParent().getParent().getData();
                process = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeSpecialKey1(dm, collectivite, budget, perso1);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                        finally {
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                    }
                };
                break;
            }
            case 5: {
                final Pair perso2 = (Pair)dn.getData();
                final Pair perso1 = (Pair)dn.getParent().getData();
                final Pair budget = (Pair)dn.getParent().getParent().getData();
                final Pair collectivite = (Pair)dn.getParent().getParent().getParent().getData();
                final DocumentModel dm = (DocumentModel)dn.getParent().getParent().getParent().getParent().getData();
                process = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeSpecialKey2(dm, collectivite, budget, perso1, perso2);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                        finally {
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                    }
                };
                break;
            }
        }
        if (process != null) {
            logger.debug((Object)"deleting");
            Deleter deleter = new Deleter(process, this);
            deleter.execute();
        }
    }

    private class Deleter
    extends SwingWorker {
        private Runnable process = null;
        private DlgCleanDatabase dlg = null;
        private WaitableUI wui;

        public Deleter(Runnable process, DlgCleanDatabase dlg) {
            this.process = process;
            this.dlg = dlg;
        }

        public String doInBackground() {
            this.dlg.enableButtons(false);
            this.dlg.setCursor(Cursor.getPredefinedCursor(3));
            this.process.run();
            return null;
        }

        public void done() {
            if (DlgCleanDatabase.this.getJTabbedPane1().getSelectedComponent() instanceof PanelChooseDatabaseDonnees) {
                ((PanelChooseDatabaseDonnees)this.dlg.getJTabbedPane1().getSelectedComponent()).getJTree1().setModel(new DatabaseTreeDataDonnee(DlgCleanDatabase.this.getDm(), this.dlg));
            }
            if (DlgCleanDatabase.this.getJTabbedPane1().getSelectedComponent() instanceof PanelChooseDatabaseFichier) {
                ((PanelChooseDatabaseFichier)this.dlg.getJTabbedPane1().getSelectedComponent()).refresh();
            }
            this.dlg.setCursor(Cursor.getDefaultCursor());
            this.dlg.enableButtons(true);
        }
    }
}

