/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.xemelios.auth.XemeliosUser;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class AboutBox
extends JDialog {
    private static final int ADDITIONAL_HEIGHT = 74;
    private static final long serialVersionUID = 3689916175660234039L;

    public AboutBox(Frame owner) {
        super(owner, "A propos... de XEMELIOS");
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 3));
        JLayeredPane layer = new JLayeredPane();
        ImageIcon image = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/montage3.jpg");
        BufferedImage bi = new BufferedImage(image.getIconWidth(), image.getIconHeight() + 74, 6);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.drawImage(image.getImage(), 0, 0, new ImageObserver(){

            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                return true;
            }
        });
        int top = image.getIconHeight();
        int width = image.getIconWidth();
        g.setColor(Color.WHITE);
        g.fillRect(0, top, width, 74);
        g.setColor(Color.BLACK);
        ImageIcon logo = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/logo_editeur.jpg");
        g.drawImage(logo.getImage(), width - logo.getIconWidth() - 2, top + 74 - logo.getIconHeight() - 2, this);
        System.out.println(logo.getIconHeight());
        Font font = g.getFont().deriveFont(1, 12.0f);
        this.ecritLigneCentree(g, this.getVersionText(), 90, width, font, Color.BLACK);
        this.ecritLigneCentree(g, "D\u00e9velopp\u00e9 par axYus", top + 10, width - logo.getIconWidth() - 2, font, Color.BLACK);
        if (this.getParent() instanceof MainWindow) {
            XemeliosUser user = ((MainWindow)this.getParent()).getConnectedUser();
            this.ecritLigneCentree(g, "Utilisateur: " + user.getDescription(), top - 20, width, font, Color.BLACK);
        }
        font = g.getFont().deriveFont(2, 12.0f);
        this.ecritLigneCentree(g, "pour le compte de la Comptabilit\u00e9 Publique", top + 25, width - logo.getIconWidth() - 2, font, Color.BLACK);
        JLabel icon = new JLabel(new ImageIcon(bi));
        icon.setOpaque(true);
        icon.setBounds(0, 0, width, top + 74);
        icon.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 3 && evt.isControlDown() && evt.getClickCount() == 2) {
                    try {
                        Class<?> c = Class.forName("fr.gouv.finances.cp.xemelios.ui.ia.Plateau");
                        c.newInstance();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
        layer.setPreferredSize(new Dimension(width, top + 74));
        JButton pbFermer = new JButton("Fermer");
        pbFermer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AboutBox.this.setVisible(false);
            }
        });
        pbFermer.setBounds((width - pbFermer.getPreferredSize().width - logo.getIconWidth()) / 2, top + 45, (int)pbFermer.getPreferredSize().getWidth(), (int)pbFermer.getPreferredSize().getHeight());
        layer.add((Component)icon, new Integer(0));
        layer.add((Component)pbFermer, new Integer(1));
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 3));
        pane.add(layer);
        pane.setOpaque(true);
        this.setContentPane(pane);
        this.pack();
        this.validate();
        Dimension sSz = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension fSz = this.getSize();
        this.setLocation((sSz.width - fSz.width) / 2, (sSz.height - fSz.height) / 2);
        this.setResizable(false);
        this.setVisible(true);
    }

    protected String getVersionText() {
        String ret = "";
        try {
            BufferedInputStream bis = new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream("fr/gouv/finances/cp/xemelios/ui/resources/release.txt"));
            byte[] buf = new byte[bis.available()];
            bis.read(buf);
            ret = new String(buf);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    protected void ecritLigneCentree(Graphics2D graph, String text, int top, int width, Font font, Color c) {
        Color oldColor = graph.getColor();
        Font oldFont = graph.getFont();
        graph.setFont(font);
        graph.setColor(c);
        FontMetrics fm = graph.getFontMetrics();
        StringTokenizer st = new StringTokenizer(text, " -");
        Vector<String> lignes = new Vector<String>();
        String ligne = null;
        while (st.hasMoreTokens()) {
            int lenLigne;
            String mot = st.nextToken();
            if (fm.stringWidth(mot) > width) {
                throw new IllegalArgumentException("le mot " + mot + " est trop grand; essayez de trouver un autre mot.");
            }
            int n = lenLigne = ligne == null ? fm.stringWidth(mot) : fm.stringWidth(ligne + " " + mot);
            if (lenLigne > width) {
                lignes.add(ligne);
                ligne = mot;
                continue;
            }
            if (ligne == null) {
                ligne = mot;
                continue;
            }
            ligne = ligne + " " + mot;
        }
        if (!"".equals(ligne)) {
            lignes.add(ligne);
        }
        int hauteurLigne = fm.getAscent() + fm.getDescent();
        int interligne = fm.getLeading();
        for (int i = 0; i < lignes.size(); ++i) {
            ligne = (String)lignes.get(i);
            int len = fm.stringWidth(ligne);
            int x = width / 2 - len / 2;
            int y = (i + 1) * interligne + fm.getAscent() + i * hauteurLigne + top;
            graph.drawString(ligne, x, y);
        }
        graph.setFont(oldFont);
        graph.setColor(oldColor);
    }

    public static void main(String[] args) {
        new AboutBox(null);
    }

    static {
        System.out.println(System.getProperty("os.name"));
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            AboutBox.setDefaultLookAndFeelDecorated(true);
        }
    }
}

