/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.importers.docetatProvider;

import fr.gouv.finances.cp.xemelios.common.config.NamespaceModel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceHolder {
    private Hashtable<String, String> prefixToUri = new Hashtable();
    private Hashtable<String, ArrayList<String>> uriToPrefix = new Hashtable();

    public void addMapping(String prefix, String uri) {
        this.prefixToUri.put(prefix, uri);
        ArrayList<String> prefixes = this.uriToPrefix.get(uri);
        if (prefixes == null) {
            prefixes = new ArrayList();
            this.uriToPrefix.put(uri, prefixes);
        }
        if (!prefixes.contains(prefix)) {
            prefixes.add(prefix);
        }
    }

    public void removeMapping(String prefix) {
        String uri = this.prefixToUri.remove(prefix);
        if (uri == null) {
            return;
        }
        ArrayList<String> prefixes = this.uriToPrefix.get(uri);
        if (prefixes != null) {
            prefixes.remove(prefix);
        }
    }

    public String getNamespaceURI(String prefix) {
        String ret = this.prefixToUri.get(prefix);
        return ret;
    }

    public String getPrefix(String namespaceURI) {
        String ret = null;
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI can not be null");
        }
        if ("xml".equals(namespaceURI)) {
            ret = "http://www.w3.org/XML/1998/namespace";
        } else if ("xmlns".equals(namespaceURI)) {
            ret = "http://www.w3.org/2000/xmlns/";
        }
        ArrayList<String> prefixes = this.uriToPrefix.get(namespaceURI);
        if (prefixes != null) {
            ret = prefixes.get(0);
            for (String s : prefixes) {
                if (s.length() >= ret.length()) continue;
                ret = s;
            }
        }
        return ret;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI must not be null");
        }
        ArrayList<String> prefixes = this.uriToPrefix.get(namespaceURI);
        if (prefixes != null) {
            return prefixes.iterator();
        }
        if ("xml".equals(namespaceURI)) {
            return new NamespaceModel.StringIterator<String>("http://www.w3.org/XML/1998/namespace");
        }
        if ("xmlns".equals(namespaceURI)) {
            return new NamespaceModel.StringIterator<String>("http://www.w3.org/2000/xmlns/");
        }
        return null;
    }

    public Set<String> getAllPrefixes() {
        return this.prefixToUri.keySet();
    }
}

