/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.importers.docetatProvider;

import fr.gouv.finances.cp.utils.xml.SAXWriter;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.NSModel;
import fr.gouv.finances.cp.xemelios.importers.docetatProvider.AttributeHolder;
import fr.gouv.finances.cp.xemelios.importers.docetatProvider.AttributesHolder;
import fr.gouv.finances.cp.xemelios.importers.docetatProvider.NamespaceHolder;
import fr.gouv.finances.cp.xemelios.importers.docetatProvider.NodesHolder;
import java.io.OutputStream;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractWriter
extends SAXWriter {
    private static final Logger logger = Logger.getLogger(AbstractWriter.class);
    private AttributesHolder attHolder;
    private NodesHolder nodeHolder;
    protected Stack<QName> stack;
    private DocumentModel dm;

    public AbstractWriter(DocumentModel dm, OutputStream out, String encoding, AttributesHolder attHolder, NodesHolder nodeHolder, NamespaceHolder ns) {
        super(out, encoding);
        this.attHolder = attHolder;
        this.nodeHolder = nodeHolder;
        this.stack = new Stack();
        this.dm = dm;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        for (NSModel ns : this.dm.getNamespaces().getMappings()) {
            this.startPrefixMapping(ns.getPrefix(), ns.getUri());
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(uri, localName, qName, atts);
        QName name = new QName(uri, localName != null ? localName : qName);
        this.stack.push(name);
        String xpath = this.getXPath();
        AttributeHolder at = this.attHolder.getAttrsAt(xpath);
        if (at != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(at.getName()).append("=\"").append(at.getValue()).append("\" ");
            this.output(sb.toString());
        }
    }

    public String getXPath() {
        StringBuilder sb = new StringBuilder();
        for (QName qn : this.stack) {
            sb.append("/");
            String prefix = this.getnsContext().getPrefix(qn.getNamespaceURI());
            if (prefix != null && prefix.length() > 0) {
                sb.append(prefix).append(":");
            }
            sb.append(qn.getLocalPart());
        }
        return sb.toString();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        QName name = this.stack.pop();
    }

    protected void writeNode(Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                break;
            }
            case 11: {
                this.writeChildren(node);
                break;
            }
            case 10: {
                break;
            }
            case 1: {
                this.element((Element)node);
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 12: {
                break;
            }
            case 7: {
                break;
            }
            case 3: {
                this.text((Text)node);
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.comment((Comment)node);
            }
        }
    }

    private void writeChildren(Node node) {
        NodeList l = node.getChildNodes();
        int size = l.getLength();
        for (int i = 0; i < size; ++i) {
            Node n = l.item(i);
            this.writeNode(n);
        }
    }

    private void element(Element elem) {
        AttributesImpl atts = new AttributesImpl();
        NamedNodeMap a = elem.getAttributes();
        int size = a.getLength();
        for (int i = 0; i < size; ++i) {
            Attr att = (Attr)a.item(i);
            if (att != null) {
                try {
                    atts.addAttribute(att.getNamespaceURI() == null ? "" : att.getNamespaceURI(), att.getLocalName() == null ? att.getName() : att.getLocalName(), att.getName(), "CDATA", att.getValue());
                }
                catch (NullPointerException npEx) {
                    logger.debug((Object)"... really strange !");
                }
                continue;
            }
            logger.info((Object)"strange, getting a null attribute...");
        }
        try {
            this.startElement(elem.getNamespaceURI(), elem.getLocalName(), elem.getTagName(), atts);
        }
        catch (SAXException saxEx) {
            // empty catch block
        }
        if (elem.hasChildNodes()) {
            this.writeChildren(elem);
        }
        try {
            this.endElement(elem.getNamespaceURI(), elem.getLocalName(), elem.getTagName());
        }
        catch (SAXException saxEx) {
            // empty catch block
        }
    }

    private void text(Text text) {
        this.writeEscapedText(text.getData());
    }

    private void comment(Comment comment) {
        this.output("<!--");
        this.output(comment.getData());
        this.output("-->\n");
    }
}

