/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.importers;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.StringUtilities;
import fr.gouv.finances.cp.xemelios.common.DematTransform;
import fr.gouv.finances.cp.xemelios.common.FileInfo;
import fr.gouv.finances.cp.xemelios.common.ToolException;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.EtatModel;
import fr.gouv.finances.cp.xemelios.common.config.ParameterModel;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.cp.xemelios.importers.EtatImporteur;
import fr.gouv.finances.cp.xemelios.importers.XmlSplitter;
import fr.gouv.finances.cp.xemelios.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImporterWithXSLBeforeSplitFile
extends EtatImporteur {
    private static Logger logger = Logger.getLogger(ImporterWithXSLBeforeSplitFile.class);
    private File documentsConfigDir = new File(System.getProperty("xemelios.documents.def.dir"));

    public void setDocument(DocumentModel dm) {
        this.dm = dm;
    }

    protected FileInfo importFile(File f) throws Exception {
        this.getImpSvcProvider().startLongWait();
        File fTmp = f;
        for (ParameterModel pm : this.dm.getParameters().getParameters()) {
            if (!"pre-split-xsl-file".equals(pm.getName())) continue;
            String fileEncoding = ImporterWithXSLBeforeSplitFile.getFileEncoding(f);
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            tmpDir = new File(tmpDir, "XEMELIOS");
            tmpDir.mkdirs();
            File tmpDest = new File(tmpDir, fTmp.getName());
            InputStream is = DematTransform.transform(new FileInputStream(f), (InputStream)new FileInputStream(new File(new File(this.dm.getBaseDirectory()), pm.getValue())), fileEncoding);
            StringBuffer newText = new StringBuffer();
            int len = 0;
            byte[] buff = new byte[1024];
            do {
                if ((len = is.read(buff)) <= 0) continue;
                newText.append(new String(buff, 0, len));
            } while (len > 0);
            FileOutputStream fos = new FileOutputStream(tmpDest);
            fos.write(newText.toString().getBytes(fileEncoding));
            fos.flush();
            fos.close();
            fTmp = tmpDest;
        }
        this.getImpSvcProvider().endLongWait();
        return this.oldImportFile(fTmp);
    }

    protected FileInfo oldImportFile(File f) throws Exception {
        this.getImpSvcProvider().startLongWait();
        String fileEncoding = ImporterWithXSLBeforeSplitFile.getFileEncoding(f);
        String xmlVersion = ImporterWithXSLBeforeSplitFile.getFileXmlVersion(f);
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        tmpDir = new File(tmpDir, "XEMELIOS");
        tmpDir.mkdirs();
        File fHeader = File.createTempFile("header-", "", tmpDir);
        File fRef = File.createTempFile("ref-", "", tmpDir);
        File fFooter = File.createTempFile("footer-", "", tmpDir);
        XmlSplitter xs = this.splitFile(fHeader, fRef, fFooter, tmpDir, f, fileEncoding);
        this.getImpSvcProvider().endLongWait();
        Pair collectivite = new Pair();
        Pair codeBudget = new Pair();
        collectivite = this.col == null ? xs.getCollectivite() : this.col;
        codeBudget = this.bdg == null ? xs.getBudget() : this.bdg;
        Vector<File> dataFiles = xs.getDataFiles();
        String header = FileUtils.readTextFile(fHeader, fileEncoding);
        String footer = FileUtils.readTextFile(fFooter, fileEncoding);
        String ref = FileUtils.readTextFile(fRef, fileEncoding);
        int docCount = 1;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        TDocument pc = DataLayerManager.getImplementation().getPersistenceConfig(this.dm).getLayer(DataLayerManager.getImplementation().getLayerName()).getDocument(this.dm.getId());
        if (collectivite == null || collectivite.key == null || collectivite.libelle == null) {
            try {
                collectivite = this.getCollectivite(this.dm, f.getName());
            }
            catch (ToolException tEx) {
                if (tEx.getErrorCode() == 1) {
                    this.getImpSvcProvider().displayMessage(tEx.getMessage(), 1);
                }
                this.removeTempDir();
                return null;
            }
        }
        if (codeBudget == null || codeBudget.key == null || codeBudget.libelle == null || codeBudget.libelle.equals("")) {
            try {
                codeBudget = this.getBudget(this.dm, collectivite, f.getName());
            }
            catch (ToolException tEx) {
                if (tEx.getErrorCode() == 1) {
                    this.getImpSvcProvider().displayMessage(tEx.getMessage(), 1);
                }
                this.removeTempDir();
                return null;
            }
        }
        if (DataLayerManager.getImplementation().isDocumentExists(this.dm, codeBudget, collectivite, f.getName())) {
            boolean shouldImport = false;
            try {
                shouldImport = this.getOverwrite(f.getName());
                if (!shouldImport) {
                    return new FileInfo();
                }
                this.getImpSvcProvider().startLongWait();
                DataLayerManager.getImplementation().removeDocument(this.dm, codeBudget, collectivite, f.getName());
                this.getImpSvcProvider().endLongWait();
            }
            catch (DataAccessException daEx) {
                logger.error((Object)"DataAcessException while removing:", daEx.getCause());
                daEx.getCause().printStackTrace();
            }
            catch (DataConfigurationException dcEx) {
                logger.error((Object)"DataConfigurationException while removing:", dcEx.getCause());
                dcEx.getCause().printStackTrace();
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                ex.printStackTrace();
                this.removeTempDir();
                return null;
            }
        }
        DataLayerManager.getImplementation().registerBudgetCollectivite(this.dm, codeBudget, collectivite, f.getName());
        DataLayerManager.getImplementation().saveSpecialKeys(this.dm, codeBudget, collectivite, f.getName(), xs.getSpecialKey1(), xs.getSpecialKey2(), xs.getSpecialKey3());
        for (int fileCount = 0; fileCount < dataFiles.size() && !this.isCancelled(); ++fileCount) {
            File df = dataFiles.get(fileCount);
            int progress = (int)((double)(fileCount + 1) * 100.0 / (double)dataFiles.size());
            this.getImpSvcProvider().pushCurrentProgress(progress);
            String data = FileUtils.readTextFile(df, fileEncoding);
            StringBuffer fullText = new StringBuffer();
            fullText.append("<?xml version=\"").append(xmlVersion).append("\" encoding=\"").append(fileEncoding).append("\"?>");
            fullText.append(header).append(data).append(footer);
            String sFullText = fullText.toString();
            Document doc = db.parse(new ByteArrayInputStream(sFullText.getBytes(fileEncoding)));
            EtatModel currentEtat = null;
            for (EtatModel em : this.dm.getEtats()) {
                String balise = em.getBalise();
                NodeList nl = doc.getElementsByTagName(balise);
                if (nl.getLength() > 0) {
                    currentEtat = em;
                    break;
                }
                nl = doc.getElementsByTagNameNS(this.dm.getNamespaces().getNamespaceURI(""), balise);
                if (nl.getLength() <= 0) continue;
                currentEtat = em;
                break;
            }
            if (pc.getEtat(currentEtat.getId()).getImportXsltBuffer() != null) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                InputStream is = DematTransform.transform(new ByteArrayInputStream(sFullText.getBytes(fileEncoding)), new ByteArrayInputStream(pc.getEtat(currentEtat.getId()).getImportXsltBuffer().replaceAll("##output-encoding##", fileEncoding).replaceAll("##xml-version##", xmlVersion).getBytes()), fileEncoding, parameters);
                StringBuffer newText = new StringBuffer();
                int len = 0;
                byte[] buff = new byte[1024];
                do {
                    if ((len = is.read(buff)) <= 0) continue;
                    newText.append(new String(buff, 0, len));
                } while (len > 0);
                sFullText = newText.toString();
            }
            String docName = StringUtilities.removeFileNameSuffix(f.getName()) + "-" + docCount + "." + this.dm.getExtension();
            if (!this.isCancelled()) {
                try {
                    if (!DataLayerManager.getImplementation().importElement(this.dm, currentEtat, codeBudget, collectivite, f.getName(), docName, sFullText, fileEncoding)) {
                        logger.warn((Object)DataLayerManager.getImplementation().getLastWarnings());
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)"importing element:", t);
                }
            }
            df.delete();
            ++docCount;
        }
        logger.debug((Object)"importing repository");
        if (!this.isCancelled()) {
            StringBuffer fullText = new StringBuffer();
            fullText.append("<?xml version=\"").append(xmlVersion).append("\" encoding=\"").append(fileEncoding).append("\" ?>");
            fullText.append(header).append(ref).append(footer);
            Document doc = db.parse(new ByteArrayInputStream(fullText.toString().getBytes(fileEncoding)));
            if (pc.getRepositoryImportXsltFile() != null && pc.getRepositoryImportXsltFile().length() > 0) {
                Document doc2 = null;
                File xslNomencl = new File(this.documentsConfigDir, pc.getRepositoryImportXsltFile());
                String xslEncoding = FileUtils.getFileEncoding(xslNomencl);
                String xsl = FileUtils.readTextFile(xslNomencl, xslEncoding);
                xsl = xsl.replaceAll("##output-encoding##", fileEncoding);
                if ((xsl = xsl.replaceAll("##xml-version##", xmlVersion)) != null && xsl.length() > 0) {
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("encoding", fileEncoding);
                    InputStream is = null;
                    is = DematTransform.transform(doc, (InputStream)new ByteArrayInputStream(xsl.getBytes(xslEncoding)), parameters);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buff = new byte[1024];
                    int read = is.read(buff);
                    while (read > 0) {
                        baos.write(buff, 0, read);
                        read = is.read(buff);
                    }
                    is = new ByteArrayInputStream(baos.toByteArray());
                    doc2 = db.parse(is);
                }
                if (doc2 != null) {
                    doc = doc2;
                }
            }
            fullText = null;
            DataLayerManager.getImplementation().saveRepository(this.dm, collectivite, doc, xs.getReferenceNomenclature());
        } else {
            logger.debug((Object)"cancelled");
        }
        fHeader.delete();
        fRef.delete();
        fFooter.delete();
        tmpDir.delete();
        f.deleteOnExit();
        return xs.getFileInfo();
    }

    protected XmlSplitter splitFile(File fHeader, File fRef, File fFooter, File tmpDir, File fToImport, String fileEncoding) throws FileNotFoundException, UnsupportedEncodingException, SAXException, ParserConfigurationException {
        XmlSplitter xs = new XmlSplitter(new FileOutputStream(fHeader), new FileOutputStream(fRef), new FileOutputStream(fFooter), tmpDir, this.dm, fileEncoding);
        SAXParserFactory sf = SAXParserFactory.newInstance();
        sf.setNamespaceAware(true);
        SAXParser parser = sf.newSAXParser();
        try {
            parser.parse(fToImport, (DefaultHandler)xs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String position = "line " + xs.getLocator().getLineNumber() + ": ";
            throw new SAXException(position + ex.getMessage(), ex);
        }
        return xs;
    }

    protected void removeTempDir() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        if ((tmpDir = new File(tmpDir, "XEMELIOS")).exists()) {
            File[] files;
            for (File df : files = tmpDir.listFiles()) {
                df.delete();
            }
        }
    }

    public boolean getOverwrite(String docName) throws Exception {
        return this.getImpSvcProvider().getOverwrite(docName);
    }

    protected Pair getBudget(DocumentModel dm, Pair collectivite, String fileName) throws ToolException {
        return this.getImpSvcProvider().getBudget(dm, collectivite, fileName);
    }

    protected Pair getCollectivite(DocumentModel dm, String fileName) throws ToolException {
        return this.getImpSvcProvider().getCollectivite(dm, fileName);
    }

    private static String getFileEncoding(File f) throws IOException {
        String s;
        String ret = null;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        byte[] bb = new byte[255];
        bis.read(bb);
        String buff = new String(bb);
        buff = buff.substring(buff.indexOf("<?"));
        String header = buff = buff.substring(0, buff.indexOf("?>") + 2);
        int encodingPos = header.indexOf("encoding=");
        ret = encodingPos >= 0 ? ((s = header.substring(encodingPos + 9)).startsWith("\"") ? s.substring(1, s.indexOf(34, 1)) : ((s = s.substring(0, s.length() - 2).trim()).indexOf(32) > 0 ? s.substring(0, s.indexOf(32)) : s)) : new InputStreamReader(new FileInputStream(f)).getEncoding();
        bis.close();
        logger.debug((Object)("encoding=" + ret));
        return ret;
    }

    private static String getFileXmlVersion(File f) throws IOException {
        String s;
        String ret = null;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        byte[] bb = new byte[255];
        bis.read(bb);
        String buff = new String(bb);
        buff = buff.substring(buff.indexOf("<?"));
        String header = buff = buff.substring(0, buff.indexOf("?>") + 2);
        int versionPos = header.indexOf("version=");
        ret = versionPos >= 0 ? ((s = header.substring(versionPos + 8)).startsWith("\"") ? s.substring(1, s.indexOf(34, 1)) : ((s = s.substring(0, s.length() - 2).trim()).indexOf(32) > 0 ? s.substring(0, s.indexOf(32)) : s)) : new InputStreamReader(new FileInputStream(f)).getEncoding();
        bis.close();
        logger.debug((Object)("version=" + ret));
        return ret;
    }

    public static InputStream transform(Node xmlNode, InputStream xslStream, String encoding) throws IOException {
        Transformer transformer;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            transformer = tFactory.newTransformer(new StreamSource(xslStream));
        }
        catch (TransformerConfigurationException e) {
            logger.error((Object)e);
            return null;
        }
        ByteArrayOutputStream outArray = new ByteArrayOutputStream();
        try {
            transformer.transform(new DOMSource(xmlNode), new StreamResult(outArray));
        }
        catch (TransformerException e) {
            logger.error((Object)e);
            return null;
        }
        return new ByteArrayInputStream(outArray.toString(encoding).getBytes());
    }

    public String getAdditionalMessage() {
        return "";
    }

    protected void postProcess(boolean isErrorOccured) throws Exception {
        logger.info((Object)("L'import a prit " + (double)((System.currentTimeMillis() - this.start) / 1000L) / 60.0 + " mins"));
    }
}

