/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.ui;

import fr.gouv.finances.cp.xemelios.data.ui.PatchProgress;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;

public class DlgPatchProgress
extends JDialog
implements PatchProgress {
    private long maxProgress;
    private long currentProgress;
    private JLabel message;
    private JProgressBar progress;

    public DlgPatchProgress() {
        super((Frame)null, false);
        this.initComponents();
        this.setLocationRelativeTo(null);
    }

    public void startProgress(String message) {
        this.message.setText(message);
        this.startProgress();
        this.pack();
    }

    public void startProgress() {
        this.currentProgress = 0L;
    }

    public void setMaxProgress(long maxProgress) {
        this.maxProgress = maxProgress;
    }

    public void pushProgress() {
        ++this.currentProgress;
        this.displayProgress();
    }

    public void endProgress() {
        this.currentProgress = this.maxProgress;
        this.displayProgress();
    }

    private void displayProgress() {
        final int progressValue = (int)((float)this.currentProgress / (float)this.maxProgress * 100.0f);
        Runnable p = new Runnable(){

            public void run() {
                DlgPatchProgress.this.progress.setValue(progressValue);
                DlgPatchProgress.this.progress.paintImmediately(0, 0, DlgPatchProgress.this.progress.getWidth(), DlgPatchProgress.this.progress.getHeight());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            p.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(p);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.message = new JLabel();
        this.progress = new JProgressBar();
        this.setDefaultCloseOperation(0);
        this.setTitle("Mise \u00e0 jour de la base de donn\u00e9es");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.progress.setStringPainted(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.progress, -1, 364, Short.MAX_VALUE).add(1, (Component)this.message, -1, 364, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.message, -1, 9, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.progress, -2, -1, -2).addContainerGap()));
        this.pack();
    }
}

