/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl.sqlconfig;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TTable;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TDocument
implements XmlMarshallable {
    public static final transient String TAG = "document";
    public static final transient QName QN = new QName("document");
    private String id;
    private String repositoryImportXsltFile;
    private TTable repositoryTable;
    private TTable listBcTable;
    private TTable specialKeyTable;
    private Hashtable<String, TEtat> etats = new Hashtable();
    private String baseDirectory;
    private String extendedDoc;

    public TDocument(QName tagName) {
    }

    public void setBaseDirectory(String baseDir) {
        this.baseDirectory = baseDir;
        for (TEtat etat : this.etats.values()) {
            etat.setBaseDirectory(baseDir);
        }
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (TTable.QN.equals(tagName)) {
            TTable table = (TTable)child;
            if ("repository".equals(table.getType())) {
                this.repositoryTable = table;
            } else if ("special-key".equals(table.getType())) {
                this.specialKeyTable = table;
            } else if ("list-bc".equals(table.getType())) {
                this.listBcTable = table;
            }
        } else if (TEtat.QN.equals(tagName)) {
            TEtat etat = (TEtat)child;
            etat.setBaseDirectory(this.baseDirectory);
            this.etats.put(etat.getId(), etat);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.repositoryImportXsltFile = attributes.getValue("repository-import-xslt-file");
        return this;
    }

    public void marshall(XmlOutputter output) {
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public TDocument clone() {
        TDocument other = new TDocument(QN);
        other.id = this.id;
        other.repositoryImportXsltFile = this.repositoryImportXsltFile;
        other.repositoryTable = this.repositoryTable.clone();
        other.listBcTable = this.listBcTable.clone();
        other.specialKeyTable = this.specialKeyTable.clone();
        for (String s : this.etats.keySet()) {
            other.etats.put(s, this.etats.get(s).clone());
        }
        other.baseDirectory = this.baseDirectory;
        return other;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRepositoryImportXsltFile() {
        return this.repositoryImportXsltFile;
    }

    public void setRepositoryImportXsltFile(String repositoryImportXsltFile) {
        this.repositoryImportXsltFile = repositoryImportXsltFile;
    }

    public TEtat getEtat(String etatId) {
        return this.etats.get(etatId);
    }

    public TTable getListBcTable() {
        return this.listBcTable;
    }

    public void setListBcTable(TTable listBcTable) {
        this.listBcTable = listBcTable;
    }

    public TTable getRepositoryTable() {
        return this.repositoryTable;
    }

    public void setRepositoryTable(TTable repositoryTable) {
        this.repositoryTable = repositoryTable;
    }

    public TTable getSpecialKeyTable() {
        return this.specialKeyTable;
    }

    public void setSpecialKeyTable(TTable specialKeyTable) {
        this.specialKeyTable = specialKeyTable;
    }

    public Iterable<TEtat> getEtats() {
        return this.etats.values();
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        QName name = new QName(uri, localName);
        if (TTable.QN.equals(name)) {
            String type = atts.getValue("type");
            if ("repository".equals(type)) {
                return this.repositoryTable;
            }
            if ("special-key".equals(type)) {
                return this.specialKeyTable;
            }
            if ("list-bc".equals(type)) {
                return this.listBcTable;
            }
        } else if (TEtat.QN.equals(name)) {
            return this.etats.get(atts.getValue("id"));
        }
        return null;
    }

    public QName getQName() {
        return QN;
    }
}

