/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data;

import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataImpl;
import java.io.File;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class DataLayerManager {
    private static Logger logger = Logger.getLogger(DataLayerManager.class);
    private static Hashtable<String, Class> dataImpl = new Hashtable();
    private static DataImpl instance = null;

    public static void regiterDataImpl(String implName, Class implClass) {
        if (dataImpl.get(implName) != null) {
            logger.warn((Object)(implName + " already registered."));
        }
        dataImpl.put(implName, implClass);
    }

    public static DataImpl getImplementation() throws DataConfigurationException {
        if (instance == null) {
            throw new DataConfigurationException("Data implementation not set.");
        }
        return instance;
    }

    public static void setDataImpl(String implName) throws DataConfigurationException {
        Class impl = dataImpl.get(implName);
        if (impl == null) {
            throw new DataConfigurationException("Unknown implementation: " + implName);
        }
        try {
            Object o = impl.newInstance();
            if (!(o instanceof DataImpl)) {
                throw new DataConfigurationException(impl.getName() + " is not a valid DataImpl");
            }
            instance = (DataImpl)o;
            instance.setDocumentsConfigDirectory(new File(System.getProperty("xemelios.documents.def.dir")));
        }
        catch (InstantiationException e) {
            throw new DataConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            throw new DataConfigurationException(e);
        }
    }
}

