/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.models;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InputModel
implements XmlMarshallable {
    public static final transient String TAG = "input";
    public static final transient QName QN = new QName("input");
    private String id;
    private String libelle;
    private String datatype;
    private String xmlFormat;

    public InputModel(QName tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.libelle = attributes.getValue("libelle");
        this.datatype = attributes.getValue("datatype");
        this.xmlFormat = attributes.getValue("xml-format");
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        if (this.libelle != null) {
            output.addAttribute("libelle", StringEscapeUtils.escapeXml(this.libelle));
        }
        output.addAttribute("datatype", this.datatype);
        if ("date".equals(this.datatype)) {
            output.addAttribute("xml-format", this.xmlFormat);
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public String getDatatype() {
        return this.datatype;
    }

    public String getId() {
        return this.id;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public String getXmlDateFormat() {
        return this.xmlFormat;
    }

    public InputModel clone() {
        InputModel im = new InputModel(QN);
        im.id = this.id;
        im.libelle = this.libelle;
        im.datatype = this.datatype;
        im.xmlFormat = this.xmlFormat;
        return im;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return null;
    }

    public QName getQName() {
        return QN;
    }
}

