/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.models;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.controls.models.ControlModel;
import fr.gouv.finances.cp.xemelios.controls.models.ControlModelTech;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModel;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentControlModel
implements XmlMarshallable {
    public static final transient String TAG = "document";
    public static final transient QName QN = new QName("document");
    private String id;
    private Vector<ParamModel> params = new Vector();
    private Vector<ControlModelTech> controlsTech;
    private Vector<ControlModel> controls = new Vector();
    private Hashtable<String, ControlModel> indexedControls;
    private Hashtable<String, ControlModelTech> indexedControlsTech;

    public DocumentControlModel(QName tagName) {
        this.controlsTech = new Vector();
        this.indexedControls = new Hashtable();
        this.indexedControlsTech = new Hashtable();
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (ParamModel.QN.equals(tagName)) {
            this.params.add((ParamModel)child);
        } else if (ControlModel.QN.equals(tagName)) {
            ControlModel cm = (ControlModel)child;
            if (this.indexedControls.containsKey(cm.getId())) {
                ControlModel old = this.indexedControls.get(cm.getId());
                this.controls.remove(old);
                this.indexedControls.remove(old.getId());
            }
            this.controls.add(cm);
            this.indexedControls.put(cm.getId(), cm);
        } else if (ControlModelTech.QN.equals(tagName)) {
            ControlModelTech cm = (ControlModelTech)child;
            if (this.indexedControlsTech.contains(cm.getId())) {
                ControlModelTech old = this.indexedControlsTech.get(cm.getId());
                this.controlsTech.remove(old);
                this.indexedControlsTech.remove(old.getId());
            }
            this.controlsTech.add(cm);
            this.indexedControlsTech.put(cm.getId(), cm);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        return this;
    }

    public void validate() throws InvalidXmlDefinition {
        for (ParamModel paramModel : this.params) {
            paramModel.validate();
        }
        for (ControlModel controlModel : this.controls) {
            controlModel.validate();
        }
        for (ControlModelTech controlModelTech : this.controlsTech) {
            controlModelTech.validate();
        }
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        for (ParamModel paramModel : this.params) {
            paramModel.marshall(output);
        }
        for (ControlModelTech controlModelTech : this.controlsTech) {
            controlModelTech.marshall(output);
        }
        for (ControlModel controlModel : this.controls) {
            controlModel.marshall(output);
        }
        output.endTag(TAG);
    }

    public String getDocumentId() {
        return this.id;
    }

    public ParamModel getParamById(String etatId) {
        for (ParamModel param : this.params) {
            if (!param.getId().equals(etatId)) continue;
            return param;
        }
        return null;
    }

    public ControlModel getControlById(String ctrlId) {
        return this.indexedControls.get(ctrlId);
    }

    public ControlModelTech getControlTechById(String ctrlId) {
        return this.indexedControlsTech.get(ctrlId);
    }

    public Vector<ControlModelTech> getControlsTech() {
        return this.controlsTech;
    }

    public Vector<ControlModel> getControls() {
        return this.controls;
    }

    public Vector<ParamModel> getParams() {
        return this.params;
    }

    public DocumentControlModel clone() {
        DocumentControlModel dcm = new DocumentControlModel(QN);
        dcm.id = this.id;
        for (ControlModel cm : this.getControls()) {
            try {
                this.addChild(cm.clone(), ControlModel.QN);
            }
            catch (SAXException ignore) {}
        }
        for (ControlModelTech cmt : this.getControlsTech()) {
            try {
                this.addChild(cmt.clone(), ControlModelTech.QN);
            }
            catch (SAXException ignore) {}
        }
        for (ParamModel pm : this.getParams()) {
            try {
                this.addChild(pm.clone(), ParamModel.QN);
            }
            catch (SAXException ignore) {}
        }
        return dcm;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        QName tagName = new QName(uri, localName);
        if (ControlModel.QN.equals(tagName)) {
            return this.indexedControls.get(atts.getValue("id"));
        }
        if (ControlModelTech.QN.equals(tagName)) {
            return this.indexedControlsTech.get(atts.getValue("id"));
        }
        return null;
    }

    public QName getQName() {
        return QN;
    }
}

